/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.resources.actions.FoldersAsProjectsActionProvider;
import org.eclipse.ui.internal.navigator.resources.actions.OpenFolderAsProjectAction;
import org.eclipse.ui.internal.navigator.resources.actions.SelectProjectForFolderAction;
import org.eclipse.ui.tests.navigator.resources.AffectedProjectsSchedulingRule;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class FoldersAsProjectsContributionTest {
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void notAFolder() {
        String notAFolder = "Some string";
        IMenuManager manager = this.menuManager();
        this.provider(new StructuredSelection((Object)notAFolder)).fillContextMenu(manager);
        Assert.assertFalse((String)"SelectProjectForFolderAction contributions were added on not an adaptable-to-IFolder selection", (boolean)this.contributionAdded(manager, SelectProjectForFolderAction.class));
        Assert.assertFalse((String)"OpenFolderAsProjectAction contributions were added on not an adaptable-to-IFolder selection", (boolean)this.contributionAdded(manager, OpenFolderAsProjectAction.class));
    }

    @Test
    public void noDescription() {
        IFolder justAFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path("some/folder"));
        IMenuManager manager = this.menuManager();
        this.provider(new StructuredSelection((Object)justAFolder)).fillContextMenu(manager);
        Assert.assertFalse((String)"SelectProjectForFolderAction contributions were added on an IFolder without project description", (boolean)this.contributionAdded(manager, SelectProjectForFolderAction.class));
        Assert.assertFalse((String)"OpenFolderAsProjectAction contributions were added on an IFolder without project description", (boolean)this.contributionAdded(manager, OpenFolderAsProjectAction.class));
    }

    @Test
    @Ignore
    public void alreadyAdded() throws IOException, CoreException {
        IProject outer = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.alreadyAdded.outer");
        IProject inner1 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.alreadyAdded.inner1");
        IProject inner2 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.alreadyAdded.inner2");
        List<IProject> projects = Arrays.asList(outer, inner1, inner2);
        AffectedProjectsSchedulingRule rule = new AffectedProjectsSchedulingRule(projects);
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            File root = this.folder.newFolder(outer.getName());
            this.createProject(root, outer);
            this.createProject(new Path(root.getAbsolutePath()).append(inner1.getName()).toFile(), inner1);
            this.createProject(new Path(root.getAbsolutePath()).append(inner2.getName()).toFile(), inner2);
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        try {
            IMenuManager manager = this.menuManager();
            this.ensureDescriptionsExist(outer, inner1, inner2);
            this.provider(new StructuredSelection(Arrays.asList(outer.getFolder(inner1.getName()), outer.getFolder(inner2.getName())))).fillContextMenu(manager);
            Assert.assertTrue((String)NLS.bind((String)"A SelectProjectForFolderAction contribution was not added. Contribution List is: {0}", (Object)this.contributionsList(manager)), (boolean)this.contributionAdded(manager, SelectProjectForFolderAction.class));
        }
        finally {
            this.clear(projects);
        }
    }

    @Test
    @Ignore
    public void notYetImported() throws IOException, CoreException {
        IProject outer = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.notYetImported.outer");
        IProject inner1 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.notYetImported.inner1");
        IProject inner2 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.notYetImported.inner2");
        List<IProject> projects = Arrays.asList(outer, inner1, inner2);
        AffectedProjectsSchedulingRule rule = new AffectedProjectsSchedulingRule(projects);
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            File root = this.folder.newFolder(outer.getName());
            this.createProject(root, outer);
            this.createProject(new Path(root.getAbsolutePath()).append(inner1.getName()).toFile(), inner1);
            this.createProject(new Path(root.getAbsolutePath()).append(inner2.getName()).toFile(), inner2);
            inner1.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
            inner2.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        try {
            IMenuManager manager = this.menuManager();
            this.ensureDescriptionsExist(outer, inner1, inner2);
            this.provider(new StructuredSelection(Arrays.asList(outer.getFolder(inner1.getName()), outer.getFolder(inner2.getName())))).fillContextMenu(manager);
            Assert.assertTrue((String)NLS.bind((String)"A OpenFolderAsProjectAction contribution was not added. Contribution List is: {0}", (Object)this.contributionsList(manager)), (boolean)this.contributionAdded(manager, OpenFolderAsProjectAction.class));
        }
        finally {
            this.clear(projects);
        }
    }

    @Test
    public void ambiguity() throws CoreException, IOException {
        IProject outer = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.ambiguity.outer");
        IProject inner1 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.ambiguity.inner1");
        IProject inner2 = ResourcesPlugin.getWorkspace().getRoot().getProject("foldersasprojects.ambiguity.inner2");
        List<IProject> projects = Arrays.asList(outer, inner1, inner2);
        AffectedProjectsSchedulingRule rule = new AffectedProjectsSchedulingRule(projects);
        try {
            Job.getJobManager().beginRule((ISchedulingRule)rule, null);
            File root = this.folder.newFolder(outer.getName());
            this.createProject(root, outer);
            this.createProject(new Path(root.getAbsolutePath()).append(inner1.getName()).toFile(), inner1);
            this.createProject(new Path(root.getAbsolutePath()).append(inner2.getName()).toFile(), inner2);
            inner1.delete(false, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)rule);
        }
        try {
            IMenuManager manager = this.menuManager();
            this.provider(new StructuredSelection(Arrays.asList(outer.getFolder(inner1.getName()), outer.getFolder(inner2.getName())))).fillContextMenu(manager);
            Assert.assertFalse((String)"There were both imported and not-imported projects in selection, but SelectProjectForFolderAction contributions were added", (boolean)this.contributionAdded(manager, SelectProjectForFolderAction.class));
            Assert.assertFalse((String)"There were both imported and not-imported projects in selection, but OpenFolderAsProjectAction contributions were added", (boolean)this.contributionAdded(manager, OpenFolderAsProjectAction.class));
        }
        finally {
            this.clear(projects);
        }
    }

    private void clear(List<IProject> projects) {
        projects.forEach(handle -> {
            try {
                handle.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        });
    }

    private IMenuManager menuManager() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("group.open"));
        menuManager.add((IContributionItem)new GroupMarker("group.port"));
        return menuManager;
    }

    private boolean contributionAdded(IMenuManager manager, Class<?> action) {
        return Stream.of(manager.getItems()).filter(ActionContributionItem.class::isInstance).map(ActionContributionItem.class::cast).map(ActionContributionItem::getAction).filter(action::isInstance).findFirst().isPresent();
    }

    private FoldersAsProjectsActionProvider provider(StructuredSelection selection) {
        FoldersAsProjectsActionProvider provider = new FoldersAsProjectsActionProvider();
        provider.setContext(new ActionContext((ISelection)selection));
        return provider;
    }

    private String contributionsList(IMenuManager manager) {
        return Stream.of(manager.getItems()).map(Object::getClass).map(Class::getName).collect(Collectors.joining(","));
    }

    private void createProject(File location, IProject actual) throws CoreException {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(actual.getName());
        description.setLocation((IPath)new Path(location.getAbsolutePath()));
        actual.create(description, (IProgressMonitor)new NullProgressMonitor());
        actual.open((IProgressMonitor)new NullProgressMonitor());
    }

    private void ensureDescriptionsExist(IProject outer, IProject inner1, IProject inner2) throws IOException {
        this.ensureFileExists(outer.getFolder(inner1.getName()).getFile(".project"), inner1.getName());
        this.ensureFileExists(outer.getFolder(inner2.getName()).getFile(".project"), inner2.getName());
    }

    private void ensureFileExists(IFile description, String name) throws IOException {
        if (description.exists()) {
            return;
        }
        Files.createFile(Paths.get(description.getLocationURI()), new FileAttribute[0]);
        Assert.assertTrue((String)String.format("Project description for %s does not exist", name), (boolean)description.exists());
    }
}

