/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectsLabelProvider;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NestedResourcesTests {
    private static final int TIMEOUT = 2000;
    private final Set<IProject> testProjects = new HashSet<IProject>();

    @Test
    public void testProjectHierarchy() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectA = root.getProject("a");
        projectA.create((IProgressMonitor)monitor);
        projectA.open((IProgressMonitor)monitor);
        IFolder folderAA = projectA.getFolder("aa");
        folderAA.create(true, true, (IProgressMonitor)monitor);
        IProjectDescription projectAAADesc = root.getWorkspace().newProjectDescription("aaa");
        projectAAADesc.setLocation(folderAA.getLocation().append(projectAAADesc.getName()));
        IProject projectAAA = root.getProject(projectAAADesc.getName());
        projectAAA.create(projectAAADesc, (IProgressMonitor)monitor);
        projectAAA.open((IProgressMonitor)monitor);
        IProjectDescription projectABDesc = projectA.getWorkspace().newProjectDescription("ab");
        projectABDesc.setLocation(projectA.getLocation().append(projectABDesc.getName()));
        IProject projectAB = projectA.getWorkspace().getRoot().getProject(projectABDesc.getName());
        projectAB.create(projectABDesc, (IProgressMonitor)monitor);
        projectAB.open((IProgressMonitor)monitor);
        IProjectDescription projectABADesc = projectAB.getWorkspace().newProjectDescription("aba");
        projectABADesc.setLocation(projectAB.getLocation().append(projectABADesc.getName()));
        IProject projectABA = root.getProject(projectABADesc.getName());
        projectABA.create(projectABADesc, (IProgressMonitor)monitor);
        projectABA.open((IProgressMonitor)monitor);
        IProjectDescription projectABBDesc = projectAB.getWorkspace().newProjectDescription("abb");
        projectABBDesc.setLocation(projectAB.getLocation().append(projectABBDesc.getName()));
        IProject projectABB = root.getProject(projectABBDesc.getName());
        projectABB.create(projectABBDesc, (IProgressMonitor)monitor);
        projectABB.open((IProgressMonitor)monitor);
        projectAB.getFolder("abc").create(true, true, (IProgressMonitor)monitor);
        this.testProjects.add(projectA);
        this.testProjects.add(projectAAA);
        this.testProjects.add(projectAB);
        this.testProjects.add(projectABA);
        this.testProjects.add(projectABB);
        IProject[] childrenOfProjectA = NestedProjectManager.getInstance().getDirectChildrenProjects((IContainer)projectA);
        Assert.assertEquals((long)1L, (long)childrenOfProjectA.length);
        Assert.assertEquals((Object)projectAB, (Object)childrenOfProjectA[0]);
        Assert.assertNull((Object)NestedProjectManager.getInstance().getMostDirectOpenContainer(projectA));
        IProject[] childrenOfFolderAA = NestedProjectManager.getInstance().getDirectChildrenProjects((IContainer)folderAA);
        Assert.assertEquals((long)1L, (long)childrenOfFolderAA.length);
        Assert.assertEquals((Object)"aaa", (Object)childrenOfFolderAA[0].getName());
        Assert.assertEquals((Object)folderAA, (Object)NestedProjectManager.getInstance().getMostDirectOpenContainer(childrenOfFolderAA[0]));
        IProject[] childrenOfProjectAB = NestedProjectManager.getInstance().getDirectChildrenProjects((IContainer)projectAB);
        Assert.assertEquals((long)2L, (long)childrenOfProjectAB.length);
    }

    @Test
    public void testDashInProject() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject projectA = root.getProject("a");
        projectA.create((IProgressMonitor)monitor);
        projectA.open((IProgressMonitor)monitor);
        IProjectDescription projectAChildDesc = root.getWorkspace().newProjectDescription("child");
        projectAChildDesc.setLocation(projectA.getLocation().append(projectAChildDesc.getName()));
        IProject projectAChild = root.getProject(projectAChildDesc.getName());
        projectAChild.create(projectAChildDesc, (IProgressMonitor)monitor);
        projectAChild.open((IProgressMonitor)monitor);
        IProject projectA_A = root.getProject("a-a");
        projectA_A.create((IProgressMonitor)monitor);
        projectA_A.open((IProgressMonitor)monitor);
        this.testProjects.add(projectA);
        this.testProjects.add(projectAChild);
        this.testProjects.add(projectA_A);
        Assert.assertTrue((boolean)NestedProjectManager.getInstance().hasDirectChildrenProjects((IContainer)projectA));
        Assert.assertEquals((Object)projectAChild, (Object)NestedProjectManager.getInstance().getDirectChildrenProjects((IContainer)projectA)[0]);
    }

    @Test
    public void testProblemDecoration() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject parentProject = root.getProject("parent");
        parentProject.create((IProgressMonitor)monitor);
        parentProject.open((IProgressMonitor)monitor);
        IFolder intermediaryFolder = parentProject.getFolder("folder");
        intermediaryFolder.create(true, false, (IProgressMonitor)monitor);
        IProject firstChildProject = root.getProject("child1");
        IProjectDescription description = root.getWorkspace().newProjectDescription(firstChildProject.getName());
        description.setLocation(intermediaryFolder.getLocation().append(firstChildProject.getName()));
        firstChildProject.create(description, (IProgressMonitor)monitor);
        firstChildProject.open((IProgressMonitor)monitor);
        IProject secondChildProject = root.getProject("child2");
        description = root.getWorkspace().newProjectDescription(secondChildProject.getName());
        description.setLocation(intermediaryFolder.getLocation().append(secondChildProject.getName()));
        secondChildProject.create(description, (IProgressMonitor)monitor);
        secondChildProject.open((IProgressMonitor)monitor);
        NestedProjectsLabelProviderAccessor labelProvider = new NestedProjectsLabelProviderAccessor();
        labelProvider.init(null);
        Assert.assertEquals((long)-1L, (long)labelProvider.getHighestProblemSeverity((IResource)parentProject));
        root.getWorkspace().run(aMonitor -> {
            IMarker marker = firstChildProject.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 1);
        }, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 1 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        root.getWorkspace().run(aMonitor -> {
            IMarker marker = secondChildProject.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
        }, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 2 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        IMarker[] iMarkerArray = secondChildProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 1 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        root.getWorkspace().run(aMonitor -> {
            IMarker marker = secondChildProject.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
        }, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 2 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        secondChildProject.close((IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 1 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        secondChildProject.open((IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 2 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
        root.getWorkspace().run(aMonitor -> {
            IMarker marker = parentProject.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            secondChildProject.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)[0].delete();
        }, (IProgressMonitor)monitor);
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)2000L, () -> 2 == labelProvider.getHighestProblemSeverity((IResource)parentProject)));
    }

    @After
    public void deleteProjects() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        for (IProject testProject : this.testProjects) {
            testProject.delete(true, true, (IProgressMonitor)monitor);
        }
        this.testProjects.clear();
    }

    private class NestedProjectsLabelProviderAccessor
    extends NestedProjectsLabelProvider {
        private NestedProjectsLabelProviderAccessor() {
        }

        public int getHighestProblemSeverity(IResource resource) {
            return super.getHighestProblemSeverity(resource);
        }
    }
}

