/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.resources;

import java.util.Comparator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;
import org.junit.Assert;
import org.junit.Test;

public class PathComparatorTest {
    private static final Comparator<IPath> COMPARATOR = new PathComparator();

    private static void assertConsistentWithEquals(IPath p1, IPath p2) {
        int compare;
        boolean equals = p1.equals((Object)p2);
        if (equals != ((compare = COMPARATOR.compare(p1, p2)) == 0)) {
            Assert.fail((String)("Path.equals() == " + equals + " inconsistent with " + PathComparator.class.getName() + ".compare() == " + compare + " for paths '" + String.valueOf(p1) + "' and '" + String.valueOf(p2) + "'"));
        }
    }

    private static void assertLessThan(IPath p1, IPath p2) {
        int compare = COMPARATOR.compare(p1, p2);
        Assert.assertTrue((String)(PathComparator.class.getName() + ".compare() returned " + compare + " expected less than zero for paths '" + String.valueOf(p1) + "' and '" + String.valueOf(p2) + "'"), (compare < 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkInvariant() {
        IPath ab = IPath.fromOSString((String)"a/b");
        IPath abc = IPath.fromOSString((String)"a/b/c");
        IPath ac = IPath.fromOSString((String)"a/c");
        IPath acb = IPath.fromOSString((String)"a/c/b");
        Assert.assertTrue((COMPARATOR.compare(ab, abc) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((COMPARATOR.compare(abc, ac) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((COMPARATOR.compare(ac, acb) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void consistentWithEqualsDistLength() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"a:/f1/f2"), IPath.forWindows((String)"a:/f1/f2/f3"));
    }

    @Test
    public void consistentWithEqualsDist() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"a:/f1/f2"), IPath.forWindows((String)"a:/f1/f3"));
    }

    @Test
    public void consistentWithEqualsDistDevice() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"a:/f1/f2"), IPath.forWindows((String)"b:/f1/f2"));
    }

    @Test
    public void consistentWithEqualsDistLeadingSlash() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"/f1/f2"), IPath.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsDistTrailingSlash() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"f1/f2/"), IPath.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsSame() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"a:/f1/f2"), IPath.forWindows((String)"a:/f1/f2"));
    }

    @Test
    public void consistentWithEqualsUncAbsolute() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"//f1/f2"), IPath.forWindows((String)"/f1/f2"));
    }

    @Test
    public void consistentWithEqualsUncRelative() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"//f1/f2"), IPath.forWindows((String)"f1/f2"));
    }

    @Test
    public void consistentWithEqualsWinPosix() {
        PathComparatorTest.assertConsistentWithEquals(IPath.forWindows((String)"f1/f2"), IPath.forPosix((String)"f1/f2"));
    }

    @Test
    public void lessThanRelativeDashSlash() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"f1/f1"), IPath.forWindows((String)"f1-f2"));
    }

    @Test
    public void lessThanRelativeDepth1() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"f1"), IPath.forWindows((String)"f2"));
    }

    @Test
    public void lessThanRelativeDepth2() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"f1/f1"), IPath.forWindows((String)"f1/f2"));
    }

    @Test
    public void deviceALessThanDeviceB() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"a:/f1/f2"), IPath.forWindows((String)"b:/f1/f2"));
    }

    @Test
    public void relativeLessThanAbsolute() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"f1/f2"), IPath.forWindows((String)"/f1/f2"));
    }

    @Test
    public void absoluteLessThanUnc() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"/f1/f2"), IPath.forWindows((String)"//f1/f2"));
    }

    @Test
    public void uncLessThanDevice() {
        PathComparatorTest.assertLessThan(IPath.forWindows((String)"//f1/f2"), IPath.forWindows((String)"a:/f1/f2"));
    }
}

