/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.resources;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.CommonActionExtensionSite;
import org.eclipse.ui.internal.navigator.resources.actions.ResourceMgmtActionProvider;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ResourceMgmtActionProviderTests
extends NavigatorTestBase {
    private IMenuManager manager;

    public ResourceMgmtActionProviderTests() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Override
    @Before
    public void setUp() throws CoreException {
        super.setUp();
        this.manager = new MenuManager();
        this.manager.add((IContributionItem)new GroupMarker("group.build"));
    }

    @Test
    public void testFillContextMenu_noSelection() {
        ResourceMgmtActionProvider provider = this.provider(null);
        provider.fillContextMenu(this.manager);
        this.checkMenuHasCorrectContributions(false, false, false, false, false);
    }

    @Test
    public void testFillContextMenu_folderSelection() {
        IFolder justAFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path("some/folder"));
        ResourceMgmtActionProvider provider = this.provider(new IResource[]{justAFolder});
        provider.fillContextMenu(this.manager);
        this.checkMenuHasCorrectContributions(false, true, false, false, false);
    }

    @Test
    public void testFillContextMenu_closedProjectSelection() {
        IProject closedProj = ResourcesPlugin.getWorkspace().getRoot().getProject("closedProj");
        ResourceMgmtActionProvider provider = this.provider(new IResource[]{closedProj});
        provider.fillContextMenu(this.manager);
        this.checkMenuHasCorrectContributions(false, false, true, false, false);
    }

    @Test
    public void testFillContextMenu_openProjectNoBuilderSelection() throws CoreException {
        IProject openProj = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        boolean autoBuildInitialState = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
        if (!autoBuildInitialState) {
            IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
            wsd.setAutoBuilding(true);
            ResourcesPlugin.getWorkspace().setDescription(wsd);
        }
        openProj.open(null);
        ResourceMgmtActionProvider provider = this.provider(new IResource[]{openProj});
        provider.fillContextMenu(this.manager);
        this.checkMenuHasCorrectContributions(false, true, false, true, true);
        if (!autoBuildInitialState) {
            IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
            wsd.setAutoBuilding(false);
            ResourcesPlugin.getWorkspace().setDescription(wsd);
        }
    }

    @Test
    public void testFillContextMenu_openProjectWithBuilderSelection() throws CoreException {
        IProject openProj = ResourcesPlugin.getWorkspace().getRoot().getProject("Test");
        IWorkspaceDescription wsd = ResourcesPlugin.getWorkspace().getDescription();
        boolean autobuildInitialState = wsd.isAutoBuilding();
        boolean hasNoInitialBuildCommands = false;
        IProjectDescription desc = null;
        if (autobuildInitialState) {
            wsd.setAutoBuilding(false);
            ResourcesPlugin.getWorkspace().setDescription(wsd);
        }
        openProj.open(null);
        desc = openProj.getDescription();
        if (desc.getBuildSpec().length == 0) {
            hasNoInitialBuildCommands = true;
            ICommand cmd = desc.newCommand();
            desc.setBuildSpec(new ICommand[]{cmd});
            openProj.setDescription(desc, null);
        }
        ResourceMgmtActionProvider provider = this.provider(new IResource[]{openProj});
        provider.fillContextMenu(this.manager);
        this.checkMenuHasCorrectContributions(true, true, false, true, true);
        if (autobuildInitialState) {
            wsd.setAutoBuilding(true);
            ResourcesPlugin.getWorkspace().setDescription(wsd);
        }
        if (desc != null && hasNoInitialBuildCommands) {
            desc.setBuildSpec(new ICommand[0]);
            openProj.setDescription(desc, null);
        }
    }

    private ResourceMgmtActionProvider provider(IResource ... selectedElements) {
        CommonActionExtensionSite cfg = new CommonActionExtensionSite("NA", "NA", (ICommonViewerSite)CommonViewerSiteFactory.createCommonViewerSite((IViewSite)this._commonNavigator.getViewSite()), (NavigatorContentService)this._contentService, (StructuredViewer)this._viewer);
        ResourceMgmtActionProvider provider = new ResourceMgmtActionProvider();
        StructuredSelection selection = null;
        selection = selectedElements != null && selectedElements.length > 0 ? new StructuredSelection((Object[])selectedElements) : new StructuredSelection();
        provider.setContext(new ActionContext((ISelection)selection));
        provider.init((ICommonActionExtensionSite)cfg);
        return provider;
    }

    private void checkMenuHasCorrectContributions(boolean ... actions) {
        if (actions.length != 5) {
            Assert.fail((String)String.format("Incorrect number of menu items being checked : %d", actions.length));
        }
        int index = 0;
        String[] stringArray = new String[]{"org.eclipse.ui.BuildAction", "org.eclipse.ui.RefreshAction", "org.eclipse.ui.OpenResourceAction", "org.eclipse.ui.CloseResourceAction", "org.eclipse.ui.CloseUnrelatedProjectsAction"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String thisAction = stringArray[n2];
            Assert.assertTrue((String)String.format("Unexpected menu membership for %s (%b)", thisAction, !actions[index]), (actions[index] == this.menuHasContribution(thisAction) ? 1 : 0) != 0);
            ++index;
            ++n2;
        }
    }

    private boolean menuHasContribution(String contribution) {
        IContributionItem[] iContributionItemArray = this.manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem thisItem = iContributionItemArray[n2];
            if (thisItem.getId() != null && thisItem.getId().equals(contribution)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

