/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ProjectUnzipUtil {
    private final IPath zipLocation;
    private final String[] projectNames;
    private IPath rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private static final String META_PROJECT_NAME = ".project";

    public ProjectUnzipUtil(IPath aLocalZipFilePath, String[] aProjectNames) {
        this.zipLocation = this.getLocalPath(aLocalZipFilePath);
        this.projectNames = aProjectNames;
    }

    public IPath getLocalPath(IPath zipFilePath) {
        Bundle bundle = FrameworkUtil.getBundle(ProjectUnzipUtil.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)zipFilePath, null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return IPath.fromOSString((String)url.getPath());
    }

    public boolean createProjects() {
        try {
            this.expandZip();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
            this.buildProjects();
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean reset() {
        try {
            this.expandZip();
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private IProgressMonitor getProgessMonitor() {
        return new NullProgressMonitor();
    }

    private void expandZip() throws CoreException, IOException {
        IProgressMonitor monitor = this.getProgessMonitor();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(this.zipLocation.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                block25: {
                    ZipEntry entry = entries.nextElement();
                    monitor.subTask(entry.getName());
                    File aFile = this.computeLocation(entry.getName()).toFile();
                    File parentFile = null;
                    if (entry.isDirectory()) {
                        aFile.mkdirs();
                        break block25;
                    }
                    parentFile = aFile.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    if (!aFile.exists()) {
                        aFile.createNewFile();
                    }
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (InputStream in = zipFile.getInputStream(entry);){
                        Files.write(aFile.toPath(), in.readAllBytes(), new OpenOption[0]);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    if (entry.getTime() > 0L) {
                        aFile.setLastModified(entry.getTime());
                    }
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private IPath computeLocation(String name) {
        return this.rootLocation.append(name);
    }

    public void setRootLocation(IPath rootLocation) {
        this.rootLocation = rootLocation;
    }

    private void buildProjects() throws IOException, CoreException {
        String[] stringArray = this.projectNames;
        int n = this.projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath projectPath = IPath.fromOSString((String)("/" + projectName + "/.project"));
            IPath path = this.rootLocation.append(projectPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IProjectDescription description = workspace.loadProjectDescription(path);
            project.create(description, this.getProgessMonitor());
            project.open(this.getProgessMonitor());
            ++n2;
        }
    }
}

