/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.graphics;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;

public class ImageDataTestHelper {
    private static boolean TEST_BLIT_SHOW_IMAGES = false;
    public static int LSB_FIRST = 0;
    public static int MSB_FIRST = 1;

    public static PaletteData makeTestPalette(int depth, boolean isDirect) {
        if (isDirect) {
            switch (depth) {
                case 8: {
                    return new PaletteData(3, 12, 48);
                }
                case 16: {
                    return new PaletteData(61440, 3840, 240);
                }
                case 24: {
                    return new PaletteData(255, 65280, 0xFF0000);
                }
                case 32: {
                    return new PaletteData(65280, 0xFF0000, -16777216);
                }
            }
            throw new IllegalArgumentException();
        }
        RGB[] rgbs = new RGB[]{new RGB(85, 170, 255), new RGB(0, 255, 170)};
        return new PaletteData(rgbs);
    }

    public static ImageData makeTestImageData(int depth, int scale, int byteOrder, boolean isDirect, boolean isClean) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Random random = new Random(0L);
        int bytesPad = random.nextInt(8) * 2;
        int bytesPerLine = 8 * depth / 8 * scale + bytesPad;
        PaletteData palette = ImageDataTestHelper.makeTestPalette(depth, isDirect);
        byte[] data = new byte[bytesPerLine * (4 * scale)];
        ImageData imageData = new ImageData(8 * scale, 4 * scale, depth, palette, bytesPerLine, data);
        if (isClean) {
            return imageData;
        }
        int[] pixelValues = null;
        PaletteData indexedPalette = ImageDataTestHelper.makeTestPalette(1, false);
        if (isDirect) {
            pixelValues = new int[indexedPalette.colors.length];
            int iColor = 0;
            while (iColor < pixelValues.length) {
                pixelValues[iColor] = palette.getPixel(indexedPalette.colors[iColor]);
                ++iColor;
            }
        }
        int y = 0;
        while (y < 4) {
            int x = 0;
            while (x < 8) {
                int colorIndex = random.nextInt(indexedPalette.colors.length);
                int pixel = isDirect ? pixelValues[colorIndex] : colorIndex;
                int yStep = 0;
                while (yStep < scale) {
                    int xStep = 0;
                    while (xStep < scale) {
                        imageData.setPixel(x * scale + xStep, y * scale + yStep, pixel);
                        ++xStep;
                    }
                    ++yStep;
                }
                ++x;
            }
            ++y;
        }
        Method method = ImageData.class.getDeclaredMethod("getByteOrder", new Class[0]);
        method.setAccessible(true);
        int defaultByteOrderForDepth = (Integer)method.invoke((Object)imageData, new Object[0]);
        if (defaultByteOrderForDepth != byteOrder) {
            BlitTestInfo actualInfo = new BlitTestInfo(depth, scale, defaultByteOrderForDepth, isDirect, imageData);
            imageData = ImageDataTestHelper.blit((BlitTestInfo)actualInfo, (int)depth, (int)scale, (int)byteOrder, (boolean)isDirect).imageData;
        }
        return imageData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlitTestInfo blit(BlitTestInfo srcInfo, int dstInfo_depth, int dstInfo_scale, int dstInfo_byteOrder, boolean dstInfo_isDirect) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ImageData src = srcInfo.imageData;
        ImageData dst = ImageDataTestHelper.makeTestImageData(dstInfo_depth, dstInfo_scale, dstInfo_byteOrder, dstInfo_isDirect, true);
        if (srcInfo.isDirect) {
            if (!dstInfo_isDirect) throw new UnsupportedOperationException();
            Method blitMethod = ImageData.class.getDeclaredMethod("blit", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            blitMethod.setAccessible(true);
            blitMethod.invoke(null, src.data, src.depth, src.bytesPerLine, srcInfo.byteOrder, src.width, src.height, src.palette.redMask, src.palette.greenMask, src.palette.blueMask, dst.data, dst.depth, dst.bytesPerLine, dstInfo_byteOrder, dst.width, dst.height, dst.palette.redMask, dst.palette.greenMask, dst.palette.blueMask, false, false);
            return new BlitTestInfo(dstInfo_depth, dstInfo_scale, dstInfo_byteOrder, dstInfo_isDirect, dst);
        } else if (dstInfo_isDirect) {
            Method blitMethod = ImageData.class.getDeclaredMethod("blit", Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, byte[].class, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            blitMethod.setAccessible(true);
            blitMethod.invoke(null, src.width, src.height, src.data, src.depth, src.bytesPerLine, srcInfo.byteOrder, srcInfo.paletteR, srcInfo.paletteG, srcInfo.paletteB, dst.data, dst.depth, dst.bytesPerLine, dstInfo_byteOrder, dst.palette.redMask, dst.palette.greenMask, dst.palette.blueMask);
            return new BlitTestInfo(dstInfo_depth, dstInfo_scale, dstInfo_byteOrder, dstInfo_isDirect, dst);
        } else {
            Method blitMethod = ImageData.class.getDeclaredMethod("blit", byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            blitMethod.setAccessible(true);
            blitMethod.invoke(null, src.data, src.depth, src.bytesPerLine, srcInfo.byteOrder, src.width, src.height, dst.data, dst.depth, dst.bytesPerLine, dstInfo_byteOrder, dst.width, dst.height, false, false);
        }
        return new BlitTestInfo(dstInfo_depth, dstInfo_scale, dstInfo_byteOrder, dstInfo_isDirect, dst);
    }

    public static void assertImageDataEqual(ImageData source, ImageData actual, ImageData expected) {
        if (TEST_BLIT_SHOW_IMAGES) {
            Image[] images = new Image[]{new Image((Device)Display.getCurrent(), source), new Image((Device)Display.getCurrent(), actual), new Image((Device)Display.getCurrent(), expected)};
            SwtTestUtil.debugDisplayImages(images, 3);
            images[0].dispose();
            images[1].dispose();
            images[2].dispose();
        }
        Assert.assertArrayEquals((byte[])actual.data, (byte[])expected.data);
    }

    public static class BlitTestInfo {
        public final int depth;
        public final int scale;
        public final int byteOrder;
        public final boolean isDirect;
        public final ImageData imageData;
        public final byte[] paletteR;
        public final byte[] paletteG;
        public final byte[] paletteB;

        public BlitTestInfo(int depth, int scale, int byteOrder, boolean isDirect, ImageData imageData) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.depth = depth;
            this.scale = scale;
            this.byteOrder = byteOrder;
            this.isDirect = isDirect;
            ImageData imageData2 = this.imageData = imageData != null ? imageData : ImageDataTestHelper.makeTestImageData(depth, scale, byteOrder, isDirect, false);
            if (!isDirect) {
                RGB[] rgbs = this.imageData.palette.getRGBs();
                this.paletteR = new byte[rgbs.length];
                this.paletteG = new byte[rgbs.length];
                this.paletteB = new byte[rgbs.length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        this.paletteR[i] = (byte)rgb.red;
                        this.paletteG[i] = (byte)rgb.green;
                        this.paletteB[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
            } else {
                this.paletteR = null;
                this.paletteG = null;
                this.paletteB = null;
            }
        }

        public BlitTestInfo(int depth, int scale, int byteOrder, boolean isDirect) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this(depth, scale, byteOrder, isDirect, null);
        }

        public String toString() {
            return "{depth=" + this.depth + " scale=" + this.scale + " byteOrder=" + this.byteOrder + " isDirect=" + this.isDirect + "}";
        }
    }
}

