/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.HashMap;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ConsistencyUtility {
    static HashMap<String, String[]> eventOrdering = new HashMap();
    static HashMap<String, Integer> eventTypes = new HashMap();
    static String[] eventNames;
    public static String[] selectionTypes;
    public static int[][] selectionConversion;
    static String[] traversalTypes;
    static final int NONE = 0;
    static final int SHELL_ICONIFY = 1;
    static final int KEY_PRESS = 10;
    static final int DOUBLE_KEY_PRESS = 20;
    static final int MOUSE_CLICK = 30;
    static final int MOUSE_DOUBLECLICK = 40;
    static final int MOUSE_DRAG = 50;
    static final int SELECTION = 60;
    static final int ESCAPE_MENU = 1;

    static {
        eventOrdering.put("DoubleClick", new String[]{"MouseDown", "Selection:", "MouseUp", "MouseDown", "MouseDoubleClick", "DefaultSelection", "MouseUp"});
        eventOrdering.put("DragDetect", new String[]{"MouseDown", "DragDetect", "MouseUp"});
        eventOrdering.put("EnterSelection", new String[]{"Traverse:Return", "KeyDown", "DefaultSelection", "KeyUp"});
        eventOrdering.put("KeySelection", new String[]{"Traverse:Arrow Next", "KeyDown", "Selection:", "KeyUp"});
        eventOrdering.put("MenuDetect", new String[]{"MouseDown", "MenuDetect", "MouseUp"});
        eventOrdering.put("ButtonMouseSelection", new String[]{"MouseDown", "MouseUp", "Selection:"});
        eventOrdering.put("ComboMouseSelection", new String[]{"MouseDown", "MouseUp", "Verify", "Modify", "Selection:"});
        eventOrdering.put("CComboMouseSelection", new String[]{"Modify", "Selection:"});
        eventOrdering.put("ExpandBarMouseSelection", new String[]{"MouseDown", "MouseUp", "Selection:"});
        eventOrdering.put("ListMouseSelection", new String[]{"MouseDown", "MouseUp", "Selection:"});
        eventOrdering.put("SashMouseSelection", new String[]{"Selection:Drag", "MouseDown", "Selection:", "MouseUp"});
        eventOrdering.put("TabFolderMouseSelection", new String[]{"MouseDown", "Selection:", "MouseUp"});
        eventOrdering.put("TableMouseSelection", new String[]{"MouseDown", "Selection:", "MouseUp"});
        eventOrdering.put("ToolBarMouseSelection", new String[]{"MouseDown", "MouseUp", "Selection:"});
        eventOrdering.put("TreeMouseSelection", new String[]{"MouseDown", "Selection:", "MouseUp"});
        eventOrdering.put("CTabFolderMouseSelection", new String[]{"Selection:", "MouseDown", "MouseUp"});
        eventOrdering.put("ListDoubleClick", new String[]{"MouseDown", "MouseUp", "Selection:", "MouseDown", "MouseDoubleClick", "DefaultSelection", "MouseUp"});
        eventOrdering.put("ButtonEnterSelection", new String[]{"Traverse:Return", "KeyDown", "KeyUp"});
        eventOrdering.put("ExpandBarEnterSelection", new String[]{"Traverse:Return", "Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("CComboEnterSelection", new String[]{"Traverse:Return", "DefaultSelection", "KeyDown", "KeyUp"});
        eventOrdering.put("ToolBarEnterSelection", new String[]{"Traverse:Return", "Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("TreeDragDetect", new String[]{"MouseDown", "Selection:", "DragDetect", "MouseUp"});
        eventOrdering.put("TableMenuDetect", new String[]{"MenuDetect", "MouseDown", "Selection:", "MouseUp"});
        eventOrdering.put("ButtonSpaceSelection", new String[]{"Traverse:Mnemonic", "KeyDown", "KeyUp", "Selection:"});
        eventOrdering.put("ExpandBarSpaceSelection", new String[]{"MouseDown", "MouseUp", "Selection:", "Traverse:Mnemonic", "KeyDown", "KeyUp"});
        eventOrdering.put("ListSpaceSelection", new String[]{"Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("ToolBarSpaceSelection", new String[]{"MouseDown", "MouseUp", "Selection:", "Traverse:Mnemonic", "KeyDown", "KeyUp"});
        eventOrdering.put("TreeSpaceSelection", new String[]{"Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("ComboKeySelection", new String[]{"KeyDown", "Verify", "Modify", "Selection:", "KeyUp"});
        eventOrdering.put("CComboKeySelection", new String[]{"Traverse:Arrow Next", "Modify", "Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("CTabFolderKeySelection", new String[]{"Traverse:Arrow Next", "Selection:", "KeyDown", "KeyUp"});
        eventOrdering.put("SliderKeySelection", new String[]{"Traverse:Arrow Next", "KeyDown", "Selection:Arrow Down", "KeyUp"});
        eventOrdering.put("SliderArrowSelection", new String[]{"MouseDown", "Selection:Arrow Down", "MouseUp"});
        eventOrdering.put("CoolBarChevronDragDetect", new String[]{"MouseDown", "DragDetect"});
        eventOrdering.put("CoolBarChevronMenuDetect", new String[]{"MouseDown", "Selection:Arrow"});
        eventOrdering.put("CoolBarChevronMouseSelection", new String[]{"MouseDown", "Selection:Arrow"});
        eventOrdering.put("ScaleTroughSelection", new String[]{"Selection:", "MouseDown", "MouseUp"});
        eventOrdering.put("SliderTroughSelection", new String[]{"MouseDown", "Selection:Page Down", "MouseUp"});
        eventOrdering.put("ScaleThumbSelection", new String[]{"Selection:", "MouseDown", "MouseUp"});
        eventOrdering.put("SliderThumbSelection", new String[]{"MouseDown", "Selection:Drag", "MouseUp"});
        eventOrdering.put("ShellClose", new String[]{"Close", "Dispose"});
        eventOrdering.put("ShellDispose", new String[]{"Dispose"});
        eventOrdering.put("ShellIconify", new String[]{"FocusOut", "Iconify", "Deactivate", "Deiconify", "Activate", "FocusIn", "Activate"});
        eventOrdering.put("ShellOpen", new String[]{"Activate", "FocusIn", "Show"});
        eventOrdering.put("TabFolderPgdwnSelection", new String[]{"KeyDown", "Traverse:Page Next", "Selection:", "KeyUp", "KeyUp"});
        eventOrdering.put("TabFolderPgupSelection", new String[]{"KeyDown", "Traverse:Page Previous", "Selection:", "KeyUp", "KeyUp"});
        eventOrdering.put("CTabFolderPgdwnSelection", new String[]{"KeyDown", "Selection:", "Traverse:None", "KeyUp", "KeyUp"});
        eventOrdering.put("CTabFolderPgupSelection", new String[]{"KeyDown", "Selection:", "Traverse:None", "KeyUp", "KeyUp"});
        eventOrdering.put("StyledTextModify", new String[]{"Verify", "Modify", "KeyDown", "KeyUp"});
        eventOrdering.put("TextModify", new String[]{"KeyDown", "Verify", "Modify", "KeyUp"});
        eventOrdering.put("TreeKeyExpand", new String[]{"Traverse:Arrow Next", "KeyDown", "Expand", "KeyUp"});
        eventOrdering.put("TreeMouseExpand", new String[]{"Expand", "MouseDown", "MouseUp"});
        eventTypes.put("None", 0);
        eventTypes.put("KeyDown", 1);
        eventTypes.put("KeyUp", 2);
        eventTypes.put("MouseDown", 3);
        eventTypes.put("MouseUp", 4);
        eventTypes.put("MouseMove", 5);
        eventTypes.put("MouseEnter", 6);
        eventTypes.put("MouseExit", 7);
        eventTypes.put("MouseDoubleClick", 8);
        eventTypes.put("Paint", 9);
        eventTypes.put("Move", 10);
        eventTypes.put("Resize", 11);
        eventTypes.put("Dispose", 12);
        eventTypes.put("Selection", 13);
        eventTypes.put("DefaultSelection", 14);
        eventTypes.put("FocusIn", 15);
        eventTypes.put("FocusOut", 16);
        eventTypes.put("Expand", 17);
        eventTypes.put("Collapse", 18);
        eventTypes.put("Iconify", 19);
        eventTypes.put("Deiconify", 20);
        eventTypes.put("Close", 21);
        eventTypes.put("Show", 22);
        eventTypes.put("Hide", 23);
        eventTypes.put("Modify", 24);
        eventTypes.put("Verify", 25);
        eventTypes.put("Activate", 26);
        eventTypes.put("Deactivate", 27);
        eventTypes.put("Help", 28);
        eventTypes.put("DragDetect", 29);
        eventTypes.put("Arm", 30);
        eventTypes.put("Traverse", 31);
        eventTypes.put("MouseHover", 32);
        eventTypes.put("HardKeyDown", 33);
        eventTypes.put("HardKeyUp", 34);
        eventTypes.put("MenuDetect", 35);
        eventTypes.put("SetData", 36);
        eventNames = new String[]{"None", "KeyDown", "KeyUp", "MouseDown", "MouseUp", "MouseMove", "MouseEnter", "MouseExit", "MouseDoubleClick", "Paint", "Move", "Resize", "Dispose", "Selection", "DefaultSelection", "FocusIn", "FocusOut", "Expand", "Collapse", "Iconify", "Deiconify", "Close", "Show", "Hide", "Modify", "Verify", "Activate", "Deactivate", "Help", "DragDetect", "Arm", "Traverse", "MouseHover", "HardKeyDown", "HardKeyUp", "MenuDetect", "SetData"};
        selectionTypes = new String[]{"Drag", "Home", "End", "Arrow Down", "Arrow Up", "Page Down", "Page Up", "Check", "Arrow"};
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{0x1000007, 1};
        nArrayArray[2] = new int[]{0x1000008, 2};
        nArrayArray[3] = new int[]{0x1000002, 3};
        nArrayArray[4] = new int[]{0x1000001, 4};
        nArrayArray[5] = new int[]{0x1000006, 5};
        nArrayArray[6] = new int[]{0x1000005, 6};
        nArrayArray[7] = new int[]{32, 7};
        nArrayArray[8] = new int[]{4, 8};
        selectionConversion = nArrayArray;
        traversalTypes = new String[]{"None", "Escape", "Return", "Tab Previous", "Tab Next", "Arrow Previous", "Arrow Next", "Mnemonic", "Page Previous", "Page Next"};
    }

    static int[] convertEventNames(String[] origNames) {
        String[] names = new String[origNames.length];
        System.arraycopy(origNames, 0, names, 0, origNames.length);
        names = ConsistencyUtility.removeDuplicates(names);
        int[] types = new int[names.length];
        int i = 0;
        while (i < names.length) {
            types[i] = eventTypes.get(names[i]);
            ++i;
        }
        return types;
    }

    private static String[] removeDuplicates(String[] names) {
        int dups = 0;
        int i = 0;
        while (i < names.length) {
            int index = names[i].indexOf(58);
            if (index != -1) {
                names[i] = names[i].substring(0, index);
            }
            int j = 0;
            while (j < i) {
                if (names[i].equals(names[j])) {
                    int k = i + 1;
                    while (k < names.length) {
                        names[k - 1] = names[k];
                        ++k;
                    }
                    names[names.length - 1] = "duplicate" + dups;
                    ++dups;
                }
                ++j;
            }
            ++i;
        }
        String[] temp = new String[names.length - dups];
        System.arraycopy(names, 0, temp, 0, names.length - dups);
        return temp;
    }

    static String getSelectionType(int type) {
        int[][] nArray = selectionConversion;
        int n = selectionConversion.length;
        int n2 = 0;
        while (n2 < n) {
            int[] element = nArray[n2];
            if (type == element[0]) {
                return selectionTypes[element[1]];
            }
            ++n2;
        }
        return "";
    }

    static String getTraversalType(int type) {
        int pow = 0;
        if (type != 0) {
            pow = (int)(Math.log(type) / Math.log(2.0));
        }
        return traversalTypes[pow];
    }

    static boolean postClick(Display display, int x, int y, int button) {
        Event event = new Event();
        event.type = 5;
        event.x = x;
        event.y = y;
        if (!display.post(event)) {
            System.out.println("MouseMove not posted");
            return false;
        }
        event = new Event();
        event.type = 3;
        event.button = button;
        if (!display.post(event)) {
            System.out.println("MouseDown not posted");
            return false;
        }
        event = new Event();
        event.type = 4;
        event.button = button;
        if (!display.post(event)) {
            System.out.println("MouseUp not posted");
            return false;
        }
        return true;
    }

    static boolean postClick(Display display, Point pt, int button) {
        return ConsistencyUtility.postClick(display, pt.x, pt.y, button);
    }

    static boolean postDoubleClick(Display display, Point pt, int button) {
        boolean ret = ConsistencyUtility.postClick(display, pt, button);
        return ret &= ConsistencyUtility.postClick(display, pt, button);
    }

    static boolean postKeyPress(Display display, int ch, int keycode) {
        Event event = new Event();
        event.type = 1;
        event.character = (char)ch;
        event.keyCode = keycode;
        if (!display.post(event)) {
            System.out.println("KeyDown not posted");
            return false;
        }
        event = new Event();
        event.type = 2;
        event.character = (char)ch;
        event.keyCode = keycode;
        if (!display.post(event)) {
            System.out.println("KeyUp not posted");
            return false;
        }
        return true;
    }

    static boolean postDoubleKeyPress(Display display, int ch1, int keycode1, int ch2, int keycode2) {
        Event event = new Event();
        event.type = 1;
        event.character = (char)ch1;
        event.keyCode = keycode1;
        if (!display.post(event)) {
            System.out.println("KeyDown not posted");
            return false;
        }
        ConsistencyUtility.postKeyPress(display, ch2, keycode2);
        event = new Event();
        event.type = 2;
        event.character = (char)ch1;
        event.keyCode = keycode1;
        if (!display.post(event)) {
            System.out.println("KeyUp not posted");
            return false;
        }
        return true;
    }

    static boolean postDrag(Display display, Point origin, Point destination) {
        int button = ConsistencyUtility.determineDrag();
        Event event = new Event();
        event.type = 5;
        event.x = origin.x;
        event.y = origin.y;
        if (!display.post(event)) {
            System.out.println("MouseMove not posted");
            return false;
        }
        event = new Event();
        event.type = 3;
        event.button = button;
        if (!display.post(event)) {
            System.out.println("MouseDown not posted");
            return false;
        }
        event = new Event();
        event.type = 5;
        event.x = destination.x;
        event.y = destination.y;
        if (!display.post(event)) {
            System.out.println("MouseMove not posted");
            return false;
        }
        event = new Event();
        event.type = 4;
        event.button = button;
        if (!display.post(event)) {
            System.out.println("MouseUp not posted");
            return false;
        }
        return true;
    }

    private static int determineDrag() {
        if (SwtTestUtil.isWindows || SwtTestUtil.isGTK) {
            return 1;
        }
        return 2;
    }

    static boolean postSelection(final Display display, Point pt1, Point pt2) {
        boolean ret = ConsistencyUtility.postClick(display, pt1, 1);
        display.syncExec((Runnable)new Thread(){

            @Override
            public void run() {
                display.update();
            }
        });
        return ret &= ConsistencyUtility.postClick(display, pt2, 1);
    }

    static boolean postShellIconify(Display display, Point pt, int button) {
        int x = pt.x;
        int y = pt.y - 10;
        if (SwtTestUtil.isWindows) {
            x -= 35;
        } else if (SwtTestUtil.isLinux) {
            x -= 16;
        }
        return ConsistencyUtility.postClick(display, x, y, button);
    }
}

