/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.internal.DPIUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.LINUX}, disabledReason="Linux uses Cairo auto scaling, thus DPIUtil scaling is disabled")
public class DPIUtilTests {
    public void scaleDownInteger() {
        int valueAt200 = 10;
        int valueAt150 = 7;
        int valueAt100 = 5;
        int scaledValue = DPIUtil.pixelToPoint((int)valueAt200, (int)200);
        Assertions.assertEquals((int)valueAt100, (int)scaledValue, (String)"Scaling down integer from 200 failed");
        scaledValue = DPIUtil.pixelToPoint((int)valueAt150, (int)150);
        Assertions.assertEquals((int)valueAt100, (int)scaledValue, (String)"Scaling down integer from 150 failed");
        scaledValue = DPIUtil.pixelToPoint((int)valueAt100, (int)100);
        Assertions.assertSame((Object)valueAt100, (Object)scaledValue, (String)"Scaling down integer without zoom change failed");
    }

    @Test
    public void scaleDownFloat() {
        float valueAt200 = 10.0f;
        float valueAt150 = 7.5f;
        float valueAt100 = 5.0f;
        float scaledValue = DPIUtil.pixelToPoint((float)valueAt200, (int)200);
        Assertions.assertEquals((float)valueAt100, (float)scaledValue, (float)0.001f, (String)"Scaling down float from 200 failed");
        scaledValue = DPIUtil.pixelToPoint((float)valueAt150, (int)150);
        Assertions.assertEquals((float)valueAt100, (float)scaledValue, (float)0.001f, (String)"Scaling down float from 150 failed");
        scaledValue = DPIUtil.pixelToPoint((float)valueAt100, (int)100);
        Assertions.assertEquals((float)valueAt100, (float)scaledValue, (float)0.001f, (String)"Scaling down float without zoom change failed");
    }
}

