/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.function.BiFunction;
import org.eclipse.swt.graphics.ImageData;
import org.junit.Assert;

public class ImageTestUtil {
    public static void assertImagesEqual(ImageData expected, ImageData actual) {
        ImageTestUtil.assertImagesEqual(new ImageData[]{expected}, new ImageData[]{actual});
    }

    public static void assertImagesNotEqual(ImageData expected, ImageData actual) {
        ImageTestUtil.assertImagesNotEqual(new ImageData[]{expected}, new ImageData[]{actual});
    }

    public static void assertImagesNotEqual(ImageData[] expected, ImageData[] actual) {
        try {
            ImageTestUtil.assertImagesEqual(expected, actual);
        }
        catch (AssertionError assertionError) {
            return;
        }
        Assert.fail((String)"Images are equal.");
    }

    public static void assertImagesEqual(ImageData[] expected, ImageData[] actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((String)"Different number of frames.", (long)expected.length, (long)actual.length);
        BiFunction<String, Integer, String> formatMsg = (msg, i) -> expected.length == 1 ? msg + "." : msg + " in frame " + String.valueOf(i) + ".";
        int i2 = 0;
        while (i2 < expected.length) {
            Assert.assertEquals((String)formatMsg.apply("Different width", i2), (long)expected[i2].width, (long)actual[i2].width);
            Assert.assertEquals((String)formatMsg.apply("Different height", i2), (long)expected[i2].height, (long)actual[i2].height);
            int expectedFixAlpha = ImageTestUtil.getEffectiveAlpha(expected[i2], -1, -1);
            int actualFixAlpha = ImageTestUtil.getEffectiveAlpha(actual[i2], -1, -1);
            int[] expectedLine = new int[expected[i2].width];
            int[] actualLine = new int[actual[i2].width];
            int y = 0;
            while (y < expected[i2].height) {
                expected[i2].getPixels(0, y, expected[i2].width, expectedLine, 0);
                actual[i2].getPixels(0, y, actual[i2].width, actualLine, 0);
                int x = 0;
                while (x < expected[i2].width) {
                    int actualAlpha;
                    Assert.assertEquals((String)formatMsg.apply("Different color at x=" + x + ", y=" + y, i2), (Object)expected[i2].palette.getRGB(expectedLine[x]), (Object)actual[i2].palette.getRGB(actualLine[x]));
                    int expectedAlpha = expectedFixAlpha < 0 ? ImageTestUtil.getEffectiveAlpha(expected[i2], x, y) : expectedFixAlpha;
                    int n = actualAlpha = actualFixAlpha < 0 ? ImageTestUtil.getEffectiveAlpha(actual[i2], x, y) : actualFixAlpha;
                    if (expectedAlpha != actualAlpha) {
                        Assert.assertEquals((String)formatMsg.apply("Different alpha at x=" + x + ", y=" + y, i2), (long)expectedAlpha, (long)actualAlpha);
                    }
                    Assert.assertNotEquals((String)formatMsg.apply("Invalid alpha at x=" + x + ", y=" + y, i2), (long)-1L, (long)actualAlpha);
                    ++x;
                }
                ++y;
            }
            ++i2;
        }
    }

    private static int getEffectiveAlpha(ImageData data, int x, int y) {
        if (data.alpha >= 0) {
            return data.alpha;
        }
        if (data.alphaData != null) {
            if (x < 0 || y < 0) {
                return -1;
            }
            return data.getAlpha(x, y);
        }
        if (!data.palette.isDirect) {
            if (x < 0 || y < 0) {
                return -1;
            }
            return data.transparentPixel != -1 && data.getPixel(x, y) == data.transparentPixel ? 0 : 255;
        }
        if (data.depth != 32) {
            return 255;
        }
        int alphaMask = ~(data.palette.redMask | data.palette.greenMask | data.palette.blueMask);
        if (data.depth != 32) {
            alphaMask &= (1 << data.depth) - 1;
        }
        if (alphaMask == 0) {
            return 255;
        }
        if (x < 0 || y < 0) {
            return -1;
        }
        int alpha = data.getPixel(x, y) & alphaMask;
        int mask = -2;
        while (alphaMask != 0) {
            if ((alphaMask & 1) == 0) {
                alpha = alpha & ~mask | (alpha & mask) >>> 1;
                mask >>>= 1;
            }
            alphaMask >>>= 1;
        }
        return 0;
    }
}

