/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class SwtTestUtil {
    public static boolean fCheckBogusTestCases = false;
    public static boolean fCheckVisibility = false;
    public static boolean fCheckSWTPolicy = false;
    public static boolean fTestDialogOpen = false;
    public static boolean fTestConsistency = false;
    public static boolean verbose = false;
    public static String[] imageFormats = new String[]{"bmp", "jpg", "gif", "png"};
    public static String[] imageFilenames = new String[]{"folder", "folderOpen", "target"};
    public static String[] invalidImageFilenames = new String[]{"corrupt", "corruptBadBitDepth.png"};
    public static String[] transparentImageFilenames = new String[]{"transparent.png"};
    public static final String testFontName;
    public static final String testFontNameFixedWidth;
    public static final boolean isWindows;
    public static final boolean isCocoa;
    public static final boolean isGTK;
    public static final boolean isWindowsOS;
    public static final boolean isLinux;
    public static final boolean isRunningOnContinousIntegration;
    public static final boolean isX11;
    private static final PaletteData palette;
    private static boolean displayExpected;

    static {
        isWindows = SWT.getPlatform().startsWith("win32");
        isCocoa = SWT.getPlatform().startsWith("cocoa");
        isGTK = SWT.getPlatform().equals("gtk");
        isWindowsOS = System.getProperty("os.name").startsWith("Windows");
        isLinux = System.getProperty("os.name").equals("Linux");
        isRunningOnContinousIntegration = isGTK && "genie.platform".equalsIgnoreCase(System.getProperty("user.name"));
        isX11 = isGTK && "x11".equals(System.getProperty("org.eclipse.swt.internal.gdk.backend"));
        palette = new PaletteData(65280, 0xFF0000, -16777216);
        testFontName = "Helvetica";
        if (isCocoa) {
            testFontNameFixedWidth = "Monaco";
        } else if (isGTK) {
            testFontNameFixedWidth = "Monospace";
        } else if (isWindows) {
            testFontNameFixedWidth = "Consolas";
        } else {
            testFontNameFixedWidth = null;
            Assert.fail((String)"A fixed width font is needed for this platform");
        }
        displayExpected = true;
    }

    public static void assertSWTProblem(String message, int expectedCode, Throwable actualThrowable) {
        if (actualThrowable instanceof SWTError) {
            SWTError error = (SWTError)actualThrowable;
            Assert.assertEquals((String)message, (long)expectedCode, (long)error.code);
        } else if (actualThrowable instanceof SWTException) {
            SWTException exception = (SWTException)actualThrowable;
            Assert.assertEquals((String)message, (long)expectedCode, (long)exception.code);
        } else {
            try {
                SWT.error((int)expectedCode);
            }
            catch (Throwable expectedThrowable) {
                if (actualThrowable.getMessage().length() > expectedThrowable.getMessage().length()) {
                    Assert.assertTrue((String)message, (boolean)actualThrowable.getMessage().startsWith(expectedThrowable.getMessage()));
                }
                Assert.assertEquals((String)message, (Object)expectedThrowable.getMessage(), (Object)actualThrowable.getMessage());
            }
        }
    }

    public static boolean isBidi() {
        return true;
    }

    public static void openShell(Shell shell) {
        if (shell != null && !shell.getVisible()) {
            if (isGTK) {
                SwtTestUtil.waitEvent(() -> shell.open(), (Control)shell, 9, 1000);
            } else {
                shell.open();
            }
        }
    }

    public static void debugDisplayImage(Image image) {
        Display display = (Display)image.getDevice();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setSize(image.getBounds().width + 50, image.getBounds().height + 100);
        Canvas canvas = new Canvas((Composite)shell, 0);
        canvas.addPaintListener(e -> e.gc.drawImage(image, 10, 10));
        SwtTestUtil.openShell(shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void debugDisplayImages(Image[] images, int numColumns) {
        Display display = (Display)images[0].getDevice();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(numColumns, false));
        Image[] imageArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            Label label = new Label((Composite)shell, 0);
            label.setImage(image);
            ++n2;
        }
        shell.pack();
        SwtTestUtil.openShell(shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void debugDisplayImage(int[][] pixels, int startColumn, int numColumns) {
        Image image = SwtTestUtil.createImage(pixels, startColumn, numColumns);
        try {
            SwtTestUtil.debugDisplayImage(image);
        }
        finally {
            image.dispose();
        }
    }

    public static void debugDisplayDifferences(Image expected, Image actual) {
        final Display display = (Display)expected.getDevice();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        int width = Math.max(expected.getBounds().width, actual.getBounds().width) + 50;
        int height = Math.max(expected.getBounds().height, actual.getBounds().height) + 100;
        shell.setSize(width, height);
        final Canvas canvas = new Canvas((Composite)shell, 0);
        canvas.addPaintListener(e -> {
            e.gc.setBackground(display.getSystemColor(1));
            e.gc.fillRectangle(new Rectangle(0, 0, width, height));
            System.out.println("Drawing " + (displayExpected ? "expected" : "actual"));
            e.gc.drawImage(displayExpected ? expected : actual, 10, 10);
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                displayExpected = !displayExpected;
                canvas.redraw();
                display.timerExec(500, (Runnable)this);
            }
        };
        display.timerExec(500, runnable);
        SwtTestUtil.openShell(shell);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void dumpShellState(PrintStream out) {
        Display display = Display.getCurrent();
        out.println("Display.getFocusControl() and its parents: ");
        Control focusControl = display.getFocusControl();
        if (focusControl == null) {
            out.println("  <null>");
        } else {
            StringBuilder indent = new StringBuilder();
            do {
                Rectangle bounds = focusControl.getBounds();
                out.format("  %08X Rect=[%4d,%4d - %4dx%4d] %s%s%n", focusControl.hashCode(), bounds.x, bounds.y, bounds.width, bounds.height, indent, focusControl);
                focusControl = focusControl.getParent();
                indent.append("  ");
            } while (focusControl != null);
        }
        out.println("Display.getShells(): ");
        Shell[] shells = display.getShells();
        if (shells.length == 0) {
            out.println("  <none>");
        } else {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                Rectangle bounds = shell.getBounds();
                out.format("  %08X Active=%c Visible=%c Rect=[%4d,%4d - %4dx%4d] Title=%s%n", shell.hashCode(), Character.valueOf(display.getActiveShell() == shell ? (char)'Y' : 'N'), Character.valueOf(shell.isVisible() ? (char)'Y' : 'N'), bounds.x, bounds.y, bounds.width, bounds.height, shell.getText());
                ++n2;
            }
        }
    }

    public static Image createImage(int[][] pixels, int startColumn, int numColumns) {
        int width = pixels.length;
        int height = width > 0 ? pixels[0].length : 0;
        int displayWidth = numColumns;
        ImageData imageData = new ImageData(displayWidth, height, 32, palette);
        int x = 0;
        while (x < displayWidth) {
            int y = 0;
            while (y < height) {
                imageData.setPixel(x, y, pixels[x + startColumn][y]);
                ++y;
            }
            ++x;
        }
        Image image = new Image((Device)Display.getDefault(), imageData);
        return image;
    }

    public static int[][] getAllPixels(Image image) {
        ImageData imageData = image.getImageData();
        Rectangle bounds = image.getBounds();
        int[][] pixels = new int[bounds.width][];
        int x = 0;
        while (x < bounds.width) {
            pixels[x] = new int[bounds.height];
            int y = 0;
            while (y < bounds.height) {
                pixels[x][y] = imageData.getPixel(x, y);
                ++y;
            }
            ++x;
        }
        return pixels;
    }

    public static void assertSimilarBrightness(String message, int expected, int actual) {
        if (expected != actual) {
            double expectedIntensity = SwtTestUtil.getBrightness(expected);
            double actualIntensity = SwtTestUtil.getBrightness(actual);
            Assert.assertEquals((String)message, (double)expectedIntensity, (double)actualIntensity, (double)31.875);
        }
    }

    private static double getBrightness(int pixel) {
        RGB rgb = palette.getRGB(pixel);
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue;
    }

    public static void processEvents() {
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static void processEvents(int timeoutMs, BooleanSupplier breakCondition) throws InterruptedException {
        if (breakCondition == null) {
            breakCondition = () -> false;
        }
        long targetTimestamp = System.currentTimeMillis() + (long)timeoutMs;
        Display display = Display.getCurrent();
        while (!breakCondition.getAsBoolean()) {
            if (display.readAndDispatch()) continue;
            if (System.currentTimeMillis() < targetTimestamp) {
                Thread.sleep(50L);
                continue;
            }
            return;
        }
    }

    public static boolean waitEvent(Runnable trigger, Control control, int swtEvent, int timeoutMsec) {
        AtomicBoolean eventReceived = new AtomicBoolean(false);
        Listener listener = event -> eventReceived.set(true);
        control.addListener(swtEvent, listener);
        try {
            if (trigger != null) {
                trigger.run();
            }
            long start = System.currentTimeMillis();
            while (!eventReceived.get()) {
                if (System.currentTimeMillis() - start > (long)timeoutMsec) {
                    return false;
                }
                SwtTestUtil.processEvents();
            }
        }
        finally {
            control.removeListener(swtEvent, listener);
        }
        return true;
    }

    public static void waitShellActivate(Runnable trigger, Shell shell) {
        Runnable triggerWithEnforcedShellActivationOnMacOs = () -> {
            trigger.run();
            if (isCocoa) {
                shell.forceActive();
            }
        };
        if (SwtTestUtil.waitEvent(triggerWithEnforcedShellActivationOnMacOs, (Control)shell, 26, 3000)) {
            return;
        }
        Screenshots.takeScreenshot(SwtTestUtil.class, (String)("waitShellActivate-" + System.currentTimeMillis()));
        SwtTestUtil.dumpShellState(System.out);
        MatcherAssert.assertThat((String)"Shell did not activate", (Object)shell.getDisplay().getActiveShell(), (Matcher)CoreMatchers.is((Object)shell));
        Assert.fail((String)"SWT.Activate was not received but Shell is (incorrectly?) reported active");
    }

    public static boolean hasPixel(Control control, Color expectedColor) {
        return SwtTestUtil.hasPixel(control, expectedColor, null);
    }

    public static boolean hasPixel(Control control, Color expectedColor, Rectangle rect) {
        ImageGcDrawer noOpGcDrawer = (gc, height, width) -> {};
        GC gc2 = new GC((Drawable)control);
        Image image = new Image((Device)control.getDisplay(), noOpGcDrawer, control.getSize().x, control.getSize().y);
        gc2.copyArea(image, 0, 0);
        gc2.dispose();
        boolean result = SwtTestUtil.hasPixel(image, expectedColor, rect);
        image.dispose();
        return result;
    }

    public static boolean hasPixel(Image image, Color expectedColor, Rectangle rect) {
        ImageData imageData = image.getImageData();
        if (rect == null) {
            rect = new Rectangle(0, 0, image.getBounds().width, image.getBounds().height);
        }
        RGB expectedRGB = expectedColor.getRGB();
        int xEnd = rect.x + rect.width;
        int yEnd = rect.y + rect.height;
        int x = Math.max(rect.x, 1);
        while (x < xEnd && x < image.getBounds().width - 1) {
            int y = rect.y;
            while (y < yEnd && y < image.getBounds().height) {
                RGB pixelRGB = imageData.palette.getRGB(imageData.getPixel(x, y));
                if (expectedRGB.equals((Object)pixelRGB)) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public static boolean hasPixelNotMatching(Image image, Color nonMatchingColor, Rectangle rect) {
        ImageData imageData = image.getImageData();
        if (rect == null) {
            rect = new Rectangle(0, 0, image.getBounds().width, image.getBounds().height);
        }
        RGB nonMatchingRGB = nonMatchingColor.getRGB();
        int xEnd = rect.x + rect.width;
        int yEnd = rect.y + rect.height;
        int x = Math.max(rect.x, 1);
        while (x < xEnd && x < image.getBounds().width - 1) {
            int y = rect.y;
            while (y < yEnd && y < image.getBounds().height) {
                RGB pixelRGB = imageData.palette.getRGB(imageData.getPixel(x, y));
                if (!nonMatchingRGB.equals((Object)pixelRGB)) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public static Path getPath(String fileName, TemporaryFolder tempFolder) {
        Path filePath = tempFolder.getRoot().toPath().resolve("image-resources").resolve(Path.of(fileName, new String[0]));
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream inStream = SwtTestUtil.class.getResourceAsStream(fileName);){
                    Assertions.assertNotNull((Object)inStream, (String)("InputStream == null for file " + fileName));
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    Files.copy(inStream, filePath, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return filePath;
    }
}

