/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.nio.file.Paths;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

public class Test_org_eclipse_swt_SWT {
    @Test
    public void test_errorI() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SWT.error((int)4), (String)"did not correctly throw exception for ERROR_NULL_ARGUMENT");
        Assertions.assertThrows(SWTException.class, () -> SWT.error((int)46), (String)"did not correctly throw exception for ERROR_FAILED_EXEC");
        Assertions.assertThrows(SWTError.class, () -> SWT.error((int)2), (String)"did not correctly throw exception for ERROR_NO_HANDLES");
        Assertions.assertThrows(SWTError.class, () -> SWT.error((int)-1), (String)"did not correctly throw exception for error(-1)");
    }

    @Test
    public void test_errorILjava_lang_Throwable() {
        RuntimeException cause = new RuntimeException("Just for testing");
        SWTException e1 = (SWTException)Assertions.assertThrows(SWTException.class, () -> SWT.error((int)42, (Throwable)cause));
        Assertions.assertTrue((e1.throwable == cause ? 1 : 0) != 0, (String)"did not correctly throw exception for ERROR_UNSUPPORTED_FORMAT");
        SWTError e2 = (SWTError)Assertions.assertThrows(SWTError.class, () -> SWT.error((int)20, (Throwable)cause));
        Assertions.assertTrue((e2.throwable == cause ? 1 : 0) != 0, (String)"did not correctly throw exception for ERROR_NOT_IMPLEMENTED");
        SWTError e3 = (SWTError)Assertions.assertThrows(SWTError.class, () -> SWT.error((int)-1, (Throwable)cause));
        Assertions.assertTrue((e3.throwable == cause ? 1 : 0) != 0, (String)"did not correctly throw exception for error(-1)");
    }

    @Test
    public void test_getMessageLjava_lang_String() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String string = SWT.getMessage(null);
        }, (String)"did not correctly throw exception with null argument");
        Assertions.assertNotNull((Object)SWT.getMessage((String)"SWT_Yes"));
        Assertions.assertEquals((Object)"_NOT_FOUND_IN_PROPERTIES_", (Object)SWT.getMessage((String)"_NOT_FOUND_IN_PROPERTIES_"), (String)"invalid key did not return as itself");
    }

    private String pathFromClass(Class<?> classValue) {
        String filePrefix = SwtTestUtil.isWindows ? "file:/" : "file:";
        String url = classValue.getProtectionDomain().getCodeSource().getLocation().toString();
        Assertions.assertTrue((boolean)url.startsWith(filePrefix));
        String urlPath = url.substring(filePrefix.length());
        String path = Paths.get(urlPath, new String[0]).toAbsolutePath().toString();
        return path.replace('\\', '/');
    }

    private List<String> signersFromClass(Class<?> classValue) {
        ArrayList<String> result = new ArrayList<String>();
        CodeSigner[] signers = classValue.getProtectionDomain().getCodeSource().getCodeSigners();
        if (signers == null) {
            return result;
        }
        CodeSigner[] codeSignerArray = signers;
        int n = signers.length;
        int n2 = 0;
        while (n2 < n) {
            CodeSigner signer = codeSignerArray[n2];
            Certificate cert = signer.getSignerCertPath().getCertificates().get(0);
            if (cert instanceof X509Certificate) {
                X509Certificate x509cert = (X509Certificate)cert;
                result.add(x509cert.getSubjectX500Principal().getName());
            }
            ++n2;
        }
        return result;
    }

    @Test
    @DisabledIfSystemProperty(named="org.eclipse.swt.tests.junit.disable.test_isLocal", matches="true")
    public void test_isLocal() {
        String swtPath = this.pathFromClass(SWT.class);
        String tstPath = this.pathFromClass(Test_org_eclipse_swt_SWT.class);
        List<String> swtSigners = this.signersFromClass(SWT.class);
        for (String signer : swtSigners) {
            if (!signer.toLowerCase().contains("cn=eclipse.org")) continue;
            Assertions.fail((String)("Tested SWT is signed by Eclipse: (SWT='" + swtPath + "' signer='" + signer + "')"));
        }
        if (swtPath.contains("/.m2/repository/p2/osgi/")) {
            Assertions.fail((String)("Tested SWT path is on maven OSGI: (SWT='" + swtPath + "' Test='" + tstPath + "'"));
        }
    }

    @Test
    public void test_getPlatform() {
        Assertions.assertNotNull((Object)SWT.getPlatform(), (String)"returned null platform name");
    }

    @Test
    public void test_getVersion() {
        int ver = SWT.getVersion();
        Assertions.assertTrue((ver > 0 && ver < 1000000 ? 1 : 0) != 0, (String)("unreasonable value returned:" + ver));
    }
}

