/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class Test_org_eclipse_swt_browser_Browser
extends Test_org_eclipse_swt_widgets_Composite {
    private static Duration MAXIMUM_BROWSER_CREATION_TIME = Duration.ofSeconds(90L);
    boolean debug_show_browser = false;
    int debug_show_browser_timeout_seconds = 2;
    boolean debug_verbose_output = false;
    int secondsToWaitTillFail;
    @Rule
    public TestName name = new TestName();
    Browser browser;
    boolean isEdge = false;
    StringBuilder testLog;
    static int testNumber;
    int openedDescriptors;
    static List<String> initialOpenedDescriptors;
    List<Browser> createdBroswers = new ArrayList<Browser>();
    static List<String> descriptors;
    private final int swtBrowserSettings;
    @ClassRule
    public static TemporaryFolder tempFolder;
    ProgressListener callCustomFunctionUponLoad = ProgressListener.completedAdapter(event -> {
        boolean bl = this.browser.execute("callCustomFunction()");
    });

    static {
        try {
            Test_org_eclipse_swt_browser_Browser.printSystemEnv();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("org.eclipse.swt.internal.win32.Edge.timeout", Long.toString(MAXIMUM_BROWSER_CREATION_TIME.toMillis()));
        initialOpenedDescriptors = new ArrayList<String>();
        descriptors = new ArrayList<String>();
        tempFolder = new TemporaryFolder();
    }

    private void testLogAppend(String msg) {
        this.testLog.append("  " + msg + "\n");
    }

    @Parameterized.Parameters(name="browser flags: {0}")
    public static Collection<Object[]> browserFlagsToTest() {
        ArrayList<Object[]> browserFlags = new ArrayList<Object[]>();
        browserFlags.add(new Object[]{0});
        if (SwtTestUtil.isWindows) {
            browserFlags.add(new Object[]{524288});
        }
        return browserFlags;
    }

    public Test_org_eclipse_swt_browser_Browser(int swtBrowserSettings) {
        this.swtBrowserSettings = swtBrowserSettings;
    }

    @BeforeClass
    public static void setupEdgeEnvironment() {
        if (SwtTestUtil.isWindows) {
            Shell shell = new Shell();
            Browser firstBrowser = new Browser((Composite)shell, 262144);
            firstBrowser.getUrl();
            shell.dispose();
            Test_org_eclipse_swt_browser_Browser.processUiEvents();
        }
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        ++testNumber;
        this.secondsToWaitTillFail = Math.max(15, this.debug_show_browser_timeout_seconds);
        System.out.println("Running Test_org_eclipse_swt_browser_Browser#" + this.name.getMethodName());
        this.shell.setLayout((Layout)new FillLayout());
        this.browser = this.createBrowser(this.shell, this.swtBrowserSettings);
        this.isEdge = this.browser.getBrowserType().equals("edge");
        Object shellTitle = this.name.getMethodName();
        if (SwtTestUtil.isGTK) {
            String webkitGtkVersionStr = System.getProperty("org.eclipse.swt.internal.webkitgtk.version");
            shellTitle = (String)shellTitle + " Webkit version: " + webkitGtkVersionStr;
        }
        this.shell.setText((String)shellTitle);
        this.setWidget((Widget)this.browser);
        this.testLog = new StringBuilder("\nTest log:\n");
        if (SwtTestUtil.isGTK) {
            Test_org_eclipse_swt_browser_Browser.processUiEvents();
            descriptors = Collections.unmodifiableList(Test_org_eclipse_swt_browser_Browser.getOpenedDescriptors());
            System.out.println("\n### Descriptors opened BEFORE " + this.name.getMethodName() + ": " + descriptors.size());
        }
    }

    @Override
    protected void afterDispose(Display display) {
        int descriptorDiff;
        super.afterDispose(display);
        Shell[] shells = Display.getDefault().getShells();
        int disposedShells = 0;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (!(shell.getParent() == null || shell.getText() != null && shell.getText().contains("limbo") || shell.isDisposed())) {
                System.out.println("Not disposed shell: " + String.valueOf(shell));
                shell.dispose();
                ++disposedShells;
            }
            ++n2;
        }
        if (disposedShells > 0) {
            throw new RuntimeException("Found " + disposedShells + " not disposed shells!");
        }
        int disposedBrowsers = 0;
        for (Browser browser : this.createdBroswers) {
            if (browser.isDisposed()) continue;
            System.out.println("Not disposed browsers: " + String.valueOf(browser));
            browser.dispose();
            ++disposedBrowsers;
        }
        Assert.assertEquals((String)("Found " + disposedBrowsers + " not disposed browsers!"), (long)0L, (long)disposedBrowsers);
        boolean verbose = false;
        if (verbose) {
            if (testNumber % 2 == 0) {
                Test_org_eclipse_swt_browser_Browser.printMemoryUse();
            } else {
                Test_org_eclipse_swt_browser_Browser.printThreadsInfo();
            }
        }
        if (this.isEdge) {
            Test_org_eclipse_swt_browser_Browser.processUiEvents();
        }
        if (SwtTestUtil.isGTK && (descriptorDiff = this.reportOpenedDescriptors()) > 0) {
            Test_org_eclipse_swt_browser_Browser.processUiEvents();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Test_org_eclipse_swt_browser_Browser.processUiEvents();
            descriptorDiff = this.reportOpenedDescriptors();
            if (descriptorDiff > 0) {
                Test_org_eclipse_swt_browser_Browser.processUiEvents();
            }
        }
    }

    private int reportOpenedDescriptors() {
        List<String> newDescriptors = Test_org_eclipse_swt_browser_Browser.getOpenedDescriptors();
        System.out.println("\n### Descriptors opened AFTER " + this.name.getMethodName() + ": " + newDescriptors.size());
        int count = newDescriptors.size();
        int diffToPrevious = count - descriptors.size();
        int diffToInitial = count - initialOpenedDescriptors.size();
        if (diffToPrevious > 0) {
            System.out.println("Delta to previous test: " + diffToPrevious);
            ArrayList<String> newDescriptorsCopy = new ArrayList<String>(newDescriptors);
            newDescriptors.removeAll(descriptors);
            newDescriptors.forEach(p -> System.out.println("\t" + p));
            System.out.println();
            System.out.println("Delta to first test: " + diffToInitial);
            if (diffToInitial > testNumber + 50) {
                newDescriptorsCopy.removeAll(initialOpenedDescriptors);
                newDescriptorsCopy.forEach(p -> System.out.println("\t" + p));
                Assert.fail((String)("Too many (" + diffToInitial + ") leaked file descriptors: " + String.valueOf(newDescriptorsCopy)));
            }
            System.out.println("########################################\n");
        }
        return diffToPrevious;
    }

    private Browser createBrowser(Shell s, int flags) {
        Instant createStartTime = Instant.now();
        Browser b = new Browser((Composite)s, flags);
        b.getUrl();
        this.createdBroswers.add(b);
        Duration createDuration = Duration.between(createStartTime, Instant.now());
        Assert.assertTrue((String)("creating browser took too long: " + createDuration.toMillis() + "ms"), (boolean)createDuration.minus(MAXIMUM_BROWSER_CREATION_TIME).isNegative());
        return b;
    }

    @Override
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        Browser browser = this.createBrowser(this.shell, this.swtBrowserSettings);
        browser.dispose();
        browser = this.createBrowser(this.shell, 0x800 | this.swtBrowserSettings);
        browser.dispose();
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Browser browser = this.createBrowser(null, this.swtBrowserSettings);
        });
    }

    @Test
    public void test_Constructor_asyncParentDisposal() {
        Display.getCurrent().asyncExec(() -> this.shell.dispose());
        Browser browser = this.createBrowser(this.shell, this.swtBrowserSettings);
        Assert.assertFalse((boolean)browser.isDisposed());
    }

    @Test
    public void test_Constructor_multipleInstantiationsInDifferentShells() {
        int i = 0;
        while (i < 5) {
            Shell browserShell = new Shell(Display.getCurrent());
            Browser browser = this.createBrowser(browserShell, this.swtBrowserSettings);
            Assert.assertFalse((boolean)browser.isDisposed());
            browser.dispose();
            Assert.assertTrue((boolean)browser.isDisposed());
            browserShell.dispose();
            Assert.assertTrue((boolean)browserShell.isDisposed());
            ++i;
        }
    }

    @Test
    public void test_Constructor_multipleInstantiationsInDifferentThreads() {
        Assume.assumeTrue((String)"This test is intended for Edge only", (boolean)this.isEdge);
        int numberOfApplication = 5;
        ArrayList<EdgeBrowserApplication> browserApplications = new ArrayList<EdgeBrowserApplication>();
        int i = 0;
        while (i < numberOfApplication) {
            EdgeBrowserApplication application = new EdgeBrowserApplication();
            browserApplications.add(application);
            application.start();
            ++i;
        }
        for (EdgeBrowserApplication application : browserApplications) {
            this.waitForPassCondition(() -> edgeBrowserApplication.isRunning);
            Assert.assertFalse((boolean)application.isDisposed);
        }
        for (EdgeBrowserApplication application : browserApplications) {
            application.close();
            Assert.assertTrue((boolean)application.isDisposed);
        }
    }

    @Test
    public void test_evalute_Cookies() {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("https://www.eclipse.org/swt");
        this.shell.open();
        this.waitForPassCondition(loaded::get);
        this.browser.evaluate("document.cookie = \"cookie1=value1\";");
        this.browser.evaluate("document.cookie = \"cookie2=value2\";");
        String res = (String)this.browser.evaluate("return document.cookie;");
        Assert.assertFalse((boolean)res.isEmpty());
    }

    @Test
    public void test_ClearAllSessionCookies() {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("https://www.eclipse.org/swt");
        this.shell.open();
        this.waitForPassCondition(loaded::get);
        Browser.setCookie((String)"cookie1=value1", (String)"https://www.eclipse.org/swt");
        Browser.setCookie((String)"cookie2=value2", (String)"https://www.eclipse.org/swt");
        String v1 = Browser.getCookie((String)"cookie1", (String)"https://www.eclipse.org/swt");
        String v2 = Browser.getCookie((String)"cookie2", (String)"https://www.eclipse.org/swt");
        Assert.assertEquals((Object)"value1", (Object)v1);
        Assert.assertEquals((Object)"value2", (Object)v2);
        Browser.clearSessions();
        String e1 = Browser.getCookie((String)"cookie1", (String)"https://www.eclipse.org/swt");
        String e2 = Browser.getCookie((String)"cookie2", (String)"https://www.eclipse.org/swt");
        Assert.assertTrue((e1 == null || e1.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((e2 == null || e2.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void test_get_set_Cookies() {
        AtomicBoolean loaded = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> loaded.set(true)));
        this.browser.setUrl("https://www.eclipse.org/swt");
        this.shell.open();
        this.waitForPassCondition(loaded::get);
        Browser.setCookie((String)"cookie1=value1", (String)"https://www.eclipse.org/swt");
        Browser.setCookie((String)"cookie2=value2", (String)"https://www.eclipse.org/swt");
        String v1 = Browser.getCookie((String)"cookie1", (String)"https://www.eclipse.org/swt");
        Assert.assertEquals((Object)"value1", (Object)v1);
        String v2 = Browser.getCookie((String)"cookie2", (String)"https://www.eclipse.org/swt");
        Assert.assertEquals((Object)"value2", (Object)v2);
    }

    @Override
    @Test
    public void test_getChildren() {
        if (SwtTestUtil.isWindows && !this.isEdge) {
            int childCount = this.composite.getChildren().length;
            String msg = "Browser on Win32 is a special case, the first child is an OleFrame (ActiveX control). Actual child count is: " + childCount;
            Assert.assertEquals((String)msg, (long)1L, (long)childCount);
        } else {
            super.test_getChildren();
        }
    }

    @Test
    public void test_CloseWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addCloseWindowListener(event -> {});
        shell.close();
    }

    @Test
    public void test_CloseWindowListener_addWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addCloseWindowListener(null));
    }

    @Test
    public void test_CloseWindowListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeCloseWindowListener(null));
    }

    @Test
    public void test_CloseWindowListener_addAndRemove() {
        CloseWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addCloseWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeCloseWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_CloseWindowListener_close() {
        AtomicBoolean browserCloseListenerFired = new AtomicBoolean(false);
        this.browser.addCloseWindowListener(e -> {
            this.disposedIntentionally = true;
            browserCloseListenerFired.set(true);
        });
        this.browser.setText("<script language='JavaScript'>window.close()</script>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(browserCloseListenerFired::get);
        Assert.assertTrue((String)"Test timed out.", (boolean)passed);
    }

    @Test
    public void test_LocationListener_adapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        LocationAdapter adapter = new LocationAdapter(){};
        browser.addLocationListener((LocationListener)adapter);
        shell.close();
    }

    @Test
    public void test_LocationListener_addWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addLocationListener(null));
    }

    @Test
    public void test_LocationListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeLocationListener(null));
    }

    @Test
    public void test_LocationListener_addAndRemove() {
        LocationListener listener = new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addLocationListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeLocationListener(listener);
            ++i;
        }
    }

    @Test
    public void test_LocationListener_changing() {
        AtomicBoolean changingFired = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changingAdapter(e -> changingFired.set(true)));
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(changingFired::get);
        Assert.assertTrue((String)"LocationListener.changing() event was never fired", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changed() {
        AtomicBoolean changedFired = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> changedFired.set(true)));
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(changedFired::get);
        String errorMsg = String.format("LocationListener.changed() event was never fired. Browser URL after waitForPassCondition: %s", this.browser.getUrl());
        Assert.assertTrue((String)errorMsg, (boolean)passed);
    }

    @Test
    public void test_LocationListener_changed_twoSetTextCycles() {
        AtomicInteger changedCount = new AtomicInteger();
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> {
            int n = changedCount.incrementAndGet();
        }));
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(() -> changedCount.get() == 1);
        Assert.assertTrue((String)"LocationListener.changed() event was never fired", (boolean)passed);
        this.browser.setText("2nd text");
        passed = this.waitForPassCondition(() -> changedCount.get() == 2);
        Assert.assertTrue((String)"LocationListener.changed() event was not fired for the 2nd text change", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changingAndOnlyThenChanged() {
        final AtomicBoolean changingFired = new AtomicBoolean(false);
        final AtomicBoolean changedFired = new AtomicBoolean(false);
        final AtomicBoolean changedFiredTooEarly = new AtomicBoolean(false);
        final AtomicBoolean finished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                changingFired.set(true);
            }

            public void changed(LocationEvent event) {
                if (!changingFired.get()) {
                    changedFiredTooEarly.set(true);
                }
                changedFired.set(true);
                finished.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(finished::get);
        if (finished.get() && changingFired.get() && changedFired.get() && !changedFiredTooEarly.get()) {
            return;
        }
        if (!finished.get()) {
            Assert.fail((String)"Test timed out. 'changed()' never fired");
        } else if (changedFiredTooEarly.get()) {
            Assert.fail((String)"changed() was fired before changing(). Wrong signal order");
        } else if (!changingFired.get()) {
            Assert.fail((String)"changing() was never fired");
        } else {
            Assert.fail((String)("LocationListener test failed. changing():" + changingFired.get() + "  changed():" + changedFired.get() + " changedFiredTooEarly:" + changedFiredTooEarly.get()));
        }
    }

    @Test
    public void test_LocationListener_then_ProgressListener() {
        AtomicBoolean locationChanged = new AtomicBoolean(false);
        AtomicBoolean progressChanged = new AtomicBoolean(false);
        AtomicBoolean progressChangedAfterLocationChanged = new AtomicBoolean(false);
        AtomicReference browserTextOnCompletedEvent = new AtomicReference();
        this.browser.addLocationListener(LocationListener.changedAdapter(event -> locationChanged.set(true)));
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            browserTextOnCompletedEvent.set(this.browser.getText());
            if (locationChanged.get()) {
                progressChangedAfterLocationChanged.set(true);
            }
            progressChanged.set(true);
        }));
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(progressChanged::get);
        String errorMsg = "\nUnexpected listener states. Expecting true for all, but have:\nLocation changed: " + locationChanged.get() + "\nProgressChangedAfterLocationChanged: " + progressChangedAfterLocationChanged.get() + "\nprogressChanged: " + progressChanged.get() + "\nbrowser text on completed event: " + (String)browserTextOnCompletedEvent.get() + "\nbrowser text after waitForPassCondition: " + this.browser.getText();
        Assert.assertTrue((String)errorMsg, (boolean)progressChangedAfterLocationChanged.get());
    }

    @Test
    public void test_LocationListener_ProgressListener_canceledLoad() {
        final AtomicBoolean locationChanging = new AtomicBoolean(false);
        final AtomicBoolean unexpectedLocationChanged = new AtomicBoolean(false);
        AtomicBoolean unexpectedProgressCompleted = new AtomicBoolean(false);
        final AtomicReference<String> unexpectedLocationChangedDetails = new AtomicReference<String>("(empty)");
        AtomicReference<String> unexpectedProgressCompletedDetails = new AtomicReference<String>("(empty)");
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                event.doit = false;
                locationChanging.set(true);
            }

            public void changed(LocationEvent event) {
                if (!event.location.isEmpty()) {
                    unexpectedLocationChanged.set(true);
                    unexpectedLocationChangedDetails.set(event.location);
                }
            }
        });
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String location = this.browser.getUrl();
            if (!location.isEmpty()) {
                unexpectedProgressCompleted.set(true);
                unexpectedProgressCompletedDetails.set(location);
            }
        }));
        this.shell.open();
        this.browser.setText("You should not see this message.");
        this.waitForMilliseconds(1000);
        boolean passed = false;
        passed = SwtTestUtil.isCocoa ? locationChanging.get() : locationChanging.get() && !unexpectedLocationChanged.get() && !unexpectedProgressCompleted.get();
        String errMsg = "\nUnexpected event fired. \nLocationChanging (should be true): " + locationChanging.get() + "\nLocationChanged unexpectedly (should be false): " + unexpectedLocationChanged.get() + (String)(unexpectedLocationChanged.get() ? " (" + unexpectedLocationChangedDetails.get() + ")" : "") + "\nProgressChanged unexpectedly (should be false): " + unexpectedProgressCompleted.get() + (String)(unexpectedProgressCompleted.get() ? " (" + unexpectedProgressCompletedDetails.get() + ")" : "") + "\n";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_LocationListener_LocationListener_ordered_changing() {
        List locations = Collections.synchronizedList(new ArrayList());
        this.browser.addLocationListener(LocationListener.changingAdapter(event -> locations.add(event.location)));
        this.shell.open();
        this.browser.setText("You should not see this message.");
        String url = this.getValidUrl();
        this.browser.setUrl(url);
        Assert.assertTrue((String)("Change of locations do not fire in order: " + locations.toString()), (boolean)this.waitForPassCondition(() -> locations.size() == 2));
        Assert.assertTrue((String)"Change of locations do not fire in order", (((String)locations.get(0)).equals("about:blank") && ((String)locations.get(1)).contains("testWebsiteWithTitle.html") ? 1 : 0) != 0);
    }

    private String getValidUrl() {
        return SwtTestUtil.getPath("testWebsiteWithTitle.html", tempFolder).toUri().toString();
    }

    @Test
    public void test_LocationListener_ProgressListener_noExtraEvents() {
        AtomicInteger changedCount = new AtomicInteger(0);
        AtomicInteger completedCount = new AtomicInteger(0);
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> {
            int n = changedCount.incrementAndGet();
        }));
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> {
            int n = completedCount.incrementAndGet();
        }));
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(() -> changedCount.get() == 1 && completedCount.get() == 1);
        this.waitForMilliseconds(600);
        boolean passed = changedCount.get() == 1 && completedCount.get() == 1;
        String errorMsg = "\nIncorrect event sequences. Too many fired:\nExpected one of each, but received:\nChanged count: " + changedCount.get() + "\nCompleted count: " + completedCount.get();
        Assert.assertTrue((String)errorMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addOpenWindowListener(event -> {});
        shell.close();
    }

    @Test
    public void test_OpenWindowListener_addWithNulArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addOpenWindowListener(null));
    }

    @Test
    public void test_OpenWindowListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeOpenWindowListener(null));
    }

    @Test
    public void test_OpenWindowListener_addAndRemove() {
        OpenWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addOpenWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeOpenWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_OpenWindowListener_openHasValidEventDetails() {
        AtomicBoolean openFiredCorrectly = new AtomicBoolean(false);
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild = this.createBrowser(this.shell, this.swtBrowserSettings);
            Assert.assertSame((String)"Expected Browser1 instance, but have another instance", (Object)this.browser, (Object)event.widget);
            Assert.assertNull((String)"Expected event.browser to be null", (Object)event.browser);
            openFiredCorrectly.set(true);
            event.browser = browserChild;
        });
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>window.open('about:blank')</script>\n<body>This test uses Javascript to open a new window.</body></html>\n");
        boolean passed = this.waitForPassCondition(openFiredCorrectly::get);
        Assert.assertTrue((String)"Test timed out. OpenWindow event not fired.", (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_open_ChildPopup() {
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        Shell childShell = new Shell(this.shell, 0);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild = this.createBrowser(childShell, this.swtBrowserSettings);
            browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event2 -> {
                childShell.open();
                browserChild.setText("Child Browser");
            }));
            browserChild.addProgressListener(ProgressListener.completedAdapter(event2 -> childCompleted.set(true)));
            event.browser = browserChild;
        });
        this.shell.open();
        this.browser.setText("<html>\n<script type='text/javascript'>\nvar newWin = window.open('about:blank');\n</script>\n<body>This test uses javascript to open a new window.</body>\n</html>");
        boolean passed = this.waitForPassCondition(childCompleted::get);
        String errMsg = "Test timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindow_Progress_Listener_ValidateEventOrder() {
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        AtomicBoolean visibilityShowed = new AtomicBoolean(false);
        Set eventOrder = Collections.synchronizedSet(new LinkedHashSet());
        Shell childShell = new Shell(this.shell, 0);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild;
            event.browser = browserChild = this.createBrowser(childShell, this.swtBrowserSettings);
            browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event2 -> {
                eventOrder.add("Visibility.show");
                visibilityShowed.set(true);
                childShell.open();
            }));
            browserChild.addProgressListener(ProgressListener.completedAdapter(event2 -> {
                eventOrder.add("Progress.completed");
                childCompleted.set(true);
                browserChild.setText("Child Browser!");
            }));
        });
        this.shell.open();
        this.browser.setText("<html>\n<script type='text/javascript'>\nvar newWin = window.open('about:blank');\n</script>\n<body>This test uses javascript to open a new window.</body>\n</html>");
        boolean passed = this.waitForPassCondition(() -> visibilityShowed.get() && childCompleted.get());
        String errMsg = "\nTest timed out.\nExpected true for the below, but have:\nVisibilityShowed:" + visibilityShowed.get() + "\nChildCompleted:" + childCompleted.get();
        Assert.assertTrue((String)errMsg, (boolean)passed);
        Assert.assertEquals((String)"Child Visibility.show should have fired before progress completed", List.of("Visibility.show", "Progress.completed"), List.copyOf(eventOrder));
    }

    @Test
    public void test_ProgressListener_newProgressAdapter() {
        new ProgressAdapter(){};
    }

    @Test
    public void test_ProgressListener_newProgressAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addProgressListener((ProgressListener)new ProgressAdapter(){});
        shell.close();
    }

    @Test
    public void test_ProgressListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        });
        shell.close();
    }

    @Test
    public void test_ProgressListener_addWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addProgressListener(null));
    }

    @Test
    public void test_ProgressListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeProgressListener(null));
    }

    @Test
    public void test_ProgressListener_addAndRemove() {
        ProgressListener listener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addProgressListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeProgressListener(listener);
            ++i;
        }
    }

    @Test
    public void test_ProgressListener_completed_Called() {
        final AtomicBoolean childCompleted = new AtomicBoolean(false);
        final AtomicReference browserTextOnChangedEvent = new AtomicReference();
        ProgressListener l = new ProgressListener(){

            public void completed(ProgressEvent event) {
                childCompleted.set(true);
            }

            public void changed(ProgressEvent event) {
                browserTextOnChangedEvent.set(Test_org_eclipse_swt_browser_Browser.this.browser.getText());
            }
        };
        this.browser.addProgressListener(l);
        this.browser.setText("<html><body>This test ensures that the completed listener is called.</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(childCompleted::get);
        String errorMsg = "Browser text before completed: " + (String)browserTextOnChangedEvent.get() + "\nBrowser text after completed: " + this.browser.getText();
        Assert.assertTrue((String)errorMsg, (boolean)passed);
    }

    @Test
    public void test_StatusTextListener_addWithNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addStatusTextListener(null));
    }

    @Test
    public void test_StatusTextListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeStatusTextListener(null));
    }

    @Test
    public void test_StatusTextListener_addAndRemove() {
        StatusTextListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addStatusTextListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeStatusTextListener(listener);
            ++i;
        }
    }

    @Test
    public void test_StatusTextListener_hoverMouseOverLink() {
        Assume.assumeFalse((String)"no API in Edge for this", (boolean)this.isEdge);
        AtomicBoolean statusChanged = new AtomicBoolean(false);
        int size = 500;
        Browser browser = this.createBrowser(this.shell, this.swtBrowserSettings);
        StringBuilder longhtml = new StringBuilder();
        int i = 0;
        while (i < 200) {
            longhtml.append("text text text text text text text text text text text text text text text text text text text text text text text text<br>");
            ++i;
        }
        browser.setText("<a href='http://localhost'>" + String.valueOf(longhtml) + "</a>");
        this.shell.setLocation(0, 0);
        this.shell.setSize(size, size);
        browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Display display = event.display;
            Point cachedLocation = display.getCursorLocation();
            display.setCursorLocation(20, 10);
            browser.getBounds();
            int i = 0;
            while (i < size) {
                display.setCursorLocation(i, i);
                this.waitForMilliseconds(this.debug_show_browser ? 3 : 1);
                i += 5;
            }
            display.setCursorLocation(cachedLocation);
        }));
        browser.addStatusTextListener(event -> statusChanged.set(true));
        this.shell.open();
        boolean passed = this.waitForPassCondition(statusChanged::get);
        String msg = "Mouse movement over text was suppose to trigger StatusTextListener. But it didn't";
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_TitleListener_addListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addTitleListener(event -> {});
        shell.close();
    }

    @Test
    public void test_TitleListener_addwithNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addTitleListener(null));
    }

    @Test
    public void test_TitleListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeTitleListener(null));
    }

    @Test
    public void test_TitleListener_addAndRemove() {
        TitleListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addTitleListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeTitleListener(listener);
            ++i;
        }
    }

    @Test
    public void test_TitleListener_event() {
        AtomicBoolean titleListenerFired = new AtomicBoolean(false);
        this.browser.addTitleListener(event -> titleListenerFired.set(true));
        this.browser.setText("<html><title>Hello world</title><body>Page with a title</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(titleListenerFired::get);
        String errMsg = "Title listener never fired. Test timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_setText() {
        String expectedTitle = "Website Title";
        Runnable browserSetFunc = () -> {
            String html = "<html><title>Website Title</title><body>Html page with custom title</body></html>";
            boolean opSuccess = this.browser.setText(html);
            Assert.assertTrue((String)"Expecting setText() to return true", (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setTextContainingScript_applicationLayerProgressListenerMustSeeUpToDateDom() {
        AtomicBoolean completed = new AtomicBoolean();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String script = "var h1s = document.getElementsByTagName(\"h1\");\n// extract the information from the DOM via the document's title\n// since getText() afterwards does not necessarily return the updated DOM (platform-dependent)\ndocument.title = \"ProgressListener: Found \" + h1s.length + \" h1 tag(s)\";\n";
            this.browser.execute(script);
            completed.set(true);
        }));
        AtomicReference title = new AtomicReference();
        this.browser.addTitleListener(event -> {
            if (event.title.startsWith("ProgressListener: ")) {
                title.set(event.title);
            }
        });
        this.browser.setText("<html>\n\t<head>\n\t\t<script>console.log(\"test\");</script>\n\t</head>\n\t<body>\n\t\t<h1>Hello, World!</h1>\n\t</body>\n</html>\n");
        Assert.assertTrue((String)"progress completion not reported", (boolean)this.waitForPassCondition(completed::get));
        Assert.assertTrue((String)"title not set", (boolean)this.waitForPassCondition(() -> title.get() != null));
        Assert.assertTrue((String)("unexpected title: " + (String)title.get()), (boolean)this.waitForPassCondition(() -> ((String)title.get()).contains("ProgressListener: Found 1 h1 tag(s)")));
    }

    @Test
    public void test_setUrl_local() {
        Assume.assumeFalse((String)"Test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.swt/issues/722", (boolean)SwtTestUtil.isCocoa);
        String expectedTitle = "Website Title";
        Runnable browserSetFunc = () -> {
            String url = this.getValidUrl();
            this.testLogAppend("URL: " + url);
            boolean opSuccess = this.browser.setUrl(url);
            Assert.assertTrue((String)("Expecting setUrl() to return true" + this.testLog.toString()), (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setUrl_remote() {
        Assume.assumeFalse((String)"Test fails on Mac, see https://github.com/eclipse-platform/eclipse.platform.swt/issues/722", (boolean)SwtTestUtil.isCocoa);
        this.secondsToWaitTillFail = 35;
        String url = "https://example.com";
        Assume.assumeTrue((String)"Skipping test due to bad internet connection", (boolean)Test_org_eclipse_swt_browser_Browser.checkInternet(url));
        this.testLog.append("checkInternet() passed");
        String expectedTitle = "Example Domain";
        Runnable browserSetFunc = () -> {
            this.testLog.append("Setting Browser url to:" + url);
            boolean opSuccess = this.browser.setUrl(url);
            Assert.assertTrue((String)"Expecting setUrl() to return true", (boolean)opSuccess);
        };
        this.validateTitleChanged(expectedTitle, browserSetFunc);
    }

    @Test
    public void test_setUrl_remote_with_post() {
        this.secondsToWaitTillFail = 35;
        String url = "https://bugs.eclipse.org/bugs/buglist.cgi";
        Assume.assumeTrue((String)"Skipping test due to bad internet connection", (boolean)Test_org_eclipse_swt_browser_Browser.checkInternet(url));
        this.testLog.append("checkInternet() passed");
        Runnable browserSetFunc = () -> {
            this.testLog.append("Setting Browser url to:" + url);
            boolean opSuccess = this.browser.setUrl(url, "bug_severity=enhancement&bug_status=NEW&email1=rgrunber&emailassigned_to1=1&emailtype1=substring", null);
            Assert.assertTrue((String)"Expecting setUrl() to return true", (boolean)opSuccess);
        };
        AtomicReference<Boolean> completed = new AtomicReference<Boolean>(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            this.testLog.append("ProgressListener fired");
            completed.set(true);
        }));
        browserSetFunc.run();
        this.shell.open();
        boolean hasFinished = this.waitForPassCondition(() -> (boolean)((Boolean)completed.get()));
        Assert.assertTrue((String)("Test timed out. ProgressListener not fired " + this.testLog.toString()), (boolean)hasFinished);
        int numChars = this.browser.getText().length();
        Assert.assertTrue((String)("Response data contained " + numChars + " chars."), (numChars > 10000 ? 1 : 0) != 0);
    }

    private void validateTitleChanged(String expectedTitle, Runnable browserSetFunc) {
        AtomicReference<String> actualTitle = new AtomicReference<String>("");
        this.browser.addTitleListener(event -> {
            this.testLog.append("TitleListener fired");
            Assert.assertNotNull((String)("event title is empty" + this.testLog.toString()), (Object)event.title);
            actualTitle.set(event.title);
        });
        browserSetFunc.run();
        this.shell.open();
        this.waitForPassCondition(() -> ((String)actualTitle.get()).equals(expectedTitle));
        Assert.assertTrue((String)"Test timed out. TitleListener not fired", (actualTitle.get().length() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)this.testLog.toString(), (Object)expectedTitle, (Object)actualTitle.get());
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter() {
        new VisibilityWindowAdapter(){};
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){});
        shell.close();
    }

    @Test
    public void test_VisibilityWindowListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = this.createBrowser(shell, this.swtBrowserSettings);
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        });
        shell.close();
    }

    @Test
    public void test_VisibilityWindowListener_addWithNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.addVisibilityWindowListener(null));
    }

    @Test
    public void test_VisibilityWindowListener_removeWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.browser.removeVisibilityWindowListener(null));
    }

    @Test
    public void test_VisibilityWindowListener_addAndRemove() {
        VisibilityWindowListener listener = new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addVisibilityWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeVisibilityWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_VisibilityWindowListener_multiple_shells() {
        final AtomicBoolean secondChildCompleted = new AtomicBoolean(false);
        AtomicInteger childCount = new AtomicInteger(0);
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild;
            Shell childShell = new Shell(this.shell);
            childShell.setText("Child shell " + childCount.get());
            childShell.setLayout((Layout)new FillLayout());
            event.browser = browserChild = this.createBrowser(childShell, this.swtBrowserSettings);
            browserChild.setText("Child window");
            browserChild.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(childCount){
                AtomicInteger invocationCount = new AtomicInteger(1);
                AtomicInteger childID;
                {
                    this.childID = new AtomicInteger(atomicInteger.get());
                }

                public void show(WindowEvent event) {
                    if (this.childID.get() == 0 && this.invocationCount.get() >= 2 && (event.location != null || event.size != null)) {
                        Assert.fail((String)"Child browser's visibility show listener should only be fired once");
                    }
                    this.invocationCount.incrementAndGet();
                }
            });
            if (childCount.get() == 1) {
                browserChild.addProgressListener((ProgressListener)new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        secondChildCompleted.set(true);
                    }
                });
            }
            childShell.open();
            childCount.incrementAndGet();
        });
        this.shell.open();
        this.browser.setText("<html><script type='text/javascript'>window.open('about:blank');window.open('about:blank');</script>\n<body>This test uses javascript to open a new window.</body>\n</html>");
        boolean passed = this.waitForPassCondition(secondChildCompleted::get);
        String errMsg = "\nTest timed out.";
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_VisibilityWindowListener_eventSize() {
        this.shell.setSize(200, 300);
        AtomicBoolean childCompleted = new AtomicBoolean(false);
        AtomicReference<Point> result = new AtomicReference<Point>(new Point(0, 0));
        Shell childShell = new Shell(this.shell);
        childShell.setSize(250, 350);
        childShell.setText("Child shell");
        childShell.setLayout((Layout)new FillLayout());
        this.browser.addOpenWindowListener(event -> {
            Browser browserChild = this.createBrowser(childShell, this.swtBrowserSettings);
            browserChild.addVisibilityWindowListener(VisibilityWindowListener.showAdapter(event2 -> {
                this.testLog.append("Visibilty show eventfired.\nEvent size: " + String.valueOf(event2.size));
                result.set(event2.size);
                childShell.open();
                childCompleted.set(true);
            }));
            event.browser = browserChild;
            this.testLog.append("openWindowListener fired");
        });
        this.shell.open();
        this.browser.setText("<html>\n<script type='text/javascript'>\nwindow.open('javascript:\"Child Window\"','', \"height=200,width=300\")\n</script>\n<body>This test uses javascript to open a new window.</body>\n</html>");
        boolean finishedWithoutTimeout = this.waitForPassCondition(childCompleted::get);
        childShell.dispose();
        boolean passed = false;
        passed = !SwtTestUtil.isWindows ? finishedWithoutTimeout && result.get().x != 0 && result.get().y != 0 : finishedWithoutTimeout && result.get().x == 300 && result.get().y == 200;
        String errMsg = finishedWithoutTimeout ? "Incorrect size received:\nexpected width=300, actual:" + result.get().x + "\nexpected height=100, actual:" + result.get().y : "test timed out. Child's visibility Window listener didn't trigger";
        Assert.assertTrue((String)(errMsg + this.testLog.toString()), (boolean)passed);
    }

    @Override
    @Test
    public void test_isVisible() {
        super.test_isVisible();
    }

    @Test
    public void test_back() {
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        boolean result = this.browser.back();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_setTextNull() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = this.browser.setText(null);
        });
    }

    @Test
    public void test_setUrlWithNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = this.browser.setUrl(null);
        });
    }

    @Test
    public void test_setJavascriptEnabled() {
        AtomicInteger pageLoadCount = new AtomicInteger(0);
        AtomicBoolean testFinished = new AtomicBoolean(false);
        AtomicBoolean testPassed = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            pageLoadCount.incrementAndGet();
            if (pageLoadCount.get() == 1) {
                this.browser.setJavascriptEnabled(false);
                this.browser.setText("Second page with javascript disabled");
            } else if (pageLoadCount.get() == 2) {
                Boolean expectedNull = null;
                try {
                    expectedNull = (Boolean)this.browser.evaluate("return true");
                }
                catch (Exception exception) {
                    Assert.fail((String)"1) if javascript is disabled, browser.evaluate() should return null. But an Exception was thrown");
                }
                Assert.assertNull((String)("2) Javascript should not have executed. But not-null was returned:" + String.valueOf(expectedNull)), (Object)expectedNull);
                testPassed.set(true);
                testFinished.set(true);
            }
        }));
        this.shell.open();
        this.browser.setText("First page with javascript enabled. This should not be visible as a second page should load");
        this.waitForPassCondition(testFinished::get);
        Assert.assertTrue((String)"3) Javascript was executed on the second page. But it shouldn't have", (boolean)testPassed.get());
    }

    @Test
    public void test_setJavascriptEnabled_multipleInstances() {
        AtomicInteger pageLoadCount = new AtomicInteger(1);
        final AtomicInteger pageLoadCountSecondInstance = new AtomicInteger(1);
        AtomicBoolean instanceOneFinishedCorrectly = new AtomicBoolean(false);
        final AtomicBoolean instanceTwoFinishedCorrectly = new AtomicBoolean(false);
        final Browser browserSecondInsance = this.createBrowser(this.shell, this.swtBrowserSettings);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (pageLoadCount.get() == 1) {
                this.browser.setJavascriptEnabled(false);
                pageLoadCount.set(2);
                this.browser.setText("First instance, second page (with javascript turned off)");
                pageLoadCountSecondInstance.set(2);
                browserSecondInsance.setText("Second instance, second page (javascript execution not changed)");
            } else if (pageLoadCount.get() == 2) {
                pageLoadCount.set(3);
                Boolean shouldBeNull = (Boolean)this.browser.evaluate("return true");
                Assert.assertNull((String)"1) Evaluate execution should be null, but 'true was returned'", (Object)shouldBeNull);
                instanceOneFinishedCorrectly.set(true);
            }
        }));
        browserSecondInsance.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                if (pageLoadCountSecondInstance.get() == 2) {
                    pageLoadCountSecondInstance.set(3);
                    Boolean shouldBeTrue = (Boolean)browserSecondInsance.evaluate("return true");
                    Assert.assertTrue((String)("2) Javascript should be executable in second instance (as javascript was not turned off), but it was not. Expected:'someStr', Actual:" + String.valueOf(shouldBeTrue)), (boolean)shouldBeTrue);
                    instanceTwoFinishedCorrectly.set(true);
                }
            }
        });
        this.browser.setText("First Instance, first page");
        browserSecondInsance.setText("Second instance, first page");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (instanceOneFinishedCorrectly.get() && instanceTwoFinishedCorrectly.get()) {
                return true;
            }
            return false;
        });
        String message = "3) Test timed out. Debug Info:\nInstanceOneFinishedCorrectly: " + instanceOneFinishedCorrectly.get() + "\nInstanceTwoFinishedCorrectly: " + instanceTwoFinishedCorrectly.get() + "\nInstance 1 & 2 page counts: " + pageLoadCount.get() + " & " + pageLoadCountSecondInstance.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_LocationListener_evaluateInCallback() {
        final AtomicBoolean changingFinished = new AtomicBoolean(false);
        final AtomicBoolean changedFinished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanging = true");
                changingFinished.set(true);
            }

            public void changed(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanged = true");
                changedFinished.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("<body>Hello <b>World</b></body>");
        if (SwtTestUtil.isWindows) {
            this.waitForPassCondition(changingFinished::get);
        } else {
            this.waitForPassCondition(() -> changingFinished.get() && changedFinished.get());
        }
        Boolean changed = false;
        try {
            changed = (Boolean)this.browser.evaluate("return SWTchanged");
        }
        catch (SWTException sWTException) {}
        Boolean changing = false;
        try {
            changing = (Boolean)this.browser.evaluate("return SWTchanging");
        }
        catch (SWTException sWTException) {}
        String errMsg = "\n  changing:  fired:" + changingFinished.get() + "    evaluated:" + String.valueOf(changing) + "\n  changed:   fired:" + changedFinished.get() + "    evaluated:" + String.valueOf(changed);
        boolean passed = false;
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            passed = changingFinished.get() && changedFinished.get() && changed != false;
        } else if (SwtTestUtil.isWindows) {
            passed = changingFinished.get();
        }
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_evaluateInCallback() {
        AtomicBoolean eventFired = new AtomicBoolean(false);
        this.browser.addOpenWindowListener(event -> {
            this.browser.evaluate("SWTopenListener = true");
            eventFired.set(true);
            event.required = true;
        });
        this.shell.open();
        this.browser.evaluate("window.open('about:blank')");
        boolean fired = this.waitForPassCondition(eventFired::get);
        boolean evaluated = false;
        try {
            evaluated = (Boolean)this.browser.evaluate("return SWTopenListener");
        }
        catch (SWTException sWTException) {}
        boolean passed = fired && evaluated;
        String errMsg = "Event fired:" + fired + "   evaluated:" + evaluated;
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_forward() {
        int i = 0;
        while (i < 2) {
            this.browser.forward();
            ++i;
        }
        boolean result = this.browser.forward();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_getUrl() {
        String string = this.browser.getUrl();
        Assert.assertNotNull((Object)string);
    }

    @Test
    public void test_isBackEnabled() {
        Assert.assertEquals((Object)this.browser.isBackEnabled(), (Object)this.browser.back());
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        Assert.assertFalse((boolean)this.browser.isBackEnabled());
    }

    @Test
    public void test_isForwardEnabled() {
        Assert.assertEquals((Object)this.browser.isForwardEnabled(), (Object)this.browser.forward());
        int i = 0;
        while (i < 10) {
            this.browser.forward();
            ++i;
        }
        Assert.assertFalse((boolean)this.browser.isForwardEnabled());
    }

    @Test
    public void test_refresh() {
        int i = 0;
        while (i < 2) {
            this.browser.refresh();
            ++i;
        }
    }

    @Override
    @Test
    public void test_setFocus_toChild_afterOpen() {
    }

    @Override
    @Test
    public void test_setFocus_toChild_beforeOpen() {
    }

    @Override
    @Test
    public void test_setFocus_withInvisibleChild() {
    }

    @Override
    @Test
    public void test_setFocus_withVisibleAndInvisibleChild() {
    }

    @Test
    public void test_getText() {
        if (SwtTestUtil.isWindows) {
            this.getText_helper("helloWorld", "<html><head></head><body>helloWorld</body></html>");
        } else {
            this.getText_helper("helloWorld", "helloWorld");
        }
    }

    @Test
    public void test_getText_html() {
        String testString = "<html><head></head><body>hello<b>World</b></body></html>";
        this.getText_helper(testString, testString);
    }

    @Test
    public void test_getText_javascriptDisabled() {
        this.browser.setJavascriptEnabled(false);
        String testString = "<html><head></head><body>hello<b>World</b></body></html>";
        this.getText_helper(testString, testString);
    }

    @Test
    public void test_getText_script() {
        String testString = "<html><head></head><body>hello World<script>document.body.style.backgroundColor = \"red\";</script></body></html>";
        if (SwtTestUtil.isWindows) {
            this.getText_helper(testString, "<html><head></head><body style=\"background-color: red;\">hello World\n<script>document.body.style.backgroundColor = \"red\";</script>\n</body></html>");
        } else {
            this.getText_helper(testString, testString);
        }
    }

    @Test
    public void test_getText_doctype() {
        String testString = "<!DOCTYPE html><html><head></head><body>hello World</body></html>";
        if (SwtTestUtil.isWindows) {
            this.getText_helper(testString, "<html><head></head><body>hello World</body></html>");
        } else {
            this.getText_helper(testString, testString);
        }
    }

    private void getText_helper(String testString, String expectedOutput) {
        AtomicReference<String> returnString = new AtomicReference<String>("");
        AtomicBoolean finished = new AtomicBoolean(false);
        this.browser.setText(testString);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            returnString.set(this.browser.getText());
            if (this.debug_verbose_output) {
                System.out.println((String)returnString.get());
            }
            finished.set(true);
        }));
        this.shell.open();
        this.waitForPassCondition(finished::get);
        String error_msg = finished.get() ? "Test did not return correct string.\nExpected:" + testString + "\nActual:" + returnString.get() : "Test timed out";
        Assert.assertEquals((String)error_msg, (Object)this.normalizeHtmlString(expectedOutput), (Object)this.normalizeHtmlString(returnString.get()));
    }

    private String normalizeHtmlString(String htmlString) {
        return htmlString.replace("\r", "").replace("\n", "").replace(";", "").toLowerCase(Locale.ENGLISH);
    }

    @Test
    public void test_stop() {
        this.browser.setUrl("https://www.eclipse.org/swt");
        this.waitForMilliseconds(1000);
        this.browser.stop();
    }

    @Test
    public void test_execute_withNullArg() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = this.browser.execute(null);
        });
    }

    @Test
    public void test_execute_and_closeListener() {
        AtomicBoolean hasClosed = new AtomicBoolean(false);
        this.browser.setText("You should not see this page, it should have been closed by javascript");
        this.browser.addCloseWindowListener(e -> hasClosed.set(true));
        this.browser.execute("window.close()");
        this.shell.open();
        boolean passed = this.waitForPassCondition(hasClosed::get);
        if (passed) {
            this.disposedIntentionally = true;
        }
        String message = "Either browser.execute() did not work (if you still see the html page) or closeListener Was not triggered if browser looks disposed, but test still fails.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_string() {
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String evalResult = (String)this.browser.evaluate("return document.getElementById('myid').childNodes[0].nodeValue;");
            returnValue.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + evalResult);
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "HelloWorld".equals(returnValue.get()));
        Assert.assertTrue((String)"Evaluation did not return a value. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_returnMoved() {
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            String evalResult = (String)this.browser.evaluate("var x = 1; return 'hello'");
            returnValue.set(evalResult);
        }));
        this.browser.setText("test text");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "hello".equals(returnValue.get()));
        Assert.assertTrue((String)"Evaluation did not return a value. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_number_normal() {
        Double testNum = 123.0;
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)this.evaluate_number_helper(testNum));
    }

    @Test
    public void test_evaluate_number_negative() {
        Double testNum = -123.0;
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)this.evaluate_number_helper(testNum));
    }

    @Test
    public void test_evaluate_number_big() {
        Double testNum = 1.0E10;
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)this.evaluate_number_helper(testNum));
    }

    boolean evaluate_number_helper(Double testNum) {
        AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Double evalResult = (Double)this.browser.evaluate("return " + testNum.toString());
            returnValue.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> testNum.equals(returnValue.get()));
        return passed;
    }

    @Test
    public void test_evaluate_boolean() {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Boolean evalResult = (Boolean)this.browser.evaluate("return true");
            atomicBoolean.set(evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(atomicBoolean::get);
        Assert.assertTrue((String)"Evaluation did not return a boolean. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_null() {
        AtomicReference<Boolean> returnValue = new AtomicReference<Boolean>(true);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            returnValue.set(false);
            Object evalResult = this.browser.evaluate("return null");
            returnValue.set((Boolean)evalResult);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnValue.get() == null);
        Assert.assertTrue((String)("Evaluate did not return a null (current value: " + String.valueOf(returnValue.get()) + "). Timed out."), (boolean)passed);
    }

    @Test
    public void test_evaluate_invalid_return_value() {
        if (SwtTestUtil.isWindows) {
            return;
        }
        AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            try {
                this.browser.evaluate("return new Date()");
            }
            catch (SWTException e) {
                exception.set(e.code);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicBoolean wrongExceptionCode = new AtomicBoolean(false);
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 51) {
                    return true;
                }
                if (exception.get() == 50) {
                    wrongExceptionCode.set(true);
                    return true;
                }
            }
            return false;
        });
        if (wrongExceptionCode.get()) {
            System.err.println("SWT Warning: test_evaluate_invalid_return_value threw wrong exception code. Expected ERROR_INVALID_RETURN_VALUE but got ERROR_FAILED_EVALUATE");
        }
        String message = exception.get() == -1 ? "Exception was not thrown. Test timed out" : "Exception thrown, but wrong code: " + exception.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_evaluation_failed_exception() {
        AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            try {
                this.browser.evaluate("return runSomeUndefinedFunctionInJavaScriptWhichCausesUndefinedError()");
            }
            catch (SWTException e) {
                exception.set(e.code);
            }
        }));
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 50) {
                    return true;
                }
                additionalErrorInfo.set("Invalid exception thrown: " + exception.get());
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not throw an error. Test timed out" : "Javascript threw an error, but not the right one." + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_numbers() {
        AtomicIntegerArray atomicIntArray = new AtomicIntegerArray(3);
        atomicIntArray.set(0, -1);
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(1,2,3)");
            atomicIntArray.set(0, ((Double)evalResult[0]).intValue());
            atomicIntArray.set(1, ((Double)evalResult[1]).intValue());
            atomicIntArray.set(2, ((Double)evalResult[2]).intValue());
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicIntArray.get(0) != -1) {
                if (atomicIntArray.get(0) == 1 && atomicIntArray.get(1) == 2 && atomicIntArray.get(2) == 3) {
                    return true;
                }
                additionalErrorInfo.set("Resulting numbers in the array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javascript called java, but passed wrong values: " + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_strings() {
        AtomicReferenceArray<String> atomicStringArray = new AtomicReferenceArray<String>(3);
        atomicStringArray.set(0, "executing");
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(\"str1\", \"str2\", \"str3\")");
            atomicStringArray.set(0, (String)evalResult[0]);
            atomicStringArray.set(1, (String)evalResult[1]);
            atomicStringArray.set(2, (String)evalResult[2]);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicStringArray.get(0))) {
                if (((String)atomicStringArray.get(0)).equals("str1") && ((String)atomicStringArray.get(1)).equals("str2") && ((String)atomicStringArray.get(2)).equals("str3")) {
                    return true;
                }
                additionalErrorInfo.set("Resulting strings in array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Expected an array of strings, but did not receive array or got the wrong result." : "Received a callback from javascript, but: " + additionalErrorInfo.get() + " : " + atomicStringArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_mixedTypes() {
        AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        this.browser.addProgressListener(ProgressListener.completedAdapter(event -> {
            Object[] evalResult = (Object[])this.browser.evaluate("return new Array(\"str1\", 2, true)");
            atomicArray.set(2, (String)evalResult[2]);
            atomicArray.set(1, (String)evalResult[1]);
            atomicArray.set(0, (String)evalResult[0]);
            if (this.debug_verbose_output) {
                System.out.println("Node value: " + String.valueOf(evalResult));
            }
        }));
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicArray.get(0))) {
                if (atomicArray.get(0).equals("str1") && (Double)atomicArray.get(1) == 2.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                    return true;
                }
                additionalErrorInfo.set("Resulting String are not as exected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javascript called java but passed wrong values: " + atomicArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_OpeningNewWindow() throws Exception {
        AtomicBoolean initialLoad = new AtomicBoolean();
        AtomicBoolean openWindowListenerCalled = new AtomicBoolean();
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> initialLoad.set(true)));
        this.browser.addOpenWindowListener(event -> {
            event.required = true;
            openWindowListenerCalled.set(true);
        });
        this.browser.setText("<button id=\"button\" onClick=\"window.open('https://eclipse.org');\">open eclipse.org</button>\n");
        this.waitForPassCondition(initialLoad::get);
        this.browser.evaluate("\tdocument.getElementById(\"button\").click();\n");
        this.waitForPassCondition(openWindowListenerCalled::get);
    }

    @Test
    public void test_BrowserFunction_callback() {
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava()\n}\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$javaCallbackExecuted.set(true);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "Java failed to get a callback from javascript. Test timed out";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_stackedCalls() {
        Assume.assumeFalse((String)"Not currently working on Linux, see https://github.com/eclipse-platform/eclipse.platform.swt/issues/2021", (boolean)SwtTestUtil.isGTK);
        AtomicInteger javaCallbackExecuted = new AtomicInteger();
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava()\n}\n\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class DeepJavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$javaCallbackExecuted;

            DeepJavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$javaCallbackExecuted = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                if (this.val$javaCallbackExecuted.get() < 5) {
                    this.val$javaCallbackExecuted.incrementAndGet();
                    Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("jsCallbackToJava();");
                }
                return null;
            }
        }
        new DeepJavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> javaCallbackExecuted.get() == 5);
        String message = "Java failed to get a callback from javascript. Test timed out";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_integer() {
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(5)\n}\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnedDouble = (Double)arguments[0];
                this.val$returnInt.set(returnedDouble.intValue());
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 5);
        String message = "Javascript should have passed an integer to Java, but this did not happen.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_boolean() {
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(true)\n}\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Boolean returnBool = (Boolean)arguments[0];
                this.val$javaCallbackExecuted.set(returnBool);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "Javascript did not pass a boolean back to Java.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_String() {
        AtomicReference returnValue = new AtomicReference();
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n    document.body.style.backgroundColor = 'red'\n\tjsCallbackToJava('hellojava')\n}\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReference val$returnValue;

            JavascriptCallback(Browser browser, String name, AtomicReference atomicReference) {
                this.val$returnValue = atomicReference;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                String returnString = (String)arguments[0];
                this.val$returnValue.set(returnString);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnValue);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "hellojava".equals(returnValue.get()));
        String message = "Javascript was suppose to call java with a String, but it seems Java did not receive the call or an incorrect value was passed.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_multipleValues() {
        AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava('hellojava', 5, true)\n}\n</script>\n</head>\n<body> Going to make a callback to Java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReferenceArray val$atomicArray;

            JavascriptCallback(Browser browser, String name, AtomicReferenceArray atomicReferenceArray) {
                this.val$atomicArray = atomicReferenceArray;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$atomicArray.set(1, arguments[1]);
                this.val$atomicArray.set(2, arguments[2]);
                this.val$atomicArray.set(0, arguments[0]);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", atomicArray);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicArray.get(0).equals("hellojava") && (Double)atomicArray.get(1) == 5.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                return true;
            }
            return false;
        });
        String msg = "Values not set. Test timed out. Array should be [\"hellojava\", 5, true], but is: " + atomicArray.toString();
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_javaReturningInt() {
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n     var retVal = jsCallbackToJava()\n     document.write(retVal)\n     jsSuccess(retVal)\n}\n</script>\n</head>\n<body> If you see this, Javascript did not receive anything from Java. This page should just be '42' </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            JavascriptCallback(Browser browser, String name) {
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                return 42;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava");
        class JavascriptCallback_javascriptReceivedJavaInt
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback_javascriptReceivedJavaInt(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnVal = (Double)arguments[0];
                this.val$returnInt.set(returnVal.intValue());
                return null;
            }
        }
        new JavascriptCallback_javascriptReceivedJavaInt(this.browser, "jsSuccess", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 42);
        String message = "Java should have returned something back to Javascript. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_javaReturningString() {
        AtomicReference returnString = new AtomicReference();
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n     var retVal = jsCallbackToJava()\n\t\tdocument.write(retVal)\n     jsSuccess(retVal)\n}</script>\n</head>\n<body> If you see this, Javascript did not receive anything from Java. This page should just be 'a\tcomplicated\"string\\\u00df' </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            JavascriptCallback(Browser browser, String name) {
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                return "a\tcomplicated\"string\\\u00df";
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava");
        class JavascriptCallback_javascriptReceivedJavaInt
        extends BrowserFunction {
            private final /* synthetic */ AtomicReference val$returnString;

            JavascriptCallback_javascriptReceivedJavaInt(Browser browser, String name, AtomicReference atomicReference) {
                this.val$returnString = atomicReference;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$returnString.set((String)arguments[0]);
                return null;
            }
        }
        new JavascriptCallback_javascriptReceivedJavaInt(this.browser, "jsSuccess", returnString);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "a\tcomplicated\"string\\\u00df".equals(returnString.get()));
        String message = "Java should have returned something back to Javascript. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_afterPageReload() {
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        AtomicInteger callCount = new AtomicInteger(0);
        this.browser.setText("1st (initial) page load");
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$callCount;
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean) {
                this.val$callCount = atomicInteger;
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                if (this.val$callCount.get() == 0) {
                    this.val$callCount.set(1);
                    Test_org_eclipse_swt_browser_Browser.this.browser.setText("2nd page load");
                } else {
                    this.val$javaCallbackExecuted.set(true);
                }
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", callCount, javaCallbackExecuted);
        this.browser.execute("jsCallbackToJava()");
        this.browser.addProgressListener(ProgressListener.completedAdapter(e -> {
            boolean bl = this.browser.execute("jsCallbackToJava()");
        }));
        this.shell.open();
        boolean passed = this.waitForPassCondition(javaCallbackExecuted::get);
        String message = "A Javascript callback should work after a page has been reloaded, but something went wrong.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_multiprocess() {
        Browser browser1 = this.createBrowser(this.shell, this.swtBrowserSettings);
        Browser browser2 = this.createBrowser(this.shell, this.swtBrowserSettings);
        class JavaFunc
        extends BrowserFunction {
            JavaFunc(Browser browser) {
                super(browser, "javaFunc");
            }

            public Object function(Object[] arguments) {
                return arguments[0];
            }
        }
        new JavaFunc(browser1);
        new JavaFunc(browser2);
        Assert.assertEquals((Object)"value1", (Object)browser1.evaluate("return javaFunc('value1')"));
        Assert.assertEquals((Object)"value2", (Object)browser2.evaluate("return javaFunc('value2')"));
        final int[] completed = new int[1];
        ProgressAdapter listener = new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                completed[0] = completed[0] + 1;
            }
        };
        browser1.addProgressListener((ProgressListener)listener);
        browser2.addProgressListener((ProgressListener)listener);
        browser1.setText("<body>new_page1");
        browser2.setText("<body>new_page2");
        this.waitForPassCondition(() -> completed[0] == 2);
        Assert.assertEquals((Object)"value1", (Object)browser1.evaluate("return javaFunc('value1')"));
        Assert.assertEquals((Object)"value2", (Object)browser2.evaluate("return javaFunc('value2')"));
        browser1.dispose();
        browser2.dispose();
    }

    @Test
    @Ignore(value="Too fragile on CI, Display.getDefault().post(event) does not work reliably")
    public void test_TabTraversalOutOfBrowser() {
        Assume.assumeFalse((String)"Not currently working on macOS, see https://github.com/eclipse-platform/eclipse.platform.swt/issues/1644", (boolean)SwtTestUtil.isCocoa);
        Assume.assumeFalse((String)"Not currently working on Linux, see https://github.com/eclipse-platform/eclipse.platform.swt/issues/1644", (boolean)SwtTestUtil.isGTK);
        Text text = new Text((Composite)this.shell, 0);
        this.shell.open();
        this.browser.forceFocus();
        AtomicBoolean changedFired = new AtomicBoolean(false);
        this.browser.addLocationListener(LocationListener.changedAdapter(e -> changedFired.set(true)));
        this.browser.setText("Hello world");
        Assert.assertTrue((String)"LocationListener.changed() event was never fired", (boolean)this.waitForPassCondition(changedFired::get));
        Assert.assertTrue((boolean)this.browser.isFocusControl());
        Assert.assertFalse((boolean)text.isFocusControl());
        AtomicBoolean textGainedFocus = new AtomicBoolean(false);
        text.addFocusListener(FocusListener.focusGainedAdapter(e -> textGainedFocus.set(true)));
        this.browser.getShell().forceActive();
        Event event = new Event();
        event.type = 1;
        event.keyCode = 9;
        Display.getDefault().post(event);
        Assert.assertTrue((String)"Text did not gain focus", (boolean)this.waitForPassCondition(textGainedFocus::get));
        Assert.assertFalse((boolean)this.browser.isFocusControl());
        Assert.assertTrue((boolean)text.isFocusControl());
    }

    protected boolean waitForPassCondition(Supplier<Boolean> passTest) {
        return this.waitForPassCondition(passTest, 1000 * this.secondsToWaitTillFail);
    }

    private boolean waitForPassCondition(Supplier<Boolean> passTest, int millisecondsToWait) {
        AtomicBoolean passed = new AtomicBoolean(false);
        Instant timeOut = Instant.now().plusMillis(millisecondsToWait);
        Instant debug_showBrowserTimeout = Instant.now().plusSeconds(this.debug_show_browser_timeout_seconds);
        Display display = this.shell.getDisplay();
        new Thread(() -> {
            while (Instant.now().isBefore(timeOut)) {
                if (((Boolean)passTest.get()).booleanValue()) {
                    passed.set(true);
                    break;
                }
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (this.debug_show_browser && Instant.now().isBefore(debug_showBrowserTimeout)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            display.wake();
        }).start();
        while (Instant.now().isBefore(timeOut)) {
            if (passed.get() && (!this.debug_show_browser || Instant.now().isAfter(debug_showBrowserTimeout))) break;
            if (this.shell.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
        return passed.get();
    }

    void waitForMilliseconds(int milliseconds) {
        this.waitForPassCondition(() -> false, milliseconds);
    }

    private static Boolean checkInternet(String url) {
        if (url != null && url.toLowerCase().startsWith("http://")) {
            throw new IllegalArgumentException("please use https instead, http do not work on mac out of the box and your test will hang there!");
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("HEAD");
            int code = connection.getResponseCode();
            if (code == 200) {
                Boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Given url is malformed: " + url + "Try a fully formed url like: https://www.example.com");
            e.printStackTrace();
        }
        catch (IOException iOException) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    private static void printMemoryUse() {
        System.gc();
        System.runFinalization();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        System.out.print("\n########### Memory usage reported by JVM ########");
        System.out.printf(Locale.GERMAN, "%n%,16d bytes max heap", max);
        System.out.printf(Locale.GERMAN, "%n%,16d bytes heap allocated", total);
        System.out.printf(Locale.GERMAN, "%n%,16d bytes free heap", free);
        System.out.printf(Locale.GERMAN, "%n%,16d bytes used heap", used);
        System.out.println("\n#################################################\n");
    }

    private static void printThreadsInfo() {
        System.out.println("\n########### Thread usage reported by JVM ########");
        ThreadMXBean mxb = ManagementFactory.getThreadMXBean();
        int peakThreadCount = mxb.getPeakThreadCount();
        long[] threadIds = mxb.getAllThreadIds();
        int threadCount = threadIds.length;
        System.out.println("Peak threads count " + peakThreadCount);
        System.out.println("Current threads count " + threadCount);
        if (threadCount > 100) {
            ThreadInfo[] allThreads = mxb.getThreadInfo(threadIds, 200);
            System.out.println("Thread names:");
            ArrayList<CallSite> threadNames = new ArrayList<CallSite>();
            ThreadInfo[] threadInfoArray = allThreads;
            int n2 = allThreads.length;
            int n3 = 0;
            while (n3 < n2) {
                ThreadInfo threadInfo = threadInfoArray[n3];
                threadNames.add((CallSite)((Object)("\t" + threadInfo.getThreadName())));
                ++n3;
            }
            Collections.sort(threadNames);
            threadNames.forEach(n -> System.out.println((String)n));
        }
    }

    private static void printSystemEnv() throws Exception {
        Set<Map.Entry<String, String>> set = new TreeMap<String, String>(System.getenv()).entrySet();
        StringBuilder sb = new StringBuilder("\n###################### System environment ######################\n");
        for (Map.Entry<String, String> entry : set) {
            sb.append(" ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        sb.append("\n###################### System properties ######################\n");
        Set<Map.Entry<String, String>> props = Test_org_eclipse_swt_browser_Browser.getPropertiesSafe();
        for (Map.Entry<String, String> entry : props) {
            sb.append(" ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        String env = sb.toString();
        System.out.println(env);
        if (SwtTestUtil.isGTK) {
            System.out.println("/proc/sys/kernel/threads-max: " + new String(Files.readAllBytes(Paths.get("/proc/sys/kernel/threads-max", new String[0]))));
            System.out.println("/proc/self/limits: " + new String(Files.readAllBytes(Paths.get("/proc/self/limits", new String[0]))));
        }
    }

    private static Set<Map.Entry<String, String>> getPropertiesSafe() {
        try {
            return new TreeMap<String, String>(System.getProperties().entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())))).entrySet();
        }
        catch (Exception exception) {
            return Test_org_eclipse_swt_browser_Browser.getPropertiesSafe();
        }
    }

    private static List<String> getOpenedDescriptors() {
        ArrayList<String> paths = new ArrayList<String>();
        Path fd = Paths.get("/proc/self/fd/", new String[0]);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fd);){
                directoryStream.forEach(path -> {
                    String resolvedPath = Test_org_eclipse_swt_browser_Browser.resolveSymLink(path);
                    if (Test_org_eclipse_swt_browser_Browser.isTestRelatedFileDescriptor(resolvedPath)) {
                        paths.add(resolvedPath);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Collections.sort(paths);
        if (initialOpenedDescriptors.size() == 0) {
            initialOpenedDescriptors = Collections.unmodifiableList(paths);
        }
        return paths;
    }

    private static boolean isTestRelatedFileDescriptor(String fileDescriptorPath) {
        return fileDescriptorPath != null && !fileDescriptorPath.contains(".m2") && !fileDescriptorPath.contains("target/classes");
    }

    private static String resolveSymLink(Path path) {
        try {
            return Files.isSymbolicLink(path) ? Files.readSymbolicLink(path).toString() : path.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void processUiEvents() {
        Display display = Display.getCurrent();
        while (display != null && !display.isDisposed() && display.readAndDispatch()) {
        }
    }

    private class EdgeBrowserApplication
    extends Thread {
        private volatile boolean shouldClose;
        private volatile boolean isRunning;
        private volatile boolean isDisposed;

        private EdgeBrowserApplication() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Display threadDisplay = new Display();
            Shell browserShell = new Shell(threadDisplay);
            Browser browser = Test_org_eclipse_swt_browser_Browser.this.createBrowser(browserShell, 262144);
            browserShell.setVisible(true);
            this.isDisposed = browser.isDisposed();
            this.isRunning = true;
            while (!this.shouldClose) {
                EdgeBrowserApplication edgeBrowserApplication = this;
                synchronized (edgeBrowserApplication) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.shouldClose = true;
                    }
                }
            }
            browser.dispose();
            browserShell.dispose();
            threadDisplay.dispose();
            this.isDisposed = browser.isDisposed();
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.shouldClose = true;
            EdgeBrowserApplication edgeBrowserApplication = this;
            synchronized (edgeBrowserApplication) {
                this.notifyAll();
            }
            Test_org_eclipse_swt_browser_Browser.this.waitForPassCondition(() -> !this.isRunning);
        }
    }
}

