/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_custom_BidiSegmentListener {
    Shell shell;
    StyledText text;
    boolean listenerCalled;
    String line = "Line1";

    @BeforeEach
    public void setUp() {
        this.shell = new Shell();
        this.text = new StyledText((Composite)this.shell, 0);
    }

    @AfterEach
    public void tearDown() {
        this.shell.dispose();
    }

    private void testListener(int[] segments, boolean exceptionExpected) {
        boolean exceptionThrown;
        block9: {
            exceptionThrown = false;
            BidiSegmentListener listener = event -> {
                Assertions.assertEquals((int)0, (int)event.lineOffset, (String)" incorrect BidiSegmentEvent");
                Assertions.assertEquals((Object)this.line, (Object)event.lineText, (String)" incorrect BidiSegmentEvent");
                event.segments = segments;
                this.listenerCalled = true;
            };
            this.listenerCalled = false;
            try {
                try {
                    this.text.addBidiSegmentListener(listener);
                    this.text.getLocationAtOffset(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exceptionThrown = true;
                    this.text.removeBidiSegmentListener(listener);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.text.removeBidiSegmentListener(listener);
                throw throwable;
            }
            this.text.removeBidiSegmentListener(listener);
        }
        if (exceptionExpected) {
            Assertions.assertTrue((boolean)exceptionThrown, (String)" expected exception not thrown");
        } else {
            Assertions.assertFalse((boolean)exceptionThrown, (String)" unexpected exception thrown");
        }
        if (SwtTestUtil.isBidi()) {
            Assertions.assertTrue((boolean)this.listenerCalled, (String)" listener not called");
        } else {
            Assertions.assertFalse((boolean)this.listenerCalled, (String)" listener called when it shouldn't be");
        }
    }

    private void testStyleRangeSegmenting(int[] segments, int[] boldRanges) {
        boolean exceptionThrown;
        block8: {
            exceptionThrown = false;
            BidiSegmentListener listener = event -> {
                Assertions.assertEquals((int)0, (int)event.lineOffset, (String)" incorrect BidiSegmentEvent");
                Assertions.assertEquals((Object)this.line, (Object)event.lineText, (String)" incorrect BidiSegmentEvent");
                event.segments = segments;
                this.listenerCalled = true;
            };
            this.listenerCalled = false;
            try {
                try {
                    this.text.addBidiSegmentListener(listener);
                    this.text.setStyleRange(null);
                    int i = 0;
                    while (i < boldRanges.length) {
                        StyleRange styleRange = new StyleRange(boldRanges[i], boldRanges[i + 1], null, null, 1);
                        this.text.setStyleRange(styleRange);
                        i += 2;
                    }
                    this.text.getLocationAtOffset(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exceptionThrown = true;
                    this.text.removeBidiSegmentListener(listener);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.text.removeBidiSegmentListener(listener);
                throw throwable;
            }
            this.text.removeBidiSegmentListener(listener);
        }
        Assertions.assertFalse((boolean)exceptionThrown, (String)" unexpected exception thrown");
        if (SwtTestUtil.isBidi()) {
            Assertions.assertTrue((boolean)this.listenerCalled, (String)" listener not called");
        } else {
            Assertions.assertFalse((boolean)this.listenerCalled, (String)" listener called when it shouldn't be");
        }
    }

    @Test
    public void test_lineGetSegmentsLorg_eclipse_swt_custom_BidiSegmentEvent() {
        int lineLength = this.line.length();
        this.text.setText(this.line);
        this.testListener(null, false);
        int[] nArray = new int[3];
        nArray[1] = lineLength / 2;
        nArray[2] = lineLength;
        this.testListener(nArray, false);
        int[] nArray2 = new int[2];
        nArray2[1] = lineLength / 2;
        this.testListener(nArray2, false);
        if (SwtTestUtil.isBidi()) {
            this.testListener(new int[]{lineLength / 2}, true);
            int[] nArray3 = new int[4];
            nArray3[1] = 1;
            nArray3[2] = 1;
            nArray3[3] = lineLength / 2;
            this.testListener(nArray3, true);
            int[] nArray4 = new int[4];
            nArray4[1] = 1;
            nArray4[2] = 2;
            nArray4[3] = lineLength + 1;
            this.testListener(nArray4, true);
            int[] nArray5 = new int[4];
            nArray5[1] = 1;
            nArray5[2] = lineLength + 1;
            nArray5[3] = lineLength + 1;
            this.testListener(nArray5, true);
            int[] nArray6 = new int[3];
            nArray6[1] = 2;
            nArray6[2] = 1;
            this.testListener(nArray6, true);
            int[] nArray7 = new int[3];
            nArray7[1] = -1;
            nArray7[2] = 2;
            this.testListener(nArray7, true);
            int[] nArray8 = new int[3];
            nArray8[1] = -1;
            nArray8[2] = 2;
            this.testListener(nArray8, true);
        }
        this.line = "this is a line with 50 chars - **** **** **** ****";
        this.text.setText(this.line);
        int[] nArray9 = new int[6];
        nArray9[1] = 5;
        nArray9[2] = 10;
        nArray9[3] = 15;
        nArray9[4] = 20;
        nArray9[5] = 25;
        int[] nArray10 = new int[8];
        nArray10[1] = 5;
        nArray10[2] = 5;
        nArray10[3] = 2;
        nArray10[4] = 12;
        nArray10[5] = 3;
        nArray10[6] = 20;
        nArray10[7] = 5;
        this.testStyleRangeSegmenting(nArray9, nArray10);
        int[] nArray11 = new int[6];
        nArray11[1] = 5;
        nArray11[2] = 10;
        nArray11[3] = 15;
        nArray11[4] = 20;
        nArray11[5] = 25;
        int[] nArray12 = new int[6];
        nArray12[1] = 6;
        nArray12[2] = 7;
        nArray12[3] = 6;
        nArray12[4] = 15;
        nArray12[5] = 10;
        this.testStyleRangeSegmenting(nArray11, nArray12);
        int[] nArray13 = new int[4];
        nArray13[1] = 5;
        nArray13[2] = 10;
        nArray13[3] = 15;
        int[] nArray14 = new int[2];
        nArray14[1] = 15;
        this.testStyleRangeSegmenting(nArray13, nArray14);
        int[] nArray15 = new int[2];
        nArray15[1] = 5;
        int[] nArray16 = new int[2];
        nArray16[1] = 5;
        this.testStyleRangeSegmenting(nArray15, nArray16);
        int[] nArray17 = new int[2];
        nArray17[1] = 5;
        this.testStyleRangeSegmenting(nArray17, new int[]{2, 3});
        int[] nArray18 = new int[2];
        nArray18[1] = 5;
        int[] nArray19 = new int[2];
        nArray19[1] = 2;
        this.testStyleRangeSegmenting(nArray18, nArray19);
        int[] nArray20 = new int[4];
        nArray20[1] = 5;
        nArray20[2] = 10;
        nArray20[3] = 15;
        this.testStyleRangeSegmenting(nArray20, new int[]{10, 5});
        int[] nArray21 = new int[4];
        nArray21[1] = 5;
        nArray21[2] = 10;
        nArray21[3] = 15;
        this.testStyleRangeSegmenting(nArray21, new int[]{12, 3});
        int[] nArray22 = new int[7];
        nArray22[1] = 5;
        nArray22[2] = 10;
        nArray22[3] = 15;
        nArray22[4] = 20;
        nArray22[5] = 25;
        nArray22[6] = 30;
        this.testStyleRangeSegmenting(nArray22, new int[]{3, 10, 21, 7});
        this.line = "test1test2/r/n";
        this.text.setText(this.line);
        int[] nArray23 = new int[2];
        nArray23[1] = 5;
        this.testStyleRangeSegmenting(nArray23, new int[]{10, 2});
    }
}

