/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_custom_BusyIndicator {
    @Test
    public void testShowWhile() {
        Shell shell = new Shell();
        Display display = shell.getDisplay();
        Cursor busyCursor = display.getSystemCursor(1);
        CountDownLatch latch = new CountDownLatch(1);
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        });
        CountDownLatch latchNested = new CountDownLatch(1);
        CompletableFuture<Void> futureNested = CompletableFuture.runAsync(() -> {
            try {
                latchNested.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        });
        Assertions.assertNotEquals((Object)busyCursor, (Object)shell.getCursor());
        display.asyncExec(() -> BusyIndicator.showWhile((Future)futureNested));
        Cursor[] cursorInAsync = new Cursor[2];
        display.asyncExec(() -> {
            cursorArray[0] = shell.getCursor();
            latchNested.countDown();
        });
        display.asyncExec(() -> {
            cursorArray[1] = shell.getCursor();
            latch.countDown();
        });
        BusyIndicator.showWhile(future);
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)busyCursor, (Object)cursorInAsync[0]);
        Assertions.assertEquals((Object)busyCursor, (Object)cursorInAsync[1]);
        shell.dispose();
        while (!display.isDisposed() && display.readAndDispatch()) {
        }
    }

    @Test
    public void testShowWhileWithFuture() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Shell shell = new Shell();
            Display display = shell.getDisplay();
            Cursor busyCursor = display.getSystemCursor(1);
            Cursor[] cursorInAsync = new Cursor[1];
            CountDownLatch latch = new CountDownLatch(1);
            Future<?> future = executor.submit(() -> {
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {}
            });
            display.asyncExec(() -> {
                cursorArray[0] = shell.getCursor();
                latch.countDown();
            });
            executor.submit(() -> {
                try {
                    future.get();
                }
                catch (Exception exception) {}
                display.wake();
            });
            BusyIndicator.showWhile(future);
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertEquals((Object)busyCursor, (Object)cursorInAsync[0]);
            shell.dispose();
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                break;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

