/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_CCombo
extends Test_org_eclipse_swt_widgets_Composite {
    CCombo ccombo;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.ccombo = new CCombo((Composite)this.shell, 0);
        this.setWidget((Widget)this.ccombo);
    }

    @Override
    protected Composite getElementExpectedToHaveFocusAfterSetFocusOnParent(Composite visibleChild) {
        return visibleChild.getParent();
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        int[] comboListeners;
        Assert.assertThrows((String)"No exception thrown for parent == null", IllegalArgumentException.class, () -> {
            CCombo cCombo = this.ccombo = new CCombo(null, 0);
        });
        int[] cases = new int[]{0x800000, 2048};
        int i = 0;
        while (i < cases.length) {
            this.ccombo = new CCombo((Composite)this.shell, cases[i]);
            Assert.assertEquals((String)(":a:" + String.valueOf(i)), (long)cases[i], (long)(this.ccombo.getStyle() & cases[i]));
            ++i;
        }
        this.ccombo = new CCombo((Composite)this.shell, 2056);
        int[] nArray = comboListeners = new int[]{12, 15, 10, 11};
        int n = comboListeners.length;
        int n2 = 0;
        while (n2 < n) {
            int comboListener = nArray[n2];
            Assert.assertTrue((String)"Combo Listener events not implemented", (this.ccombo.getListeners(comboListener).length > 0 ? 1 : 0) != 0);
            ++n2;
        }
        Assert.assertEquals((String)"Pop up items are present.", (long)0L, (long)this.ccombo.getItems().length);
        Assert.assertNotNull((Object)this.ccombo.getAccessible());
    }

    @Test
    public void test_copy() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copy(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_CCombo).");
            }
            return;
        }
        this.ccombo.setText("123456");
        this.ccombo.setSelection(new Point(1, 3));
        this.ccombo.copy();
        this.ccombo.setSelection(new Point(0, 0));
        this.ccombo.paste();
        Assert.assertEquals((String)":a:", (Object)"23123456", (Object)this.ccombo.getText());
    }

    @Test
    public void test_cut() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_cut(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_CCombo).");
            }
            return;
        }
        this.ccombo.setText("123456");
        this.ccombo.setSelection(new Point(1, 3));
        this.ccombo.cut();
        Assert.assertEquals((String)":a:", (Object)"1456", (Object)this.ccombo.getText());
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Override
    @Test
    public void test_getChildren() {
    }

    @Override
    @Test
    public void test_isFocusControl() {
        if (SwtTestUtil.isGTK) {
            Assert.assertFalse((boolean)this.control.isFocusControl());
        } else {
            super.test_isFocusControl();
        }
    }

    @Test
    public void test_paste() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_paste(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_custom_CCombo).");
            }
            return;
        }
        this.ccombo.setText("123456");
        this.ccombo.setSelection(new Point(1, 3));
        this.ccombo.cut();
        Assert.assertEquals((String)":a:", (Object)"1456", (Object)this.ccombo.getText());
        this.ccombo.paste();
        Assert.assertEquals((String)":a:", (Object)"123456", (Object)this.ccombo.getText());
    }

    @Override
    @Test
    public void test_redraw() {
    }

    @Override
    @Test
    public void test_redrawIIIIZ() {
    }

    @Override
    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color[] colors = new Color[]{new Color(0, 0, 0), new Color(255, 255, 255), new Color(0, 45, 255)};
        int i = 0;
        while (i < 3) {
            this.ccombo.setBackground(colors[i]);
            Assert.assertEquals((String)("i=" + i), (Object)this.ccombo.getBackground(), (Object)colors[i]);
            ++i;
        }
    }

    @Override
    @Test
    public void test_setEnabledZ() {
        this.ccombo.setEnabled(true);
        Assert.assertTrue((String)"Set true error", (boolean)this.ccombo.getEnabled());
        this.ccombo.setEnabled(false);
        Assert.assertFalse((String)"Set false error", (boolean)this.ccombo.getEnabled());
    }

    @Override
    @Test
    public void test_setFocus() {
        Assert.assertFalse((boolean)this.ccombo.setFocus());
        this.shell.open();
        this.shell.setVisible(true);
        boolean exceptionThrown = false;
        try {
            this.ccombo.setEnabled(false);
            this.ccombo.setVisible(true);
            Assert.assertFalse((String)"Expect false wehn not enabled", (boolean)this.ccombo.setFocus());
            this.ccombo.setEnabled(true);
            this.ccombo.setVisible(false);
            Assert.assertFalse((String)"Expect false wehn not visible", (boolean)this.ccombo.setFocus());
            this.ccombo.setEnabled(false);
            this.ccombo.setVisible(false);
            Assert.assertFalse((String)"Expect false wehn not visible and not enabled", (boolean)this.ccombo.setFocus());
            this.ccombo.setEnabled(true);
            this.ccombo.setVisible(true);
            SwtTestUtil.processEvents();
            if (this.ccombo.isFocusControl()) {
                Assert.assertTrue((String)"Set focus error", (boolean)this.ccombo.setFocus());
            }
            if (!SwtTestUtil.isCocoa) {
                this.ccombo.setEnabled(true);
                this.ccombo.setVisible(true);
                this.ccombo.setFocus();
                SwtTestUtil.processEvents(100, () -> this.ccombo.isFocusControl());
                Assert.assertTrue((boolean)this.ccombo.isFocusControl());
                Control focusControl = this.ccombo.getDisplay().getFocusControl();
                Assert.assertTrue((boolean)(focusControl instanceof Text));
                Assert.assertEquals((Object)this.ccombo, (Object)focusControl.getParent());
            }
        }
        catch (Exception exception) {
            exceptionThrown = true;
        }
        Assert.assertFalse((String)"Exception thrown", (boolean)exceptionThrown);
    }

    @Override
    @Test
    public void test_setFocus_toChild_afterOpen() {
    }

    @Override
    @Test
    public void test_setFocus_toChild_beforeOpen() {
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
    }

    @Override
    @Test
    public void test_setForegroundLorg_eclipse_swt_graphics_Color() {
        Color c1 = new Color(0, 0, 0);
        Color c2 = new Color(255, 255, 255);
        Color c3 = new Color(23, 45, 151);
        this.ccombo.setForeground(c1);
        this.ccombo.setForeground(c2);
        this.ccombo.setForeground(c3);
    }

    @Override
    @Test
    public void test_setToolTipTextLjava_lang_String() {
        this.ccombo.setToolTipText(null);
        Assert.assertNull((Object)this.ccombo.getToolTipText());
        String[] cases = new String[]{"", "fang", "fang0"};
        int i = 0;
        while (i < cases.length) {
            this.ccombo.setText(cases[i]);
            Assert.assertEquals((String)(":a:" + i), (Object)cases[i], (Object)this.ccombo.getText());
            ++i;
        }
    }

    @Override
    @Test
    public void test_setVisibleZ() {
        this.ccombo.getParent().setVisible(true);
        this.ccombo.setVisible(true);
        if (!this.ccombo.isDisposed()) {
            Assert.assertTrue((boolean)this.ccombo.isVisible());
        }
        this.ccombo.setVisible(false);
        if (!this.ccombo.isDisposed()) {
            Assert.assertFalse((boolean)this.ccombo.isVisible());
        }
    }

    private void add() {
        this.ccombo.add("this");
        this.ccombo.add("is");
        this.ccombo.add("SWT");
    }

    @Test
    public void test_consistency_MouseSelection() {
        this.add();
        this.consistencyPrePackShell();
        this.consistencyEvent(this.ccombo.getSize().x - 10, 5, 30, this.ccombo.getItemHeight() * 2, 60);
    }

    @Test
    public void test_consistency_KeySelection() {
        this.add();
        this.consistencyEvent(0, 0x1000002, 0, 0, 10);
    }

    @Test
    public void test_consistency_EnterSelection() {
        this.add();
        this.consistencyEvent(10, 13, 0, 0, 10);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.add();
        this.consistencyPrePackShell();
        this.consistencyEvent(this.ccombo.getSize().x - 10, 5, 3, 0, 30);
        this.consistencyEvent(10, 5, 3, 1, 30);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.add();
        this.consistencyEvent(10, 5, 20, 10, 50);
    }

    @Test
    public void test_addLjava_lang_String() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        Assert.assertThrows((String)"Did not catch null argument", IllegalArgumentException.class, () -> this.ccombo.add(null));
        this.add();
        Assert.assertTrue((String)"Items not successfully added", (this.ccombo.getItems().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_addLjava_lang_StringI() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        Assert.assertThrows((String)"Did not catch null argument", IllegalArgumentException.class, () -> this.ccombo.add(null, 0));
        this.add();
        Assert.assertTrue((String)"Items not successfully added", (this.ccombo.getItems().length > 0 ? 1 : 0) != 0);
        Assert.assertThrows((String)"Did not catch range exception", IllegalArgumentException.class, () -> this.ccombo.add("Hello", 7));
        this.ccombo.add("Hello", 1);
        String test = this.ccombo.getItem(1);
        Assert.assertEquals((Object)"Hello", (Object)test);
    }

    @Test
    public void test_addModifyListenerLorg_eclipse_swt_events_ModifyListener() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        ModifyListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.addModifyListener(null));
        this.ccombo.addModifyListener(listener);
        this.listenerCalled = false;
        this.ccombo.setText("new text");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.ccombo.removeModifyListener(listener);
        this.ccombo.setText("line");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.removeModifyListener(null));
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_custom_CCombo.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.addSelectionListener(null));
        this.ccombo.addSelectionListener(listener);
        this.ccombo.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.ccombo.removeSelectionListener(listener);
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.removeSelectionListener(null));
    }

    @Test
    public void test_clearSelection() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        this.ccombo.clearSelection();
        Assert.assertEquals((String)":a:", (Object)new Point(0, 0), (Object)this.ccombo.getSelection());
        this.ccombo.setSelection(new Point(0, 5));
        Assert.assertEquals((String)":b:", (Object)new Point(0, 0), (Object)this.ccombo.getSelection());
        this.ccombo.setText("some text");
        this.ccombo.setSelection(new Point(0, 5));
        Assert.assertEquals((String)":c:", (Object)new Point(0, 5), (Object)this.ccombo.getSelection());
        this.ccombo.clearSelection();
        Assert.assertEquals((String)":d:", (long)this.ccombo.getSelection().x, (long)this.ccombo.getSelection().y);
    }

    @Test
    public void test_deselectAll() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        this.ccombo.add("123");
        this.ccombo.add("456");
        this.ccombo.add("789");
        this.ccombo.select(0);
        this.ccombo.select(2);
        this.ccombo.deselectAll();
        Assert.assertEquals((String)":a:", (long)-1L, (long)this.ccombo.getSelectionIndex());
    }

    @Test
    public void test_deselectI() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        String[] items = new String[]{"item0", "item1", "item2"};
        this.ccombo.setItems(items);
        this.ccombo.select(1);
        this.ccombo.deselect(10);
        Assert.assertEquals((long)1L, (long)this.ccombo.getSelectionIndex());
        this.ccombo.removeAll();
        this.ccombo.deselect(2);
        int number = 10;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.select(i);
            Assert.assertEquals((String)(":a:" + i), (long)i, (long)this.ccombo.getSelectionIndex());
            this.ccombo.deselect(i);
            Assert.assertEquals((String)(":b:" + i), (long)-1L, (long)this.ccombo.getSelectionIndex());
            ++i;
        }
    }

    @Test
    public void test_getEditable() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        Assert.assertTrue((String)"a: Receiver is not editable", (boolean)this.ccombo.getEditable());
        this.ccombo = new CCombo((Composite)this.shell, 2048);
        Assert.assertTrue((String)"a: Receiver is not editable", (boolean)this.ccombo.getEditable());
    }

    @Test
    public void test_getItemCount() {
        int number = 10;
        int i = 0;
        while (i < number) {
            Assert.assertEquals((String)(":a:" + i), (long)i, (long)this.ccombo.getItemCount());
            this.ccombo.add("fred" + i);
            ++i;
        }
        Assert.assertEquals((String)":aa:", (long)number, (long)this.ccombo.getItemCount());
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)(":b:" + i), (long)(number - i), (long)this.ccombo.getItemCount());
            this.ccombo.remove(0);
            ++i;
        }
        this.ccombo.removeAll();
        Assert.assertEquals((String)":c:", (long)0L, (long)this.ccombo.getItemCount());
    }

    @Test
    public void test_getItemHeight() {
        this.ccombo.getItemHeight();
    }

    @Test
    public void test_getItemI() {
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> {
            String string = this.ccombo.getItem(0);
        });
        int number = 10;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((Object)("fred" + i), (Object)this.ccombo.getItem(i));
            ++i;
        }
    }

    @Test
    public void test_getItems() {
        this.ccombo.removeAll();
        this.ccombo.add("1");
        this.ccombo.add("2");
        this.ccombo.add("3");
        String[] items = this.ccombo.getItems();
        Assert.assertEquals((String)":a:", (long)3L, (long)items.length);
        Assert.assertEquals((String)":a:", (Object)"1", (Object)items[0]);
        Assert.assertEquals((String)":a:", (Object)"2", (Object)items[1]);
        Assert.assertEquals((String)":a:", (Object)"3", (Object)items[2]);
    }

    @Test
    public void test_getSelection() {
        this.ccombo.setText("123456");
        this.ccombo.setSelection(new Point(1, 3));
        this.ccombo.getSelection();
        Assert.assertEquals((String)":a:", (Object)new Point(1, 3), (Object)this.ccombo.getSelection());
    }

    @Test
    public void test_getSelectionIndex() {
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.ccombo.getSelectionIndex());
        i = 0;
        while (i < number) {
            this.ccombo.select(i);
            Assert.assertEquals((long)i, (long)this.ccombo.getSelectionIndex());
            ++i;
        }
        this.ccombo.removeAll();
        i = 1;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.ccombo.getSelectionIndex());
        i = 0;
        while (i < number) {
            this.ccombo.select(i);
            this.ccombo.deselect(i);
            Assert.assertEquals((long)-1L, (long)this.ccombo.getSelectionIndex());
            ++i;
        }
    }

    @Test
    public void test_getStyle() {
        int style = 0;
        this.ccombo.setEditable(false);
        style = this.ccombo.getStyle();
        Assert.assertNotEquals((long)0L, (long)(style & 8));
    }

    @Test
    public void test_getText() {
        String[] cases = new String[]{"", "fred", "fredfred"};
        int i = 0;
        while (i < cases.length) {
            this.ccombo.setText(cases[i]);
            Assert.assertEquals((String)(":a:" + String.valueOf(i)), (Object)cases[i], (Object)this.ccombo.getText());
            ++i;
        }
    }

    @Test
    public void test_getTextHeight() {
        this.ccombo.getTextHeight();
    }

    @Test
    public void test_getTextLimit() {
        this.ccombo.setTextLimit(3);
        Assert.assertEquals((String)":a:", (long)3L, (long)this.ccombo.getTextLimit());
    }

    @Test
    public void test_indexOfLjava_lang_String() {
        this.ccombo.add("string1");
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> {
            int n = this.ccombo.indexOf(null);
        });
        this.ccombo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)i, (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)-1L, (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        this.ccombo.remove("fred3");
        i = 0;
        while (i < 3) {
            Assert.assertEquals((long)i, (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.ccombo.indexOf("fred3"));
        i = 4;
        while (i < number) {
            Assert.assertEquals((long)(i - 1), (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        this.ccombo.remove(2);
        i = 0;
        while (i < 2) {
            Assert.assertEquals((long)i, (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.ccombo.indexOf("fred2"));
        i = 3;
        while (i < number) {
            Assert.assertEquals((long)(i - 1), (long)this.ccombo.indexOf("fred" + i));
            ++i;
        }
    }

    @Test
    public void test_indexOfLjava_lang_StringI() {
        this.ccombo.add("string0");
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> {
            int n = this.ccombo.indexOf(null);
        });
        Assert.assertEquals((long)0L, (long)this.ccombo.indexOf("string0", 0));
        this.ccombo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)(":a:" + i), (long)i, (long)this.ccombo.indexOf("fred" + i, 0));
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)(":b:" + i), (long)-1L, (long)this.ccombo.indexOf("fred" + i, i + 1));
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < 3) {
            Assert.assertEquals((String)(":a:" + i), (long)i, (long)this.ccombo.indexOf("fred" + i, 0));
            ++i;
        }
        i = 3;
        while (i < number) {
            Assert.assertEquals((String)(":b:" + i), (long)i, (long)this.ccombo.indexOf("fred" + i, 3));
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)(":b:" + i), (long)i, (long)this.ccombo.indexOf("fred" + i, i));
            ++i;
        }
    }

    @Test
    public void test_removeAll() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        this.add();
        this.ccombo.removeAll();
        Assert.assertEquals((String)":a:", (long)0L, (long)this.ccombo.getItems().length);
    }

    @Test
    public void test_removeII() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        this.ccombo.remove(0, 4);
        Assert.assertEquals((long)0L, (long)this.ccombo.getItemCount());
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        this.ccombo.remove(0, 2);
        Assert.assertEquals((long)2L, (long)this.ccombo.getItemCount());
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        this.ccombo.remove(2, 4);
        Assert.assertEquals((long)2L, (long)this.ccombo.getItemCount());
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        this.ccombo.remove(3, 2);
        Assert.assertEquals((long)number, (long)this.ccombo.getItemCount());
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> this.ccombo.remove(2, 100));
        Assert.assertThrows((String)"No exception thrown for start index < 0", IllegalArgumentException.class, () -> this.ccombo.remove(-1, number - 1));
    }

    @Test
    public void test_removeLjava_lang_String() {
        this.ccombo = new CCombo((Composite)this.shell, 0);
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)(number - i), (long)this.ccombo.getItemCount());
            this.ccombo.remove("fred" + i);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)(number - i), (long)this.ccombo.getItemCount());
            this.ccombo.remove("fred");
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.add("fred");
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for item == null", IllegalArgumentException.class, () -> this.ccombo.remove(null));
        this.ccombo.removeAll();
        i = 0;
        while (i < number) {
            this.ccombo.add("fred" + i);
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for item not found", IllegalArgumentException.class, () -> this.ccombo.remove("fred"));
        Assert.assertEquals((long)number, (long)this.ccombo.getItemCount());
    }

    @Test
    public void test_removeModifyListenerLorg_eclipse_swt_events_ModifyListener() {
        ModifyListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.addModifyListener(null));
        this.ccombo.addModifyListener(listener);
        this.listenerCalled = false;
        this.ccombo.setText("new text");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.ccombo.removeModifyListener(listener);
        this.ccombo.setText("line");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.removeModifyListener(null));
    }

    @Test
    public void test_removeSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_custom_CCombo.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.addSelectionListener(null));
        this.ccombo.addSelectionListener(listener);
        this.ccombo.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.ccombo.removeSelectionListener(listener);
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.ccombo.removeSelectionListener(null));
    }

    @Test
    public void test_selectI() {
        this.ccombo.add("123");
        this.ccombo.add("456");
        this.ccombo.add("789");
        this.ccombo.select(0);
        this.ccombo.select(1);
        Assert.assertEquals((String)":a:", (long)1L, (long)this.ccombo.getSelectionIndex());
        this.ccombo.select(10);
        Assert.assertEquals((long)1L, (long)this.ccombo.getSelectionIndex());
    }

    @Test
    public void test_setEditableZ() {
        this.ccombo.setEditable(true);
        Assert.assertTrue((String)"Set true error", (boolean)this.ccombo.getEditable());
        this.ccombo.setEditable(false);
        Assert.assertFalse((String)"Set false error", (boolean)this.ccombo.getEditable());
    }

    @Test
    public void test_setItemILjava_lang_String() {
        Assert.assertThrows((String)"No exception thrown for item == null", IllegalArgumentException.class, () -> this.ccombo.setItem(0, null));
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> this.ccombo.setItem(3, "fang"));
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> this.ccombo.setItem(0, "fang"));
        this.ccombo.add("string0");
        Assert.assertThrows((String)"No exception thrown for item == null", IllegalArgumentException.class, () -> this.ccombo.setItem(0, null));
        Assert.assertThrows((String)"No exception thrown for index < 0", IllegalArgumentException.class, () -> this.ccombo.setItem(-1, "new value"));
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> this.ccombo.setItem(3, "fang"));
        this.ccombo.add("joe");
        this.ccombo.setItem(0, "fang");
        Assert.assertEquals((String)"fang", (Object)"fang", (Object)this.ccombo.getItem(0));
        Assert.assertThrows((String)"No exception thrown for illegal index argument", IllegalArgumentException.class, () -> this.ccombo.setItem(4, "fang"));
        this.ccombo.removeAll();
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fang");
            ++i;
        }
        i = 0;
        while (i < number) {
            this.ccombo.setItem(i, "fang" + i);
            ++i;
        }
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{"fang0", "fang1", "fang2", "fang3", "fang4"}, (Object[])this.ccombo.getItems());
    }

    @Test
    public void test_setItems$Ljava_lang_String() {
        Assert.assertThrows((String)"No exception thrown for items == null", IllegalArgumentException.class, () -> this.ccombo.setItems(null));
        String[] nullItem = new String[]{null};
        Assert.assertThrows((String)"No exception thrown for items[0] == null", IllegalArgumentException.class, () -> this.ccombo.setItems(nullItem));
        String[][] items = new String[][]{new String[0], {""}, {"", ""}, {"fang"}, {"fang0", "fang0"}, {"fang", "fang"}};
        int i = 0;
        while (i < items.length) {
            this.ccombo.setItems(items[i]);
            Assert.assertArrayEquals((String)(":a:" + i), (Object[])items[i], (Object[])this.ccombo.getItems());
            ++i;
        }
    }

    @Test
    public void test_setSelectionLorg_eclipse_swt_graphics_Point() {
        Assert.assertThrows((String)"No exception thrown for point == null", IllegalArgumentException.class, () -> this.ccombo.setSelection(null));
        int number = 5;
        int i = 0;
        while (i < number) {
            this.ccombo.add("fang" + i);
            ++i;
        }
        this.ccombo.setSelection(new Point(0, 5));
        Assert.assertEquals((String)":a:", (Object)new Point(0, 0), (Object)this.ccombo.getSelection());
        this.ccombo.setText("some text");
        this.ccombo.setSelection(new Point(0, 5));
        Assert.assertEquals((String)"Has not been implemented :b:", (Object)new Point(0, 5), (Object)this.ccombo.getSelection());
    }

    @Test
    public void test_setTextLimitI() {
        Assert.assertThrows((String)"No exception thrown for limit == 0", IllegalArgumentException.class, () -> this.ccombo.setTextLimit(0));
        this.ccombo.setTextLimit(3);
        Assert.assertEquals((String)":a:", (long)3L, (long)this.ccombo.getTextLimit());
    }

    @Test
    public void test_setTextLjava_lang_String() {
        Assert.assertThrows((String)"No exception thrown for text == null", IllegalArgumentException.class, () -> this.ccombo.setText(null));
        String[] cases = new String[]{"", "fang", "fang0"};
        int i = 0;
        while (i < cases.length) {
            this.ccombo.setText(cases[i]);
            Assert.assertEquals((String)(":a:" + i), (Object)cases[i], (Object)this.ccombo.getText());
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.ccombo.add("fang");
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            this.ccombo.setText(cases[i]);
            Assert.assertEquals((String)(":b:" + i), (Object)cases[i], (Object)this.ccombo.getText());
            ++i;
        }
        i = 0;
        while (i < 5) {
            this.ccombo.add("fang" + i);
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            this.ccombo.setText(cases[i]);
            Assert.assertEquals((String)(":c:" + i), (Object)cases[i], (Object)this.ccombo.getText());
            ++i;
        }
    }

    @Test
    public void test_setAlignment() {
        Assert.assertEquals((String)":a:", (long)16384L, (long)this.ccombo.getAlignment());
        this.ccombo.setText("Trail");
        this.ccombo.setAlignment(131072);
        Assert.assertEquals((String)":b:", (long)131072L, (long)this.ccombo.getAlignment());
        Assert.assertEquals((String)":b:", (Object)"Trail", (Object)this.ccombo.getText());
        this.ccombo.add("Center");
        this.ccombo.select(this.ccombo.getItemCount() - 1);
        this.ccombo.setAlignment(0x1000000);
        Assert.assertEquals((String)":c:", (long)0x1000000L, (long)this.ccombo.getAlignment());
        Assert.assertEquals((String)":c:", (Object)"Center", (Object)this.ccombo.getText());
        this.ccombo.setAlignment(16384);
        Assert.assertEquals((String)":d:", (long)16384L, (long)this.ccombo.getAlignment());
        Assert.assertEquals((String)":d:", (Object)"Center", (Object)this.ccombo.getText());
    }
}

