/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tests.junit.ImageTestUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_CTabFolder
extends Test_org_eclipse_swt_widgets_Composite {
    protected CTabFolder ctabFolder;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.shell.setLayout((Layout)new FillLayout());
        this.makeCleanEnvironment();
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
    }

    @Override
    @Test
    public void test_getClientArea() {
    }

    @Override
    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
    }

    private void makeCleanEnvironment() {
        this.makeCleanEnvironment(0);
    }

    private void makeCleanEnvironment(int style) {
        Control[] children;
        Control[] controlArray = children = this.shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.ctabFolder = new CTabFolder((Composite)this.shell, style);
        this.setWidget((Widget)this.ctabFolder);
    }

    private void createTabFolder(List<String> events) {
        this.createTabFolder(events, 3);
    }

    private void createTabFolder(List<String> events, int numItems) {
        this.makeCleanEnvironment();
        int i = 0;
        while (i < numItems) {
            CTabItem item = new CTabItem(this.ctabFolder, 0);
            item.setText("CTabItem &" + i);
            item.setToolTipText("CTabItem ToolTip" + i);
            Text itemText = new Text((Composite)this.ctabFolder, 2050);
            itemText.setText("\nText for CTabItem " + i + "\n\n\n");
            item.setControl((Control)itemText);
            if (events != null) {
                this.hookExpectedEvents((Widget)item, this.getTestName(), events);
                this.hookExpectedEvents((Widget)itemText, this.getTestName(), events);
            }
            ++i;
        }
        this.ctabFolder.setSelection(this.ctabFolder.getItem(0));
    }

    @Test
    public void test_ItemCountListeners() {
        int expectedTabsCount = 1;
        int expectedEventsCount = 0;
        this.createTabFolder(null, expectedTabsCount);
        AtomicLong itemCount = new AtomicLong();
        AtomicLong callCount = new AtomicLong();
        Consumer<CTabFolderEvent> tabCountUpdate = e -> {
            itemCount.set(this.ctabFolder.getItemCount());
            callCount.incrementAndGet();
        };
        this.ctabFolder.addCTabFolder2Listener(CTabFolder2Listener.itemsCountAdapter(tabCountUpdate));
        CTabItem item1 = new CTabItem(this.ctabFolder, 0);
        Assert.assertEquals((long)(++expectedTabsCount), (long)this.ctabFolder.getItemCount());
        Assert.assertEquals((long)this.ctabFolder.getItemCount(), (long)itemCount.get());
        Assert.assertEquals((long)(++expectedEventsCount), (long)callCount.get());
        CTabItem item2 = new CTabItem(this.ctabFolder, 0);
        Assert.assertEquals((long)(++expectedTabsCount), (long)this.ctabFolder.getItemCount());
        Assert.assertEquals((long)this.ctabFolder.getItemCount(), (long)itemCount.get());
        Assert.assertEquals((long)(++expectedEventsCount), (long)callCount.get());
        item1.dispose();
        Assert.assertEquals((long)(--expectedTabsCount), (long)this.ctabFolder.getItemCount());
        Assert.assertEquals((long)this.ctabFolder.getItemCount(), (long)itemCount.get());
        Assert.assertEquals((long)(++expectedEventsCount), (long)callCount.get());
        item2.dispose();
        Assert.assertEquals((long)(--expectedTabsCount), (long)this.ctabFolder.getItemCount());
        Assert.assertEquals((long)this.ctabFolder.getItemCount(), (long)itemCount.get());
        Assert.assertEquals((long)(++expectedEventsCount), (long)callCount.get());
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 0x1000004, 0, 0, 10, events, false);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(this.ctabFolder.getSize().x / 2, 5, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_PgdwnSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 262144, 0, 0x1000006, 20, events, false);
    }

    @Test
    public void test_consistency_PgupSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(2);
        this.consistencyEvent(0, 262144, 0, 0x1000005, 20, events, false);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 70, 10, 50, events);
    }

    @Test
    public void test_setHighlightEnabled() {
        Assert.assertTrue((String)"By default, highlighting should be enabled", (boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(false);
        Assert.assertFalse((boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(true);
        Assert.assertTrue((boolean)this.ctabFolder.getHighlightEnabled());
    }

    @Ignore(value="Currently failing due to Bug 507611. E.g: Height is 50 instead of being at least 59")
    @Test
    public void test_checkSize() {
        this.shell.setLayout((Layout)new GridLayout(1, false));
        Text text2 = new Text((Composite)this.shell, 18436);
        text2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text2.setText("This control takes the initial focus.");
        Color red = this.shell.getDisplay().getSystemColor(3);
        Image systemImage = this.shell.getDisplay().getSystemImage(2);
        CTabFolder folder = new CTabFolder((Composite)this.shell, 2048);
        folder.setLayoutData((Object)new GridData(4, 1, true, false));
        folder.setSelectionBackground(red);
        int i = 0;
        while (i < 3) {
            CTabItem item = new CTabItem(folder, 64);
            item.setText("Item " + i);
            Text text = new Text((Composite)folder, 2);
            text.setText("Content for Item " + i);
            item.setImage(systemImage);
            item.setControl((Control)text);
            ++i;
        }
        folder.setSelection(0);
        this.shell.pack();
        this.shell.open();
        int folderY = folder.getSize().y;
        int expectedminHeight = systemImage.getImageData().height + text2.getFont().getFontData()[0].getHeight();
        Assert.assertTrue((String)("\nBug 507611 - CTabFolder is too thin for its actual content. \nCtabFolder height:" + folderY + "\nExpected min:" + expectedminHeight), (folderY > expectedminHeight ? 1 : 0) != 0);
    }

    @Test
    public void test_nestedTabHighlighting() {
        CTabFolder partStackTabFolder = new CTabFolder((Composite)this.shell, 0);
        CTabItem consoleViewTab = new CTabItem(partStackTabFolder, 0);
        consoleViewTab.setText("Console View");
        SashForm anotherView = new SashForm((Composite)partStackTabFolder, 0);
        CTabItem anotherViewTab = new CTabItem(partStackTabFolder, 0);
        anotherViewTab.setText("Other View");
        anotherViewTab.setControl((Control)anotherView);
        CTabFolder anotherViewNestedTabFolder = new CTabFolder((Composite)anotherView, 0);
        CTabItem anotherViewNestedTab = new CTabItem(anotherViewNestedTabFolder, 0);
        anotherViewNestedTab.setText("nested tab");
        this.shell.pack();
        this.shell.open();
        this.processEvents();
        boolean shouldHighlightConsoleViewTab = Test_org_eclipse_swt_custom_CTabFolder.reflection_shouldHighlight(partStackTabFolder);
        Assert.assertFalse((String)"expected CTabFolder to not need highlighting without any selection", (boolean)shouldHighlightConsoleViewTab);
        partStackTabFolder.notifyListeners(26, new Event());
        partStackTabFolder.setSelection(consoleViewTab);
        partStackTabFolder.setSelection(anotherViewTab);
        anotherViewNestedTabFolder.notifyListeners(26, new Event());
        anotherViewNestedTabFolder.setSelection(anotherViewNestedTab);
        partStackTabFolder.setSelection(consoleViewTab);
        anotherViewNestedTabFolder.notifyListeners(27, new Event());
        this.processEvents();
        shouldHighlightConsoleViewTab = Test_org_eclipse_swt_custom_CTabFolder.reflection_shouldHighlight(partStackTabFolder);
        Assert.assertTrue((String)"Bug 528251 - View tab not highlighted due to another view with a CTabFolder", (boolean)shouldHighlightConsoleViewTab);
    }

    @Test
    public void test_chevronAppearanceChanged() {
        Display display = this.shell.getDisplay();
        this.createTabFolder(null);
        this.shell.open();
        this.processEvents();
        ToolItem chevron = this.showChevron();
        Image oldChevronImg = new Image((Device)display, chevron.getImage(), 0);
        Font newFont = null;
        try {
            this.ctabFolder.setForeground(display.getSystemColor(6));
            Image newChevronImg = chevron.getImage();
            ImageTestUtil.assertImagesNotEqual(oldChevronImg.getImageData(), newChevronImg.getImageData());
            oldChevronImg.dispose();
            oldChevronImg = new Image((Device)display, newChevronImg, 0);
            FontData[] existingFontData = this.ctabFolder.getFont().getFontData();
            existingFontData[0].setName(SwtTestUtil.testFontName);
            existingFontData[0].setStyle(3);
            newFont = new Font((Device)display, existingFontData);
            this.ctabFolder.setFont(newFont);
            newChevronImg = chevron.getImage();
            ImageTestUtil.assertImagesNotEqual(oldChevronImg.getImageData(), newChevronImg.getImageData());
        }
        finally {
            oldChevronImg.dispose();
            if (newFont != null) {
                newFont.dispose();
            }
        }
    }

    @Test
    public void test_childControlOverlap() {
        BiConsumer<Control, Integer> setTopRightAndCheckOverlap = (control, style) -> {
            if (style == 0) {
                this.ctabFolder.setTopRight(control);
            } else {
                this.ctabFolder.setTopRight(control, style.intValue());
            }
            this.processEvents();
            this.checkElementOverlap(this.ctabFolder);
        };
        this.makeCleanEnvironment(64);
        this.shell.setLayout((Layout)new FillLayout());
        SwtTestUtil.openShell(this.shell);
        Label topRightControl = new Label((Composite)this.ctabFolder, 2048);
        topRightControl.setText("TopRight");
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
        int i = 1;
        while (i <= 5) {
            CTabItem tabItem = new CTabItem(this.ctabFolder, 0);
            tabItem.setText("Item" + i);
            Composite filler = new Composite((Composite)this.ctabFolder, 0);
            filler.setBackground(filler.getDisplay().getSystemColor(5 + i));
            tabItem.setControl((Control)filler);
            ++i;
        }
        this.checkElementOverlap(this.ctabFolder);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 0);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 131136);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
        this.ctabFolder.setMinimizeVisible(true);
        this.checkElementOverlap(this.ctabFolder);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 0);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 131136);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
        this.ctabFolder.setMinimizeVisible(false);
        this.ctabFolder.setMaximizeVisible(true);
        this.checkElementOverlap(this.ctabFolder);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 0);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 131136);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
        this.ctabFolder.setMinimizeVisible(true);
        this.checkElementOverlap(this.ctabFolder);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 0);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 131136);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
        this.showChevron();
        this.checkElementOverlap(this.ctabFolder);
        this.ctabFolder.setMinimizeVisible(true);
        this.checkElementOverlap(this.ctabFolder);
        this.ctabFolder.setMaximizeVisible(true);
        this.checkElementOverlap(this.ctabFolder);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 0);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 131136);
        setTopRightAndCheckOverlap.accept((Control)topRightControl, 4);
        setTopRightAndCheckOverlap.accept(null, 0);
    }

    @Test
    public void test_iconWrappedOnNextLine() {
        this.createTabFolder(null);
        FontData[] existingFontData = this.ctabFolder.getFont().getFontData();
        existingFontData[0].setName(SwtTestUtil.testFontName);
        existingFontData[0].setHeight(3);
        Font smallFont = new Font((Device)this.ctabFolder.getDisplay(), existingFontData);
        try {
            SwtTestUtil.openShell(this.shell);
            this.ctabFolder.setFont(smallFont);
            this.ctabFolder.setMaximizeVisible(true);
            this.processEvents();
            this.assertTabElementsInLine();
            this.createTabFolder(null, 20);
            this.ctabFolder.setFont(smallFont);
            this.shell.layout(true, true);
            this.showChevron();
            this.processEvents();
            this.assertTabElementsInLine();
        }
        finally {
            smallFont.dispose();
        }
    }

    @Test
    public void test_selectedImageVisible() {
        this.createTabFolder(null);
        this.ctabFolder.setSelectedImageVisible(true);
        Assert.assertTrue((boolean)this.ctabFolder.getSelectedImageVisible());
        this.ctabFolder.setSelectedImageVisible(false);
        Assert.assertFalse((boolean)this.ctabFolder.getSelectedImageVisible());
    }

    private void processEvents() {
        Display display = this.shell.getDisplay();
        while (display.readAndDispatch()) {
        }
    }

    private static boolean reflection_shouldHighlight(CTabFolder partStackTabs) {
        String shouldHighlightMethodName = "shouldHighlight";
        Class<CTabFolder> cTabFolderClass = CTabFolder.class;
        boolean shouldHighlightConsoleViewTab = false;
        try {
            Method method = cTabFolderClass.getDeclaredMethod(shouldHighlightMethodName, new Class[0]);
            method.setAccessible(true);
            Object result = method.invoke((Object)partStackTabs, new Object[0]);
            Boolean shouldHighlight = (Boolean)result;
            shouldHighlightConsoleViewTab = shouldHighlight;
        }
        catch (Throwable t) {
            String message = "reflection call to " + cTabFolderClass.getName() + "." + shouldHighlightMethodName + "() failed";
            throw new AssertionError(message, t);
        }
        return shouldHighlightConsoleViewTab;
    }

    private ToolItem showChevron() {
        int itemWidth = 0;
        CTabItem[] cTabItemArray = this.ctabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            itemWidth += item.getBounds().width;
            ++n2;
        }
        int newWidth = itemWidth * 3 / 4;
        this.shell.setSize(newWidth, this.shell.getSize().y);
        boolean resizeFailed = Math.abs(newWidth - this.shell.getSize().x) > 10;
        ToolItem chevron = this.getChevron(this.ctabFolder);
        Assert.assertNotNull((String)("Chevron not shown" + (resizeFailed ? ". Shell could not be resized to the desired size. Tab row width might be smaller than the minimum shell width." : "")), (Object)chevron);
        return chevron;
    }

    private ToolItem getChevron(CTabFolder tabFolder) {
        Control[] controlArray = tabFolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)child;
                ToolItem[] toolItemArray = toolBar.getItems();
                int n3 = toolItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ToolItem toolItem = toolItemArray[n4];
                    if ((toolItem.getStyle() & 8) != 0 && toolItem.getText().isEmpty() && SWT.getMessage((String)"SWT_ShowList").equals(toolItem.getToolTipText()) && toolItem.getImage() != null) {
                        return toolItem;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    private void checkElementOverlap(CTabFolder tabFolder) {
        Rectangle folderBounds = tabFolder.getBounds();
        ArrayList<Object> subControls = new ArrayList<Object>();
        subControls.addAll(Arrays.asList(Test_org_eclipse_swt_custom_CTabFolder.reflection_getChildControls(tabFolder)));
        subControls.addAll(Arrays.asList(tabFolder.getItems()));
        int i = 0;
        while (i < subControls.size()) {
            block5: {
                Rectangle boundsA;
                block6: {
                    block4: {
                        boundsA = null;
                        Widget widget = (Widget)subControls.get(i);
                        if (!(widget instanceof Control)) break block4;
                        Control c = (Control)widget;
                        if (!c.isVisible()) break block5;
                        boundsA = c.getBounds();
                        break block6;
                    }
                    Widget widget = (Widget)subControls.get(i);
                    if (!(widget instanceof CTabItem)) break block6;
                    CTabItem cTab = (CTabItem)widget;
                    if (!cTab.isShowing()) break block5;
                    boundsA = cTab.getBounds();
                }
                int j = i + 1;
                while (j < subControls.size()) {
                    block8: {
                        Rectangle boundsB;
                        block9: {
                            block7: {
                                boundsB = null;
                                Widget widget = (Widget)subControls.get(j);
                                if (!(widget instanceof Control)) break block7;
                                Control c = (Control)widget;
                                if (!c.isVisible()) break block8;
                                boundsB = c.getBounds();
                                break block9;
                            }
                            Widget widget = (Widget)subControls.get(j);
                            if (!(widget instanceof CTabItem)) break block9;
                            CTabItem cTab = (CTabItem)widget;
                            if (!cTab.isShowing()) break block8;
                            boundsB = cTab.getBounds();
                        }
                        Assert.assertFalse((String)("Overlap between <" + String.valueOf(subControls.get(i)) + "> and <" + String.valueOf(subControls.get(j)) + ">\n" + String.valueOf(boundsA) + " overlaps " + String.valueOf(boundsB)), (boolean)boundsA.intersects(boundsB));
                    }
                    ++j;
                }
                Assert.assertEquals((String)("Element <" + String.valueOf(subControls.get(i)) + "> outside folder."), (Object)folderBounds.intersection(boundsA), (Object)boundsA);
            }
            ++i;
        }
    }

    private static Control[] reflection_getChildControls(CTabFolder tabFolder) {
        String childControlArrayName = "controls";
        try {
            Field field = CTabFolder.class.getDeclaredField(childControlArrayName);
            field.setAccessible(true);
            return (Control[])field.get(tabFolder);
        }
        catch (Exception exception) {
            Assert.fail((String)"Failed to access controls via reflections.");
            return null;
        }
    }

    private void assertTabElementsInLine() {
        ArrayList<Rectangle> tabBarElementBounds = new ArrayList<Rectangle>();
        Arrays.stream(this.ctabFolder.getItems()).filter(CTabItem::isShowing).map(this::getBoundsInShell).forEach(tabBarElementBounds::add);
        Control[] controlArray = this.ctabFolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ToolBar) {
                ToolBar toolBarChild = (ToolBar)child;
                ToolItem[] toolItemArray = toolBarChild.getItems();
                int n3 = toolItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ToolItem toolItem = toolItemArray[n4];
                    if (toolItem.getImage() != null) {
                        tabBarElementBounds.add(this.getBoundsInShell((Widget)toolItem));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        Rectangle maxBound = (Rectangle)tabBarElementBounds.get(0);
        for (Rectangle bound : tabBarElementBounds) {
            if (bound.height > maxBound.height) {
                Assert.assertTrue((String)("Element at " + String.valueOf(maxBound) + " is not on line."), (bound.y <= maxBound.y && bound.y + bound.height >= maxBound.y + maxBound.height ? 1 : 0) != 0);
                maxBound = bound;
                continue;
            }
            Assert.assertTrue((String)("Element at " + String.valueOf(bound) + " is not on line."), (bound.y >= maxBound.y && bound.y + bound.height <= maxBound.y + maxBound.height ? 1 : 0) != 0);
        }
    }

    private Rectangle getBoundsInShell(Widget control) {
        Rectangle bounds;
        Composite parent;
        if (control instanceof Control) {
            Control c = (Control)control;
            parent = c.getParent();
            bounds = c.getBounds();
        } else if (control instanceof CTabItem) {
            CTabItem cTab = (CTabItem)control;
            parent = cTab.getParent();
            bounds = cTab.getBounds();
        } else if (control instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)control;
            parent = toolItem.getParent();
            bounds = toolItem.getBounds();
        } else {
            throw new UnsupportedOperationException("Widget must provide bounds and parent");
        }
        if (parent != null && !(parent instanceof Shell)) {
            Rectangle absParentBound = this.getBoundsInShell((Widget)parent);
            bounds.x += absParentBound.x;
            bounds.y += absParentBound.y;
        }
        return bounds;
    }
}

