/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_custom_ExtendedModifyListener {
    Shell shell;
    StyledText styledText;
    int verify = -1;

    @BeforeEach
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
        this.shell.open();
    }

    @Test
    public void test_modifyTextLorg_eclipse_swt_custom_ExtendedModifyEvent() {
        ExtendedModifyListener listener = event -> {
            switch (this.verify) {
                case 1: {
                    Assertions.assertEquals((int)0, (int)event.start);
                    Assertions.assertEquals((int)1, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 2: {
                    Assertions.assertEquals((int)0, (int)event.start);
                    Assertions.assertEquals((int)1, (int)event.length);
                    Assertions.assertEquals((Object)"\n\n", (Object)event.replacedText);
                    break;
                }
                case 3: {
                    Assertions.assertEquals((int)0, (int)event.start);
                    Assertions.assertEquals((int)2, (int)event.length);
                    Assertions.assertEquals((Object)"a", (Object)event.replacedText);
                    break;
                }
                case 4: {
                    Assertions.fail();
                    break;
                }
                case 5: {
                    Assertions.assertEquals((int)0, (int)event.start);
                    Assertions.assertEquals((int)1, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 6: {
                    Assertions.assertEquals((int)21, (int)event.start);
                    Assertions.assertEquals((int)0, (int)event.length);
                    Assertions.assertEquals((Object)"\nline 4", (Object)event.replacedText);
                    break;
                }
                case 7: {
                    Assertions.assertEquals((int)5, (int)event.start);
                    Assertions.assertEquals((int)0, (int)event.length);
                    Assertions.assertEquals((Object)"is a test", (Object)event.replacedText);
                    break;
                }
                case 8: {
                    Assertions.assertEquals((int)7, (int)event.start);
                    Assertions.assertEquals((int)0, (int)event.length);
                    Assertions.assertEquals((Object)"\r\n", (Object)event.replacedText);
                    break;
                }
                case 9: {
                    Assertions.assertEquals((int)2, (int)event.start);
                    Assertions.assertEquals((int)4, (int)event.length);
                    Assertions.assertEquals((Object)"\r\n", (Object)event.replacedText);
                    break;
                }
                case 10: 
                case 11: {
                    Assertions.fail();
                    break;
                }
                case 12: {
                    Assertions.assertEquals((int)3, (int)event.start);
                    Assertions.assertEquals((int)1, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 13: {
                    Assertions.assertEquals((int)2, (int)event.start);
                    Assertions.assertEquals((int)1, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 14: {
                    Assertions.fail();
                    break;
                }
                case 15: {
                    Assertions.assertEquals((int)2, (int)event.start);
                    Assertions.assertEquals((int)6, (int)event.length);
                    Assertions.assertEquals((Object)"\r\n", (Object)event.replacedText);
                    break;
                }
                case 16: 
                case 17: {
                    Assertions.fail();
                    break;
                }
                case 18: {
                    Assertions.assertEquals((int)3, (int)event.start);
                    Assertions.assertEquals((int)7, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 19: {
                    Assertions.assertEquals((int)2, (int)event.start);
                    Assertions.assertEquals((int)7, (int)event.length);
                    Assertions.assertTrue((boolean)event.replacedText.isEmpty());
                    break;
                }
                case 20: {
                    Assertions.assertTrue((boolean)false);
                    break;
                }
                case 21: {
                    Assertions.assertEquals((int)0, (int)event.start);
                    Assertions.assertEquals((int)16, (int)event.length);
                    Assertions.assertEquals((Object)"L1\r\nL2\r\nL3\r\nL4\r\n", (Object)event.replacedText);
                }
            }
        };
        this.styledText.addExtendedModifyListener(listener);
        this.verify = 0;
        this.styledText.setText("testing");
        this.verify = 1;
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 0;
        this.styledText.setText("\n\n");
        this.verify = 2;
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 0;
        this.styledText.setText("a");
        this.verify = 3;
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 4;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        this.verify = 0;
        this.styledText.setText("Line 1\r\nLine 2");
        this.verify = 5;
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 0;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.verify = 6;
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 0;
        this.styledText.setText("This\nis a test\r");
        this.verify = 7;
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 0;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.verify = 8;
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 9;
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 10;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, ""));
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 11;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, ""));
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 12;
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 13;
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 14;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 0, "test"));
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 15;
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 16;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\r\n"));
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 17;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, "test\n\n"));
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 18;
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 19;
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 20;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        this.verify = 21;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.styledText.removeExtendedModifyListener(listener);
    }
}

