/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextLineSpacingProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_custom_StyledTextLineSpacingProvider {
    Shell shell;
    StyledText styledText;

    @BeforeEach
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
    }

    @Test
    public void test_setLineSpacingProvider() {
        this.styledText.setText("a\n45\nc\n57");
        this.assertLineSpacingEquals(0, 0, 0, 0, 0);
        this.styledText.setLineSpacingProvider((StyledTextLineSpacingProvider)new IntegerLineSpacingProvider());
        this.assertLineSpacingEquals(0, 0, 45, 0, 57);
        this.styledText.setLineSpacingProvider(null);
        this.assertLineSpacingEquals(0, 0, 0, 0, 0);
    }

    @Test
    public void test_replaceTextRange() {
        this.styledText.setText("a\n45\nc\n57");
        this.styledText.setLineSpacingProvider((StyledTextLineSpacingProvider)new IntegerLineSpacingProvider());
        this.assertLineSpacingEquals(0, 0, 45, 0, 57);
        this.styledText.replaceTextRange(2, 2, "b");
        this.assertLineSpacingEquals(0, 0, 0, 0, 57);
        this.styledText.replaceTextRange(2, 1, "45");
        this.assertLineSpacingEquals(0, 0, 45, 0, 57);
    }

    private void assertLineSpacingEquals(int ... expecteds) {
        int lineHeight = this.styledText.getLineHeight();
        int[] actuals = new int[expecteds.length];
        int i = 0;
        while (i < expecteds.length) {
            actuals[i] = this.styledText.getLinePixel(i) - (i > 0 ? this.styledText.getLinePixel(i - 1) + lineHeight : 0);
            ++i;
        }
        Assertions.assertArrayEquals((int[])expecteds, (int[])actuals);
    }

    class IntegerLineSpacingProvider
    implements StyledTextLineSpacingProvider {
        IntegerLineSpacingProvider() {
        }

        public Integer getLineSpacing(int lineIndex) {
            try {
                String text = Test_org_eclipse_swt_custom_StyledTextLineSpacingProvider.this.styledText.getLine(lineIndex);
                return Integer.parseInt(text);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

