/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_StyledText_VariableLineHeight {
    Shell shell;
    StyledText styledText;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
        this.styledText.setLineSpacingProvider(l -> 0);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
    }

    @Test
    public void testRise() {
        this.styledText.setText("a\nb\nc\nd");
        int length = this.styledText.getCharCount();
        this.assertVariableLineHeightEquals(0, 0);
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.rise = 1;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(1, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.rise = 0;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.rise = 2;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(2, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.rise = 2;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(2, 0);
    }

    @Test
    public void testFont() {
        FontData[] fontData;
        this.styledText.setText("a\nb\nc\nd");
        Font initialFont = this.styledText.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(24);
            ++n2;
        }
        Font bigFont = new Font((Device)this.styledText.getDisplay(), fontData);
        FontData[] fontDataArray2 = fontData = initialFont.getFontData();
        int n3 = fontData.length;
        n = 0;
        while (n < n3) {
            FontData fd = fontDataArray2[n];
            fd.setHeight(fd.getHeight() - 1);
            ++n;
        }
        Font littleFont = new Font((Device)this.styledText.getDisplay(), fontData);
        int length = this.styledText.getCharCount();
        this.assertVariableLineHeightEquals(0, 0);
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = bigFont;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0, bigFont);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = null;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = bigFont;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0, bigFont);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = littleFont;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = null;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0);
        style = new StyleRange();
        style.start = 0;
        style.length = length;
        style.foreground = this.styledText.getDisplay().getSystemColor(9);
        style.font = littleFont;
        this.styledText.replaceStyleRanges(0, length, new StyleRange[]{style});
        this.assertVariableLineHeightEquals(0, 0);
        bigFont.dispose();
        littleFont.dispose();
    }

    @Test
    public void testLittleFontSeveralRanges() {
        FontData[] fontData;
        this.styledText.setText("abc\nd");
        Font initialFont = this.styledText.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(fd.getHeight() / 2);
            ++n2;
        }
        Font littleFont1 = new Font((Device)this.styledText.getDisplay(), fontData);
        FontData[] fontDataArray2 = fontData = initialFont.getFontData();
        int n3 = fontData.length;
        n = 0;
        while (n < n3) {
            FontData fd = fontDataArray2[n];
            fd.setHeight(fd.getHeight() / 4);
            ++n;
        }
        Font littleFont2 = new Font((Device)this.styledText.getDisplay(), fontData);
        StyleRange[] ranges = new StyleRange[2];
        ranges[0] = new StyleRange();
        ranges[0].start = 0;
        ranges[0].length = 1;
        ranges[0].font = littleFont1;
        ranges[1] = new StyleRange();
        ranges[1].start = 1;
        ranges[1].length = 1;
        ranges[1].font = littleFont2;
        this.styledText.replaceStyleRanges(0, 3, ranges);
        this.assertVariableLineHeightEquals(0, 0);
        littleFont1.dispose();
        littleFont2.dispose();
    }

    @Test
    public void testBigFontSeveralRanges() {
        FontData[] fontData;
        this.styledText.setText("abc\nd");
        Font initialFont = this.styledText.getFont();
        FontData[] fontDataArray = fontData = initialFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(fd.getHeight() * 2);
            ++n2;
        }
        Font bigFont = new Font((Device)this.styledText.getDisplay(), fontData);
        FontData[] fontDataArray2 = fontData = initialFont.getFontData();
        int n3 = fontData.length;
        n = 0;
        while (n < n3) {
            FontData fd = fontDataArray2[n];
            fd.setHeight(fd.getHeight() / 2);
            ++n;
        }
        Font littleFont = new Font((Device)this.styledText.getDisplay(), fontData);
        StyleRange[] ranges = new StyleRange[2];
        ranges[0] = new StyleRange();
        ranges[0].start = 0;
        ranges[0].length = 1;
        ranges[0].font = bigFont;
        ranges[1] = new StyleRange();
        ranges[1].start = 1;
        ranges[1].length = 1;
        ranges[1].font = littleFont;
        this.styledText.replaceStyleRanges(0, 3, ranges);
        this.assertVariableLineHeightEquals(0, 0, bigFont);
        bigFont.dispose();
        littleFont.dispose();
    }

    private void assertVariableLineHeightEquals(int expected, int lineIndex) {
        this.assertVariableLineHeightEquals(expected, lineIndex, null);
    }

    private void assertVariableLineHeightEquals(int expected, int lineIndex, Font font) {
        int fontHeight = this.styledText.getLineHeight();
        if (font != null) {
            TextLayout layout = new TextLayout(font.getDevice());
            layout.setFont(font);
            layout.setText("a");
            fontHeight = layout.getBounds().height;
            layout.dispose();
        }
        int actual = this.styledText.getLinePixel(lineIndex + 1) - this.styledText.getLinePixel(lineIndex) - fontHeight;
        Assert.assertEquals((long)expected, (long)actual);
    }
}

