/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class Test_org_eclipse_swt_custom_StyledText_multiCaretsSelections {
    Shell shell;
    StyledText text;
    GC gc;
    @Rule
    public TestWatcher screenshotRule = Screenshots.onFailure(() -> this.shell);

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.text = new StyledText((Composite)this.shell, 0);
        this.gc = new GC((Drawable)this.text);
    }

    @After
    public void tearDown() {
        this.gc.dispose();
    }

    @Test
    public void test_MultiSelectionEdit() {
        this.text.setText("0123456789abcdef");
        this.text.setSelectionRanges(new int[]{1, 1, 5, 1});
        Assert.assertArrayEquals((int[])new int[]{1, 1, 5, 1}, (int[])this.text.getSelectionRanges());
        Assert.assertEquals((long)2L, (long)this.text.getCaretOffset());
        Event keyEvent = new Event();
        keyEvent.type = 1;
        keyEvent.character = (char)120;
        keyEvent.widget = this.text;
        keyEvent.display = this.text.getDisplay();
        keyEvent.doit = true;
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"0x234x6789abcdef", (Object)this.text.getText());
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 6;
        Assert.assertArrayEquals((int[])nArray, (int[])this.text.getSelectionRanges());
        Assert.assertEquals((long)2L, (long)this.text.getCaretOffset());
        keyEvent.character = (char)121;
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"0xy234xy6789abcdef", (Object)this.text.getText());
        this.text.setText("0123456789 ABCDEFGHIJKLM NOPQRSTUVWXYZ");
        this.text.setSelectionRanges(new int[]{3, 5, 13, 2, 21, 10});
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"012y89 AByEFGHIJyTUVWXYZ", (Object)this.text.getText());
        Assert.assertEquals((long)4L, (long)this.text.getCaretOffset());
        int[] nArray2 = new int[6];
        nArray2[0] = 4;
        nArray2[2] = 10;
        nArray2[4] = 17;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.text.getSelectionRanges());
        keyEvent.character = (char)122;
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"012yz89 AByzEFGHIJyzTUVWXYZ", (Object)this.text.getText());
        Assert.assertEquals((long)5L, (long)this.text.getCaretOffset());
    }

    @Test
    public void test_MultiSelectionExpandRanges() {
        this.text.setText("0123456789");
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[4] = 6;
        this.text.setSelectionRanges(nArray);
        this.text.invokeAction(16908292);
        int[] nArray2 = new int[6];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 1;
        nArray2[4] = 6;
        nArray2[5] = 1;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
        this.text.invokeAction(16908292);
        int[] nArray3 = new int[4];
        nArray3[1] = 5;
        nArray3[2] = 6;
        nArray3[3] = 2;
        Assert.assertArrayEquals((int[])nArray3, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
        this.text.invokeAction(16908292);
        int[] nArray4 = new int[2];
        nArray4[1] = 9;
        Assert.assertArrayEquals((int[])nArray4, (int[])this.text.getSelectionRanges());
        this.text.invokeAction(16908292);
        int[] nArray5 = new int[2];
        nArray5[1] = 10;
        Assert.assertArrayEquals((int[])nArray5, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
        int[] nArray6 = new int[6];
        nArray6[0] = 3;
        nArray6[2] = 5;
        nArray6[3] = 2;
        nArray6[4] = 10;
        this.text.setSelectionRanges(nArray6);
        this.text.invokeAction(16908291);
        Assert.assertArrayEquals((int[])new int[]{2, 1, 4, 3, 9, 1}, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
        this.text.invokeAction(16908291);
        Assert.assertArrayEquals((int[])new int[]{1, 6, 8, 2}, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
        this.text.invokeAction(16908291);
        int[] nArray7 = new int[2];
        nArray7[1] = 10;
        Assert.assertArrayEquals((int[])nArray7, (int[])this.text.getSelectionRanges());
        this.text.notifyListeners(9, this.paintEvent());
    }

    @Test
    public void test_MultiCarets_TypeAndMove() {
        this.text.setText("0123456789");
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[2] = 3;
        nArray[4] = 6;
        this.text.setSelectionRanges(nArray);
        this.text.invokeAction(0x1000004);
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[2] = 4;
        nArray2[4] = 7;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.text.getSelectionRanges());
        this.text.invokeAction(0x1000003);
        int[] nArray3 = new int[6];
        nArray3[0] = 1;
        nArray3[2] = 3;
        nArray3[4] = 6;
        Assert.assertArrayEquals((int[])nArray3, (int[])this.text.getSelectionRanges());
        Event keyEvent = new Event();
        keyEvent.type = 1;
        keyEvent.character = (char)120;
        keyEvent.widget = this.text;
        keyEvent.display = this.text.getDisplay();
        keyEvent.doit = true;
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"0x12x345x6789", (Object)this.text.getText());
        int[] nArray4 = new int[6];
        nArray4[0] = 2;
        nArray4[2] = 5;
        nArray4[4] = 9;
        Assert.assertArrayEquals((int[])nArray4, (int[])this.text.getSelectionRanges());
        keyEvent.keyCode = 8;
        keyEvent.character = '\u0000';
        this.text.notifyListeners(1, keyEvent);
        Assert.assertEquals((Object)"0123456789", (Object)this.text.getText());
        int[] nArray5 = new int[6];
        nArray5[0] = 1;
        nArray5[2] = 3;
        nArray5[4] = 6;
        Assert.assertArrayEquals((int[])nArray5, (int[])this.text.getSelectionRanges());
        this.text.setText("12345\n12345\n12345\n12345");
        int[] nArray6 = new int[8];
        nArray6[0] = 1;
        nArray6[2] = 4;
        nArray6[4] = 13;
        nArray6[6] = 17;
        this.text.setSelectionRanges(nArray6);
        this.text.invokeAction(0x1000002);
        int[] nArray7 = new int[8];
        nArray7[0] = 7;
        nArray7[2] = 10;
        nArray7[4] = 19;
        nArray7[6] = 23;
        Assert.assertArrayEquals((int[])nArray7, (int[])this.text.getSelectionRanges());
        this.text.invokeAction(0x1000001);
        int[] nArray8 = new int[8];
        nArray8[0] = 1;
        nArray8[2] = 4;
        nArray8[4] = 13;
        nArray8[6] = 17;
        Assert.assertArrayEquals((int[])nArray8, (int[])this.text.getSelectionRanges());
        int[] nArray9 = new int[4];
        nArray9[0] = 8;
        nArray9[2] = 15;
        this.text.setSelectionRanges(nArray9);
        boolean visible = this.text.getShell().getVisible();
        Layout layout = this.text.getShell().getLayout();
        try {
            this.text.getShell().setVisible(true);
            this.text.getShell().forceActive();
            this.text.getShell().setLayout((Layout)new FillLayout());
            this.text.getShell().pack();
            this.text.forceFocus();
            this.text.isFocusControl();
            this.text.invokeAction(0x1020001);
            Assert.assertArrayEquals((int[])new int[]{2, 6, 9, 6}, (int[])this.text.getSelectionRanges());
            this.text.invokeAction(0x1020001);
            int[] nArray10 = new int[2];
            nArray10[1] = 15;
            Assert.assertArrayEquals((int[])nArray10, (int[])this.text.getSelectionRanges());
            this.text.notifyListeners(9, this.paintEvent());
        }
        finally {
            this.text.getShell().setVisible(visible);
            this.text.getShell().setLayout(layout);
        }
    }

    private Event paintEvent() {
        Event paintEvent = new Event();
        paintEvent.display = this.text.getDisplay();
        paintEvent.width = this.text.getSize().x;
        paintEvent.height = this.text.getSize().y;
        paintEvent.widget = this.text;
        paintEvent.type = 9;
        paintEvent.gc = this.gc;
        return paintEvent;
    }

    @Test
    public void test_MultiCarets_DeleteAtOffset0() {
        this.text.setText("0123456789");
        int[] nArray = new int[6];
        nArray[2] = 3;
        nArray[4] = 6;
        this.text.setSelectionRanges(nArray);
        this.text.invokeAction(127);
        int[] nArray2 = new int[6];
        nArray2[2] = 2;
        nArray2[4] = 4;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.text.getSelectionRanges());
    }

    @Test
    public void test_MultiCarets_Delete() {
        this.text.setText("12345\n12345");
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 8;
        this.text.setSelectionRanges(nArray);
        this.text.invokeAction(127);
        Assert.assertEquals((Object)"1245\n1245", (Object)this.text.getText());
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[2] = 7;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.text.getSelectionRanges());
    }

    @Test
    public void test_MultiCarets_CopyPaste() {
        this.text.setText("1\n2");
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 1;
        this.text.setSelectionRanges(nArray);
        this.text.copy();
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 3;
        this.text.setSelectionRanges(nArray2);
        this.text.paste();
        Assert.assertEquals((Object)"11\n22", (Object)this.text.getText());
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[2] = 5;
        Assert.assertArrayEquals((int[])nArray3, (int[])this.text.getSelectionRanges());
    }
}

