/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_custom_TextChangeListener {
    Shell shell;
    StyledText styledText;
    int verify = -1;

    @BeforeEach
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
    }

    @Test
    public void test_textChangedLorg_eclipse_swt_custom_TextChangedEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(TextChangedEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assertions.assertEquals((Object)"\ntesting", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 2: {
                        Assertions.assertEquals((Object)"a", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 3: {
                        Assertions.assertEquals((Object)"\n\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 4: {
                        Assertions.fail();
                        break;
                    }
                    case 5: {
                        Assertions.assertEquals((Object)"\rLine 1\r\nLine 2", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 6: {
                        Assertions.assertEquals((Object)"This\nis a test\nline 3", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 7: {
                        Assertions.assertEquals((Object)"This\n\r", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 8: {
                        Assertions.assertEquals((Object)"\nL1\r\nL2", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 9: {
                        Assertions.assertEquals((Object)"L1test", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 10: {
                        Assertions.fail();
                        break;
                    }
                    case 11: {
                        Assertions.fail();
                        break;
                    }
                    case 12: {
                        Assertions.assertEquals((Object)"L1\r\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 13: {
                        Assertions.assertEquals((Object)"L1\r\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 14: {
                        Assertions.fail();
                        break;
                    }
                    case 15: {
                        Assertions.assertEquals((Object)"L1test\n\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 16: {
                        Assertions.fail();
                        break;
                    }
                    case 17: {
                        Assertions.fail();
                        break;
                    }
                    case 18: {
                        Assertions.assertEquals((Object)"L1\r\ntest\r\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 19: {
                        Assertions.assertEquals((Object)"L1test\r\r\r\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 20: {
                        Assertions.fail();
                    }
                }
            }

            public void textChanging(TextChangingEvent event) {
            }

            public void textSet(TextChangedEvent event) {
            }
        };
        content.addTextChangeListener(listener);
        this.verify = 0;
        this.styledText.setText("testing");
        this.verify = 1;
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 0;
        this.styledText.setText("\n\n");
        this.verify = 2;
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 0;
        this.styledText.setText("a");
        this.verify = 3;
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 4;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        this.verify = 0;
        this.styledText.setText("Line 1\r\nLine 2");
        this.verify = 5;
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 0;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.verify = 6;
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 0;
        this.styledText.setText("This\nis a test\r");
        this.verify = 7;
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 0;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.verify = 8;
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 9;
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 10;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, ""));
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 11;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, ""));
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 12;
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 13;
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 14;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 0, "test"));
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 15;
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 16;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\r\n"));
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 17;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, "test\n\n"));
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 18;
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 19;
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 20;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        content.removeTextChangeListener(listener);
    }

    @Test
    public void test_textChangingLorg_eclipse_swt_custom_TextChangingEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)1, (int)event.newLineCount);
                        break;
                    }
                    case 2: {
                        Assertions.assertEquals((int)2, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)0, (int)event.newLineCount);
                        break;
                    }
                    case 3: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)2, (int)event.newLineCount);
                        break;
                    }
                    case 4: {
                        Assertions.fail();
                        break;
                    }
                    case 5: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)1, (int)event.newLineCount);
                        break;
                    }
                    case 6: {
                        Assertions.assertEquals((int)1, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)0, (int)event.newLineCount);
                        break;
                    }
                    case 7: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)0, (int)event.newLineCount);
                        break;
                    }
                    case 8: {
                        Assertions.assertEquals((int)1, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)0, (int)event.newLineCount);
                        break;
                    }
                    case 9: {
                        Assertions.assertEquals((int)1, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)0, (int)event.newLineCount);
                        break;
                    }
                    case 10: {
                        Assertions.fail();
                        break;
                    }
                    case 11: {
                        Assertions.fail();
                        break;
                    }
                    case 12: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)1, (int)event.newLineCount);
                        break;
                    }
                    case 13: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)1, (int)event.newLineCount);
                        break;
                    }
                    case 14: {
                        Assertions.fail();
                        break;
                    }
                    case 15: {
                        Assertions.assertEquals((int)1, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)2, (int)event.newLineCount);
                        break;
                    }
                    case 16: {
                        Assertions.fail();
                        break;
                    }
                    case 17: {
                        Assertions.fail();
                        break;
                    }
                    case 18: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)2, (int)event.newLineCount);
                        break;
                    }
                    case 19: {
                        Assertions.assertEquals((int)0, (int)event.replaceLineCount);
                        Assertions.assertEquals((int)3, (int)event.newLineCount);
                        break;
                    }
                    case 20: {
                        Assertions.fail();
                    }
                }
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
            }
        };
        content.addTextChangeListener(listener);
        this.verify = 1;
        this.styledText.setText("testing");
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 2;
        this.styledText.setText("\n\n");
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 3;
        this.styledText.setText("a");
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 4;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        this.verify = 5;
        this.styledText.setText("Line 1\r\nLine 2");
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 6;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 7;
        this.styledText.setText("This\nis a test\r");
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 8;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 9;
        this.styledText.setText("L1\r\n");
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 10;
        this.styledText.setText("L1\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, ""));
        this.verify = 11;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, ""));
        this.verify = 12;
        this.styledText.setText("L1\r");
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 13;
        this.styledText.setText("L1\n");
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 14;
        this.styledText.setText("L1\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 0, "test"));
        this.verify = 15;
        this.styledText.setText("L1\r\n");
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 16;
        this.styledText.setText("L1\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\r\n"));
        this.verify = 17;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(1, 2, "test\n\n"));
        this.verify = 18;
        this.styledText.setText("L1\r");
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 19;
        this.styledText.setText("L1\n");
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 20;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.replaceTextRange(3, 1, "test\n"));
        content.removeTextChangeListener(listener);
    }

    @Test
    public void test_textSetLorg_eclipse_swt_custom_TextChangedEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assertions.assertEquals((Object)"testing", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 2: {
                        Assertions.assertEquals((Object)"\n\n", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 3: {
                        Assertions.assertEquals((Object)"a", (Object)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText());
                        break;
                    }
                    case 4: {
                        Assertions.assertTrue((boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().isEmpty());
                    }
                }
            }
        };
        content.addTextChangeListener(listener);
        this.verify = 1;
        this.styledText.setText("testing");
        this.verify = 2;
        this.styledText.setText("\n\n");
        this.verify = 3;
        this.styledText.setText("a");
        this.verify = 4;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.styledText.setText(null));
        content.removeTextChangeListener(listener);
    }
}

