/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Color {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceIII() {
        new Color(0, 0, 0);
        new Color(0, 0, 0, 0);
        new Color(255, 255, 255);
        new Color(255, 255, 255, 0);
        new Color(20, 20, 20);
        new Color(20, 20, 20, 0);
        new Color(102, 255, 0);
        new Color(102, 255, 0, 0);
        Assert.assertThrows((String)"No exception thrown for rgb < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(-10, -10, -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(0, 0, 0, -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgb > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(1000, 2000, 3000);
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(1000, 2000, 3000, 4000);
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(10, 10, 256);
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(10, 10, 10, 256);
        });
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceIII_with_device() {
        new Color((Device)this.display, 0, 0, 0);
        new Color((Device)this.display, 0, 0, 0, 0);
        new Color((Device)this.display, 255, 255, 255);
        new Color((Device)this.display, 255, 255, 255, 0);
        new Color((Device)this.display, 20, 20, 20);
        new Color((Device)this.display, 20, 20, 20, 0);
        new Color((Device)this.display, 102, 255, 0);
        new Color((Device)this.display, 102, 255, 0, 0);
        new Color(null, 0, 0, 0);
        new Color(null, 0, 0, 0, 0);
        Assert.assertThrows((String)"No exception thrown for rgb < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, -10, -10, -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, 0, 0, 0, -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgb > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, 1000, 2000, 3000);
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 355", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, 1000, 2000, 3000, 4000);
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, 10, 10, 256);
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, 10, 10, 10, 256);
        });
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGB() {
        new Color(new RGB(0, 0, 0));
        new Color(new RGB(0, 0, 0), 0);
        new Color(new RGB(255, 255, 255));
        new Color(new RGB(255, 255, 255), 0);
        new Color(new RGB(10, 10, 10));
        new Color(new RGB(10, 10, 10), 0);
        new Color(new RGB(102, 255, 0));
        new Color(new RGB(102, 255, 0), 0);
        Assert.assertThrows((String)"No exception thrown for rgb < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(-10, -10, -10));
        });
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(0, 0, 0), -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgb > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(1000, 2000, 3000));
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(1000, 2000, 3000), 4000);
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(10, 10, 256));
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGB(10, 10, 10), 256);
        });
        Assert.assertThrows((String)"No exception thrown for rgb == null with alpha", IllegalArgumentException.class, () -> {
            Color color = new Color(null, 0);
        });
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGB_with_device() {
        new Color((Device)this.display, new RGB(0, 0, 0));
        new Color((Device)this.display, new RGB(0, 0, 0), 0);
        new Color((Device)this.display, new RGB(255, 255, 255));
        new Color((Device)this.display, new RGB(255, 255, 255), 0);
        new Color((Device)this.display, new RGB(10, 10, 10));
        new Color((Device)this.display, new RGB(10, 10, 10), 0);
        new Color((Device)this.display, new RGB(102, 255, 0));
        new Color((Device)this.display, new RGB(102, 255, 0), 0);
        new Color(null, new RGB(0, 0, 0));
        new Color(null, new RGB(0, 0, 0), 0);
        Assert.assertThrows((String)"No exception thrown for rgb < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(-10, -10, -10));
        });
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(0, 0, 0), -10);
        });
        Assert.assertThrows((String)"No exception thrown for rgb > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(1000, 2000, 3000));
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(1000, 2000, 3000), 4000);
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(10, 10, 256));
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGB(10, 10, 10), 256);
        });
        Assert.assertThrows((String)"No exception thrown for rgb == null with alpha", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, null, 0);
        });
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGBA() {
        new Color(new RGBA(0, 0, 0, 255));
        new Color(new RGBA(0, 0, 0, 0));
        new Color(new RGBA(255, 255, 255, 255));
        new Color(new RGBA(255, 255, 255, 0));
        new Color(new RGBA(10, 10, 10, 10));
        new Color(new RGBA(10, 10, 10, 0));
        new Color(new RGBA(102, 255, 0, 255));
        new Color(new RGBA(102, 255, 0, 0));
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGBA(-10, -10, -10, -10));
        });
        Assert.assertThrows((String)"No exception thrown for alpha < 0", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGBA(0, 0, 0, -10));
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGBA(1000, 2000, 3000, 4000));
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGBA(10, 10, 256, 10));
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color(new RGBA(10, 10, 10, 256));
        });
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGBA_with_device() {
        new Color((Device)this.display, new RGBA(0, 0, 0, 255));
        new Color((Device)this.display, new RGBA(0, 0, 0, 0));
        new Color((Device)this.display, new RGBA(255, 255, 255, 255));
        new Color((Device)this.display, new RGBA(255, 255, 255, 0));
        new Color((Device)this.display, new RGBA(10, 10, 10, 10));
        new Color((Device)this.display, new RGBA(10, 10, 10, 0));
        new Color((Device)this.display, new RGBA(102, 255, 0, 255));
        new Color((Device)this.display, new RGBA(102, 255, 0, 0));
        new Color(null, new RGBA(0, 0, 0, 255));
        new Color(null, new RGBA(0, 0, 0, 0));
        Assert.assertThrows((String)"No exception thrown for rgba < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGBA(-10, -10, -10, -10));
        });
        Assert.assertThrows((String)"No exception thrown for alpha < 0", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGBA(0, 0, 0, -10));
        });
        Assert.assertThrows((String)"No exception thrown for rgba > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGBA(1000, 2000, 3000, 4000));
        });
        Assert.assertThrows((String)"No exception thrown for blue > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGBA(10, 10, 256, 10));
        });
        Assert.assertThrows((String)"No exception thrown for alpha > 255", IllegalArgumentException.class, () -> {
            Color color = new Color((Device)this.display, new RGBA(10, 10, 10, 256));
        });
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Color color = new Color(1, 2, 3);
        Color sameColor = new Color(1, 2, 3);
        Color sameColor2 = new Color(new RGB(1, 2, 3));
        Color otherColor = new Color(5, 6, 7);
        Color disposedColor = new Color(1, 2, 3);
        Color disposedColor2 = new Color(5, 6, 7);
        Assert.assertFalse((String)"!color.equals((Object)null)", (boolean)color.equals(null));
        Assert.assertFalse((String)"!color.equals((Color)null)", (boolean)color.equals(null));
        Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
        Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColor));
        color = new Color(1, 2, 3, 0);
        sameColor = new Color(1, 2, 3, 0);
        sameColor2 = new Color(new RGB(1, 2, 3), 0);
        otherColor = new Color(5, 6, 7, 0);
        Assert.assertFalse((String)"!color.equals((Object)null)", (boolean)color.equals(null));
        Assert.assertFalse((String)"!color.equals((Color)null)", (boolean)color.equals(null));
        Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
        Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColor));
        Assert.assertFalse((String)"!color.equals(disposedColor)", (boolean)color.equals((Object)disposedColor));
        Assert.assertFalse((String)"!disposedColor.equals(color)", (boolean)disposedColor.equals((Object)color));
        Assert.assertFalse((String)"!disposedColor.equals(disposedColor2)", (boolean)disposedColor.equals((Object)disposedColor2));
        Assert.assertFalse((String)"!disposedColor2.equals(disposedColor)", (boolean)disposedColor2.equals((Object)disposedColor));
    }

    @Test
    public void test_equalsLjava_lang_Object_with_device() {
        Color color = new Color((Device)this.display, 1, 2, 3);
        Color sameColor = new Color((Device)this.display, 1, 2, 3);
        Color sameColor2 = new Color((Device)this.display, new RGB(1, 2, 3));
        Color otherColor = new Color((Device)this.display, 5, 6, 7);
        Assert.assertFalse((String)"!color.equals((Object)null)", (boolean)color.equals(null));
        Assert.assertFalse((String)"!color.equals((Color)null)", (boolean)color.equals(null));
        Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
        Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColor));
        color = new Color((Device)this.display, 1, 2, 3, 0);
        sameColor = new Color((Device)this.display, 1, 2, 3, 0);
        sameColor2 = new Color((Device)this.display, new RGB(1, 2, 3), 0);
        otherColor = new Color((Device)this.display, 5, 6, 7, 0);
        Assert.assertFalse((String)"!color.equals((Object)null)", (boolean)color.equals(null));
        Assert.assertFalse((String)"!color.equals((Color)null)", (boolean)color.equals(null));
        Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
        Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColor));
    }

    @Test
    public void test_equalsLjava_lang_Object_mix() {
        Color color = new Color((Device)this.display, 1, 2, 3);
        Color sameColorNoDevice = new Color(1, 2, 3);
        Color otherColorNoDevice = new Color(5, 6, 7);
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColorNoDevice));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColorNoDevice));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)sameColorNoDevice.equals((Object)color));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)otherColorNoDevice.equals((Object)color));
        color = new Color((Device)this.display, 1, 2, 3, 0);
        sameColorNoDevice = new Color(1, 2, 3, 0);
        otherColorNoDevice = new Color(5, 6, 7, 0);
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColorNoDevice));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)color.equals((Object)otherColorNoDevice));
        Assert.assertTrue((String)"color.equals(sameColor)", (boolean)sameColorNoDevice.equals((Object)color));
        Assert.assertFalse((String)"!color.equals(otherColor)", (boolean)otherColorNoDevice.equals((Object)color));
    }

    @Test
    public void test_getBlue() {
        Color color = new Color(0, 0, 255);
        Assert.assertEquals((String)"color.getBlue()", (long)color.getBlue(), (long)255L);
    }

    @Test
    public void test_getBlue_with_device() {
        Color color = new Color((Device)this.display, 0, 0, 255);
        Assert.assertEquals((String)"color.getBlue()", (long)color.getBlue(), (long)255L);
    }

    @Test
    public void test_getGreen() {
        Color color = new Color(0, 255, 0);
        Assert.assertEquals((String)"color.getGreen()", (long)color.getGreen(), (long)255L);
    }

    @Test
    public void test_getGreen_with_device() {
        Color color = new Color((Device)this.display, 0, 255, 0);
        Assert.assertEquals((String)"color.getGreen()", (long)color.getGreen(), (long)255L);
    }

    @Test
    public void test_getRGB() {
        Color color = new Color(255, 255, 255);
        Assert.assertNotNull((Object)color.getRGB());
        Assert.assertEquals((Object)new RGB(255, 255, 255), (Object)color.getRGB());
    }

    @Test
    public void test_getRGB_with_device() {
        Color color = new Color((Device)this.display, 255, 255, 255);
        Assert.assertNotNull((Object)color.getRGB());
        Assert.assertEquals((Object)new RGB(255, 255, 255), (Object)color.getRGB());
    }

    @Test
    public void test_getRed() {
        Color color = new Color(255, 0, 0);
        Assert.assertEquals((String)"color.getRed()", (long)color.getRed(), (long)255L);
    }

    @Test
    public void test_getRed_with_device() {
        Color color = new Color((Device)this.display, 255, 0, 0);
        Assert.assertEquals((String)"color.getRed()", (long)color.getRed(), (long)255L);
    }

    @Test
    public void test_getAlpha() {
        Color color = new Color(255, 0, 0, 0);
        Assert.assertEquals((String)"color.getAlpha()", (long)color.getAlpha(), (long)0L);
    }

    @Test
    public void test_getAlpha_with_device() {
        Color color = new Color((Device)this.display, 255, 0, 0, 0);
        Assert.assertEquals((String)"color.getAlpha()", (long)color.getAlpha(), (long)0L);
    }

    @Test
    public void test_hashCode() {
        Color color = new Color(12, 34, 56, 0);
        Color otherColor = new Color(12, 34, 56, 0);
        if (color.equals((Object)otherColor)) {
            Assert.assertEquals((String)"Hash codes of equal objects should be equal", (long)color.hashCode(), (long)otherColor.hashCode());
        }
    }

    @Test
    public void test_hashCode_with_device() {
        Color color = new Color((Device)this.display, 12, 34, 56, 0);
        Color otherColor = new Color((Device)this.display, 12, 34, 56, 0);
        if (color.equals((Object)otherColor)) {
            Assert.assertEquals((String)"Hash codes of equal objects should be equal", (long)color.hashCode(), (long)otherColor.hashCode());
        }
    }

    @Test
    public void test_isDisposed() {
        Color color = new Color(34, 67, 98, 0);
        Assert.assertFalse((String)"Color should not be disposed", (boolean)color.isDisposed());
        color.dispose();
        Assert.assertTrue((String)"Color should be disposed", (boolean)color.isDisposed());
    }

    @Test
    public void test_isDisposed_with_device() {
        Color color = new Color((Device)this.display, 34, 67, 98, 0);
        Assert.assertFalse((String)"Color should not be disposed", (boolean)color.isDisposed());
        color.dispose();
        Assert.assertTrue((String)"Color should be disposed", (boolean)color.isDisposed());
    }

    @Test
    public void test_toString() {
        Color color = new Color(0, 0, 255, 255);
        Assert.assertNotNull((Object)color.toString());
        Assert.assertFalse((boolean)color.toString().isEmpty());
        Assert.assertEquals((Object)"Color {0, 0, 255, 255}", (Object)color.toString());
    }

    @Test
    public void test_toString_with_device() {
        Color color = new Color((Device)this.display, 0, 0, 255, 255);
        Assert.assertNotNull((Object)color.toString());
        Assert.assertFalse((boolean)color.toString().isEmpty());
        Assert.assertEquals((Object)"Color {0, 0, 255, 255}", (Object)color.toString());
    }

    @Test
    public void test_getDevice() {
        Color color = new Color(0, 0, 255, 255);
        Device device = color.getDevice();
        Assert.assertEquals((String)"The existing display should have been returned", (Object)this.display, (Object)device);
        SWTException e = (SWTException)Assert.assertThrows((String)"No exception thrown for getDevice on disposed Color", SWTException.class, () -> {
            Color color1 = new Color(0, 0, 255, 255);
            color1.dispose();
            color1.getDevice();
        });
        Assert.assertEquals((String)"Color should have thrown device disposed on getDevice", (long)44L, (long)e.code);
    }

    @Test
    public void test_getDevice_with_device() {
        Color color = new Color((Device)this.display, 0, 0, 255, 255);
        Assert.assertEquals((String)"Color should return device as constructed", (Object)this.display, (Object)color.getDevice());
        SWTException e = (SWTException)Assert.assertThrows((String)"No exception thrown for getDevice on disposed Color", SWTException.class, () -> {
            Color color1 = new Color(0, 0, 255, 255);
            color1.dispose();
            color1.getDevice();
        });
        Assert.assertEquals((String)"Color should have thrown device disposed on getDevice", (long)44L, (long)e.code);
    }
}

