/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_Font {
    Display display;

    @BeforeEach
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device$Lorg_eclipse_swt_graphics_FontData() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Font font = new Font(null, new FontData[1]);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Font font = new Font((Device)this.display, null);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Font font = new Font((Device)this.display, new FontData[0]);
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FontData[] fontDataArray = new FontData[2];
            fontDataArray[1] = new FontData();
            Font font = new Font((Device)this.display, fontDataArray);
        }, (String)"null data element 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FontData[] fontDataArray = new FontData[2];
            fontDataArray[0] = new FontData();
            Font font = new Font((Device)this.display, fontDataArray);
        }, (String)"null data element 0");
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_FontData() {
        Font font = new Font((Device)this.display, new FontData("", 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData("bad-font", 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 0, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 100, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 1));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 2));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 3));
        font.dispose();
        try {
            font = new Font((Device)this.display, null);
            font.dispose();
            Assertions.fail((String)"No exception thrown for fontData == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            font = new Font((Device)this.display, new FontData(null, 10, 0));
            font.dispose();
            Assertions.fail((String)"No exception thrown for name == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, -10, 0));
            font.dispose();
            Assertions.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_lang_StringII() {
        Font font = new Font((Device)this.display, "", 10, 0);
        font.dispose();
        font = new Font((Device)this.display, "bad-font", 10, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 0, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 100, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 1);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 2);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 3);
        font.dispose();
        font = new Font(null, SwtTestUtil.testFontName, 10, 0);
        font.dispose();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Font font = new Font((Device)this.display, null, 10, 0);
        }, (String)"No exception thrown for name == null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Font font = new Font((Device)this.display, SwtTestUtil.testFontName, -10, 0);
        }, (String)"No exception thrown for height < 0");
    }

    @Test
    public void test_dispose() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assertions.assertFalse((boolean)font.isDisposed());
        font.dispose();
        Assertions.assertTrue((boolean)font.isDisposed());
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Font otherFont = new Font((Device)this.display, SwtTestUtil.testFontName, 20, 0);
        try {
            Assertions.assertFalse((boolean)font.equals(null), (String)"!font.equals((Object)null)");
            Assertions.assertFalse((boolean)font.equals(null), (String)"!font.equals((Font)null)");
            Assertions.assertTrue((boolean)font.equals((Object)font), (String)"font.equals(font)");
            Assertions.assertFalse((boolean)font.equals((Object)otherFont), (String)"!font.equals(otherFont)");
        }
        finally {
            font.dispose();
            otherFont.dispose();
        }
    }

    @Test
    public void test_getFontData() {
        FontData[] fontData;
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        try {
            fontData = font.getFontData();
            Assertions.assertTrue((fontData != null && fontData.length > 0 ? 1 : 0) != 0, (String)"No font data");
            Assertions.assertEquals((Object)SwtTestUtil.testFontName, (Object)fontData[0].getName(), (String)"Wrong font name");
            Assertions.assertEquals((int)10, (int)fontData[0].getHeight(), (String)"Wrong font height");
            Assertions.assertEquals((int)0, (int)fontData[0].getStyle(), (String)"Wrong font style");
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 20, 1);
        try {
            fontData = font.getFontData();
            Assertions.assertTrue((fontData != null && fontData.length > 0 ? 1 : 0) != 0, (String)"No font data");
            Assertions.assertEquals((Object)SwtTestUtil.testFontName, (Object)fontData[0].getName(), (String)"Wrong font name");
            Assertions.assertEquals((int)20, (int)fontData[0].getHeight(), (String)"Wrong font height");
            Assertions.assertEquals((int)1, (int)fontData[0].getStyle(), (String)"Wrong font style");
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 30, 2);
        try {
            fontData = font.getFontData();
            Assertions.assertTrue((fontData != null && fontData.length > 0 ? 1 : 0) != 0, (String)"No font data");
            Assertions.assertEquals((int)30, (int)fontData[0].getHeight(), (String)"Wrong font height");
            Assertions.assertEquals((int)2, (int)fontData[0].getStyle(), (String)"Wrong font style");
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 40, 3);
        try {
            fontData = font.getFontData();
            font.dispose();
            Assertions.assertTrue((fontData != null && fontData.length > 0 ? 1 : 0) != 0, (String)"No font data");
            Assertions.assertEquals((int)40, (int)fontData[0].getHeight(), (String)"Wrong font height");
            Assertions.assertEquals((int)3, (int)fontData[0].getStyle(), (String)"Wrong font style");
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, "bad-font", 10, 0);
        try {
            fontData = font.getFontData();
            Assertions.assertTrue((fontData != null && fontData.length > 0 ? 1 : 0) != 0, (String)"No font data");
            Assertions.assertEquals((int)10, (int)fontData[0].getHeight(), (String)"No font data");
            Assertions.assertEquals((int)0, (int)fontData[0].getStyle(), (String)"Wrong font style");
        }
        finally {
            font.dispose();
        }
    }

    @Test
    public void test_hashCode() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assertions.assertEquals((Object)font, (Object)font);
        Assertions.assertEquals((int)font.hashCode(), (int)font.hashCode());
        Font boldFont = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 1);
        Assertions.assertNotEquals((int)boldFont.hashCode(), (int)font.hashCode());
        boldFont.dispose();
        font.dispose();
    }

    @Test
    public void test_isDisposed() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        try {
            Assertions.assertFalse((boolean)font.isDisposed(), (String)"Font should not be disposed");
        }
        finally {
            font.dispose();
            Assertions.assertTrue((boolean)font.isDisposed(), (String)"Font should be disposed");
        }
    }

    @Test
    public void test_toString() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assertions.assertNotNull((Object)font.toString());
        font.dispose();
        Assertions.assertNotNull((Object)font.toString());
    }
}

