/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.Locale;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_FontData {
    @Test
    public void test_Constructor() {
        new FontData();
    }

    @Test
    public void test_ConstructorLjava_lang_String() {
        FontData fd = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData reconstructedFontData = new FontData(fd.toString());
        Assertions.assertEquals((Object)fd, (Object)reconstructedFontData);
        Assertions.assertEquals((int)fd.hashCode(), (int)reconstructedFontData.hashCode());
    }

    @Test
    public void test_ConstructorLjava_lang_StringII() {
        new FontData("", 10, 0);
        new FontData("bad-font", 10, 0);
        new FontData(SwtTestUtil.testFontName, 0, 0);
        new FontData(SwtTestUtil.testFontName, 10, 0);
        new FontData(SwtTestUtil.testFontName, 10, 1);
        new FontData(SwtTestUtil.testFontName, 10, 2);
        new FontData(SwtTestUtil.testFontName, 10, 3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FontData fontData = new FontData(null, 10, 0);
        }, (String)"No exception thrown for name == null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FontData fontData = new FontData(SwtTestUtil.testFontName, -10, 0);
        }, (String)"No exception thrown for height < 0");
    }

    @Test
    public void test_ConstructorLjava_lang_FontData() {
        FontData fd = new FontData(SwtTestUtil.testFontName, 30, 2);
        FontData reconstructedFontDataFromCopyConstructor = new FontData(fd);
        Assertions.assertEquals((Object)fd, (Object)reconstructedFontDataFromCopyConstructor);
        Assertions.assertEquals((int)fd.hashCode(), (int)reconstructedFontDataFromCopyConstructor.hashCode());
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        FontData fd1 = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData fd2 = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assertions.assertEquals((Object)fd1, (Object)fd1);
        Assertions.assertEquals((Object)fd1, (Object)fd2);
    }

    @Test
    public void test_hashCode() {
        FontData fd1 = new FontData(SwtTestUtil.testFontName, 10, 0);
        FontData fd2 = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assertions.assertEquals((Object)fd1, (Object)fd2);
        Assertions.assertEquals((int)fd1.hashCode(), (int)fd2.hashCode());
        FontData fd3 = new FontData(SwtTestUtil.testFontName, 10, 1);
        Assertions.assertNotEquals((int)fd3.hashCode(), (int)fd1.hashCode());
    }

    @Test
    public void test_setHeightI() {
        FontData fontData = new FontData(SwtTestUtil.testFontName, 10, 0);
        int height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assertions.assertEquals((int)fontData.getHeight(), (int)height, (String)"Wrong height");
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 1);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assertions.assertEquals((int)fontData.getHeight(), (int)height, (String)"Wrong height");
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 2);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assertions.assertEquals((int)fontData.getHeight(), (int)height, (String)"Wrong height");
            ++height;
        }
        fontData = new FontData(SwtTestUtil.testFontName, 10, 3);
        height = 0;
        while (height < 1000) {
            fontData.setHeight(height);
            Assertions.assertEquals((int)fontData.getHeight(), (int)height, (String)"Wrong height");
            ++height;
        }
    }

    @Test
    public void test_setLocaleLjava_lang_String() {
        FontData fd = new FontData(SwtTestUtil.testFontName, 10, 0);
        Locale locale = Locale.ENGLISH;
        fd.setLocale(locale.toString());
        Assertions.assertEquals((Object)Locale.ENGLISH.toString(), (Object)fd.getLocale());
    }

    @Test
    public void test_setNameLjava_lang_String() {
        FontData fontData = new FontData(SwtTestUtil.testFontName, 10, 0);
        Assertions.assertEquals((Object)fontData.getName(), (Object)SwtTestUtil.testFontName);
        fontData.setName("bad-font");
        Assertions.assertEquals((Object)fontData.getName(), (Object)"bad-font");
        if (SwtTestUtil.isWindows) {
            fontData.setName("");
            Assertions.assertEquals((Object)fontData.getName(), (Object)"");
        }
        fontData.setName(SwtTestUtil.testFontName);
        Assertions.assertEquals((Object)fontData.getName(), (Object)SwtTestUtil.testFontName);
        Assertions.assertThrows(IllegalArgumentException.class, () -> fontData.setName(null), (String)"No exception thrown for name == null");
    }

    @Test
    public void test_setStyleI() {
        int height = 0;
        while (height < 1000) {
            FontData fontData = new FontData(SwtTestUtil.testFontName, height, 0);
            Assertions.assertEquals((int)fontData.getStyle(), (int)0, (String)"Wrong style");
            fontData.setStyle(1);
            Assertions.assertEquals((int)fontData.getStyle(), (int)1, (String)"Wrong style");
            fontData.setStyle(2);
            Assertions.assertEquals((int)fontData.getStyle(), (int)2, (String)"Wrong style");
            fontData.setStyle(3);
            Assertions.assertEquals((int)fontData.getStyle(), (int)3, (String)"Wrong style");
            fontData.setStyle(0);
            Assertions.assertEquals((int)fontData.getStyle(), (int)0, (String)"Wrong style");
            ++height;
        }
    }

    @Test
    public void test_toString() {
        FontData data = new FontData();
        Assertions.assertNotNull((Object)data.toString());
        Assertions.assertTrue((data.toString().length() > 0 ? 1 : 0) != 0);
    }
}

