/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_GC {
    Display display;
    Shell shell;
    Image image;
    GC gc;

    @BeforeEach
    public void setUp() {
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
        this.shell.setBounds(0, 30, 240, 290);
        this.image = new Image((Device)this.display, 200, 200);
        this.gc = new GC((Drawable)this.image);
    }

    @AfterEach
    public void tearDown() {
        this.gc.dispose();
        this.image.dispose();
        this.shell.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Drawable() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            GC gC = new GC(null);
        }, (String)"No exception thrown for drawable == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for drawable == null", 4, e);
        IllegalArgumentException e1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Image image = null;
            GC gc1 = null;
            GC gc2 = null;
            try {
                image = new Image((Device)this.display, 10, 10);
                gc1 = new GC((Drawable)image);
                gc2 = new GC((Drawable)image);
            }
            finally {
                if (image != null) {
                    image.dispose();
                }
                if (gc1 != null) {
                    gc1.dispose();
                }
                if (gc2 != null) {
                    gc2.dispose();
                }
            }
        }, (String)"No exception thrown for more than one GC on one image");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for more than one GC on one image", 5, e1);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DrawableI() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            GC gC = new GC(null, 0x2000000);
        }, (String)"No exception thrown for drawable == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for drawable == null", 4, e);
        IllegalArgumentException e1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Image image = null;
            Object gc1 = null;
            Object gc2 = null;
            try {
                image = new Image((Device)this.display, 10, 10);
                new GC((Drawable)image, 0x4000000);
                new GC((Drawable)image, 0x2000000);
            }
            finally {
                if (image != null) {
                    image.dispose();
                }
                if (gc1 != null) {
                    gc1.dispose();
                }
                if (gc2 != null) {
                    gc2.dispose();
                }
            }
        }, (String)"No exception thrown for more than one GC on one image");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for more than one GC on one image", 5, e1);
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas, 0x4000000);
        testGC.dispose();
        testGC = new GC((Drawable)canvas, 0x2000000);
        testGC.dispose();
        canvas.dispose();
    }

    @Test
    public void test_copyAreaIIIIII() {
        Assumptions.assumeTrue((DPIUtil.getDeviceZoom() == 100 ? 1 : 0) != 0, (String)"Skipping test due to non-100% zoom");
        Color white = this.display.getSystemColor(1);
        Color blue = this.display.getSystemColor(9);
        RGB whiteRGB = this.getRealRGB(white);
        RGB blueRGB = this.getRealRGB(blue);
        int width = 20;
        int height = 20;
        int destX = 10;
        int destY = 50;
        this.gc.setBackground(white);
        this.gc.fillRectangle(this.image.getBounds());
        this.gc.setBackground(blue);
        this.gc.fillRectangle(5, 0, 6, 1);
        this.gc.copyArea(0, 0, width, height, destX, destY);
        ImageData imageData = this.image.getImageData();
        PaletteData palette = imageData.palette;
        int pixel = imageData.getPixel(destX + 4, destY);
        Assertions.assertEquals((Object)whiteRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 6, destY);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 10, destY);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(destX + 12, destY);
        Assertions.assertEquals((Object)whiteRGB, (Object)palette.getRGB(pixel));
    }

    @Test
    public void test_copyAreaIIIIII_overlapingSourceTarget() {
        Assumptions.assumeTrue((DPIUtil.getDeviceZoom() == 100 ? 1 : 0) != 0, (String)"Skipping test due to non-100% zoom");
        Color red = this.display.getSystemColor(3);
        Color blue = this.display.getSystemColor(9);
        RGB redRGB = this.getRealRGB(red);
        RGB blueRGB = this.getRealRGB(blue);
        this.gc.setBackground(red);
        this.gc.fillRectangle(this.image.getBounds());
        this.gc.setBackground(blue);
        this.gc.fillRectangle(0, 100, 200, 100);
        ImageData imageData = this.image.getImageData();
        PaletteData palette = imageData.palette;
        int pixel = imageData.getPixel(0, 0);
        Assertions.assertEquals((Object)redRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(0, 105);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(0, 155);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        this.gc.copyArea(0, 50, 200, 100, 0, 100);
        imageData = this.image.getImageData();
        palette = imageData.palette;
        pixel = imageData.getPixel(0, 105);
        Assertions.assertEquals((Object)redRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(0, 145);
        Assertions.assertEquals((Object)redRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(0, 155);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(0, 195);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
    }

    @Test
    public void test_copyAreaLorg_eclipse_swt_graphics_ImageII() {
        Assumptions.assumeTrue((DPIUtil.getDeviceZoom() == 100 ? 1 : 0) != 0, (String)"Skipping test due to non-100% zoom");
        Color white = this.display.getSystemColor(1);
        Color blue = this.display.getSystemColor(9);
        RGB whiteRGB = this.getRealRGB(white);
        RGB blueRGB = this.getRealRGB(blue);
        this.gc.setBackground(white);
        this.gc.fillRectangle(this.image.getBounds());
        this.gc.setBackground(blue);
        this.gc.fillRectangle(5, 0, 6, 1);
        Image image = new Image((Device)this.display, 12, 12);
        this.gc.copyArea(image, 0, 0);
        ImageData imageData = image.getImageData();
        PaletteData palette = imageData.palette;
        int pixel = imageData.getPixel(4, 0);
        Assertions.assertEquals((Object)whiteRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(5, 0);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(10, 0);
        Assertions.assertEquals((Object)blueRGB, (Object)palette.getRGB(pixel));
        pixel = imageData.getPixel(11, 0);
        Assertions.assertEquals((Object)whiteRGB, (Object)palette.getRGB(pixel));
        image.dispose();
    }

    @Test
    public void test_dispose() {
        this.gc.dispose();
    }

    @Test
    public void test_drawArcIIIIII() {
        this.gc.drawArc(10, 20, 50, 25, 90, 90);
    }

    @Test
    public void test_drawFocusIIII() {
        this.gc.drawFocus(1, 1, 50, 25);
    }

    @Test
    public void test_drawImageLorg_eclipse_swt_graphics_ImageII() {
        Color c1 = new Color(255, 0, 0);
        Color c2 = new Color(0, 0, 0);
        Color c3 = new Color(255, 255, 0);
        PaletteData paletteData = new PaletteData(new RGB[]{c1.getRGB(), c2.getRGB(), c3.getRGB()});
        ImageData data = new ImageData(30, 30, 8, paletteData);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (x > y) {
                    data.setPixel(x, y, paletteData.getPixel(c1.getRGB()));
                } else if (x < y) {
                    data.setPixel(x, y, paletteData.getPixel(c2.getRGB()));
                } else {
                    data.setPixel(x, y, paletteData.getPixel(c3.getRGB()));
                }
                ++x;
            }
            ++y;
        }
        Image image = new Image((Device)this.display, data);
        data = image.getImageData();
        data.transparentPixel = paletteData.getPixel(c1.getRGB());
        Image imageTransparent = new Image((Device)this.display, data);
        data.transparentPixel = -1;
        int y2 = 0;
        while (y2 < data.height) {
            int x = 0;
            while (x < data.width) {
                data.setAlpha(x, y2, 127);
                ++x;
            }
            ++y2;
        }
        Image imageAlpha = new Image((Device)this.display, data);
        this.gc.drawImage(image, 100, 100);
        this.gc.drawImage(imageTransparent, 130, 100);
        this.gc.drawImage(imageAlpha, 160, 100);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.drawImage(null, 100, 100));
        image.dispose();
        imageTransparent.dispose();
        imageAlpha.dispose();
    }

    @Test
    public void test_drawImageLorg_eclipse_swt_graphics_ImageIIIIIIII() {
        Color c1 = new Color(255, 0, 0);
        Color c2 = new Color(0, 0, 0);
        Color c3 = new Color(255, 255, 0);
        PaletteData paletteData = new PaletteData(new RGB[]{c1.getRGB(), c2.getRGB(), c3.getRGB()});
        ImageData data = new ImageData(30, 30, 8, paletteData);
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                if (x > y) {
                    data.setPixel(x, y, paletteData.getPixel(c1.getRGB()));
                } else if (x < y) {
                    data.setPixel(x, y, paletteData.getPixel(c2.getRGB()));
                } else {
                    data.setPixel(x, y, paletteData.getPixel(c3.getRGB()));
                }
                ++x;
            }
            ++y;
        }
        Image image = new Image((Device)this.display, data);
        data = image.getImageData();
        data.transparentPixel = paletteData.getPixel(c1.getRGB());
        Image imageTransparent = new Image((Device)this.display, data);
        data.transparentPixel = -1;
        int y2 = 0;
        while (y2 < data.height) {
            int x = 0;
            while (x < data.width) {
                data.setAlpha(x, y2, 127);
                ++x;
            }
            ++y2;
        }
        Image imageAlpha = new Image((Device)this.display, data);
        this.gc.drawImage(image, 10, 5, 20, 15, 100, 120, 50, 60);
        this.gc.drawImage(imageTransparent, 10, 5, 20, 15, 100, 120, 10, 10);
        this.gc.drawImage(imageAlpha, 10, 5, 20, 15, 100, 120, 20, 15);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.drawImage(null, 10, 5, 20, 15, 100, 120, 50, 60));
        image.dispose();
        imageAlpha.dispose();
        imageTransparent.dispose();
    }

    @Test
    public void test_drawLineIIII() {
        this.gc.drawLine(0, 0, 0, 20);
    }

    @Test
    public void test_drawOvalIIII() {
        this.gc.drawOval(10, 0, 20, 30);
    }

    @Test
    public void test_drawPointII() {
        this.gc.drawPoint(10, 10);
    }

    @Test
    public void test_drawPolygon$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.drawPolygon(nArray);
        this.gc.drawPolygon(new int[2]);
    }

    @Test
    public void test_drawPolyline$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.drawPolyline(nArray);
        this.gc.drawPolyline(new int[2]);
    }

    @Test
    public void test_drawRectangleIIII() {
        this.gc.drawRectangle(10, 0, 20, 30);
        this.gc.drawRectangle(0, 0, 0, 0);
    }

    @Test
    public void test_drawRectangleLorg_eclipse_swt_graphics_Rectangle() {
        this.gc.drawRectangle(new Rectangle(10, 0, 20, 30));
        this.gc.drawRectangle(new Rectangle(0, 0, 0, 0));
    }

    @Test
    public void test_drawRoundRectangleIIIIII() {
        this.gc.drawRoundRectangle(10, 0, 20, 30, 3, 3);
        this.gc.drawRoundRectangle(0, 0, 0, 0, 0, 0);
    }

    @Test
    public void test_drawStringLjava_lang_StringII() {
        this.gc.drawString("test", 5, 5);
    }

    @Test
    public void test_drawStringLjava_lang_StringIIZ() {
        this.gc.drawString("test", 5, 5, true);
        this.gc.drawString("test", 5, 5, false);
    }

    @Test
    public void test_drawTextLjava_lang_StringII() {
        this.gc.drawText("test", 5, 5);
        this.gc.drawText("", 0, 0);
    }

    @Test
    public void test_drawTextLjava_lang_StringIII() {
        this.gc.drawText("abc", 5, 5, 0);
        this.gc.drawText("abc", 5, 5, 1);
        this.gc.drawText("abc", 5, 5, 2);
        this.gc.drawText("abc", 5, 5, 8);
        this.gc.drawText("abc", 5, 5, 4);
        this.gc.drawText("", 0, 0, 0);
        this.gc.drawText("", 0, 0, 1);
        this.gc.drawText("", 0, 0, 2);
        this.gc.drawText("", 0, 0, 8);
        this.gc.drawText("", 0, 0, 4);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 0);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 1);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 2);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 8);
        this.gc.drawText("\t\r\na&bc&", 5, 5, 4);
        this.gc.drawText("\r", 5, 5, 2);
        this.gc.drawText("\n", 5, 5, 2);
        this.gc.drawText("&", 5, 5, 8);
        this.gc.drawText("\t", 5, 5, 4);
    }

    @Test
    public void test_drawTextLjava_lang_StringIIZ() {
        this.gc.drawText("abc", 5, 5, true);
        this.gc.drawText("abc", 5, 5, false);
        this.gc.drawText("", 0, 0, true);
        this.gc.drawText("", 0, 0, false);
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Assertions.assertTrue((boolean)this.gc.equals((Object)this.gc));
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas);
        Assertions.assertFalse((boolean)testGC.equals((Object)this.gc));
        testGC.dispose();
    }

    @Test
    public void test_fillArcIIIIII() {
        this.gc.fillArc(10, 20, 50, 25, 90, 90);
        this.gc.fillArc(10, 20, 50, 25, -10, -10);
    }

    @Test
    public void test_fillGradientRectangleIIIIZ() {
        this.gc.fillGradientRectangle(10, 0, 20, 30, true);
        this.gc.fillGradientRectangle(0, 0, 0, 0, true);
        this.gc.fillGradientRectangle(10, 0, 20, 30, false);
        this.gc.fillGradientRectangle(0, 0, 0, 0, false);
    }

    @Test
    public void test_fillOvalIIII() {
        this.gc.fillOval(10, 0, 20, 30);
        this.gc.fillOval(-1, -1, -1, -1);
    }

    @Test
    public void test_fillPolygon$I() {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[5] = 20;
        this.gc.fillPolygon(nArray);
        this.gc.fillPolygon(new int[2]);
        this.gc.fillPolygon(new int[]{-1, -1});
    }

    @Test
    public void test_fillRectangleIIII() {
        this.gc.fillRectangle(new Rectangle(10, 0, 20, 30));
        this.gc.fillRectangle(new Rectangle(0, 0, 0, 0));
        this.gc.fillRectangle(new Rectangle(-1, -1, -1, -1));
    }

    @Test
    public void test_fillRectangleLorg_eclipse_swt_graphics_Rectangle() {
        this.gc.fillRectangle(10, 0, 20, 30);
        this.gc.fillRectangle(0, 0, 0, 0);
    }

    @Test
    public void test_fillRoundRectangleIIIIII() {
        this.gc.fillRoundRectangle(10, 0, 20, 30, 3, 3);
        this.gc.fillRoundRectangle(0, 0, 0, 0, 0, 0);
        this.gc.fillRoundRectangle(10, 0, 20, 30, -10, -10);
    }

    @Test
    public void test_getAdvanceWidthC() {
        int w = this.gc.getAdvanceWidth('a');
        Assertions.assertTrue((w > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getCharWidthC() {
        int w = this.gc.getCharWidth('a');
        Assertions.assertTrue((w > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getFontMetrics() {
        FontMetrics fm = this.gc.getFontMetrics();
        Assertions.assertTrue((fm.getHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getStyle() {
        Canvas canvas = new Canvas((Composite)this.shell, 0);
        GC testGC = new GC((Drawable)canvas, 0x2000000);
        int style = testGC.getStyle();
        Assertions.assertNotEquals((int)0, (int)(style & 0x2000000));
        testGC.dispose();
        testGC = new GC((Drawable)canvas);
        style = testGC.getStyle();
        Assertions.assertNotEquals((int)0, (int)(style & 0x2000000));
        testGC.dispose();
        testGC = new GC((Drawable)canvas, 0x4000000);
        style = testGC.getStyle();
        Assertions.assertNotEquals((int)0, (int)(style & 0x4000000));
        testGC.dispose();
    }

    @Test
    public void test_hashCode() {
        Assertions.assertEquals((int)this.gc.hashCode(), (int)this.gc.hashCode());
        GC gc2 = new GC((Drawable)this.shell);
        Assertions.assertNotEquals((int)gc2.hashCode(), (int)this.gc.hashCode());
        gc2.dispose();
    }

    @Test
    public void test_isClipped() {
        Assertions.assertFalse((boolean)this.gc.isClipped());
        this.gc.setClipping(5, 10, 15, 20);
        Assertions.assertTrue((boolean)this.gc.isClipped());
    }

    @Test
    public void test_isDisposed() {
        Assertions.assertFalse((boolean)this.gc.isDisposed());
        this.gc.dispose();
        Assertions.assertTrue((boolean)this.gc.isDisposed());
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color(255, 0, 0);
        this.gc.setBackground(color);
        Assertions.assertEquals((Object)color, (Object)this.gc.getBackground());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.setBackground(null), (String)"No exception thrown for null color");
        Assertions.assertEquals((Object)this.gc.getBackground(), (Object)this.gc.getBackground());
        color.dispose();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.setBackground(color), (String)"No exception thrown for color disposed");
    }

    @Test
    public void test_setClippingIIII() {
    }

    @Test
    public void test_setClippingLorg_eclipse_swt_graphics_Rectangle() {
    }

    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        this.gc.setFont(null);
        Assertions.assertEquals((Object)this.shell.getDisplay().getSystemFont(), (Object)this.gc.getFont());
        this.gc.setFont(this.shell.getDisplay().getSystemFont());
        Font font = this.gc.getFont();
        Assertions.assertEquals((Object)this.shell.getDisplay().getSystemFont(), (Object)font);
    }

    @Test
    public void test_setForegroundLorg_eclipse_swt_graphics_Color() {
        Color color = new Color(255, 0, 0);
        this.gc.setForeground(color);
        Assertions.assertEquals((Object)color, (Object)this.gc.getForeground());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.setForeground(null), (String)"No exception thrown for null color");
        Assertions.assertEquals((Object)this.gc.getForeground(), (Object)this.gc.getForeground());
        color.dispose();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.gc.setForeground(color), (String)"No exception thrown for color disposed");
    }

    @Test
    public void test_setLineAttributes$I() {
        int width = 1;
        int cap = 3;
        int join = 2;
        int style = 6;
        float[] dashes = new float[]{1.2f, 3.3f};
        float dashOffset = 3.3f;
        float miterLimit = 2.6f;
        LineAttributes passedLineAttributes = new LineAttributes((float)width, cap, join, style, dashes, dashOffset, miterLimit);
        this.gc.setLineAttributes(passedLineAttributes);
        Assertions.assertEquals((int)width, (int)this.gc.getLineWidth(), (String)"unexpected line width");
        Assertions.assertEquals((int)cap, (int)this.gc.getLineCap(), (String)"unexpected line cap");
        Assertions.assertEquals((int)join, (int)this.gc.getLineJoin(), (String)"unexpected line join");
        Assertions.assertEquals((int)style, (int)this.gc.getLineStyle(), (String)"unexpected line style");
        Assertions.assertEquals((Object)new LineAttributes((float)width, cap, join, style, dashes, dashOffset, miterLimit), (Object)this.gc.getLineAttributes(), (String)"actual line attributes differ from the ones that have been set");
        Assertions.assertEquals((float)width, (float)passedLineAttributes.width, (float)0.0f, (String)"setter call changed line width");
        this.gc.setLineAttributes(new LineAttributes(1.0f));
        Assertions.assertEquals((Object)new LineAttributes(1.0f), (Object)this.gc.getLineAttributes());
    }

    @Test
    public void test_setLineAttributes$I_withDeviceScaling() {
        this.executeWithNonDefaultDeviceZoom(() -> this.test_setLineAttributes$I());
    }

    @Test
    public void test_setLineStyleI() {
        this.gc.setLineStyle(1);
        Assertions.assertEquals((int)1, (int)this.gc.getLineStyle());
        this.gc.setLineStyle(2);
        Assertions.assertEquals((int)2, (int)this.gc.getLineStyle());
        this.gc.setLineStyle(3);
        Assertions.assertEquals((int)3, (int)this.gc.getLineStyle());
        this.gc.setLineStyle(4);
        Assertions.assertEquals((int)4, (int)this.gc.getLineStyle());
        this.gc.setLineStyle(5);
        Assertions.assertEquals((int)5, (int)this.gc.getLineStyle());
    }

    @Test
    public void test_setLineWidthI() {
        this.gc.setLineWidth(10);
        Assertions.assertEquals((int)10, (int)this.gc.getLineWidth());
        this.gc.setLineWidth(0);
        Assertions.assertEquals((int)0, (int)this.gc.getLineWidth());
    }

    @Test
    public void test_setLineWidthI_withDeviceScaling() {
        this.executeWithNonDefaultDeviceZoom(this::test_setLineWidthI);
    }

    @Test
    public void test_setLineDash$I() {
        int[] dashes = new int[]{5, 1, 3};
        this.gc.setLineDash(dashes);
        Assertions.assertArrayEquals((int[])dashes, (int[])this.gc.getLineDash());
        this.gc.setLineDash(null);
        Assertions.assertEquals(null, (Object)this.gc.getLineDash());
    }

    @Test
    public void test_setLineDash$I_withDeviceScaling() {
        this.executeWithNonDefaultDeviceZoom(this::test_setLineDash$I);
    }

    @Test
    public void test_setXORModeZ() {
        this.gc.setXORMode(true);
        Assertions.assertTrue((boolean)this.gc.getXORMode());
        this.gc.setXORMode(false);
        Assertions.assertFalse((boolean)this.gc.getXORMode());
    }

    @Test
    public void test_stringExtentLjava_lang_String() {
        Point pt = this.gc.stringExtent("abc");
        Assertions.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_textExtentLjava_lang_String() {
        Point pt = this.gc.textExtent("abc");
        Assertions.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_textExtentLjava_lang_StringI() {
        Point pt = this.gc.textExtent("abc", 0);
        Assertions.assertTrue((pt.x > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((pt.y > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_toString() {
        String s = this.gc.toString();
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_bug493455_drawImageAlpha_srcPos() {
        int j;
        Assumptions.assumeFalse((boolean)SwtTestUtil.isCocoa, (String)"https://github.com/eclipse-platform/eclipse.platform.swt/issues/40 causes test to fail on Mac");
        RGB red = new RGB(255, 0, 0);
        RGB green = new RGB(0, 255, 0);
        ImageData initImageData = new ImageData(200, 200, 32, new PaletteData(255, 65280, 0xFF0000));
        initImageData.alphaData = new byte[40000];
        Image srcImage = new Image((Device)this.display, initImageData);
        GC srcImageGc = new GC((Drawable)srcImage);
        srcImageGc.setAdvanced(true);
        srcImageGc.setBackground(new Color(red));
        srcImageGc.fillRectangle(0, 0, 200, 200);
        srcImageGc.setBackground(new Color(green));
        srcImageGc.fillRectangle(100, 50, 100, 150);
        srcImageGc.dispose();
        this.gc.drawImage(srcImage, 100, 50, 100, 150, 0, 0, 100, 150);
        ImageData srcImageData = srcImage.getImageData();
        srcImage.dispose();
        ImageData testImageData = this.image.getImageData();
        Assertions.assertNotNull((Object)srcImageData.alphaData);
        int i = 0;
        while (i < 200) {
            j = 0;
            while (j < 200) {
                RGB expected = i < 100 || j < 50 ? red : green;
                RGB actual = srcImageData.palette.getRGB(srcImageData.getPixel(i, j));
                Assertions.assertEquals((Object)expected, (Object)actual);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 100) {
            j = 0;
            while (j < 150) {
                RGB rgb = testImageData.palette.getRGB(testImageData.getPixel(i, j));
                Assertions.assertEquals((Object)green, (Object)rgb);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void test_drawLine_noSingularitiesIn45DregreeRotation() {
        int imageSize = 3;
        int centerPixel = imageSize / 2;
        Image image = new Image((Device)Display.getDefault(), imageSize, imageSize);
        GC gc = new GC((Drawable)image);
        Transform rotation = new Transform(gc.getDevice());
        gc.getTransform(rotation);
        try {
            rotation.translate((float)centerPixel, (float)centerPixel);
            rotation.rotate(45.0f);
            rotation.translate((float)(-centerPixel), (float)(-centerPixel));
            gc.setTransform(rotation);
            gc.drawLine(centerPixel, centerPixel, centerPixel + 1, centerPixel);
            MatcherAssert.assertThat((String)"line is not drawn with 45 degree rotation", (Object)image.getImageData().getPixel(centerPixel, centerPixel), (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
        }
        finally {
            rotation.dispose();
            gc.dispose();
            image.dispose();
        }
    }

    @Test
    public void test_bug1288_createGCFromImageFromNonDisplayThread() throws InterruptedException {
        AtomicReference exceptionReference = new AtomicReference();
        Thread thread = new Thread(() -> {
            try {
                Image image = new Image(null, 100, 100);
                GC gc = new GC((Drawable)image);
                gc.dispose();
                image.dispose();
            }
            catch (Exception e) {
                exceptionReference.set(e);
            }
        });
        thread.start();
        thread.join();
        Assertions.assertNull(exceptionReference.get(), (String)"Creating a GC from an Image without a device threw an exception");
    }

    RGB getRealRGB(Color color) {
        ImageGcDrawer gcDrawer = (imageGc, width, height) -> {
            imageGc.setBackground(color);
            imageGc.setForeground(color);
            imageGc.fillRectangle(0, 0, width, height);
        };
        Image colorImage = new Image((Device)this.display, gcDrawer, 10, 10);
        ImageData imageData = colorImage.getImageData();
        PaletteData palette = imageData.palette;
        colorImage.dispose();
        int pixel = imageData.getPixel(0, 0);
        return palette.getRGB(pixel);
    }

    private void executeWithNonDefaultDeviceZoom(Runnable executable) {
        int previousDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.setDeviceZoom((int)200);
        this.gc.dispose();
        this.gc = new GC((Drawable)this.image);
        try {
            executable.run();
        }
        finally {
            DPIUtil.setDeviceZoom((int)previousDeviceZoom);
        }
    }
}

