/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.tests.junit.ImageTestUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class Test_org_eclipse_swt_graphics_Image {
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();
    ImageFileNameProvider imageFileNameProvider = zoom -> {
        String fileName = switch (zoom) {
            case 100 -> "collapseall.png";
            case 150 -> "collapseall@1.5x.png";
            case 200 -> "collapseall@2x.png";
            default -> null;
        };
        return fileName != null ? Test_org_eclipse_swt_graphics_Image.getPath(fileName) : null;
    };
    ImageDataProvider imageDataProvider = zoom -> {
        String fileName = switch (zoom) {
            case 100 -> "collapseall.png";
            case 150 -> "collapseall@1.5x.png";
            case 200 -> "collapseall@2x.png";
            default -> null;
        };
        return fileName != null ? new ImageData(Test_org_eclipse_swt_graphics_Image.getPath(fileName)) : null;
    };
    ImageDataProvider imageDataProvider1xOnly = zoom -> {
        if (zoom == 100) {
            return new ImageData(Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png"));
        }
        return null;
    };
    ImageGcDrawer imageGcDrawer = (gc, width, height) -> {};
    Display display;

    private static String getPath(String fileName) {
        return SwtTestUtil.getPath(fileName, tempFolder).toString();
    }

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceII() {
        IllegalArgumentException e1 = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, -1, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width < 0", 5, e1);
        IllegalArgumentException e2 = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 0, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width == 0", 5, e2);
        IllegalArgumentException e3 = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 10, -20);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height < 0", 5, e3);
        IllegalArgumentException e4 = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 10, 0);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height == 0", 5, e4);
        Image image = new Image(null, 10, 10);
        image.dispose();
        image = new Image((Device)this.display, 10, 10);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle bounds1 = null;
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, bounds1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
        Rectangle bounds2 = new Rectangle(0, 0, -1, 10);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, bounds2);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width < 0", 5, e);
        Rectangle bounds3 = new Rectangle(0, 0, 0, 10);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, bounds3);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width == 0", 5, e);
        Rectangle bounds4 = new Rectangle(0, 0, 10, -1);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, bounds4);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height < 0", 5, e);
        Rectangle bounds5 = new Rectangle(0, 0, 10, 0);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, bounds5);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height == 0", 5, e);
        Rectangle bounds = new Rectangle(-1, -10, 10, 10);
        Image image = new Image((Device)this.display, bounds);
        image.dispose();
        bounds = new Rectangle(0, 0, 10, 10);
        image = new Image(null, bounds);
        image.dispose();
        image = new Image((Device)this.display, bounds);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_int_int() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, -1, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width < 0", 5, e);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 0, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for width == 0", 5, e);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 10, -1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height < 0", 5, e);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, 10, 0);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for height == 0", 5, e);
        Image image = new Image(null, 10, 10);
        image.dispose();
        image = new Image((Device)this.display, 10, 10);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_ImageData() {
        ImageData data1 = null;
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, data1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData == null", 4, e);
        ImageData data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        Image image = new Image(null, data);
        image.dispose();
        data = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, data);
        image.dispose();
        data = new ImageData(10, 10, 8, new PaletteData(48, 12, 3));
        data.setPixel(9, 9, 48);
        Image imageFromImageData = new Image((Device)this.display, data);
        ImageGcDrawer gcDrawer = (gc, width, height) -> gc.drawImage(imageFromImageData, 0, 0);
        Image gcImage = new Image((Device)this.display, gcDrawer, 10, 10);
        ImageData gcImageData = gcImage.getImageData();
        int redPixel = gcImageData.getPixel(9, 9);
        Assert.assertEquals((Object)this.getRealRGB(this.display.getSystemColor(3)), (Object)gcImageData.palette.getRGB(redPixel));
        gcImage.dispose();
        image.dispose();
        imageFromImageData.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_ImageDataLorg_eclipse_swt_graphics_ImageData() {
        ImageData data1 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, null, data1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source == null", 4, e);
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, data1, null);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData mask == null", 4, e);
        ImageData data2 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        ImageData data3 = new ImageData(1, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, data2, data3);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source width != ImageData mask width", 5, e);
        ImageData data4 = new ImageData(10, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        ImageData data5 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, data4, data5);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageData source height != ImageData mask height", 5, e);
        ImageData data6 = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        ImageData data7 = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        Image image = new Image((Device)this.display, data6, data7);
        image.dispose();
        data6 = new ImageData(10, 10, 8, new PaletteData(48, 12, 3));
        data6.setPixel(9, 9, 48);
        data7 = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        data7.setPixel(9, 9, 1);
        Image image2 = new Image((Device)this.display, data6, data7);
        Color backgroundColor = this.display.getSystemColor(9);
        ImageGcDrawer gcDrawer = (gc, width, height) -> {
            gc.setBackground(backgroundColor);
            gc.fillRectangle(0, 0, 10, 10);
            gc.drawImage(image2, 0, 0);
        };
        Image gcImage = new Image((Device)this.display, gcDrawer, 10, 10);
        ImageData gcImageData = gcImage.getImageData();
        int redPixel = gcImageData.getPixel(9, 9);
        Assert.assertEquals((Object)this.getRealRGB(this.display.getSystemColor(3)), (Object)gcImageData.palette.getRGB(redPixel));
        int bluePixel = gcImageData.getPixel(0, 0);
        Assert.assertEquals((Object)this.getRealRGB(backgroundColor), (Object)gcImageData.palette.getRGB(bluePixel));
        gcImage.dispose();
        image.dispose();
        image2.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_io_InputStream() throws IOException {
        int n;
        int n2;
        String[] stringArray;
        Object display;
        Display[] displays;
        InputStream stream1 = null;
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, stream1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for InputStream == null", 4, e);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream2 = SwtTestUtil.class.getResourceAsStream("empty.txt");){
            e = (Exception)Assert.assertThrows(SWTException.class, () -> {
                Image image = new Image((Device)this.display, stream2);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid InputStream", 42, e);
        String firstFile = SwtTestUtil.invalidImageFilenames[0];
        Display[] displayArray = new Display[2];
        displayArray[0] = this.display;
        Display[] displayArray2 = displays = displayArray;
        int n3 = displays.length;
        int n4 = 0;
        while (n4 < n3) {
            display = displayArray2[n4];
            stringArray = SwtTestUtil.imageFormats;
            n2 = SwtTestUtil.imageFormats.length;
            n = 0;
            while (n < n2) {
                String format = stringArray[n];
                Throwable throwable3 = null;
                Object var14_23 = null;
                try (InputStream stream = SwtTestUtil.class.getResourceAsStream(firstFile + "." + format);){
                    e = (Exception)Assert.assertThrows(SWTException.class, () -> Test_org_eclipse_swt_graphics_Image.lambda$26((Display)display, stream));
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image InputStream", 40, e);
                ++n;
            }
            ++n4;
        }
        display = null;
        Object var6_14 = null;
        try (InputStream stream = SwtTestUtil.class.getResourceAsStream(SwtTestUtil.invalidImageFilenames[1]);){
            e = (Exception)Assert.assertThrows(SWTException.class, () -> {
                Image image = new Image((Device)this.display, stream);
            });
        }
        catch (Throwable throwable5) {
            if (display == null) {
                display = throwable5;
            } else if (display != throwable5) {
                ((Throwable)display).addSuppressed(throwable5);
            }
            throw display;
        }
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image InputStream", 40, e);
        displayArray2 = displays;
        int n5 = displays.length;
        int n6 = 0;
        while (n6 < n5) {
            Display tempDisplay = displayArray2[n6];
            stringArray = SwtTestUtil.imageFilenames;
            n2 = SwtTestUtil.imageFilenames.length;
            n = 0;
            while (n < n2) {
                String fileName = stringArray[n];
                String[] stringArray2 = SwtTestUtil.imageFormats;
                int n7 = SwtTestUtil.imageFormats.length;
                int n8 = 0;
                while (n8 < n7) {
                    String format = stringArray2[n8];
                    Throwable throwable6 = null;
                    Object var18_31 = null;
                    try (InputStream stream = SwtTestUtil.class.getResourceAsStream(fileName + "." + format);){
                        Image image = new Image((Device)tempDisplay, stream);
                        image.dispose();
                    }
                    catch (Throwable throwable7) {
                        if (throwable6 == null) {
                            throwable6 = throwable7;
                        } else if (throwable6 != throwable7) {
                            throwable6.addSuppressed(throwable7);
                        }
                        throw throwable6;
                    }
                    ++n8;
                }
                ++n;
            }
            ++n6;
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_lang_String() {
        int n;
        Display[] displays;
        String fileName1 = null;
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, fileName1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for file name == null", 4, e);
        String pathName2 = "nonexistent.txt";
        e = (Exception)Assert.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)this.display, pathName2);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for non-existent file name", 39, e);
        String pathName3 = Test_org_eclipse_swt_graphics_Image.getPath("empty.txt").toString();
        e = (Exception)Assert.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)this.display, pathName3);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid file name", 42, e);
        String firstFile = SwtTestUtil.invalidImageFilenames[0];
        Display[] displayArray = new Display[2];
        displayArray[0] = this.display;
        Display[] displayArray2 = displays = displayArray;
        int n2 = displays.length;
        int n3 = 0;
        while (n3 < n2) {
            Display display = displayArray2[n3];
            String[] stringArray = SwtTestUtil.imageFormats;
            n = SwtTestUtil.imageFormats.length;
            int n4 = 0;
            while (n4 < n) {
                String format = stringArray[n4];
                String pathName = Test_org_eclipse_swt_graphics_Image.getPath(firstFile + "." + format).toString();
                e = (Exception)Assert.assertThrows(SWTException.class, () -> {
                    Image image = new Image((Device)display, pathName);
                });
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image file name", 40, e);
                ++n4;
            }
            ++n3;
        }
        String pathName4 = Test_org_eclipse_swt_graphics_Image.getPath(SwtTestUtil.invalidImageFilenames[1]).toString();
        e = (Exception)Assert.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)this.display, pathName4);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid image file name", 40, e);
        Display[] displayArray3 = displays;
        int n5 = displays.length;
        n2 = 0;
        while (n2 < n5) {
            Display display = displayArray3[n2];
            String[] stringArray = SwtTestUtil.imageFilenames;
            int n6 = SwtTestUtil.imageFilenames.length;
            n = 0;
            while (n < n6) {
                String fileName = stringArray[n];
                String[] stringArray2 = SwtTestUtil.imageFormats;
                int n7 = SwtTestUtil.imageFormats.length;
                int n8 = 0;
                while (n8 < n7) {
                    String format = stringArray2[n8];
                    String pathName = Test_org_eclipse_swt_graphics_Image.getPath(fileName + "." + format).toString();
                    Image image = new Image((Device)display, pathName);
                    image.dispose();
                    ++n8;
                }
                ++n;
            }
            ++n2;
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageFileNameProvider() {
        ImageFileNameProvider provider1 = null;
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, provider1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 4, e);
        ImageFileNameProvider provider2 = zoom -> null;
        e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, provider2);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 5, e);
        Image image = new Image((Device)this.display, this.imageFileNameProvider);
        image.dispose();
        ImageFileNameProvider provider3 = zoom -> {
            String fileName = switch (zoom) {
                case 100, 150, 200 -> "corrupt.png";
                default -> null;
            };
            return fileName != null ? Test_org_eclipse_swt_graphics_Image.getPath(fileName) : null;
        };
        e = (Exception)Assert.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)this.display, provider3);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
        ImageFileNameProvider provider4 = zoom -> {
            if (zoom == 100) {
                return Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png");
            }
            return null;
        };
        image = new Image((Device)this.display, provider4);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageDataProvider() {
        ImageDataProvider provider1 = null;
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, provider1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 4, e);
        ImageDataProvider provider2 = zoom -> null;
        e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, provider2);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider == null", 5, e);
        Image image = new Image((Device)this.display, this.imageDataProvider);
        image.dispose();
        ImageDataProvider provider3 = zoom -> switch (zoom) {
            case 100, 150, 200 -> new ImageData(Test_org_eclipse_swt_graphics_Image.getPath("corrupt.png"));
            default -> null;
        };
        e = (Exception)Assert.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)this.display, provider3);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
        ImageDataProvider provider4 = zoom -> {
            if (zoom == 100) {
                return new ImageData(Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png"));
            }
            return null;
        };
        image = new Image((Device)this.display, provider4);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageGcDrawer() {
        ImageGcDrawer drawer = null;
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> {
            Image image = new Image((Device)this.display, drawer, 20, 20);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for ImageGcDrawer == null", 4, e);
        Image image = new Image((Device)this.display, this.imageGcDrawer, 20, 20);
        image.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceImageI() throws IOException {
        byte[] bytes = Files.readAllBytes(Path.of(Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png"), new String[0]));
        Image sourceImage = new Image((Device)this.display, (InputStream)new ByteArrayInputStream(bytes));
        Image copiedImage = new Image((Device)this.display, sourceImage, 0);
        Image targetImage = new Image((Device)this.display, 1, 1);
        GC gc = new GC((Drawable)targetImage);
        gc.drawImage(sourceImage, 0, 0);
        gc.drawImage(targetImage, 0, 0);
        Assert.assertEquals((long)0L, (long)this.imageDataComparator().compare(sourceImage.getImageData(), copiedImage.getImageData()));
        sourceImage.dispose();
        copiedImage.dispose();
        targetImage.dispose();
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Image image = null;
        Image image1 = null;
        try {
            image1 = image = new Image((Device)this.display, 10, 10);
            Assert.assertFalse((boolean)image.equals(null));
            Assert.assertTrue((boolean)image.equals((Object)image1));
            ImageData imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            image.dispose();
            image = new Image((Device)this.display, imageData);
            image1 = new Image((Device)this.display, imageData);
            Assert.assertFalse((boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertFalse((boolean)image.equals(null));
            Assert.assertTrue((boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertTrue((boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertFalse((boolean)image.equals(null));
            Assert.assertTrue((boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertTrue((boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertFalse((boolean)image.equals(null));
            Assert.assertTrue((boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertTrue((boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image1 = image = new Image((Device)this.display, this.imageGcDrawer, 10, 10);
            Assert.assertFalse((boolean)image.equals(null));
            Assert.assertTrue((boolean)image.equals((Object)image1));
            image1 = new Image((Device)this.display, this.imageGcDrawer, 10, 10);
            Assert.assertTrue((boolean)image.equals((Object)image1));
        }
        finally {
            image.dispose();
            image1.dispose();
        }
    }

    @Test
    public void test_getBackground() {
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        Image image = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        image.dispose();
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> {
            Color color = image.getBackground();
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
    }

    @Test
    public void test_getBounds() {
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image1 = new Image((Device)this.display, noOpGcDrawer, bounds.width, bounds.height);
        image1.dispose();
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> {
            Rectangle rectangle = image1.getBounds();
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        Image image = new Image((Device)this.display, noOpGcDrawer, bounds.width, bounds.height);
        Rectangle bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((Object)bounds, (Object)bounds1);
        image = new Image((Device)this.display, noOpGcDrawer, bounds.width, bounds.height);
        bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((Object)bounds, (Object)bounds1);
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        bounds1 = image.getBounds();
        image.dispose();
        Assert.assertEquals((Object)bounds, (Object)bounds1);
    }

    @Test
    public void test_getBoundsInPixels() {
        Rectangle initialBounds = new Rectangle(0, 0, 10, 20);
        Image image1 = new Image((Device)this.display, initialBounds.width, initialBounds.height);
        image1.dispose();
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> {
            Rectangle rectangle = image1.getBoundsInPixels();
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        Image image = new Image((Device)this.display, initialBounds.width, initialBounds.height);
        Rectangle boundsInPixels = image.getBoundsInPixels();
        Rectangle bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)"Image.getBounds method doesn't return original bounds.", (Object)initialBounds, (Object)bounds);
        Assert.assertEquals((String)"Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)initialBounds, (Object)boundsInPixels);
        ImageData imageData = new ImageData(initialBounds.width, initialBounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)"Image.getBounds method doesn't return original bounds.", (Object)initialBounds, (Object)bounds);
        Assert.assertEquals((String)"Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)initialBounds, (Object)boundsInPixels);
        image = new Image((Device)this.display, this.imageFileNameProvider);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)"Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)bounds, (Object)boundsInPixels);
        image = new Image((Device)this.display, this.imageDataProvider);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)"Image.getBoundsInPixels method doesn't return bounds in Pixel values.", (Object)bounds, (Object)boundsInPixels);
        image = new Image((Device)this.display, this.imageGcDrawer, initialBounds.width, initialBounds.height);
        boundsInPixels = image.getBoundsInPixels();
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)"Image.getBounds method doesn't return original bounds.", (Object)initialBounds, (Object)bounds);
        Assert.assertEquals((String)"Image.getBoundsInPixels method doesn't return bounds in Pixel values for ImageGcDrawer.", (Object)initialBounds, (Object)boundsInPixels);
    }

    @Test
    public void test_getImageDataCurrentZoom() {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image1 = new Image((Device)this.display, bounds.width, bounds.height);
        image1.dispose();
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> {
            ImageData imageData = image1.getImageDataAtCurrentZoom();
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        ImageData imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        image.dispose();
        Rectangle boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)bounds);
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        image.dispose();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        Assert.assertEquals((String)":b: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)bounds);
        image = new Image((Device)this.display, this.imageFileNameProvider);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)bounds);
        image = new Image((Device)this.display, this.imageDataProvider);
        imageDataAtCurrentZoom = image.getImageDataAtCurrentZoom();
        boundsAtCurrentZoom = new Rectangle(0, 0, imageDataAtCurrentZoom.width, imageDataAtCurrentZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Size of ImageData returned from Image.getImageDataAtCurrentZoom method doesn't return matches with bounds in Pixel values.", (Object)boundsAtCurrentZoom, (Object)bounds);
    }

    @Test
    public void test_getImageData() {
        this.getImageData1();
        this.getImageData2(24, new PaletteData(0xFF0000, 65280, 255));
        this.getImageData2(32, new PaletteData(0xFF0000, 65280, 255));
    }

    @Test
    public void test_getImageData_changingImageDataDoesNotAffectImage() {
        List<Image> images = List.of(new Image((Device)this.display, this.imageFileNameProvider), new Image((Device)this.display, this.imageDataProvider), new Image((Device)this.display, new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255))));
        try {
            for (Image image : images) {
                ImageData originalImageData = image.getImageData();
                originalImageData.setPixel(0, 0, originalImageData.getPixel(0, 0) + 1);
                Assertions.assertNotEquals((int)image.getImageData().getPixel(0, 0), (int)originalImageData.getPixel(0, 0));
            }
        }
        finally {
            images.forEach(Resource::dispose);
        }
    }

    @Test
    public void test_getImageData_100() {
        this.getImageData_int(100);
    }

    @Test
    public void test_getImageData_125() {
        this.getImageData_int(125);
    }

    @Test
    public void test_getImageData_150() {
        this.getImageData_int(150);
    }

    @Test
    public void test_getImageData_200() {
        this.getImageData_int(200);
    }

    void getImageData_int(int zoom) {
        Rectangle bounds = new Rectangle(0, 0, 10, 20);
        Image image1 = new Image((Device)this.display, bounds.width, bounds.height);
        image1.dispose();
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> {
            ImageData imageData = image1.getImageData(zoom);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        ImageData imageDataAtZoom = image.getImageData(zoom);
        image.dispose();
        Rectangle boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, bounds.width, bounds.height);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, (gc, width, height) -> {}, bounds.width, bounds.height);
        imageDataAtZoom = image.getImageData(zoom);
        image.dispose();
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        Assert.assertEquals((String)":a: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        ImageData imageData = new ImageData(bounds.width, bounds.height, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        image = new Image((Device)this.display, imageData);
        imageDataAtZoom = image.getImageData(zoom);
        image.dispose();
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        Assert.assertEquals((String)":b: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, this.imageFileNameProvider);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":c: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, this.imageDataProvider);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
        image = new Image((Device)this.display, this.imageDataProvider1xOnly);
        imageDataAtZoom = image.getImageData(zoom);
        boundsAtZoom = new Rectangle(0, 0, imageDataAtZoom.width, imageDataAtZoom.height);
        bounds = image.getBounds();
        image.dispose();
        Assert.assertEquals((String)":d: Size of ImageData returned from Image.getImageData(int) method doesn't return matches with bounds in Pixel values.", (Object)Test_org_eclipse_swt_graphics_Image.scaleBounds(bounds, zoom, 100), (Object)boundsAtZoom);
    }

    public static Rectangle scaleBounds(Rectangle rect, int targetZoom, int currentZoom) {
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        Rectangle returnRect = new Rectangle(0, 0, 0, 0);
        returnRect.x = Math.round((float)rect.x * scaleFactor);
        returnRect.y = Math.round((float)rect.y * scaleFactor);
        returnRect.width = Math.round((float)rect.width * scaleFactor);
        returnRect.height = Math.round((float)rect.height * scaleFactor);
        return returnRect;
    }

    @Test
    public void test_hashCode() {
        Image image = null;
        Image image1 = null;
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        try {
            image1 = image = new Image((Device)this.display, noOpGcDrawer, 10, 10);
            Assert.assertEquals((long)image1.hashCode(), (long)image.hashCode());
            ImageData imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            image.dispose();
            image = new Image((Device)this.display, imageData);
            image1 = new Image((Device)this.display, imageData);
            boolean equals = image1.hashCode() == image.hashCode();
            Assert.assertFalse((boolean)equals);
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image = new Image((Device)this.display, this.imageFileNameProvider);
            image1 = new Image((Device)this.display, this.imageFileNameProvider);
            Assert.assertEquals((long)image1.hashCode(), (long)image.hashCode());
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image = new Image((Device)this.display, this.imageDataProvider);
            image1 = new Image((Device)this.display, this.imageDataProvider);
            Assert.assertEquals((long)image1.hashCode(), (long)image.hashCode());
        }
        finally {
            image.dispose();
            image1.dispose();
        }
        try {
            image = new Image((Device)this.display, this.imageGcDrawer, 10, 10);
            image1 = new Image((Device)this.display, this.imageGcDrawer, 10, 10);
            Assert.assertEquals((long)image1.hashCode(), (long)image.hashCode());
        }
        finally {
            image.dispose();
            image1.dispose();
        }
    }

    @Test
    public void test_isDisposed() {
        Image image = new Image((Device)this.display, 10, 10);
        Assert.assertFalse((boolean)image.isDisposed());
        image.dispose();
        Assert.assertTrue((boolean)image.isDisposed());
    }

    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
        Assume.assumeFalse((String)"Excluded test_setBackgroundLorg_eclipse_swt_graphics_Color(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_Image)", (boolean)SwtTestUtil.isGTK);
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        Image image1 = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        try {
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> image1.setBackground(null));
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for color == null", 4, e);
        }
        finally {
            image1.dispose();
        }
        Image image2 = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        Color color2 = new Color(255, 255, 255);
        color2.dispose();
        try {
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> image2.setBackground(color2));
            SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed color", 5, e);
        }
        finally {
            image2.dispose();
        }
        Image image3 = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        image3.dispose();
        Color color3 = new Color(255, 255, 255);
        SWTException e = (SWTException)Assert.assertThrows(SWTException.class, () -> image3.setBackground(color3));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for disposed image", 44, e);
        Image image4 = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        image4.setBackground(this.display.getSystemColor(5));
        Color color4 = image4.getBackground();
        Assert.assertNull((String)"background color should be null for non-transparent image", (Object)color4);
        image4.dispose();
        ImageData imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)}));
        imageData.transparentPixel = 0;
        Image image5 = new Image((Device)this.display, imageData);
        image5.setBackground(this.display.getSystemColor(5));
        Color color5 = image5.getBackground();
        Assert.assertEquals((String)"background color should have been set to green", (Object)this.display.getSystemColor(5), (Object)color5);
        image5.dispose();
    }

    @Test
    public void test_toString() {
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        Image image = new Image((Device)this.display, noOpGcDrawer, 10, 10);
        try {
            Assert.assertNotNull((Object)image.toString());
            Assert.assertTrue((image.toString().length() > 0 ? 1 : 0) != 0);
        }
        finally {
            image.dispose();
        }
    }

    void getImageData1() {
        String fileName = SwtTestUtil.imageFilenames[0];
        String[] stringArray = SwtTestUtil.imageFormats;
        int n = SwtTestUtil.imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream stream = SwtTestUtil.class.getResourceAsStream(fileName + "." + format);){
                    ImageData data1 = new ImageData(stream);
                    Image image = new Image((Device)this.display, data1);
                    ImageData data2 = image.getImageData();
                    image.dispose();
                    Assert.assertEquals((String)"Image width should be the same", (long)data1.width, (long)data2.width);
                    Assert.assertEquals((String)"Image height should be the same", (long)data1.height, (long)data2.height);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
    }

    void getImageData2(int depth, PaletteData palette) {
        int width = 10;
        int height = 10;
        Color color = new Color(0, 255, 0);
        RGB colorRGB = color.getRGB();
        ImageData imageData = new ImageData(width, height, depth, palette);
        Image image = new Image((Device)this.display, imageData);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(color);
        gc.fillRectangle(0, 0, 10, 10);
        ImageData newData = image.getImageData();
        PaletteData newPalette = newData.palette;
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int pixel = newData.getPixel(i, j);
                RGB rgb = newPalette.getRGB(pixel);
                Assert.assertTrue((String)"rgb.equals(colorRGB)", (boolean)rgb.equals((Object)colorRGB));
                ++j;
            }
            ++i;
        }
        gc.dispose();
        image.dispose();
    }

    RGB getRealRGB(Color color) {
        ImageGcDrawer gcDrawer = (imageGc, width, height) -> {
            imageGc.setBackground(color);
            imageGc.setForeground(color);
            imageGc.fillRectangle(0, 0, width, height);
        };
        Image colorImage = new Image((Device)this.display, gcDrawer, 10, 10);
        ImageData imageData = colorImage.getImageData();
        PaletteData palette = imageData.palette;
        colorImage.dispose();
        int pixel = imageData.getPixel(0, 0);
        return palette.getRGB(pixel);
    }

    @Test
    public void test_bug566545_efficientGrayscaleImage() {
        RGB[] grayscale = new RGB[256];
        int i = 0;
        while (i < grayscale.length) {
            grayscale[i] = new RGB(i, i, i);
            ++i;
        }
        int width = 128;
        int height = 128;
        ImageData imageDataIndexed = new ImageData(width, height, 8, new PaletteData(grayscale));
        ImageData imageDataDirect = new ImageData(width, height, 8, new PaletteData(255, 255, 255));
        Consumer<ImageData> fillImage = imageData -> {
            int y = 0;
            while (y < imageData.height) {
                int x = 0;
                while (x < imageData.width) {
                    imageData.setPixel(x, y, (x + y) % 256);
                    ++x;
                }
                ++y;
            }
        };
        fillImage.accept(imageDataIndexed);
        fillImage.accept(imageDataDirect);
        Image imageIndexed = new Image((Device)this.display, imageDataIndexed);
        Image imageDirect = new Image((Device)this.display, imageDataDirect);
        ImageGcDrawer gcDrawer1 = (gc, iWidth, iHeight) -> gc.drawImage(imageIndexed, 0, 0);
        Image outImageIndexed = new Image((Device)this.display, gcDrawer1, width, height);
        ImageGcDrawer gcDrawer2 = (gc, iWidth, iHeight) -> gc.drawImage(imageDirect, 0, 0);
        Image outImageDirect = new Image((Device)this.display, gcDrawer2, width, height);
        ImageTestUtil.assertImagesEqual(imageDataIndexed, imageDataDirect);
        ImageTestUtil.assertImagesEqual(imageIndexed.getImageData(), imageDirect.getImageData());
        ImageTestUtil.assertImagesEqual(outImageIndexed.getImageData(), outImageDirect.getImageData());
        imageIndexed.dispose();
        imageDirect.dispose();
        outImageIndexed.dispose();
        outImageDirect.dispose();
    }

    @Test
    public void test_updateWidthHeightAfterDPIChange() {
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        int deviceZoom = DPIUtil.getDeviceZoom();
        try {
            Rectangle imageSize = new Rectangle(0, 0, 16, 16);
            Image baseImage = new Image((Device)this.display, noOpGcDrawer, imageSize.width, imageSize.height);
            GC gc2 = new GC((Drawable)this.display);
            gc2.drawImage(baseImage, 10, 10);
            Assert.assertEquals((String)"Base image size differs unexpectedly", (Object)imageSize, (Object)baseImage.getBounds());
            DPIUtil.setDeviceZoom((int)(deviceZoom * 2));
            gc2.drawImage(baseImage, 10, 10);
            Assert.assertEquals((String)"Image size at 100% must always stay the same despite the zoom factor", (Object)imageSize, (Object)baseImage.getBounds());
            gc2.dispose();
            baseImage.dispose();
        }
        finally {
            DPIUtil.setDeviceZoom((int)deviceZoom);
        }
    }

    @Test
    public void test_imageDataIsCached() {
        Assume.assumeTrue((String)"On-demand image creation only implemented for Windows", (boolean)SwtTestUtil.isWindows);
        String imagePath = Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png");
        AtomicInteger callCount = new AtomicInteger();
        ImageFileNameProvider imageFileNameProvider = __ -> {
            callCount.incrementAndGet();
            return imagePath;
        };
        Image fileNameProviderImage = new Image((Device)this.display, imageFileNameProvider);
        callCount.set(0);
        fileNameProviderImage.getImageData(100);
        fileNameProviderImage.getImageData(100);
        fileNameProviderImage.getImageData(100);
        Assert.assertEquals((long)0L, (long)callCount.get());
    }

    @Test
    public void test_imageDataSameViaDifferentProviders() {
        Assume.assumeFalse((String)"Cocoa generates inconsistent image data", (boolean)SwtTestUtil.isCocoa);
        String imagePath = Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png");
        ImageFileNameProvider imageFileNameProvider = zoom -> zoom == 100 ? imagePath : null;
        ImageDataProvider dataProvider = zoom -> {
            if (zoom == 100) {
                try {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (InputStream imageStream = Files.newInputStream(Path.of(imagePath, new String[0]), new OpenOption[0]);){
                        return new ImageData(imageStream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
            }
            return null;
        };
        Image fileNameProviderImage = new Image((Device)this.display, imageFileNameProvider);
        Image dataProviderImage = new Image((Device)this.display, dataProvider);
        ImageData dataFromFileNameProviderImage = fileNameProviderImage.getImageData(100);
        ImageData dataFromImageDescriptorImage = dataProviderImage.getImageData(100);
        Assert.assertEquals((long)0L, (long)this.imageDataComparator().compare(dataFromFileNameProviderImage, dataFromImageDescriptorImage));
        fileNameProviderImage.dispose();
        dataProviderImage.dispose();
    }

    @Test
    public void test_imageDataSameViaProviderAndSimpleData() {
        Assume.assumeFalse((String)"Cocoa generates inconsistent image data", (boolean)SwtTestUtil.isCocoa);
        String imagePath = Test_org_eclipse_swt_graphics_Image.getPath("collapseall.png");
        ImageFileNameProvider imageFileNameProvider = __ -> imagePath;
        ImageDataProvider dataProvider = __ -> {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InputStream imageStream = Files.newInputStream(Path.of(imagePath, new String[0]), new OpenOption[0]);){
                    return new ImageData(imageStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                return null;
            }
        };
        Image fileNameProviderImage = new Image((Device)this.display, imageFileNameProvider);
        Image dataImage = new Image((Device)this.display, dataProvider.getImageData(100));
        ImageData dataFromFileNameProviderImage = fileNameProviderImage.getImageData(100);
        ImageData dataFromImageWithSimpleData = dataImage.getImageData(100);
        Assert.assertEquals((long)0L, (long)this.imageDataComparator().compare(dataFromFileNameProviderImage, dataFromImageWithSimpleData));
        fileNameProviderImage.dispose();
        dataImage.dispose();
    }

    @Test
    public void test_gcOnImageGcDrawer_imageDataAtNonDeviceZoom() {
        int originalDeviceZoom = DPIUtil.getDeviceZoom();
        int deviceZoom = 200;
        int nonDeviceZoom = 100;
        DPIUtil.setDeviceZoom((int)deviceZoom);
        ImageGcDrawer blueDrawer = (gc, width, height) -> {
            gc.setBackground(this.display.getSystemColor(9));
            gc.fillRectangle(0, 0, width, height);
        };
        Image image = new Image((Device)this.display, blueDrawer, 1, 1);
        int bluePixelValue = image.getImageData(nonDeviceZoom).getPixel(0, 0);
        GC redOverwritingGc = new GC((Drawable)image);
        try {
            redOverwritingGc.setBackground(this.display.getSystemColor(3));
            redOverwritingGc.fillRectangle(0, 0, 1, 1);
            Assertions.assertNotEquals((int)bluePixelValue, (int)image.getImageData(nonDeviceZoom).getPixel(0, 0));
        }
        finally {
            redOverwritingGc.dispose();
            image.dispose();
            DPIUtil.setDeviceZoom((int)originalDeviceZoom);
        }
    }

    private Comparator<ImageData> imageDataComparator() {
        return Comparator.comparingInt(d -> d.width).thenComparing(d -> d.height).thenComparing((firstData, secondData) -> {
            int x = 0;
            while (x < firstData.width) {
                int y = 0;
                while (y < firstData.height) {
                    if (firstData.getPixel(x, y) != secondData.getPixel(x, y)) {
                        return -1;
                    }
                    if (firstData.getAlpha(x, y) != secondData.getAlpha(x, y)) {
                        return -1;
                    }
                    ++y;
                }
                ++x;
            }
            return 0;
        });
    }

    private static /* synthetic */ void lambda$26(Display display, InputStream inputStream) throws Throwable {
        Image image = new Image((Device)display, inputStream);
    }
}

