/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.tests.graphics.ImageDataTestHelper;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_ImageData {
    static int[] indexedDepths = new int[]{1, 2, 4, 8, 16};
    static int[] directDepths = new int[]{8, 16, 24, 32};
    ImageData imageData;
    final int IMAGE_DIMENSION = 10;

    @Before
    public void setUp() {
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
    }

    @Test
    public void test_blit() throws Exception {
        ArrayList<ImageDataTestHelper.BlitTestInfo> tests = new ArrayList<ImageDataTestHelper.BlitTestInfo>();
        int iByteOrder = 0;
        while (iByteOrder < 2) {
            int byteOrder = iByteOrder == 0 ? ImageDataTestHelper.MSB_FIRST : ImageDataTestHelper.LSB_FIRST;
            int scale = 1;
            while (scale < 3) {
                int depth;
                int[] nArray = indexedDepths;
                int n = indexedDepths.length;
                int n2 = 0;
                while (n2 < n) {
                    depth = nArray[n2];
                    tests.add(new ImageDataTestHelper.BlitTestInfo(depth, scale, byteOrder, false));
                    ++n2;
                }
                nArray = directDepths;
                n = directDepths.length;
                n2 = 0;
                while (n2 < n) {
                    depth = nArray[n2];
                    tests.add(new ImageDataTestHelper.BlitTestInfo(depth, scale, byteOrder, true));
                    ++n2;
                }
                ++scale;
            }
            ++iByteOrder;
        }
        for (ImageDataTestHelper.BlitTestInfo dstInfo : tests) {
            for (ImageDataTestHelper.BlitTestInfo srcInfo : tests) {
                if (srcInfo.isDirect && !dstInfo.isDirect || !srcInfo.isDirect && dstInfo.isDirect && srcInfo.scale != dstInfo.scale || !srcInfo.isDirect && !dstInfo.isDirect && srcInfo.depth > dstInfo.depth) continue;
                try {
                    ImageDataTestHelper.BlitTestInfo actual = ImageDataTestHelper.blit(srcInfo, dstInfo.depth, dstInfo.scale, dstInfo.byteOrder, dstInfo.isDirect);
                    ImageDataTestHelper.assertImageDataEqual(srcInfo.imageData, actual.imageData, dstInfo.imageData);
                }
                catch (Error e) {
                    String error = "ImageData.blit() error with src=" + String.valueOf(srcInfo) + " dst=" + String.valueOf(dstInfo);
                    throw new Error(error, e);
                }
                catch (RuntimeException e) {
                    String error = "ImageData.blit() error with src=" + String.valueOf(srcInfo) + " dst=" + String.valueOf(dstInfo);
                    throw new RuntimeException(error, e);
                }
            }
        }
    }

    @Test
    public void test_blit_MsbLsb() throws Exception {
        int depth;
        ArrayList<ImageDataTestHelper.BlitTestInfo> tests = new ArrayList<ImageDataTestHelper.BlitTestInfo>();
        int[] nArray = indexedDepths;
        int n = indexedDepths.length;
        int n2 = 0;
        while (n2 < n) {
            depth = nArray[n2];
            tests.add(new ImageDataTestHelper.BlitTestInfo(depth, 1, ImageDataTestHelper.MSB_FIRST, false));
            ++n2;
        }
        nArray = directDepths;
        n = directDepths.length;
        n2 = 0;
        while (n2 < n) {
            depth = nArray[n2];
            tests.add(new ImageDataTestHelper.BlitTestInfo(depth, 1, ImageDataTestHelper.MSB_FIRST, true));
            ++n2;
        }
        for (ImageDataTestHelper.BlitTestInfo src : tests) {
            String error;
            try {
                ImageDataTestHelper.BlitTestInfo lsb = ImageDataTestHelper.blit(src, src.depth, src.scale, ImageDataTestHelper.LSB_FIRST, src.isDirect);
                ImageDataTestHelper.BlitTestInfo msb = ImageDataTestHelper.blit(lsb, lsb.depth, lsb.scale, ImageDataTestHelper.MSB_FIRST, lsb.isDirect);
                ImageDataTestHelper.assertImageDataEqual(src.imageData, msb.imageData, src.imageData);
            }
            catch (Error e) {
                error = "ImageData.blit() error with src=" + String.valueOf(src);
                throw new Error(error, e);
            }
            catch (RuntimeException e) {
                error = "ImageData.blit() error with src=" + String.valueOf(src);
                throw new RuntimeException(error, e);
            }
        }
    }

    @Test
    public void test_ConstructorIIILorg_eclipse_swt_graphics_PaletteData() {
        int[] validDepths;
        Assert.assertThrows((String)"No exception thrown for width < 0", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(-1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        });
        Assert.assertThrows((String)"No exception thrown for height < 0", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, -1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        });
        Assert.assertThrows((String)"No exception thrown for paletteData == null", IllegalArgumentException.class, () -> {
            byte[] byArray = new byte[4];
            byArray[1] = 79;
            byArray[2] = 79;
            ImageData imageData = new ImageData(1, 1, 1, null, 0, byArray);
        });
        Assert.assertThrows((String)"No exception thrown for unsupported depth", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 3, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
        });
        int[] nArray = validDepths = new int[]{1, 2, 4, 8, 16, 24, 32};
        int n = validDepths.length;
        int n2 = 0;
        while (n2 < n) {
            int validDepth = nArray[n2];
            new ImageData(1, 1, validDepth, new PaletteData(new RGB[]{new RGB(0, 0, 0)}));
            ++n2;
        }
    }

    @Test
    public void test_ConstructorIIILorg_eclipse_swt_graphics_PaletteDataI$B() {
        int[] validDepths;
        byte[] byArray = new byte[4];
        byArray[1] = 79;
        byArray[2] = 79;
        byte[] validData = byArray;
        Assert.assertThrows((String)"No exception thrown for width < 0", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(-1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
        });
        Assert.assertThrows((String)"No exception thrown for height < 0", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, -1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
        });
        Assert.assertThrows((String)"No exception thrown for paletteData == null", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 1, null, 0, validData);
        });
        Assert.assertThrows((String)"No exception thrown for data == null", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, null);
        });
        Assert.assertThrows((String)"No exception thrown for data array too small", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[0]);
        });
        Assert.assertThrows((String)"No exception thrown for data array too small", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 16, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79});
        });
        Assert.assertThrows((String)"No exception thrown for data array too small", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 32, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79, 79});
        });
        Assert.assertThrows((String)"No exception thrown for data array too small", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(2, 2, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, new byte[]{79, 79, 79});
        });
        Assert.assertThrows((String)"No exception thrown for unsupported depth", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 3, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
        });
        int[] nArray = validDepths = new int[]{1, 2, 4, 8, 16, 24, 32};
        int n = validDepths.length;
        int n2 = 0;
        while (n2 < n) {
            int validDepth = nArray[n2];
            new ImageData(1, 1, validDepth, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 1, validData);
            ++n2;
        }
        Assert.assertThrows((String)"No exception thrown for scanlinePad == 0", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(1, 1, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0)}), 0, validData);
        });
    }

    @Test
    public void test_ConstructorLjava_io_InputStream() throws IOException {
        InputStream stream = null;
        Assert.assertThrows((String)"No exception thrown for InputStream == null", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(stream);
        });
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream1 = SwtTestUtil.class.getResourceAsStream("empty.txt");){
            Assert.assertThrows((String)"No exception thrown for invalid InputStream", SWTException.class, () -> {
                ImageData imageData = new ImageData(stream1);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String fileName = SwtTestUtil.imageFilenames[0];
        String[] stringArray = SwtTestUtil.imageFormats;
        int n = SwtTestUtil.imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            Throwable throwable3 = null;
            Object var8_12 = null;
            try (InputStream stream2 = SwtTestUtil.class.getResourceAsStream(fileName + "." + format);){
                new ImageData(stream2);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++n2;
        }
    }

    @Test
    public void test_ConstructorLjava_lang_String() {
        String filename = null;
        Assert.assertThrows((String)"No exception thrown for filename == null", IllegalArgumentException.class, () -> {
            ImageData imageData = new ImageData(filename);
        });
    }

    @Test
    public void test_clone() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream stream = SwtTestUtil.class.getResourceAsStream(SwtTestUtil.imageFilenames[0] + "." + SwtTestUtil.imageFormats[0]);){
            ImageData data1 = new ImageData(stream);
            ImageData data2 = (ImageData)data1.clone();
            Assert.assertEquals((String)":a:", (long)data1.alpha, (long)data2.alpha);
            Assert.assertArrayEquals((String)":b:", (byte[])data1.alphaData, (byte[])data2.alphaData);
            Assert.assertEquals((String)":c:", (long)data1.bytesPerLine, (long)data2.bytesPerLine);
            Assert.assertArrayEquals((String)":d:", (byte[])data1.data, (byte[])data2.data);
            Assert.assertEquals((String)":e:", (long)data1.delayTime, (long)data2.delayTime);
            Assert.assertEquals((String)":f:", (long)data1.depth, (long)data2.depth);
            Assert.assertEquals((String)":g:", (long)data1.disposalMethod, (long)data2.disposalMethod);
            Assert.assertEquals((String)":h:", (long)data1.height, (long)data2.height);
            Assert.assertArrayEquals((String)":i:", (byte[])data1.maskData, (byte[])data2.maskData);
            Assert.assertEquals((String)":j:", (long)data1.maskPad, (long)data2.maskPad);
            Assert.assertEquals((String)":k:", (Object)data1.palette, (Object)data2.palette);
            Assert.assertEquals((String)":l:", (long)data1.scanlinePad, (long)data2.scanlinePad);
            Assert.assertEquals((String)":m:", (long)data1.transparentPixel, (long)data2.transparentPixel);
            Assert.assertEquals((String)":n:", (long)data1.type, (long)data2.type);
            Assert.assertEquals((String)":o:", (long)data1.width, (long)data2.width);
            Assert.assertEquals((String)":p:", (long)data1.x, (long)data2.x);
            Assert.assertEquals((String)":q:", (long)data1.y, (long)data2.y);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void test_getAlphaII() {
        Assert.assertEquals((String)":a:", (long)255L, (long)this.imageData.getAlpha(0, 0));
        int value = 170;
        this.imageData.setAlpha(0, 0, value);
        Assert.assertEquals((String)":b:", (long)value, (long)this.imageData.getAlpha(0, 0));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getAlpha(-1, 1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getAlpha(10, 1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getAlpha(0, -1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getAlpha(0, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
    }

    @Test
    public void test_getAlphasIII$BI() {
        byte[] alphaData = new byte[20];
        this.imageData.getAlphas(0, 1, 10, alphaData, 10);
        int i = 0;
        while (i < alphaData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":a:", (long)0L, (long)alphaData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)-1L, (long)alphaData[i]);
            }
            ++i;
        }
        byte value = -86;
        byte[] values = new byte[]{value, (byte)(value + 1), (byte)(value + 2), (byte)(value + 3), (byte)(value + 4)};
        this.imageData.setAlphas(0, 1, values.length, values, 0);
        this.imageData.getAlphas(0, 1, 10, alphaData, 10);
        int i2 = 0;
        while (i2 < alphaData.length) {
            if (i2 < 10) {
                Assert.assertEquals((String)":c:", (long)0L, (long)alphaData[i2]);
            } else if (i2 < 10 + values.length) {
                Assert.assertEquals((String)":d:", (long)values[i2 - 10], (long)alphaData[i2]);
            } else if (i2 < 20) {
                Assert.assertEquals((String)":e:", (long)0L, (long)alphaData[i2]);
            }
            ++i2;
        }
        Assert.assertThrows((String)"No exception thrown for getWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.getAlphas(0, 1, 100, alphaData, 10));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for alphas == null", IllegalArgumentException.class, () -> this.imageData.getAlphas(0, 1, 10, null, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for alphas == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getAlphas(-1, 1, 10, alphaData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getAlphas(10, 1, 10, alphaData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getAlphas(0, -1, 10, alphaData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getAlphas(0, 10, 10, alphaData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for getWidth < 0", IllegalArgumentException.class, () -> this.imageData.getAlphas(0, 1, -1, alphaData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, ex);
    }

    @Test
    public void test_getPixelII() {
        Assert.assertEquals((String)":a:", (long)0L, (long)this.imageData.getPixel(0, 0));
        int value = 170;
        this.imageData.setPixel(0, 0, value);
        Assert.assertEquals((String)":b:", (long)value, (long)this.imageData.getPixel(0, 0));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getPixel(-1, 1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getPixel(10, 1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getPixel(0, -1);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> {
            int n = this.imageData.getPixel(0, 10);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        int width = 3;
        int height = 3;
        int depth = 4;
        int pixelValue = 1;
        byte[] data = new byte[]{(byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4), (byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4), (byte)((pixelValue << 4) + pixelValue), (byte)(pixelValue << 4)};
        this.imageData = new ImageData(width, height, depth, new PaletteData(new RGB[]{new RGB(0, 0, 255), new RGB(111, 111, 111)}), 1, data);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = this.imageData.getPixel(x, y);
                Assert.assertEquals((String)"Bad pixel data", (long)pixelValue, (long)pixel);
                ++x;
            }
            ++y;
        }
    }

    @Test
    public void test_getPixelsIII$BI() {
        byte b;
        byte[] pixelData = new byte[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        byte[] byArray = pixelData;
        int n = pixelData.length;
        int n2 = 0;
        while (n2 < n) {
            byte b2 = byArray[n2];
            Assert.assertEquals((String)":a:", (long)0L, (long)b2);
            ++n2;
        }
        byte[] values = new byte[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":c:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        byte[] byArray2 = pixelData;
        int n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            b = byArray2[n];
            Assert.assertEquals((String)":e:", (long)0L, (long)b);
            ++n;
        }
        values = new byte[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":g:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        byArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            b = byArray2[n];
            Assert.assertEquals((String)":i:", (long)0L, (long)b);
            ++n;
        }
        values = new byte[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":k:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        byArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            b = byArray2[n];
            Assert.assertEquals((String)":m:", (long)0L, (long)b);
            ++n;
        }
        values = new byte[]{1, 2, 3, 15, -1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":o:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":p:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for getWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.getPixels(0, 1, 100, pixelData, 10));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for pixels == null", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 1, 10, null, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(-1, 1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(10, 1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(0, -1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 10, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for getWidth < 0", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 1, -1, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, ex);
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
        SWTException swtEx = (SWTException)Assert.assertThrows((String)"No exception thrown for invalid depth", SWTException.class, () -> this.imageData.getPixels(0, 1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid depth", 38, swtEx);
    }

    @Test
    public void test_getPixelsIII$II() {
        int data;
        int[] pixelData = new int[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int[] nArray = pixelData;
        int n = pixelData.length;
        int n2 = 0;
        while (n2 < n) {
            int data2 = nArray[n2];
            Assert.assertEquals((String)":a:", (long)0L, (long)data2);
            ++n2;
        }
        int[] values = new int[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":c:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        int[] nArray2 = pixelData;
        int n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":e:", (long)0L, (long)data);
            ++n;
        }
        values = new int[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":g:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        nArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":i:", (long)0L, (long)data);
            ++n;
        }
        values = new int[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":k:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        nArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":m:", (long)0L, (long)data);
            ++n;
        }
        values = new int[]{1, 2, 3, 15, 255};
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":o:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":p:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 16, new PaletteData(63488, 2016, 31));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        nArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":q:", (long)0L, (long)data);
            ++n;
        }
        int[] nArray3 = new int[5];
        nArray3[1] = 2;
        nArray3[2] = 15;
        nArray3[3] = 255;
        nArray3[4] = 65450;
        values = nArray3;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":r:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":s:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":t:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 24, new PaletteData(0xFF0000, 65280, 255));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        nArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":u:", (long)0L, (long)data);
            ++n;
        }
        int[] nArray4 = new int[4];
        nArray4[1] = 255;
        nArray4[2] = 65450;
        nArray4[3] = 0xFF00AA;
        values = nArray4;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":v:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":w:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":x:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(-16777216, 65280, 255));
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        nArray2 = pixelData;
        n3 = pixelData.length;
        n = 0;
        while (n < n3) {
            data = nArray2[n];
            Assert.assertEquals((String)":y:", (long)0L, (long)data);
            ++n;
        }
        int[] nArray5 = new int[4];
        nArray5[1] = 255;
        nArray5[2] = 65450;
        nArray5[3] = -16733696;
        values = nArray5;
        this.imageData.setPixels(0, 1, values.length, values, 0);
        this.imageData.getPixels(0, 1, 10, pixelData, 10);
        i = 0;
        while (i < pixelData.length) {
            if (i < 10) {
                Assert.assertEquals((String)":z:", (long)0L, (long)pixelData[i]);
            } else if (i < 10 + values.length) {
                Assert.assertEquals((String)":aa:", (long)values[i - 10], (long)pixelData[i]);
            } else if (i < 20) {
                Assert.assertEquals((String)":ab:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for getWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.getPixels(0, 1, 100, pixelData, 10));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for pixels == null", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 1, 10, null, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(-1, 1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(10, 1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(0, -1, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 10, 10, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for getWidth < 0", IllegalArgumentException.class, () -> this.imageData.getPixels(0, 1, -1, pixelData, 10));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for getWidth < 0", 5, ex);
    }

    @Test
    public void test_getRGBs() {
        Assert.assertNull((String)":a:", (Object)this.imageData.getRGBs());
        Object[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        this.imageData = new ImageData(10, 10, 8, new PaletteData((RGB[])rgbs));
        Assert.assertArrayEquals((String)":b:", (Object[])rgbs, (Object[])this.imageData.getRGBs());
    }

    @Test
    public void test_getTransparencyMask() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream stream = this.getClass().getResourceAsStream(SwtTestUtil.transparentImageFilenames[0]);){
            Image image = new Image((Device)Display.getDefault(), stream);
            this.imageData = image.getImageData();
            ImageData maskData = this.imageData.getTransparencyMask();
            Assert.assertNotNull((String)":b:", (Object)maskData);
            image.dispose();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void test_getTransparencyType() throws IOException {
        Image image;
        InputStream stream;
        Assert.assertEquals((String)":a:", (long)0L, (long)this.imageData.getTransparencyType());
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            stream = this.getClass().getResourceAsStream(SwtTestUtil.transparentImageFilenames[0]);
            try {
                image = new Image((Device)Display.getDefault(), stream);
                this.imageData = image.getImageData();
                Assert.assertNotEquals((String)":b:", (long)0L, (long)this.imageData.getTransparencyType());
                image.dispose();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try {
            stream = this.getClass().getResourceAsStream(SwtTestUtil.imageFilenames[0] + "." + SwtTestUtil.imageFormats[SwtTestUtil.imageFormats.length - 1]);
            try {
                image = new Image((Device)Display.getDefault(), stream);
                this.imageData = image.getImageData();
                Assert.assertEquals((String)":c:", (long)0L, (long)this.imageData.getTransparencyType());
                image.dispose();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void test_scaledToII() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        byte[] pixelData = new byte[8];
        pixelData[0] = 79;
        this.imageData = new ImageData(8, 8, 1, new PaletteData(rgbs), 1, pixelData);
        ImageData scaledImageData = this.imageData.scaledTo(-8, -8);
        byte[] scaledPixelData = new byte[8];
        scaledImageData.getPixels(0, 7, scaledPixelData.length, scaledPixelData, 0);
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[6] = 1;
        byte[] expectedPixelData = byArray;
        Assert.assertArrayEquals((String)":a:", (byte[])expectedPixelData, (byte[])scaledPixelData);
        scaledImageData = this.imageData.scaledTo(80, 8);
        scaledPixelData = new byte[80];
        scaledImageData.getPixels(0, 0, scaledPixelData.length, scaledPixelData, 0);
        Assert.assertEquals((String)":b:", (long)0L, (long)scaledPixelData[0]);
        Assert.assertEquals((String)":c:", (long)0L, (long)scaledPixelData[1]);
        scaledImageData = this.imageData.scaledTo(8, 80);
        scaledPixelData = new byte[8];
        scaledImageData.getPixels(0, 0, scaledPixelData.length, scaledPixelData, 0);
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArray2[6] = 1;
        byArray2[7] = 1;
        expectedPixelData = byArray2;
        Assert.assertArrayEquals((String)":d:", (byte[])expectedPixelData, (byte[])scaledPixelData);
    }

    @Test
    public void test_setAlphaIII() {
        int value = 170;
        this.imageData.setAlpha(0, 0, value);
        Assert.assertEquals((String)":a:", (long)value, (long)this.imageData.getAlpha(0, 0));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlpha(-1, 1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlpha(10, 1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlpha(0, -1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlpha(0, 10, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
    }

    @Test
    public void test_setAlphasIII$BI() {
        byte[] alphaData = new byte[20];
        byte value = -86;
        byte[] values = new byte[]{value, (byte)(value + 1), (byte)(value + 2), (byte)(value + 3), (byte)(value + 4)};
        this.imageData.setAlphas(0, 1, values.length - 1, values, 1);
        this.imageData.getAlphas(0, 1, 10, alphaData, 0);
        int i = 0;
        while (i < alphaData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)alphaData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)alphaData[i]);
            }
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for putWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.setAlphas(0, 1, 100, alphaData, 1));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for alphas == null", IllegalArgumentException.class, () -> this.imageData.setAlphas(0, 1, 10, null, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for alphas == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlphas(-1, 1, 10, alphaData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlphas(10, 1, 10, alphaData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlphas(0, -1, 10, alphaData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setAlphas(0, 10, 10, alphaData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for putWidth < 0", IllegalArgumentException.class, () -> this.imageData.setAlphas(0, 1, -1, alphaData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, ex);
    }

    @Test
    public void test_setPixelIII() {
        int value = 170;
        this.imageData.setPixel(0, 0, value);
        Assert.assertEquals((String)":a:", (long)value, (long)this.imageData.getPixel(0, 0));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixel(-1, 1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixel(10, 1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixel(0, -1, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixel(0, 10, value));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
    }

    @Test
    public void test_setPixelsIII$BI() {
        byte[] pixelData = new byte[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        byte[] values = new byte[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        int i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":c:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":e:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new byte[]{1, 2, 3, 15, -1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":g:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for putWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.setPixels(0, 1, 100, pixelData, 1));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for pixels == null", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 1, 10, null, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(-1, 1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(10, 1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(0, -1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 10, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for putWidth < 0", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 1, -1, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, ex);
        this.imageData = new ImageData(10, 10, 32, new PaletteData(0xFF0000, 65280, 255));
        SWTException swtEx = (SWTException)Assert.assertThrows((String)"No exception thrown for invalid depth", SWTException.class, () -> this.imageData.setPixels(0, 1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for invalid depth", 38, swtEx);
    }

    @Test
    public void test_setPixelsIII$II() {
        int[] pixelData = new int[20];
        this.imageData = new ImageData(10, 10, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        int[] values = new int[]{1, 1, 1, 1, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        int i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":a:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":b:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 2, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 2, 1};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":c:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":d:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 4, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 4, 15};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":e:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":f:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 8, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}));
        values = new int[]{1, 2, 3, 15, 255};
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":g:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":h:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 16, new PaletteData(63488, 2016, 31));
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 15;
        nArray[3] = 255;
        nArray[4] = 65450;
        values = nArray;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":i:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":j:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 24, new PaletteData(0xFF0000, 65280, 255));
        int[] nArray2 = new int[4];
        nArray2[1] = 255;
        nArray2[2] = 65450;
        nArray2[3] = 0xFF00AA;
        values = nArray2;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":k:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":l:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        this.imageData = new ImageData(10, 10, 32, new PaletteData(-16777216, 65280, 255));
        int[] nArray3 = new int[4];
        nArray3[1] = 255;
        nArray3[2] = 65450;
        nArray3[3] = -16733696;
        values = nArray3;
        this.imageData.setPixels(0, 1, values.length - 1, values, 1);
        this.imageData.getPixels(0, 1, 10, pixelData, 0);
        i = 0;
        while (i < pixelData.length) {
            if (i + 1 < values.length) {
                Assert.assertEquals((String)":m:", (long)values[i + 1], (long)pixelData[i]);
            } else {
                Assert.assertEquals((String)":n:", (long)0L, (long)pixelData[i]);
            }
            ++i;
        }
        Assert.assertThrows((String)"No exception thrown for putWidth out of bounds", IndexOutOfBoundsException.class, () -> this.imageData.setPixels(0, 1, 100, pixelData, 1));
        IllegalArgumentException ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for pixels == null", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 1, 10, null, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for pixels == null", 4, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(-1, 1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for x out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(10, 1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for x out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(0, -1, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for y out of bounds", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 10, 10, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for y out of bounds", 5, ex);
        ex = (IllegalArgumentException)Assert.assertThrows((String)"No exception thrown for putWidth < 0", IllegalArgumentException.class, () -> this.imageData.setPixels(0, 1, -1, pixelData, 1));
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for putWidth < 0", 5, ex);
    }
}

