/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class Test_org_eclipse_swt_graphics_ImageLoader {
    boolean loaderListenerCalled;

    @Test
    public void test_Constructor() {
        new ImageLoader();
    }

    @Test
    public void test_addImageLoaderListenerLorg_eclipse_swt_graphics_ImageLoaderListener() throws IOException {
        InputStream stream;
        ImageLoader loader = new ImageLoader();
        ImageLoaderListener loaderListener = e -> {
            boolean bl = this.loaderListenerCalled = true;
        };
        Assertions.assertThrows(IllegalArgumentException.class, () -> loader.addImageLoaderListener(null), (String)"No exception thrown for addImageLoaderListener with null argument");
        Assert.assertFalse((String)":a:", (boolean)loader.hasListeners());
        loader.addImageLoaderListener(loaderListener);
        Assert.assertTrue((String)":b:", (boolean)loader.hasListeners());
        this.loaderListenerCalled = false;
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            stream = SwtTestUtil.class.getResourceAsStream("interlaced_target.png");
            try {
                loader.load(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((String)":c:", (boolean)this.loaderListenerCalled);
        this.loaderListenerCalled = false;
        throwable = null;
        var4_6 = null;
        try {
            stream = SwtTestUtil.class.getResourceAsStream("target.png");
            try {
                loader.load(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Assert.assertFalse((String)":d:", (boolean)this.loaderListenerCalled);
        this.loaderListenerCalled = false;
        loader.notifyListeners(new ImageLoaderEvent(loader, loader.data[0], 0, true));
        Assert.assertTrue((String)":e:", (boolean)this.loaderListenerCalled);
        loader.removeImageLoaderListener(loaderListener);
        Assert.assertFalse((String)":f:", (boolean)loader.hasListeners());
    }

    @Test
    public void test_loadLjava_io_InputStream() throws IOException {
        ImageLoader loader = new ImageLoader();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImageData[] imageDataArray = loader.load(null);
        }, (String)"No exception thrown for load inputStream == null");
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = SwtTestUtil.class.getResourceAsStream("empty.txt");){
            Assertions.assertThrows(SWTException.class, () -> {
                ImageData[] imageDataArray = loader.load(stream);
            }, (String)"No exception thrown for load from invalid inputStream");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String fileName = SwtTestUtil.imageFilenames[0];
        String[] stringArray = SwtTestUtil.imageFormats;
        int n = SwtTestUtil.imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            Throwable throwable3 = null;
            Object var8_12 = null;
            try (InputStream stream = SwtTestUtil.class.getResourceAsStream(fileName + "." + format);){
                loader.load(stream);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++n2;
        }
    }

    @Test
    public void test_loadLjava_lang_String() {
        ImageLoader loader = new ImageLoader();
        String filename = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImageData[] imageDataArray = loader.load(filename);
        }, (String)"No exception thrown for load filename == null");
    }

    @Test
    public void test_saveLjava_io_OutputStreamI() throws IOException {
        ImageLoader loader = new ImageLoader();
        OutputStream outStream1 = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> loader.save(outStream1, 0), (String)"No exception thrown for save outputStream == null");
        ByteArrayOutputStream outStream2 = new ByteArrayOutputStream();
        Assertions.assertThrows(SWTException.class, () -> loader.save(outStream2, -1), (String)"No exception thrown for save to invalid outputStream format");
        boolean jpgSupported = Arrays.asList(SwtTestUtil.imageFormats).contains("jpg");
        if (jpgSupported) {
            String filename = SwtTestUtil.imageFilenames[0];
            String filetype = "jpg";
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream inStream = SwtTestUtil.class.getResourceAsStream(filename + "." + filetype);){
                loader.load(inStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int i = 0;
            String[] stringArray = SwtTestUtil.imageFormats;
            int n = SwtTestUtil.imageFormats.length;
            int n2 = 0;
            while (n2 < n) {
                String format = stringArray[n2];
                if (format.equals(filetype)) {
                    loader.save((OutputStream)outStream, i++);
                    break;
                }
                ++n2;
            }
        }
    }

    @Test
    public void test_saveLjava_lang_StringI() {
        ImageLoader loader = new ImageLoader();
        String filename = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> loader.save(filename, 0), (String)"No exception thrown for save filename == null");
    }

    @Test
    public void test_bug547529() {
        Display display = Display.getDefault();
        try {
            int imageWidth = 8;
            int imageHeight = 8;
            int imageDepth = SwtTestUtil.isGTK ? 32 : 24;
            int RED = 0xFF0000;
            int GREEN = 65280;
            int BLUE = 255;
            PaletteData palette = new PaletteData(RED, GREEN, BLUE);
            ImageData imageData = new ImageData(imageWidth, imageHeight, imageDepth, palette);
            int w = imageWidth / 2;
            int h = imageHeight / 2;
            int y = 0;
            while (y < imageHeight) {
                int x = 0;
                while (x < imageWidth) {
                    int color = 0;
                    if (x < w && y < h) {
                        color = RED;
                    } else if (x < w && y >= h) {
                        color = GREEN;
                    } else if (x >= w && y < h) {
                        color = BLUE;
                    }
                    imageData.setPixel(x, y, color);
                    ++x;
                }
                ++y;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageLoader saver = new ImageLoader();
            saver.data = new ImageData[]{imageData};
            saver.save((OutputStream)outputStream, 5);
            byte[] savedBytes = imageData.data;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ImageLoader loader = new ImageLoader();
            loader.load((InputStream)inputStream);
            ImageData[] loadedData = loader.data;
            Assert.assertEquals((String)"ImageLoader loaded incorrect number of ImageData objects", (long)1L, (long)loadedData.length);
            byte[] loadedBytes = loadedData[0].data;
            Assert.assertArrayEquals((byte[])savedBytes, (byte[])loadedBytes);
        }
        finally {
            display.dispose();
        }
    }
}

