/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_PaletteData {
    @Test
    public void test_Constructor$Lorg_eclipse_swt_graphics_RGB() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PaletteData paletteData = new PaletteData(null);
        }, (String)"No exception thrown for rgb == null");
        PaletteData data = new PaletteData(new RGB[0]);
        Assertions.assertFalse((boolean)data.isDirect);
        new PaletteData(new RGB[2]);
        Assertions.assertFalse((boolean)data.isDirect);
        new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        Assertions.assertFalse((boolean)data.isDirect);
    }

    @Test
    public void test_ConstructorIII() {
        PaletteData data = new PaletteData(0, 0, 0);
        Assertions.assertTrue((boolean)data.isDirect);
        data = new PaletteData(-1, -1, -1);
        Assertions.assertTrue((boolean)data.isDirect);
        data = new PaletteData(0xFF0000, 65280, 255);
        Assertions.assertTrue((boolean)data.isDirect);
    }

    @Test
    public void test_getPixelLorg_eclipse_swt_graphics_RGB() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)};
        PaletteData data = new PaletteData(rgbs);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            int n = data.getPixel(null);
        }, (String)"No exception thrown for indexed palette with rgb == null");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            int n = data.getPixel(new RGB(0, 0, 1));
        }, (String)"No exception thrown for rgb not found");
        Assertions.assertEquals((int)(rgbs.length - 1), (int)data.getPixel(rgbs[rgbs.length - 1]));
        RGB rgb = new RGB(50, 100, 150);
        PaletteData data1 = new PaletteData(0xFF0000, 65280, 255);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            int n = data.getPixel(null);
        }, (String)"No exception thrown for direct palette with rgb == null");
        Assertions.assertEquals((int)3302550, (int)data1.getPixel(rgb));
    }

    @Test
    public void test_getRGBI() {
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255), new RGB(50, 100, 150)};
        PaletteData data = new PaletteData(rgbs);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = data.getRGB(rgbs.length);
        }, (String)"No exception thrown for nonexistent pixel");
        Assertions.assertEquals((Object)rgbs[rgbs.length - 1], (Object)data.getRGB(rgbs.length - 1));
        RGB rgb = new RGB(50, 100, 150);
        PaletteData data1 = new PaletteData(0xFF0000, 65280, 255);
        Assertions.assertEquals((Object)rgb, (Object)data1.getRGB(3302550));
    }

    @Test
    public void test_getRGBs() {
        Object[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        PaletteData data = new PaletteData((RGB[])rgbs);
        Assertions.assertArrayEquals((Object[])rgbs, (Object[])data.getRGBs());
        data = new PaletteData(0xFF0000, 65280, 255);
        Assertions.assertNull((Object)data.getRGBs());
    }
}

