/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_Path {
    private Display display;

    @BeforeEach
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void createTransform() {
        Path path = new Path((Device)this.display);
        Assertions.assertFalse((boolean)path.isDisposed(), (String)"Constructor for Path didn't initialize");
        path.dispose();
    }

    @Test
    public void testClonePath() {
        Assumptions.assumeFalse((boolean)SwtTestUtil.isCocoa, (String)"Not currently working on macOS, cloning the path leads to not equal pathData.");
        Display display = Display.getDefault();
        Path path = new Path((Device)display);
        path.addArc(0.0f, 0.0f, 10.0f, 10.0f, 0.0f, 90.0f);
        path.addRectangle(10.0f, 10.0f, 50.0f, 50.0f);
        path.quadTo(30.0f, 30.0f, 20.0f, 40.0f);
        Path path2 = new Path((Device)display);
        path2.addArc(0.0f, 0.0f, 30.0f, 30.0f, 0.0f, 270.0f);
        path.addPath(path2);
        PathData pathData = path.getPathData();
        Path clonedPath = new Path((Device)display, path, 0.0f);
        PathData clonedPathData = clonedPath.getPathData();
        Assertions.assertArrayEquals((float[])pathData.points, (float[])clonedPathData.points, (float)0.001f);
        path.dispose();
        path2.dispose();
        clonedPath.dispose();
    }

    @Test
    public void disposePath() {
        Path path = new Path((Device)this.display);
        path.addArc(0.0f, 0.0f, 10.0f, 10.0f, 0.0f, 90.0f);
        Assertions.assertFalse((boolean)path.isDisposed(), (String)"Path should not be in the disposed state");
        int i = 0;
        while (i < 2) {
            path.dispose();
            Assertions.assertTrue((boolean)path.isDisposed(), (String)"Path should be in the disposed state");
            ++i;
        }
    }

    @Test
    public void testToString() {
        Path path = new Path((Device)this.display);
        String s = path.toString();
        Assertions.assertNotNull((Object)s);
        Assertions.assertFalse((boolean)s.isEmpty());
        path.addArc(0.0f, 0.0f, 10.0f, 10.0f, 0.0f, 90.0f);
        s = path.toString();
        Assertions.assertNotNull((Object)s);
        Assertions.assertFalse((boolean)s.isEmpty());
        path.dispose();
        s = path.toString();
        Assertions.assertNotNull((Object)s);
        Assertions.assertFalse((boolean)s.isEmpty());
    }
}

