/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.RGB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_RGB {
    @Test
    public void test_ConstructorIII() {
        new RGB(20, 100, 200);
        new RGB(0, 0, 0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(-1, 20, 50);
        }, (String)"No exception thrown for red < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(256, 20, 50);
        }, (String)"No exception thrown for red > 255");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(20, -1, 50);
        }, (String)"No exception thrown for green < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(20, 256, 50);
        }, (String)"No exception thrown for green > 255");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(20, 50, -1);
        }, (String)"No exception thrown for blue < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(20, 50, 256);
        }, (String)"No exception thrown for blue > 255");
    }

    @Test
    public void test_ConstructorFFF() {
        new RGB(0.0f, 0.0f, 0.0f);
        new RGB(0.0f, 1.0f, 0.0f);
        new RGB(0.0f, 0.0f, 1.0f);
        new RGB(0.0f, 0.6f, 0.4f);
        new RGB(1.0f, 0.0f, 1.0f);
        new RGB(1.0f, 1.0f, 1.0f);
        new RGB(1.0f, 0.0f, 1.0f);
        new RGB(1.0f, 1.0f, 0.0f);
        new RGB(1.0f, 0.6f, 0.4f);
        new RGB(59.0f, 0.0f, 1.0f);
        new RGB(59.0f, 1.0f, 1.0f);
        new RGB(59.0f, 0.0f, 1.0f);
        new RGB(59.0f, 1.0f, 0.0f);
        new RGB(59.0f, 0.6f, 0.4f);
        new RGB(60.0f, 0.0f, 1.0f);
        new RGB(60.0f, 1.0f, 1.0f);
        new RGB(60.0f, 0.0f, 1.0f);
        new RGB(60.0f, 1.0f, 0.0f);
        new RGB(60.0f, 0.6f, 0.4f);
        new RGB(61.0f, 0.0f, 1.0f);
        new RGB(61.0f, 1.0f, 1.0f);
        new RGB(61.0f, 0.0f, 1.0f);
        new RGB(61.0f, 1.0f, 0.0f);
        new RGB(61.0f, 0.6f, 0.4f);
        new RGB(119.0f, 0.0f, 1.0f);
        new RGB(119.0f, 1.0f, 1.0f);
        new RGB(119.0f, 0.0f, 1.0f);
        new RGB(119.0f, 1.0f, 0.0f);
        new RGB(119.0f, 0.6f, 0.4f);
        new RGB(120.0f, 0.0f, 1.0f);
        new RGB(120.0f, 1.0f, 1.0f);
        new RGB(120.0f, 0.0f, 1.0f);
        new RGB(120.0f, 1.0f, 0.0f);
        new RGB(120.0f, 0.6f, 0.4f);
        new RGB(121.0f, 0.0f, 1.0f);
        new RGB(121.0f, 1.0f, 1.0f);
        new RGB(121.0f, 0.0f, 1.0f);
        new RGB(121.0f, 1.0f, 0.0f);
        new RGB(121.0f, 0.6f, 0.4f);
        new RGB(179.0f, 0.0f, 1.0f);
        new RGB(179.0f, 1.0f, 1.0f);
        new RGB(179.0f, 0.0f, 1.0f);
        new RGB(179.0f, 1.0f, 0.0f);
        new RGB(179.0f, 0.6f, 0.4f);
        new RGB(180.0f, 0.0f, 1.0f);
        new RGB(180.0f, 1.0f, 1.0f);
        new RGB(180.0f, 0.0f, 1.0f);
        new RGB(180.0f, 1.0f, 0.0f);
        new RGB(180.0f, 0.6f, 0.4f);
        new RGB(181.0f, 0.0f, 1.0f);
        new RGB(181.0f, 1.0f, 1.0f);
        new RGB(181.0f, 0.0f, 1.0f);
        new RGB(181.0f, 1.0f, 0.0f);
        new RGB(181.0f, 0.6f, 0.4f);
        new RGB(239.0f, 0.0f, 1.0f);
        new RGB(239.0f, 1.0f, 1.0f);
        new RGB(239.0f, 0.0f, 1.0f);
        new RGB(239.0f, 1.0f, 0.0f);
        new RGB(239.0f, 0.6f, 0.4f);
        new RGB(240.0f, 0.0f, 1.0f);
        new RGB(240.0f, 1.0f, 1.0f);
        new RGB(240.0f, 0.0f, 1.0f);
        new RGB(240.0f, 1.0f, 0.0f);
        new RGB(240.0f, 0.6f, 0.4f);
        new RGB(241.0f, 0.0f, 1.0f);
        new RGB(241.0f, 1.0f, 1.0f);
        new RGB(241.0f, 0.0f, 1.0f);
        new RGB(241.0f, 1.0f, 0.0f);
        new RGB(241.0f, 0.6f, 0.4f);
        new RGB(299.0f, 0.0f, 1.0f);
        new RGB(299.0f, 1.0f, 1.0f);
        new RGB(299.0f, 0.0f, 1.0f);
        new RGB(299.0f, 1.0f, 0.0f);
        new RGB(299.0f, 0.6f, 0.4f);
        new RGB(300.0f, 0.0f, 1.0f);
        new RGB(300.0f, 1.0f, 1.0f);
        new RGB(300.0f, 0.0f, 1.0f);
        new RGB(300.0f, 1.0f, 0.0f);
        new RGB(300.0f, 0.6f, 0.4f);
        new RGB(301.0f, 0.0f, 1.0f);
        new RGB(301.0f, 1.0f, 1.0f);
        new RGB(301.0f, 0.0f, 1.0f);
        new RGB(301.0f, 1.0f, 0.0f);
        new RGB(301.0f, 0.6f, 0.4f);
        new RGB(359.0f, 0.0f, 1.0f);
        new RGB(359.0f, 1.0f, 1.0f);
        new RGB(359.0f, 0.0f, 1.0f);
        new RGB(359.0f, 1.0f, 0.0f);
        new RGB(359.0f, 0.6f, 0.4f);
        new RGB(360.0f, 0.0f, 1.0f);
        new RGB(360.0f, 1.0f, 1.0f);
        new RGB(360.0f, 0.0f, 1.0f);
        new RGB(360.0f, 1.0f, 0.0f);
        new RGB(360.0f, 0.6f, 0.4f);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(400.0f, 0.5f, 0.5f);
        }, (String)"No exception thrown for hue > 360");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(-5.0f, 0.5f, 0.5f);
        }, (String)"No exception thrown for hue < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(200.0f, -0.5f, 0.5f);
        }, (String)"No exception thrown for saturation < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(200.0f, 300.0f, 0.5f);
        }, (String)"No exception thrown for saturation > 1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(200.0f, 0.5f, -0.5f);
        }, (String)"No exception thrown for brightness < 0");
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RGB rGB = new RGB(200.0f, 0.5f, 400.0f);
        }, (String)"No exception thrown for brightness > 1");
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        float bright;
        float sat;
        float hue;
        RGB rgb1;
        int r = 0;
        int g = 127;
        int b = 254;
        RGB rgb2 = rgb1 = new RGB(r, g, b);
        if (!rgb1.equals((Object)rgb2)) {
            Assertions.fail((String)"Two references to the same RGB instance not found equal");
        }
        if (!rgb1.equals((Object)(rgb2 = new RGB(r, g, b)))) {
            Assertions.fail((String)"References to two different RGB instances with same R G B parameters not found equal");
        }
        if (rgb1.equals((Object)new RGB(r + 1, g, b)) || rgb1.equals((Object)new RGB(r, g + 1, b)) || rgb1.equals((Object)new RGB(r, g, b + 1)) || rgb1.equals((Object)new RGB(r + 1, g + 1, b + 1))) {
            Assertions.fail((String)"Comparing two RGB instances with different combination of R G B parameters found equal");
        }
        if (!rgb1.equals((Object)(rgb2 = (rgb1 = new RGB(hue = 220.0f, sat = 0.6f, bright = 0.7f))))) {
            Assertions.fail((String)"Two references to the same RGB instance not found equal");
        }
        if (!rgb1.equals((Object)(rgb2 = new RGB(hue, sat, bright)))) {
            Assertions.fail((String)"References to two different RGB instances with same H S B parameters not found equal");
        }
        if (rgb1.equals((Object)new RGB(hue + 1.0f, sat, bright)) || rgb1.equals((Object)new RGB(hue, sat + 0.1f, bright)) || rgb1.equals((Object)new RGB(hue, sat, bright + 0.1f)) || rgb1.equals((Object)new RGB(hue + 1.0f, sat + 0.1f, bright + 0.1f))) {
            Assertions.fail((String)"Comparing two RGB instances with different combination of H S B parameters found equal");
        }
    }

    @Test
    public void test_getHSB() {
        float[] hsb = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.6f, 0.4f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.6f, 0.4f, 59.0f, 0.0f, 1.0f, 59.0f, 1.0f, 1.0f, 59.0f, 0.0f, 1.0f, 59.0f, 1.0f, 0.0f, 59.0f, 0.6f, 0.4f, 60.0f, 0.0f, 1.0f, 60.0f, 1.0f, 1.0f, 60.0f, 0.0f, 1.0f, 60.0f, 1.0f, 0.0f, 60.0f, 0.6f, 0.4f, 61.0f, 0.0f, 1.0f, 61.0f, 1.0f, 1.0f, 61.0f, 0.0f, 1.0f, 61.0f, 1.0f, 0.0f, 61.0f, 0.6f, 0.4f, 119.0f, 0.0f, 1.0f, 119.0f, 1.0f, 1.0f, 119.0f, 0.0f, 1.0f, 119.0f, 1.0f, 0.0f, 119.0f, 0.6f, 0.4f, 120.0f, 0.0f, 1.0f, 120.0f, 1.0f, 1.0f, 120.0f, 0.0f, 1.0f, 120.0f, 1.0f, 0.0f, 120.0f, 0.6f, 0.4f, 121.0f, 0.0f, 1.0f, 121.0f, 1.0f, 1.0f, 121.0f, 0.0f, 1.0f, 121.0f, 1.0f, 0.0f, 121.0f, 0.6f, 0.4f, 179.0f, 0.0f, 1.0f, 179.0f, 1.0f, 1.0f, 179.0f, 0.0f, 1.0f, 179.0f, 1.0f, 0.0f, 179.0f, 0.6f, 0.4f, 180.0f, 0.0f, 1.0f, 180.0f, 1.0f, 1.0f, 180.0f, 0.0f, 1.0f, 180.0f, 1.0f, 0.0f, 180.0f, 0.6f, 0.4f, 181.0f, 0.0f, 1.0f, 181.0f, 1.0f, 1.0f, 181.0f, 0.0f, 1.0f, 181.0f, 1.0f, 0.0f, 181.0f, 0.6f, 0.4f, 239.0f, 0.0f, 1.0f, 239.0f, 1.0f, 1.0f, 239.0f, 0.0f, 1.0f, 239.0f, 1.0f, 0.0f, 239.0f, 0.6f, 0.4f, 240.0f, 0.0f, 1.0f, 240.0f, 1.0f, 1.0f, 240.0f, 0.0f, 1.0f, 240.0f, 1.0f, 0.0f, 240.0f, 0.6f, 0.4f, 241.0f, 0.0f, 1.0f, 241.0f, 1.0f, 1.0f, 241.0f, 0.0f, 1.0f, 241.0f, 1.0f, 0.0f, 241.0f, 0.6f, 0.4f, 299.0f, 0.0f, 1.0f, 299.0f, 1.0f, 1.0f, 299.0f, 0.0f, 1.0f, 299.0f, 1.0f, 0.0f, 299.0f, 0.6f, 0.4f, 300.0f, 0.0f, 1.0f, 300.0f, 1.0f, 1.0f, 300.0f, 0.0f, 1.0f, 300.0f, 1.0f, 0.0f, 300.0f, 0.6f, 0.4f, 301.0f, 0.0f, 1.0f, 301.0f, 1.0f, 1.0f, 301.0f, 0.0f, 1.0f, 301.0f, 1.0f, 0.0f, 301.0f, 0.6f, 0.4f, 359.0f, 0.0f, 1.0f, 359.0f, 1.0f, 1.0f, 359.0f, 0.0f, 1.0f, 359.0f, 1.0f, 0.0f, 359.0f, 0.6f, 0.4f, 360.0f, 0.0f, 1.0f, 360.0f, 1.0f, 1.0f, 360.0f, 0.0f, 1.0f, 360.0f, 1.0f, 0.0f, 360.0f, 0.6f, 0.4f, 220.0f, 0.6f, 0.7f};
        int i = 0;
        while (i < hsb.length) {
            RGB rgb1 = new RGB(hsb[i], hsb[i + 1], hsb[i + 2]);
            float[] hsb2 = rgb1.getHSB();
            RGB rgb2 = new RGB(hsb2[0], hsb2[1], hsb2[2]);
            Assertions.assertEquals((Object)rgb1, (Object)rgb2, (String)"Two references to the same RGB using getHSB() function not found equal");
            i += 3;
        }
    }

    @Test
    public void test_hashCode() {
        int r = 255;
        int g = 100;
        int b = 0;
        RGB rgb1 = new RGB(r, g, b);
        RGB rgb2 = new RGB(r, g, b);
        int hash1 = rgb1.hashCode();
        int hash2 = rgb2.hashCode();
        Assertions.assertEquals((int)hash1, (int)hash2, (String)"Two RGB instances with same R G B parameters returned different hash codes");
        Assertions.assertTrue((rgb1.hashCode() != new RGB(g, b, r).hashCode() && rgb1.hashCode() != new RGB(b, r, g).hashCode() ? 1 : 0) != 0, (String)"Two RGB instances with different R G B parameters returned the same hash code");
    }

    @Test
    public void test_toString() {
        RGB rgb = new RGB(0, 100, 200);
        String s = rgb.toString();
        Assertions.assertTrue((s != null && s.length() != 0 ? 1 : 0) != 0, (String)"RGB.toString returns a null or empty String");
    }
}

