/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_graphics_Rectangle {
    @Test
    public void test_ConstructorIIII() {
        Rectangle r = new Rectangle(3, 4, 5, 6);
        Assertions.assertEquals((int)3, (int)r.x);
        Assertions.assertEquals((int)4, (int)r.y);
        Assertions.assertEquals((int)5, (int)r.width);
        Assertions.assertEquals((int)6, (int)r.height);
        r = new Rectangle(-4, -3, -2, -1);
        Assertions.assertEquals((int)-4, (int)r.x);
        Assertions.assertEquals((int)-3, (int)r.y);
        Assertions.assertEquals((int)-2, (int)r.width);
        Assertions.assertEquals((int)-1, (int)r.height);
        r = new Rectangle(500000, 700000, 200000, 100000);
        Assertions.assertEquals((int)500000, (int)r.x);
        Assertions.assertEquals((int)700000, (int)r.y);
        Assertions.assertEquals((int)200000, (int)r.width);
        Assertions.assertEquals((int)100000, (int)r.height);
    }

    @Test
    public void test_addLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        r1.add(r2);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 4, 4), (Object)r1, (String)"Rectangle add incorrect");
        r1.add(r2);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 4, 4), (Object)r1, (String)"Rectangle add incorrect");
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, 0, 0);
        r1.add(r2);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)r1, (String)"Rectangle add incorrect");
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(6, 6, 0, 0);
        r1.add(r2);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 5, 4), (Object)r1, (String)"Rectangle add incorrect");
        Rectangle r = new Rectangle(1, 2, 3, 4);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> r.add(null), (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_containsII() {
        Rectangle r = new Rectangle(1, 2, 3, 4);
        Assertions.assertTrue((boolean)r.contains(1, 2), (String)"Rectangle should contain point (1, 2)");
        Assertions.assertTrue((boolean)r.contains(3, 4), (String)"Rectangle should contain point (3, 4)");
        Assertions.assertTrue((boolean)r.contains(3, 5), (String)"Rectangle should contain point (3, 5)");
        Assertions.assertFalse((boolean)r.contains(9, 10), (String)"Rectangle should not contain point (9, 10)");
        Assertions.assertFalse((boolean)r.contains(-1, -1), (String)"Rectangle should not contain point (-1, -1)");
    }

    @Test
    public void test_containsLorg_eclipse_swt_graphics_Point() {
        Rectangle r = new Rectangle(1, 2, 3, 4);
        Assertions.assertTrue((boolean)r.contains(new Point(1, 2)), (String)"Rectangle should contain Point(1, 2)");
        Assertions.assertTrue((boolean)r.contains(new Point(3, 4)), (String)"Rectangle should contain Point(3, 4)");
        Assertions.assertTrue((boolean)r.contains(new Point(3, 5)), (String)"Rectangle should contain point (3, 5)");
        Assertions.assertFalse((boolean)r.contains(new Point(9, 10)), (String)"Rectangle should not contain Point(9, 10)");
        Assertions.assertFalse((boolean)r.contains(new Point(-1, -1)), (String)"Rectangle should not contain point (-1, -1)");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = r.contains(null);
        }, (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Rectangle r1 = new Rectangle(5, 4, 3, 2);
        Rectangle r2 = new Rectangle(5, 4, 3, 2);
        Assertions.assertTrue((boolean)r1.equals((Object)r2), (String)"Rectangles should be equal");
        r2 = new Rectangle(3, 4, 5, 6);
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rectangles should not be equal");
        r2 = new Rectangle(2, 3, 4, 5);
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rectangles should not be equal");
        r2 = new Rectangle(5, 4, 2, 3);
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rectangles should not be equal");
        r2 = new Rectangle(4, 5, 3, 2);
        Assertions.assertFalse((boolean)r1.equals((Object)r2), (String)"Rectangles should not be equal");
    }

    @Test
    public void test_hashCode() {
        Rectangle r1 = new Rectangle(5, 4, 3, 2);
        Rectangle r2 = new Rectangle(5, 4, 3, 2);
        Assertions.assertEquals((int)r2.hashCode(), (int)r1.hashCode(), (String)"Rectangles should have the same hashCode");
    }

    @Test
    public void test_intersectLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        r1.intersect(r2);
        Assertions.assertEquals((Object)new Rectangle(3, 3, 1, 2), (Object)r1, (String)"Rectangle intersect incorrect");
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, 0, 0);
        r1.intersect(r2);
        Assertions.assertEquals((Object)new Rectangle(3, 3, 0, 0), (Object)r1, (String)"Rectangle intersect incorrect");
        r1 = new Rectangle(1, 2, 3, 4);
        r2 = new Rectangle(3, 3, -1, -1);
        r1.intersect(r2);
        Assertions.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)r1, (String)"Rectangle intersect incorrect");
        Rectangle r = new Rectangle(1, 2, 3, 4);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> r.intersect(null), (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_intersectionLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        Assertions.assertEquals((Object)new Rectangle(3, 3, 1, 2), (Object)r1.intersection(r2), (String)"Rectangle intersection incorrect");
        r2 = new Rectangle(3, 3, 0, 0);
        Assertions.assertEquals((Object)new Rectangle(3, 3, 0, 0), (Object)r1.intersection(r2), (String)"Rectangle intersection incorrect");
        r2 = new Rectangle(3, 3, -1, -1);
        Assertions.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)r1.intersection(r2), (String)"Rectangle intersection incorrect");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Rectangle rectangle2 = r1.intersection(null);
        }, (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_intersectsIIII() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(2, 3, 7, 8);
        Assertions.assertTrue((boolean)r1.intersects(2, 3, 7, 8), (String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(2, 3, 7, 8)");
        Assertions.assertTrue((boolean)r2.intersects(1, 2, 3, 4), (String)"Rectangle(2, 3, 7, 8) should intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(200, 300, 400, 500);
        Assertions.assertFalse((boolean)r1.intersects(200, 300, 400, 500), (String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(200, 300, 400, 500)");
        Assertions.assertFalse((boolean)r2.intersects(1, 2, 3, 4), (String)"Rectangle(200, 300, 400, 500) should not intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(3, 3, 0, 0);
        Assertions.assertTrue((boolean)r1.intersects(3, 3, 0, 0), (String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(3, 3, 0, 0)");
        Assertions.assertTrue((boolean)r2.intersects(1, 2, 3, 4), (String)"Rectangle(3, 3, 0, 0) should intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(3, 3, -1, -1);
        Assertions.assertFalse((boolean)r1.intersects(3, 3, -1, -1), (String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(3, 3, -1, -1)");
        Assertions.assertFalse((boolean)r2.intersects(1, 2, 3, 4), (String)"Rectangle(3, 3, -1, -1) should not intersect Rectangle(1, 2, 3, 4)");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = r1.intersects(null);
        }, (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_intersectsLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(2, 3, 7, 8);
        Assertions.assertTrue((boolean)r1.intersects(r2), (String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(2, 3, 7, 8)");
        Assertions.assertTrue((boolean)r2.intersects(r1), (String)"Rectangle(2, 3, 7, 8) should intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(200, 300, 400, 500);
        Assertions.assertFalse((boolean)r1.intersects(r2), (String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(200, 300, 400, 500)");
        Assertions.assertFalse((boolean)r2.intersects(r1), (String)"Rectangle(200, 300, 400, 500) should not intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(3, 3, 0, 0);
        Assertions.assertTrue((boolean)r1.intersects(r2), (String)"Rectangle(1, 2, 3, 4) should intersect Rectangle(3, 3, 0, 0)");
        Assertions.assertTrue((boolean)r2.intersects(r1), (String)"Rectangle(3, 3, 0, 0) should intersect Rectangle(1, 2, 3, 4)");
        r2 = new Rectangle(3, 3, -1, -1);
        Assertions.assertFalse((boolean)r1.intersects(r2), (String)"Rectangle(1, 2, 3, 4) should not intersect Rectangle(3, 3, -1, -1)");
        Assertions.assertFalse((boolean)r2.intersects(r1), (String)"Rectangle(3, 3, -1, -1) should not intersect Rectangle(1, 2, 3, 4)");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = r1.intersects(null);
        }, (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }

    @Test
    public void test_isEmpty() {
        Rectangle r = new Rectangle(1, 2, 0, 0);
        Assertions.assertTrue((boolean)r.isEmpty(), (String)"Rectangle is empty");
        r = new Rectangle(1, 2, -3, -4);
        Assertions.assertTrue((boolean)r.isEmpty(), (String)"Rectangle is empty");
        r = new Rectangle(1, 2, 3, 4);
        Assertions.assertFalse((boolean)r.isEmpty(), (String)"Rectangle is not empty");
    }

    @Test
    public void test_toString() {
        Rectangle r = new Rectangle(3, 4, 5, 6);
        Assertions.assertNotNull((Object)r.toString());
        Assertions.assertTrue((r.toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Rectangle {3, 4, 5, 6}", (Object)r.toString());
    }

    @Test
    public void test_unionLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle r1 = new Rectangle(1, 2, 3, 4);
        Rectangle r2 = new Rectangle(3, 3, 2, 2);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 4, 4), (Object)r1.union(r2), (String)"Rectangle union incorrect");
        r2 = new Rectangle(3, 3, 0, 0);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)r1.union(r2), (String)"Rectangle union incorrect");
        r2 = new Rectangle(3, 3, -1, -1);
        Assertions.assertEquals((Object)new Rectangle(1, 2, 3, 4), (Object)r1.union(r2), (String)"Rectangle union incorrect");
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Rectangle rectangle2 = r1.union(null);
        }, (String)"No exception thrown for rectangle == null");
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle == null", 4, e);
    }
}

