/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Region {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_Constructor() {
        Region reg = new Region();
        if (reg.isDisposed()) {
            Assert.fail((String)"Constructor for Region didn't initialize");
        }
        reg.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device() {
        Region reg = new Region((Device)this.display);
        if (reg.isDisposed()) {
            Assert.fail((String)"Constructor for Region didn't initialize");
        }
        reg.dispose();
    }

    @Test
    public void test_add$I() {
        Region reg = new Region((Device)this.display);
        try {
            reg.add(null);
            reg.dispose();
            Assert.fail((String)"no exception thrown for adding a null rectangle");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        reg.dispose();
        try {
            reg.add(new int[0]);
            reg.dispose();
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg.dispose();
        reg = new Region((Device)this.display);
        int[] nArray = new int[8];
        nArray[2] = 50;
        nArray[4] = 50;
        nArray[5] = 25;
        nArray[7] = 25;
        reg.add(nArray);
        Rectangle box = reg.getBounds();
        reg.dispose();
        Rectangle expected = new Rectangle(0, 0, 50, 25);
        if (!box.equals((Object)expected)) {
            Assert.fail((String)("add 1 failed - expected: " + String.valueOf(expected) + " actual: " + String.valueOf(box)));
        }
        reg = new Region((Device)this.display);
        int[] nArray2 = new int[8];
        nArray2[2] = 50;
        nArray2[4] = 50;
        nArray2[5] = 25;
        nArray2[7] = 25;
        reg.add(nArray2);
        int[] nArray3 = new int[8];
        nArray3[1] = 25;
        nArray3[2] = 50;
        nArray3[3] = 25;
        nArray3[4] = 50;
        nArray3[5] = 40;
        nArray3[7] = 40;
        reg.add(nArray3);
        box = reg.getBounds();
        reg.dispose();
        expected = new Rectangle(0, 0, 50, 40);
        if (!box.equals((Object)expected)) {
            Assert.fail((String)("add 2 failed - expected: " + String.valueOf(expected) + " actual: " + String.valueOf(box)));
        }
    }

    @Test
    public void test_addLorg_eclipse_swt_graphics_Rectangle() {
        Region reg = new Region((Device)this.display);
        reg.add(new Rectangle(0, 0, 100, 50));
        reg.add(new Rectangle(200, 200, 10, 10));
        try {
            reg.add(null);
            Assert.fail((String)"no exception thrown for adding a null rectangle");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        reg.dispose();
        try {
            reg.add(new Rectangle(20, 30, 10, 5));
            Assert.fail((String)"no exception thrown for adding a rectangle after Region got disposed");
        }
        catch (SWTException sWTException) {}
    }

    @Test
    public void test_addLorg_eclipse_swt_graphics_Region() {
        Region reg1 = new Region((Device)this.display);
        Region reg2 = new Region((Device)this.display);
        reg2.add(new Rectangle(40, 50, 10, 20));
        reg1.add(reg2);
        reg2.dispose();
        try {
            reg1.add(null);
            Assert.fail((String)"no exception thrown for adding a null region");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            reg2 = new Region((Device)this.display);
            reg2.add(new Rectangle(1, 1, 100, 200));
            reg2.dispose();
            reg1.add(reg2);
            Assert.fail((String)"no exception thrown for adding to a Region a Region which got disposed");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        reg1.dispose();
        try {
            try {
                reg2 = new Region((Device)this.display);
                reg2.add(new Rectangle(1, 1, 100, 200));
                reg1.add(reg2);
                Assert.fail((String)"no exception thrown for adding a Region to a Region which got disposed");
            }
            catch (SWTException sWTException) {
                if (reg2 != null) {
                    reg2.dispose();
                }
            }
        }
        finally {
            if (reg2 != null) {
                reg2.dispose();
            }
        }
    }

    @Test
    public void test_containsII() {
        Rectangle rect1 = new Rectangle(10, 10, 200, 100);
        Point pointInRect1 = new Point(10, 10);
        Rectangle rect2 = new Rectangle(50, 50, 1000, 1000);
        Point pointInRect2 = new Point(1049, 1009);
        Point pointNotInRect12 = new Point(49, 110);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.contains(pointInRect1.x, pointInRect1.y);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (Exception exception) {}
        reg = new Region((Device)this.display);
        if (reg.contains(pointInRect1.x, pointInRect1.y)) {
            reg.dispose();
            Assert.fail((String)"Empty region should not contain point");
        }
        reg.add(rect1);
        if (!reg.contains(pointInRect1.x, pointInRect1.y)) {
            reg.dispose();
            Assert.fail((String)"Region should contain point");
        }
        reg.add(rect2);
        if (!reg.contains(pointInRect1.x, pointInRect1.y) || !reg.contains(pointInRect2.x, pointInRect2.y)) {
            reg.dispose();
            Assert.fail((String)"Region should contain point");
        }
        if (reg.contains(pointNotInRect12.x, pointNotInRect12.y)) {
            reg.dispose();
            Assert.fail((String)"Region should not contain point");
        }
        reg.dispose();
    }

    @Test
    public void test_containsLorg_eclipse_swt_graphics_Point() {
        Rectangle rect1 = new Rectangle(10, 10, 200, 100);
        Point pointInRect1 = new Point(10, 10);
        Rectangle rect2 = new Rectangle(50, 50, 1000, 1000);
        Point pointInRect2 = new Point(1049, 1009);
        Point pointNotInRect12 = new Point(49, 110);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.contains(pointInRect1);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (Exception exception) {}
        reg = new Region((Device)this.display);
        if (reg.contains(pointInRect1)) {
            reg.dispose();
            Assert.fail((String)"Empty region should not contain point");
        }
        reg.add(rect1);
        if (!reg.contains(pointInRect1)) {
            reg.dispose();
            Assert.fail((String)"Region should contain point");
        }
        reg.add(rect2);
        if (!reg.contains(pointInRect1) || !reg.contains(pointInRect2)) {
            reg.dispose();
            Assert.fail((String)"Region should contain point");
        }
        if (reg.contains(pointNotInRect12)) {
            reg.dispose();
            Assert.fail((String)"Region should not contain point");
        }
        reg.dispose();
    }

    @Test
    public void test_dispose() {
        Region reg = new Region((Device)this.display);
        reg.add(new Rectangle(1, 1, 50, 100));
        if (reg.isDisposed()) {
            Assert.fail((String)"Region should not be in the disposed state");
        }
        int i = 0;
        while (i < 2) {
            reg.dispose();
            if (!reg.isDisposed()) {
                Assert.fail((String)"Region should be in the disposed state");
            }
            ++i;
        }
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Rectangle rect1 = new Rectangle(25, 100, 200, 780);
        Rectangle rect2 = new Rectangle(30, 105, 205, 785);
        Region reg1 = new Region((Device)this.display);
        reg1.add(rect1);
        Region reg2 = reg1;
        if (!reg1.equals((Object)reg2)) {
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"references to the same instance of Region should be considered equal");
        }
        reg2 = new Region((Device)this.display);
        reg2.add(rect1);
        reg2.dispose();
        reg2 = new Region((Device)this.display);
        if (reg1.equals((Object)reg2)) {
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"Non empty region considered equal to empty one");
        }
        reg2.add(rect2);
        if (reg1.equals((Object)reg2)) {
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"two different regions considered equal");
        }
        reg1.dispose();
        reg2.dispose();
    }

    @Test
    public void test_getBounds() {
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.getBounds();
            Assert.fail((String)"Region disposed should throw Exception");
        }
        catch (Exception exception) {}
        Rectangle rect1 = new Rectangle(10, 10, 50, 30);
        Rectangle rect2 = new Rectangle(100, 100, 10, 10);
        Rectangle rect12Bounds = new Rectangle(10, 10, 100, 100);
        reg = new Region((Device)this.display);
        reg.add(rect1);
        Rectangle rect1Bis = reg.getBounds();
        if (rect1Bis.x != rect1.x || rect1Bis.y != rect1.y || rect1Bis.height != rect1.height || rect1Bis.width != rect1.width) {
            reg.dispose();
            Assert.fail((String)"getBounds doesn't return the borders of the rectangle area which was set up");
        }
        reg.add(rect2);
        Rectangle rect12 = reg.getBounds();
        if (rect12.x != rect12Bounds.x || rect12.y != rect12Bounds.y || rect12.height != rect12Bounds.height || rect12.width != rect12Bounds.width) {
            reg.dispose();
            Assert.fail((String)"getBounds doesn't return the borders of the resulting rectangle area which was set up");
        }
        reg.dispose();
    }

    @Test
    public void test_hashCode() {
        Region reg1 = new Region((Device)this.display);
        Region reg2 = new Region((Device)this.display);
        Rectangle rect1 = new Rectangle(25, 100, 200, 780);
        Rectangle rect2 = new Rectangle(30, 105, 205, 785);
        reg1.add(rect1);
        reg2.add(rect2);
        if (reg1.hashCode() == reg2.hashCode()) {
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"two different regions should have different hashCode");
        }
        reg2.dispose();
        reg2 = new Region((Device)this.display);
        reg2.add(rect1);
        reg1.dispose();
        reg2.dispose();
    }

    @Test
    public void test_intersectLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle rect1 = new Rectangle(0, 0, 48, 24);
        Rectangle rect2 = new Rectangle(0, 0, 48, 24);
        Rectangle rect3 = new Rectangle(10, 10, 10, 10);
        Rectangle rect4 = new Rectangle(48, 24, 10, 10);
        Rectangle rect5 = new Rectangle(24, 20, 24, 10);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.intersect(rect1);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg = new Region((Device)this.display);
        reg.intersect(rect1);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"intersect failed for empty region");
        }
        reg.add(rect1);
        reg.intersect(rect2);
        Rectangle box = reg.getBounds();
        if (!box.equals((Object)rect1)) {
            reg.dispose();
            Assert.fail((String)"intersect failed 1");
        }
        reg.intersect(rect3);
        box = reg.getBounds();
        if (!box.equals((Object)rect3)) {
            reg.dispose();
            Assert.fail((String)"intersect failed 2");
        }
        reg.intersect(rect4);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"intersect failed 3");
        }
        reg.add(rect1.union(rect4));
        reg.intersect(rect5);
        box = reg.getBounds();
        if (!box.equals((Object)rect5)) {
            reg.dispose();
            Assert.fail((String)"intersect failed 4");
        }
        reg.dispose();
        reg = new Region((Device)this.display);
        reg.add(rect1);
        reg.add(rect4);
        reg.intersect(rect5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(24, 20, 24, 4))) {
            reg.dispose();
            Assert.fail((String)"intersect failed 5");
        }
        reg.dispose();
    }

    @Test
    public void test_intersectLorg_eclipse_swt_graphics_Region() {
        Region reg = new Region((Device)this.display);
        Region reg1 = new Region((Device)this.display);
        reg1.add(new Rectangle(0, 0, 48, 24));
        reg.dispose();
        try {
            reg.intersect(reg1);
            reg1.dispose();
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg = new Region((Device)this.display);
        reg.intersect(reg1);
        if (!reg.isEmpty()) {
            reg.dispose();
            reg1.dispose();
            Assert.fail((String)"intersect failed for empty region");
        }
        Region reg2 = new Region((Device)this.display);
        reg2.add(new Rectangle(0, 0, 48, 24));
        reg.add(reg1);
        reg.intersect(reg2);
        Rectangle box = reg.getBounds();
        if (!box.equals((Object)reg1.getBounds())) {
            reg.dispose();
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"intersect failed 1");
        }
        reg2.dispose();
        Region reg3 = new Region((Device)this.display);
        reg3.add(new Rectangle(10, 10, 10, 10));
        reg.intersect(reg3);
        box = reg.getBounds();
        if (!box.equals((Object)reg3.getBounds())) {
            reg.dispose();
            reg1.dispose();
            reg3.dispose();
            Assert.fail((String)"intersect failed 2");
        }
        reg3.dispose();
        Region reg4 = new Region((Device)this.display);
        reg4.add(new Rectangle(48, 24, 10, 10));
        reg.intersect(reg4);
        if (!reg.isEmpty()) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            Assert.fail((String)"intersect failed 3");
        }
        Region reg5 = new Region((Device)this.display);
        reg5.add(new Rectangle(24, 20, 24, 10));
        reg.add(reg1.getBounds().union(reg4.getBounds()));
        reg.intersect(reg5);
        box = reg.getBounds();
        if (!box.equals((Object)reg5.getBounds())) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            Assert.fail((String)"intersect failed 4");
        }
        reg.dispose();
        reg = new Region((Device)this.display);
        reg.add(reg1);
        reg.add(reg4);
        reg.intersect(reg5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(24, 20, 24, 4))) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            Assert.fail((String)"intersect failed 5");
        }
        reg.dispose();
        reg1.dispose();
        reg4.dispose();
        reg5.dispose();
    }

    @Test
    public void test_intersectsIIII() {
        Rectangle rect1 = new Rectangle(10, 20, 50, 30);
        Rectangle rectInter1 = new Rectangle(59, 49, 10, 20);
        Rectangle rectNotInter1 = new Rectangle(0, 5, 10, 15);
        Rectangle rect2 = new Rectangle(30, 40, 10, 100);
        Rectangle rectInter2 = new Rectangle(39, 139, 1, 5);
        Rectangle rectNotInter12 = new Rectangle(40, 50, 5, 15);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.intersects(rectInter1.x, rectInter1.y, rectInter1.width, rectInter1.height);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (Exception exception) {}
        reg = new Region((Device)this.display);
        if (reg.intersects(rect1.x, rect1.y, rect1.width, rect1.height)) {
            reg.dispose();
            Assert.fail((String)"intersects can't return true on empty region");
        }
        reg.add(rect1);
        if (!reg.intersects(rect1.x, rect1.y, rect1.width, rect1.height)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true");
        }
        if (!reg.intersects(rectInter1.x, rectInter1.y, rectInter1.width, rectInter1.height)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true ");
        }
        if (reg.intersects(rectNotInter1.x, rectNotInter1.y, rectNotInter1.width, rectNotInter1.height)) {
            reg.dispose();
            Assert.fail((String)"intersects return true on rectangle not intersecting with region");
        }
        reg.add(rect2);
        if (!reg.intersects(rect2.x, rect2.y, rect2.width, rect2.height)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true");
        }
        if (!reg.intersects(rectInter2.x, rectInter2.y, rectInter2.width, rectInter2.height)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true ");
        }
        if (reg.intersects(rectNotInter12.x, rectNotInter12.y, rectNotInter12.width, rectNotInter12.height)) {
            reg.dispose();
            Assert.fail((String)"intersects return true on rectangle not intersecting with region");
        }
        reg.dispose();
    }

    @Test
    public void test_intersectsLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle rect1 = new Rectangle(10, 20, 50, 30);
        Rectangle rectInter1 = new Rectangle(59, 49, 10, 20);
        Rectangle rectNotInter1 = new Rectangle(0, 5, 10, 15);
        Rectangle rect2 = new Rectangle(30, 40, 10, 100);
        Rectangle rectInter2 = new Rectangle(39, 139, 1, 5);
        Rectangle rectNotInter12 = new Rectangle(40, 50, 5, 15);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.intersects(rectInter1);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (Exception exception) {}
        reg = new Region((Device)this.display);
        if (reg.intersects(rect1)) {
            reg.dispose();
            Assert.fail((String)"intersects can't return true on empty region");
        }
        reg.add(rect1);
        if (!reg.intersects(rect1)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true");
        }
        if (!reg.intersects(rectInter1)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true ");
        }
        if (reg.intersects(rectNotInter1)) {
            reg.dispose();
            Assert.fail((String)"intersects return true on rectangle not intersecting with region");
        }
        reg.add(rect2);
        if (!reg.intersects(rect2)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true");
        }
        if (!reg.intersects(rectInter2)) {
            reg.dispose();
            Assert.fail((String)"intersects didn't return true ");
        }
        if (reg.intersects(rectNotInter12)) {
            reg.dispose();
            Assert.fail((String)"intersects return true on rectangle not intersecting with region");
        }
        reg.dispose();
    }

    @Test
    public void test_isEmpty() {
        Region reg = new Region((Device)this.display);
        Rectangle emptyRect1 = new Rectangle(10, 20, 0, 200);
        Rectangle emptyRect2 = new Rectangle(10, 20, 10, 0);
        Rectangle rect = new Rectangle(10, 20, 50, 100);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"isEmpty didn't return true on empty region");
        }
        reg.add(emptyRect1);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"isEmpty didn't return true on empty region");
        }
        reg.add(emptyRect2);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"isEmpty didn't return true on empty region");
        }
        reg.add(rect);
        if (reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"isEmpty returned true on non empty region");
        }
        reg.dispose();
    }

    @Test
    public void test_subtract$I() {
        Region reg = new Region((Device)this.display);
        try {
            reg.subtract(null);
            reg.dispose();
            Assert.fail((String)"no exception thrown for subtract a null array");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        reg.dispose();
        try {
            reg.subtract(new int[0]);
            reg.dispose();
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg.dispose();
        reg = new Region((Device)this.display);
        int[] nArray = new int[8];
        nArray[2] = 50;
        nArray[4] = 50;
        nArray[5] = 25;
        nArray[7] = 25;
        reg.add(nArray);
        int[] nArray2 = new int[8];
        nArray2[2] = 50;
        nArray2[4] = 50;
        nArray2[5] = 20;
        nArray2[7] = 20;
        reg.subtract(nArray2);
        Rectangle box = reg.getBounds();
        reg.dispose();
        Rectangle expected = new Rectangle(0, 20, 50, 5);
        if (!box.equals((Object)expected)) {
            Assert.fail((String)("subtract 1 failed - expected: " + String.valueOf(expected) + " actual: " + String.valueOf(box)));
        }
        reg = new Region((Device)this.display);
        int[] nArray3 = new int[8];
        nArray3[2] = 50;
        nArray3[4] = 50;
        nArray3[5] = 25;
        nArray3[7] = 25;
        reg.add(nArray3);
        int[] nArray4 = new int[8];
        nArray4[1] = 25;
        nArray4[2] = 50;
        nArray4[3] = 25;
        nArray4[4] = 50;
        nArray4[5] = 40;
        nArray4[7] = 40;
        reg.add(nArray4);
        int[] nArray5 = new int[8];
        nArray5[1] = 25;
        nArray5[2] = 50;
        nArray5[3] = 25;
        nArray5[4] = 50;
        nArray5[5] = 40;
        nArray5[7] = 40;
        reg.subtract(nArray5);
        box = reg.getBounds();
        reg.dispose();
        expected = new Rectangle(0, 0, 50, 25);
        if (!box.equals((Object)expected)) {
            Assert.fail((String)("subtract 2 failed - expected: " + String.valueOf(expected) + " actual: " + String.valueOf(box)));
        }
    }

    @Test
    public void test_subtractLorg_eclipse_swt_graphics_Rectangle() {
        Rectangle rect1 = new Rectangle(0, 0, 50, 25);
        Rectangle rect2 = new Rectangle(0, 0, 50, 25);
        Rectangle rect3 = new Rectangle(10, 10, 10, 10);
        Rectangle rect4 = new Rectangle(50, 25, 10, 10);
        Rectangle rect5 = new Rectangle(0, 0, 60, 20);
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.subtract(rect1);
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg = new Region((Device)this.display);
        reg.subtract(rect1);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"subtract failed for empty region");
        }
        reg.add(rect1);
        reg.subtract(rect2);
        if (!reg.isEmpty()) {
            reg.dispose();
            Assert.fail((String)"subtract failed 1");
        }
        reg.add(rect1);
        reg.subtract(rect3);
        Rectangle box = reg.getBounds();
        if (!box.equals((Object)rect1)) {
            reg.dispose();
            Assert.fail((String)"subtract failed 2");
        }
        reg.subtract(rect4);
        box = reg.getBounds();
        if (!box.equals((Object)rect1)) {
            reg.dispose();
            Assert.fail((String)"subtract failed 3");
        }
        reg.add(rect1.union(rect4));
        reg.subtract(rect5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(0, 20, 60, 15))) {
            reg.dispose();
            Assert.fail((String)"subtract failed 4");
        }
        reg.dispose();
        reg = new Region((Device)this.display);
        reg.add(rect1);
        reg.add(rect4);
        reg.subtract(rect5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(0, 20, 60, 15))) {
            reg.dispose();
            Assert.fail((String)"subtract failed 5");
        }
        reg.dispose();
    }

    @Test
    public void test_subtractLorg_eclipse_swt_graphics_Region() {
        Region reg1 = new Region((Device)this.display);
        reg1.add(new Rectangle(0, 0, 50, 25));
        Region reg = new Region((Device)this.display);
        reg.dispose();
        try {
            reg.subtract(reg1);
            reg1.dispose();
            Assert.fail((String)"no exception thrown on disposed region");
        }
        catch (SWTException sWTException) {}
        reg = new Region((Device)this.display);
        reg.subtract(reg1);
        if (!reg.isEmpty()) {
            reg.dispose();
            reg1.dispose();
            Assert.fail((String)"subtract failed for empty region");
        }
        Region reg2 = new Region((Device)this.display);
        reg2.add(new Rectangle(0, 0, 50, 25));
        reg.add(reg1);
        reg.subtract(reg2);
        if (!reg.isEmpty()) {
            reg.dispose();
            reg1.dispose();
            reg2.dispose();
            Assert.fail((String)"subtract failed 1");
        }
        reg2.dispose();
        Region reg3 = new Region((Device)this.display);
        reg3.add(new Rectangle(10, 10, 10, 10));
        reg.add(reg1);
        reg.subtract(reg3);
        Rectangle box = reg.getBounds();
        if (!box.equals((Object)reg1.getBounds())) {
            reg.dispose();
            reg1.dispose();
            reg3.dispose();
            Assert.fail((String)"subtract failed 2");
        }
        reg3.dispose();
        Region reg4 = new Region((Device)this.display);
        reg4.add(new Rectangle(50, 25, 10, 10));
        reg.subtract(reg4);
        box = reg.getBounds();
        if (!box.equals((Object)reg1.getBounds())) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            Assert.fail((String)"subtract failed 3");
        }
        Region reg5 = new Region((Device)this.display);
        reg5.add(new Rectangle(0, 0, 60, 20));
        reg.add(reg1.getBounds().union(reg4.getBounds()));
        reg.subtract(reg5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(0, 20, 60, 15))) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            reg5.dispose();
            Assert.fail((String)"subtract failed 4");
        }
        reg.dispose();
        reg = new Region((Device)this.display);
        reg.add(reg1);
        reg.add(reg4);
        reg.subtract(reg5);
        box = reg.getBounds();
        if (!box.equals((Object)new Rectangle(0, 20, 60, 15))) {
            reg.dispose();
            reg1.dispose();
            reg4.dispose();
            reg5.dispose();
            Assert.fail((String)"subtract failed 5");
        }
        reg.dispose();
        reg1.dispose();
        reg4.dispose();
        reg5.dispose();
    }

    @Test
    public void test_toString() {
        Region reg = new Region((Device)this.display);
        String s = reg.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
        reg.add(new Rectangle(1, 1, 10, 20));
        s = reg.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
        reg.dispose();
        s = reg.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
    }

    @Test
    public void test_add_intArray() {
        Region reg = new Region((Device)this.display);
        int[] points = new int[]{1};
        reg.add(points);
        reg.dispose();
        Region reg2 = new Region((Device)this.display);
        points = new int[]{1, 2};
        reg2.add(points);
        reg2.dispose();
        Region reg3 = new Region((Device)this.display);
        points = new int[]{1, 2, 3};
        reg3.add(points);
        reg3.dispose();
        Region reg4 = new Region((Device)this.display);
        points = new int[]{1, 2, 3, 4};
        reg4.add(points);
        reg4.dispose();
        Region reg5 = new Region((Device)this.display);
        points = new int[]{1, 2, 3, 4, 5};
        reg5.add(points);
        reg5.dispose();
        Region reg6 = new Region((Device)this.display);
        points = new int[]{1, 2, 3, 4, 5, 6};
        reg6.add(points);
        reg6.dispose();
    }
}

