/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Transform {
    private Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void createTransform() {
        Transform transform = new Transform((Device)this.display);
        if (transform.isDisposed()) {
            Assert.fail((String)"Constructor for Transform didn't initialize");
        }
        transform.dispose();
    }

    @Test
    public void multiplyWithDisposedTransform() {
        Transform transform = new Transform((Device)this.display);
        transform.translate(10.0f, 10.0f);
        Transform transformDisposed = new Transform((Device)this.display);
        transformDisposed.translate(20.0f, 20.0f);
        transform.multiply(transformDisposed);
        transformDisposed.dispose();
        float[] elements = new float[6];
        transform.getElements(elements);
        Assert.assertEquals((String)"Multiply of transforms failed.", (double)30.0, (double)elements[4], (double)0.01);
        transform.dispose();
    }

    @Test
    public void disposeTransform() {
        Transform transform = new Transform((Device)this.display);
        transform.setElements(2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f);
        if (transform.isDisposed()) {
            Assert.fail((String)"Transform should not be in the disposed state");
        }
        int i = 0;
        while (i < 2) {
            transform.dispose();
            if (!transform.isDisposed()) {
                Assert.fail((String)"Transform should be in the disposed state");
            }
            ++i;
        }
    }

    @Test
    public void testToString() {
        Transform transform = new Transform((Device)this.display);
        String s = transform.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
        transform.setElements(2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f);
        s = transform.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
        transform.dispose();
        s = transform.toString();
        if (s == null || s.length() == 0) {
            Assert.fail((String)"toString returns null or empty string");
        }
    }
}

