/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TemporaryFolder;

public class Test_org_eclipse_swt_internal_SVGRasterizer {
    @ClassRule
    public static TemporaryFolder tempFolder = new TemporaryFolder();

    private static String getPath(String fileName) {
        return SwtTestUtil.getPath(fileName, tempFolder).toString();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageFileNameProvider() {
        ImageFileNameProvider validImageFileNameProvider = zoom -> Test_org_eclipse_swt_internal_SVGRasterizer.getPath("collapseall.svg");
        Image image = new Image((Device)Display.getDefault(), validImageFileNameProvider);
        image.dispose();
        ImageFileNameProvider corruptImageFileNameProvider = zoom -> Test_org_eclipse_swt_internal_SVGRasterizer.getPath("corrupt.svg");
        SWTException e = (SWTException)Assertions.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)Display.getDefault(), corruptImageFileNameProvider);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device_ImageDataProvider() {
        ImageDataProvider validImageDataProvider = zoom -> zoom == 100 ? new ImageData(Test_org_eclipse_swt_internal_SVGRasterizer.getPath("collapseall.svg")) : null;
        Image image = new Image((Device)Display.getDefault(), validImageDataProvider);
        image.dispose();
        ImageDataProvider corruptImageDataProvider = zoom -> zoom == 100 ? new ImageData(Test_org_eclipse_swt_internal_SVGRasterizer.getPath("corrupt.svg")) : null;
        SWTException e = (SWTException)Assertions.assertThrows(SWTException.class, () -> {
            Image image = new Image((Device)Display.getDefault(), corruptImageDataProvider);
        });
        SwtTestUtil.assertSWTProblem("Incorrect exception thrown for provider with corrupt images", 40, e);
    }
}

