/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.layout.BorderLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_layout_BorderLayout {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    public void tearDown() {
        SwtTestUtil.processEvents();
        this.display.dispose();
    }

    @Test
    public void testControlExcluded() {
        Shell shell = new Shell(this.display);
        shell.setLayout((Layout)new BorderLayout());
        shell.setSize(800, 600);
        MockControl control = new MockControl((Composite)shell);
        control.setLayoutData(new BorderData(0));
        control.setBounds(0, 0, 100, 100);
        shell.open();
        SwtTestUtil.processEvents();
        Rectangle bounds = control.getBounds();
        Assert.assertEquals((long)0L, (long)bounds.width);
        Assert.assertEquals((long)0L, (long)bounds.height);
        shell.dispose();
    }

    @Test
    public void testHints() {
        Shell shell = new Shell(this.display);
        shell.setLayout((Layout)new BorderLayout());
        shell.setSize(800, 600);
        MockControl controlNorth = new MockControl((Composite)shell);
        MockControl controlSouth = new MockControl((Composite)shell);
        MockControl controlWest = new MockControl((Composite)shell);
        MockControl controlEast = new MockControl((Composite)shell);
        controlNorth.setLayoutData(new BorderData(128, 40, 50));
        controlWest.setLayoutData(new BorderData(16384, 20, 30));
        controlSouth.setLayoutData(new BorderData(1024));
        controlEast.setLayoutData(new BorderData(131072));
        shell.open();
        SwtTestUtil.processEvents();
        Assert.assertTrue((controlNorth.wHint > 100 ? 1 : 0) != 0);
        Assert.assertEquals((long)50L, (long)controlNorth.hHint);
        Assert.assertEquals((long)30L, (long)controlWest.hHint);
        Assert.assertEquals((long)20L, (long)controlWest.wHint);
        Assert.assertTrue((controlSouth.wHint > 100 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)controlSouth.hHint);
        Assert.assertEquals((long)-1L, (long)controlEast.hHint);
        Assert.assertEquals((long)-1L, (long)controlEast.wHint);
        shell.dispose();
    }

    @Test
    public void testControlLayout() {
        Shell shell = new Shell(this.display);
        shell.setLayout((Layout)new BorderLayout());
        shell.setSize(800, 600);
        MockControl topControl = new MockControl((Composite)shell);
        topControl.reportedHeight = 10;
        topControl.reportedWidth = 1000000;
        MockControl bottomControl = new MockControl((Composite)shell);
        bottomControl.reportedHeight = 20;
        bottomControl.reportedWidth = 123;
        MockControl leftControl = new MockControl((Composite)shell);
        leftControl.reportedHeight = 5;
        leftControl.reportedWidth = 50;
        MockControl rightControl = new MockControl((Composite)shell);
        rightControl.reportedHeight = 5;
        rightControl.reportedWidth = 40;
        MockControl centerControl = new MockControl((Composite)shell);
        topControl.setLayoutData(new BorderData(128));
        bottomControl.setLayoutData(new BorderData(1024));
        leftControl.setLayoutData(new BorderData(16384));
        rightControl.setLayoutData(new BorderData(131072));
        shell.open();
        shell.layout();
        SwtTestUtil.processEvents();
        Rectangle clientArea = shell.getClientArea();
        Rectangle topBounds = topControl.getBounds();
        Assert.assertEquals((long)0L, (long)topBounds.x);
        Assert.assertEquals((long)0L, (long)topBounds.y);
        Assert.assertEquals((long)clientArea.width, (long)topBounds.width);
        Assert.assertEquals((long)topControl.reportedHeight, (long)topBounds.height);
        Rectangle bottomBounds = bottomControl.getBounds();
        Assert.assertEquals((long)0L, (long)bottomBounds.x);
        Assert.assertEquals((long)(clientArea.height - bottomControl.reportedHeight), (long)bottomBounds.y);
        Assert.assertEquals((long)clientArea.width, (long)bottomBounds.width);
        Assert.assertEquals((long)bottomControl.reportedHeight, (long)bottomBounds.height);
        Rectangle leftBounds = leftControl.getBounds();
        Assert.assertEquals((long)0L, (long)leftBounds.x);
        Assert.assertEquals((long)topControl.reportedHeight, (long)leftBounds.y);
        Assert.assertEquals((long)leftControl.reportedWidth, (long)leftBounds.width);
        Assert.assertEquals((long)(clientArea.height - topControl.reportedHeight - bottomControl.reportedHeight), (long)leftBounds.height);
        Rectangle rightBounds = rightControl.getBounds();
        Assert.assertEquals((long)(clientArea.width - rightControl.reportedWidth), (long)rightBounds.x);
        Assert.assertEquals((long)topControl.reportedHeight, (long)rightBounds.y);
        Assert.assertEquals((long)rightControl.reportedWidth, (long)rightBounds.width);
        Assert.assertEquals((long)(clientArea.height - topControl.reportedHeight - bottomControl.reportedHeight), (long)rightBounds.height);
        Rectangle centerBounds = centerControl.getBounds();
        Assert.assertEquals((long)leftControl.reportedWidth, (long)centerBounds.x);
        Assert.assertEquals((long)topControl.reportedHeight, (long)centerBounds.y);
        Assert.assertEquals((long)(clientArea.width - leftControl.reportedWidth - rightControl.reportedWidth), (long)centerBounds.width);
        Assert.assertEquals((long)(clientArea.height - topControl.reportedHeight - bottomControl.reportedHeight), (long)centerBounds.height);
        shell.dispose();
    }

    private static final class MockControl
    extends Canvas {
        private int wHint;
        private int hHint;
        private int reportedHeight = -1;
        private int reportedWidth = -1;

        public MockControl(Composite parent) {
            super(parent, 0);
            this.setBackground(parent.getDisplay().getSystemColor(9));
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            this.wHint = wHint;
            this.hHint = hHint;
            if (this.reportedHeight > 0 && this.reportedWidth > 0) {
                return new Point(this.reportedWidth, this.reportedHeight);
            }
            return super.computeSize(wHint, hHint, changed);
        }
    }
}

