/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_printing_Printer {
    @Test
    public void test_Constructor() {
        if (Printer.getDefaultPrinterData() == null) {
            SWTError ex = (SWTError)Assertions.assertThrows(SWTError.class, () -> {
                Printer printer = new Printer();
            });
            Assertions.assertEquals((int)2, (int)ex.code, (String)"ERROR_NO_HANDLES not thrown");
        } else {
            Printer printer = new Printer();
            Assertions.assertNotNull((Object)printer);
            printer.dispose();
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_printing_PrinterData() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            SWTError ex = (SWTError)Assertions.assertThrows(SWTError.class, () -> {
                Printer printer = new Printer(data);
            });
            Assertions.assertEquals((int)2, (int)ex.code, (String)"ERROR_NO_HANDLES not thrown");
        } else {
            Printer printer = new Printer(data);
            Assertions.assertNotNull((Object)printer);
            printer.dispose();
        }
    }

    @Test
    public void test_computeTrimIIII() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        Rectangle trim = printer.computeTrim(0, 0, 10, 10);
        Assertions.assertTrue((trim.width >= 10 && trim.height >= 10 ? 1 : 0) != 0, (String)"trim width or height is incorrect");
        printer.dispose();
    }

    @Test
    public void test_getBounds() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        Rectangle bounds = printer.getBounds();
        Assertions.assertTrue((bounds.width > 0 && bounds.height > 0 ? 1 : 0) != 0, (String)"bounds width or height is zero");
        printer.dispose();
    }

    @Test
    public void test_getClientArea() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        Rectangle clientArea = printer.getClientArea();
        Assertions.assertTrue((clientArea.width > 0 && clientArea.height > 0 ? 1 : 0) != 0, (String)"clientArea width or height is zero");
        printer.dispose();
    }

    @Test
    public void test_getDPI() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        Point dpi = printer.getDPI();
        Assertions.assertTrue((dpi.x > 0 && dpi.y > 0 ? 1 : 0) != 0, (String)"dpi x or y is zero");
        printer.dispose();
    }

    @Test
    public void test_getPrinterData() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        Assertions.assertTrue((data == printer.getPrinterData() ? 1 : 0) != 0, (String)"getPrinterData != data used in constructor");
        printer.dispose();
    }

    @Test
    public void test_getPrinterList() {
        PrinterData data = Printer.getDefaultPrinterData();
        if (data == null) {
            Stream<PrinterData> printerStream = Arrays.stream(Printer.getPrinterList());
            if (SWT.getPlatform().equals("gtk")) {
                printerStream = printerStream.filter(pd -> !"GtkPrintBackendFile".equals(pd.driver));
            } else if (SWT.getPlatform().equals("win32")) {
                printerStream = printerStream.filter(pd -> {
                    block11: {
                        if (pd.name == null) break block11;
                        switch (pd.name.toLowerCase()) {
                            case "microsoft print to pdf": 
                            case "microsoft xps document writer": 
                            case "fax": {
                                return false;
                            }
                        }
                    }
                    return true;
                });
            }
            PrinterData[] list = (PrinterData[])printerStream.toArray(PrinterData[]::new);
            String printerNames = Arrays.stream(list).map(String::valueOf).collect(Collectors.joining(", "));
            Assertions.assertEquals((int)0, (int)list.length, (String)("printer list contains items even though there are no printers, printers from list are: " + printerNames));
        } else {
            PrinterData[] list = Printer.getPrinterList();
            Assertions.assertTrue((list.length > 0 ? 1 : 0) != 0, (String)"printer list is empty");
        }
    }

    @Test
    public void test_isAutoScalable() {
        PrinterData data = Printer.getDefaultPrinterData();
        Assumptions.assumeTrue((data != null ? 1 : 0) != 0, (String)"if there aren't any printers, don't do this test");
        Printer printer = new Printer(data);
        boolean isAutoScalable = printer.isAutoScalable();
        Assertions.assertFalse((boolean)isAutoScalable, (String)"SWT doesnot auto-scale for Printer devices");
        printer.dispose();
    }
}

