/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.HashSet;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_program_Program {
    @BeforeAll
    public static void setUp() {
        Display.getDefault();
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    Assertions.assertTrue((boolean)program.equals((Object)program));
                }
                ++n2;
            }
        }
    }

    @Test
    public void test_executeLjava_lang_String() {
        Program[] programs = Program.getPrograms();
        if (programs != null && programs.length > 0) {
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
                boolean bl = programs[0].execute(null);
            }, (String)"Failed to throw ERROR_NULL_ARGUMENT");
            SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
        }
    }

    @Test
    public void test_findProgramLjava_lang_String() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Program.findProgram((String)extension);
                ++n2;
            }
        }
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Program program = Program.findProgram(null);
        }, (String)"Failed to throw ERROR_NULL_ARGUMENT");
        SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
    }

    @Test
    public void test_getExtensions() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Assertions.assertNotNull((Object)extension);
                ++n2;
            }
        }
    }

    @Test
    public void test_getImageData() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    program.getImageData();
                }
                ++n2;
            }
        }
    }

    @Test
    public void test_getName() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    String name = program.getName();
                    Assertions.assertNotNull((Object)"Program has null name", (String)name);
                }
                ++n2;
            }
        }
    }

    @Test
    public void test_getPrograms() {
        Program[] programs = Program.getPrograms();
        Assertions.assertNotNull((Object)programs);
        HashSet<Program> lookup = new HashSet<Program>();
        Program[] programArray = programs;
        int n = programs.length;
        int n2 = 0;
        while (n2 < n) {
            Program program = programArray[n2];
            Assertions.assertNotNull((Object)program);
            Assertions.assertTrue((boolean)lookup.add(program), (String)("Duplicated list entry for " + String.valueOf(program)));
            ++n2;
        }
    }

    @Test
    public void test_launchLjava_lang_String() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            boolean bl = Program.launch(null);
        }, (String)"Failed to throw ERROR_NULL_ARGUMENT");
        SwtTestUtil.assertSWTProblem("Failed to throw ERROR_NULL_ARGUMENT", 4, e);
    }

    @Test
    public void test_toString() {
        String[] extensions = Program.getExtensions();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    String string = program.toString();
                    Assertions.assertNotNull((Object)"toString returned null", (String)string);
                }
                ++n2;
            }
        }
    }
}

