/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Canvas
extends Test_org_eclipse_swt_widgets_Composite {
    Canvas canvas;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.canvas = new Canvas((Composite)this.shell, 0);
        super.setWidget((Widget)this.canvas);
    }

    @Override
    protected void setWidget(Widget w) {
        if (!this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        this.canvas = (Canvas)w;
        super.setWidget(w);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            new Canvas(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_scrollIIIIIIZ() {
        this.canvas.scroll(100, 100, 0, 0, 50, 50, false);
        this.canvas.scroll(100, 100, 0, 0, 50, 50, true);
        this.canvas.scroll(10000, 10000, 100, 100, 500, 500, false);
        this.canvas.scroll(10000, 10000, 100, 100, 500, 500, true);
        this.canvas.scroll(-100, -100, 10, 10, 30, 30, false);
        this.canvas.scroll(-100, -100, 10, 10, 30, 30, true);
        this.canvas.scroll(10, 10, -200, -200, 100, 100, false);
        this.canvas.scroll(10, 10, -200, -200, 100, 100, true);
        this.canvas.scroll(100, 100, 50, 50, -50, -50, false);
        this.canvas.scroll(100, 100, 50, 50, -50, -50, true);
    }

    @Test
    public void test_setCaretLorg_eclipse_swt_widgets_Caret() {
        int number = 5;
        Caret[] carets = new Caret[number];
        int i = 0;
        while (i < number) {
            carets[i] = new Caret(this.canvas, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.canvas.setCaret(carets[i]);
            Assert.assertEquals((String)("Caret # " + i + "not set properly"), (Object)this.canvas.getCaret(), (Object)carets[i]);
            ++i;
        }
        this.canvas.setCaret(null);
        Assert.assertNull((String)"Caret should be null", (Object)this.canvas.getCaret());
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        FontData fontData = this.canvas.getFont().getFontData()[0];
        Font font = new Font((Device)this.canvas.getDisplay(), fontData.getName(), 8, fontData.getStyle());
        this.canvas.setFont(font);
        Assert.assertEquals((String)":a:", (Object)font, (Object)this.canvas.getFont());
        this.canvas.setFont(null);
        font.dispose();
    }

    @Test
    public void test_CaretWithDisposedFontDoesNotThrowException_issue2323() {
        Caret caret = new Caret(this.canvas, 0);
        Font font = new Font((Device)this.canvas.getDisplay(), "Default", 10, 1);
        this.shell.open();
        caret.setFont(font);
        font.dispose();
        this.canvas.setFocus();
        this.canvas.setCaret(caret);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.consistencyEvent(10, 10, 3, 0, 30);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.consistencyEvent(10, 10, 20, 20, 50);
    }
}

