/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Widget;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Caret
extends Test_org_eclipse_swt_widgets_Widget {
    Canvas canvas;
    Caret caret;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.canvas = new Canvas((Composite)this.shell, 0);
        this.caret = new Caret(this.canvas, 0);
        this.setWidget((Widget)this.caret);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CanvasI() {
        try {
            new Caret(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getBounds() {
        Rectangle rect = new Rectangle(0, 0, 30, 30);
        this.caret.setBounds(rect);
        Assert.assertEquals((Object)rect, (Object)this.caret.getBounds());
        rect = new Rectangle(0, 0, 30, 30);
        this.caret.setBounds(rect);
        Assert.assertNotEquals((Object)new Rectangle(0, 0, 60, 70), (Object)this.caret.getBounds());
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.canvas, (Object)this.caret.getParent());
        Assert.assertTrue((this.caret.getDisplay() == this.shell.getDisplay() ? 1 : 0) != 0);
    }

    @Test
    public void test_isVisible() {
        this.caret.setVisible(true);
        Assert.assertFalse((boolean)this.caret.isVisible());
        this.caret.setVisible(false);
        Assert.assertFalse((boolean)this.caret.isVisible());
        this.caret.setVisible(true);
        this.canvas.setVisible(true);
        this.shell.setVisible(true);
        Assert.assertTrue((boolean)this.caret.getVisible());
        this.canvas.setVisible(false);
        if (SwtTestUtil.fCheckVisibility) {
            Assert.assertFalse((boolean)this.caret.getVisible());
        }
        this.shell.setVisible(false);
        this.canvas.setVisible(false);
        this.caret.setVisible(false);
        Assert.assertFalse((boolean)this.caret.getVisible());
    }

    @Test
    public void test_setBoundsIIII() {
        this.caret.setBounds(0, 0, 30, 30);
    }

    @Test
    public void test_setBoundsLorg_eclipse_swt_graphics_Rectangle() {
        this.caret.setBounds(new Rectangle(0, 0, 30, 30));
        try {
            this.caret.setBounds(null);
            Assert.fail((String)"No exception thrown for bounds == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        Font font = this.caret.getFont();
        this.caret.setFont(font);
        Assert.assertEquals((Object)font, (Object)this.caret.getFont());
        this.caret.setFont(null);
        font = new Font((Device)this.caret.getDisplay(), SwtTestUtil.testFontName, 10, 0);
        this.caret.setFont(font);
        Assert.assertEquals((Object)font, (Object)this.caret.getFont());
        this.caret.setFont(null);
        font.dispose();
        try {
            this.caret.setFont(font);
            this.caret.setFont(null);
            Assert.fail((String)"No exception thrown for disposed font");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Image image = this.caret.getImage();
        this.caret.setImage(image);
        Assert.assertEquals((Object)image, (Object)this.caret.getImage());
        this.caret.setImage(null);
        Assert.assertNull((Object)this.caret.getImage());
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        image = new Image((Device)this.shell.getDisplay(), noOpGcDrawer, 10, 10);
        this.caret.setImage(image);
        Assert.assertEquals((Object)image, (Object)this.caret.getImage());
        this.caret.setImage(null);
        image.dispose();
        try {
            this.caret.setImage(image);
            this.caret.setImage(null);
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setVisibleZ() {
        this.caret.setVisible(true);
        Assert.assertTrue((String)"Caret should be visible", (boolean)this.caret.getVisible());
        this.caret.setVisible(false);
        Assert.assertFalse((String)"Caret should not be visible", (boolean)this.caret.getVisible());
    }
}

