/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Scrollable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Composite
extends Test_org_eclipse_swt_widgets_Scrollable {
    Composite composite;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.composite = new Composite((Composite)this.shell, 0);
        super.setWidget((Widget)this.composite);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        int[] cases;
        try {
            this.composite = new Composite(null, 0);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] nArray = cases = new int[]{256, 512, 768};
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int style = nArray[n2];
            this.composite = new Composite((Composite)this.shell, style);
            ++n2;
        }
    }

    @Test
    public void test_getChildren() {
        Control[] children;
        Assert.assertArrayEquals((String)":a:", (Object[])new Control[0], (Object[])this.composite.getChildren());
        Composite c1 = new Composite(this.composite, 0);
        Assert.assertArrayEquals((String)":b:", (Object[])new Control[]{c1}, (Object[])this.composite.getChildren());
        List c2 = new List(this.composite, 0);
        Assert.assertArrayEquals((String)":c:", (Object[])new Control[]{c1, c2}, (Object[])this.composite.getChildren());
        Button c3 = new Button(this.composite, 0);
        Assert.assertArrayEquals((String)":d:", (Object[])new Control[]{c1, c2, c3}, (Object[])this.composite.getChildren());
        c2.dispose();
        Assert.assertArrayEquals((String)":e:", (Object[])new Control[]{c1, c3}, (Object[])this.composite.getChildren());
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.dispose();
            ++n2;
        }
        Assert.assertArrayEquals((String)":f:", (Object[])new Control[0], (Object[])this.composite.getChildren());
    }

    @Test
    public void test_setVisibility_and_sizing() {
        Shell visibilityShell = new Shell();
        visibilityShell.setSize(500, 500);
        Composite visibilityComposite = new Composite((Composite)visibilityShell, 2048);
        visibilityShell.setLayout((Layout)new FillLayout());
        visibilityComposite.setLayout((Layout)new FillLayout());
        Button button = new Button(visibilityComposite, 8);
        button.setText("Test Button");
        visibilityComposite.setVisible(false);
        visibilityComposite.setVisible(true);
        visibilityShell.layout();
        Point compSize = visibilityComposite.getSize();
        Assert.assertTrue((String)("Composite should be aprox 500 by 463 px, but instead it is: " + compSize.toString()), (compSize.x > 100 && compSize.y > 100 ? 1 : 0) != 0);
        visibilityShell.dispose();
    }

    @Test
    public void test_setFocus_toChild_afterOpen() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setFocus_toChild_afterOpen(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite)");
            }
            return;
        }
        Text focusChild = new Text(this.composite, 0);
        SwtTestUtil.waitShellActivate(() -> ((Shell)this.shell).open(), this.shell);
        this.composite.setFocus();
        Assert.assertTrue((String)"First child widget should have focus", (boolean)focusChild.isFocusControl());
    }

    @Test
    public void test_setFocus_toChild_beforeOpen() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setFocus_toChild_beforeOpen(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite)");
            }
            return;
        }
        Text focusChild = new Text(this.composite, 0);
        this.composite.setFocus();
        SwtTestUtil.waitShellActivate(() -> ((Shell)this.shell).open(), this.shell);
        Assert.assertTrue((String)"First child widget should have focus", (boolean)focusChild.isFocusControl());
    }

    @Test
    public void test_setFocus_withInvisibleChild() {
        final AtomicReference<Boolean> wasSetFocusCalledOnInvisibleChildWidget = new AtomicReference<Boolean>(false);
        Composite invisibleChildWidget = new Composite(this.composite, 0){

            public boolean setFocus() {
                wasSetFocusCalledOnInvisibleChildWidget.set(true);
                return super.setFocus();
            }
        };
        invisibleChildWidget.setVisible(false);
        SwtTestUtil.waitShellActivate(() -> ((Shell)this.shell).open(), this.shell);
        this.composite.setFocus();
        Assert.assertFalse((String)"Composite should not try to set focus on invisible child", (boolean)wasSetFocusCalledOnInvisibleChildWidget.get());
    }

    @Test
    public void test_setFocus_withVisibleAndInvisibleChild() {
        final AtomicReference<Boolean> wasSetFocusCalledOnInvisibleChildWidget = new AtomicReference<Boolean>(false);
        Composite invisibleChildWidget = new Composite(this.composite, 0){

            public boolean setFocus() {
                wasSetFocusCalledOnInvisibleChildWidget.set(true);
                return super.setFocus();
            }
        };
        invisibleChildWidget.setVisible(false);
        Composite visibleChildWidget = new Composite(this.composite, 0);
        SwtTestUtil.waitShellActivate(() -> ((Shell)this.shell).open(), this.shell);
        this.composite.setFocus();
        Assert.assertFalse((String)"Composite should not try to set focus on invisible child", (boolean)wasSetFocusCalledOnInvisibleChildWidget.get());
        Assert.assertTrue((String)"Visible child widget should have focus", (boolean)this.getElementExpectedToHaveFocusAfterSetFocusOnParent(visibleChildWidget).isFocusControl());
    }

    @Test
    public void test_setTabList$Lorg_eclipse_swt_widgets_Control() {
        Button button1 = new Button(this.composite, 8);
        Button button2 = new Button(this.composite, 8);
        Object[] tablist = new Control[]{button1, button2};
        this.composite.setTabList((Control[])tablist);
        Assert.assertArrayEquals((Object[])tablist, (Object[])this.composite.getTabList());
        button1.dispose();
        button2.dispose();
    }

    @Test
    public void test_bug2162_transparentStyle() {
        Composite c = new Composite((Composite)this.shell, 0x40000000);
        c.addPaintListener(e -> {});
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.open();
    }

    protected Composite getElementExpectedToHaveFocusAfterSetFocusOnParent(Composite visibleChild) {
        return visibleChild;
    }

    @Override
    protected void setWidget(Widget w) {
        if (this.composite != null) {
            this.composite.dispose();
        }
        this.composite = (Composite)w;
        super.setWidget(w);
    }
}

