/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_CoolBar
extends Test_org_eclipse_swt_widgets_Composite {
    CoolBar coolBar;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.coolBar = new CoolBar((Composite)this.shell, 0);
        this.setWidget((Widget)this.coolBar);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    private void createCoolBar(List<String> events) {
        this.tearDown();
        super.setUp();
        String test = this.getTestName();
        this.coolBar = new CoolBar((Composite)this.shell, 0x800000);
        ToolBar[] coolItemToolBar = new ToolBar[2];
        int i = 0;
        while (i < 2) {
            CoolItem coolItem = new CoolItem(this.coolBar, 4);
            coolItemToolBar[i] = new ToolBar((Composite)this.coolBar, 0x800000);
            this.hookExpectedEvents((Widget)coolItem, test, events);
            this.hookExpectedEvents((Widget)coolItemToolBar[i], test, events);
            int toolItemWidth = 0;
            int j = 0;
            while (j < 2) {
                ToolItem item = new ToolItem(coolItemToolBar[i], 32);
                item.setText("CB" + (i * 2 + j));
                item.setToolTipText("ToolItem ToolTip" + i + j);
                if (item.getWidth() > toolItemWidth) {
                    toolItemWidth = item.getWidth();
                }
                this.hookExpectedEvents((Widget)item, test, events);
                ++j;
            }
            coolItem.setControl((Control)coolItemToolBar[i]);
            Point size = i == 1 ? coolItemToolBar[i].computeSize(20, -1) : coolItemToolBar[i].computeSize(-1, -1);
            Point coolSize = coolItem.computeSize(size.x, size.y);
            coolItem.setMinimumSize(toolItemWidth / 3, coolSize.y);
            coolItem.setPreferredSize(coolSize);
            coolItem.setSize(coolSize.x / 3, coolSize.y);
            coolItem.addSelectionListener((SelectionListener)new CoolItemSelectionListener());
            ++i;
        }
        this.setWidget((Widget)this.coolBar);
    }

    @Test
    public void test_consistency_ChevronMenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createCoolBar(events);
        this.consistencyPrePackShell();
        Point[] points = this.coolBar.getItemSizes();
        this.consistencyEvent(points[0].x - 12, 0, 3, 1, 30, events);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createCoolBar(events);
        this.consistencyPrePackShell();
        Point[] points = this.coolBar.getItemSizes();
        this.consistencyEvent(points[0].x, 2, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_ChevronDragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createCoolBar(events);
        this.consistencyPrePackShell();
        Point[] points = this.coolBar.getItemSizes();
        this.consistencyEvent(points[0].x - 12, 0, points[0].x - 12, 5, 50, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createCoolBar(events);
        this.consistencyPrePackShell();
        Point[] points = this.coolBar.getItemSizes();
        this.consistencyEvent(points[0].x, 0, points[0].x, 5, 50, events);
    }

    @Test
    public void test_consistency_ChevronMouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createCoolBar(events);
        this.consistencyPrePackShell();
        Point[] points = this.coolBar.getItemSizes();
        this.consistencyEvent(points[0].x - 12, 0, points[0].x - 8, 30, 60, events);
    }

    class CoolItemSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        CoolItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                    return;
                }
                CoolItem coolItem = (CoolItem)event.widget;
                Rectangle itemBounds = coolItem.getBounds();
                itemBounds.width = event.x - itemBounds.x;
                Point pt = Test_org_eclipse_swt_widgets_CoolBar.this.coolBar.toDisplay(new Point(itemBounds.x, itemBounds.y));
                itemBounds.x = pt.x;
                itemBounds.y = pt.y;
                ToolBar toolBar = (ToolBar)coolItem.getControl();
                ToolItem[] tools = toolBar.getItems();
                int toolCount = tools.length;
                int i = 0;
                while (i < toolCount) {
                    Rectangle toolBounds = tools[i].getBounds();
                    pt = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
                    toolBounds.x = pt.x;
                    toolBounds.y = pt.y;
                    Rectangle intersection = itemBounds.intersection(toolBounds);
                    if (!intersection.equals((Object)toolBounds)) break;
                    ++i;
                }
                this.menu = new Menu((Control)Test_org_eclipse_swt_widgets_CoolBar.this.coolBar);
                int j = i;
                while (j < toolCount) {
                    ToolItem tool = tools[j];
                    String text = tool.getText();
                    MenuItem menuItem = new MenuItem(this.menu, 0);
                    menuItem.setText(text);
                    ++j;
                }
                pt = Test_org_eclipse_swt_widgets_CoolBar.this.coolBar.toDisplay(new Point(event.x, event.y));
                this.menu.setLocation(pt.x, pt.y);
                this.menu.setVisible(true);
                Display display = Test_org_eclipse_swt_widgets_CoolBar.this.coolBar.getDisplay();
                while (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }
        }
    }
}

