/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Canvas;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Decorations
extends Test_org_eclipse_swt_widgets_Canvas {
    Decorations decorations;
    private List<Image> images = new ArrayList<Image>();

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
        this.decorations.computeTrim(0, 0, 0, 0);
        this.decorations.computeTrim(0, 0, 10, 20);
    }

    @Override
    @Test
    public void test_getClientArea() {
        Rectangle rect = this.decorations.getClientArea();
        Assert.assertTrue((String)":a:", (rect.height >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)":b:", (rect.width >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getDefaultButton() {
        Button button = new Button((Composite)this.decorations, 8);
        this.decorations.setDefaultButton(button);
        Assert.assertTrue((String)":a:", (this.decorations.getDefaultButton() == button ? 1 : 0) != 0);
    }

    @Test
    public void test_getImage() {
        Image[] cases;
        ImageGcDrawer noOpGcDrawer = (gc, width, height) -> {};
        Image[] imageArray = new Image[2];
        imageArray[1] = new Image(null, noOpGcDrawer, 100, 100);
        Image[] imageArray2 = cases = imageArray;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray2[n2];
            this.decorations.setImage(image);
            Assert.assertEquals((Object)this.decorations.getImage(), (Object)image);
            if (image != null) {
                image.dispose();
            }
            ++n2;
        }
    }

    @Override
    @Test
    public void test_getLocation() {
        this.decorations.setLocation(10, 15);
        Assert.assertEquals((String)":a:", (long)10L, (long)this.decorations.getLocation().x);
        Assert.assertEquals((String)":b:", (long)15L, (long)this.decorations.getLocation().y);
    }

    @Test
    public void test_getMenuBar() {
        Assert.assertNull((String)":a:", (Object)this.decorations.getMenuBar());
        Menu bar = new Menu(this.decorations, 2);
        this.decorations.setMenuBar(bar);
        Assert.assertTrue((String)":b:", (this.decorations.getMenuBar() == bar ? 1 : 0) != 0);
    }

    @Test
    public void test_getText() {
        this.decorations.setText("test");
        Assert.assertEquals((String)":a:", (Object)"test", (Object)this.decorations.getText());
    }

    @Override
    @Test
    public void test_isReparentable() {
        Assert.assertFalse((boolean)this.decorations.isReparentable());
    }

    @Test
    public void test_setDefaultButtonLorg_eclipse_swt_widgets_Button() {
        Assert.assertNull((Object)this.decorations.getDefaultButton());
        Button button = new Button((Composite)this.decorations, 0);
        this.decorations.setDefaultButton(button);
        Assert.assertTrue((String)"button not default", (this.decorations.getDefaultButton() == button ? 1 : 0) != 0);
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.decorations.setDefaultButton(null);
            Assert.assertNull((Object)this.decorations.getDefaultButton());
        }
    }

    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Assert.assertNull((String)":a:", (Object)this.decorations.getImage());
        this.loadImages();
        this.decorations.setImage(this.images.get(0));
        Assert.assertTrue((String)":b:", (this.images.get(0) == this.decorations.getImage() ? 1 : 0) != 0);
        Assert.assertTrue((String)":c:", (this.images.get(1) != this.decorations.getImage() ? 1 : 0) != 0);
        this.decorations.setImage(null);
        Assert.assertNull((String)":d:", (Object)this.decorations.getImage());
        this.freeImages();
    }

    @Test
    public void test_setMaximizedZ() {
        this.decorations.setMaximized(false);
        Assert.assertFalse((String)":1:", (boolean)this.decorations.getMaximized());
        this.decorations.setMaximized(true);
        Assert.assertTrue((String)":2:", (boolean)this.decorations.getMaximized());
        Assert.assertFalse((String)":3:", (boolean)this.decorations.getMinimized());
    }

    @Test
    public void test_setMenuBarLorg_eclipse_swt_widgets_Menu() {
        Assert.assertNull((Object)this.decorations.getMenu());
        Menu testMenu = new Menu((Control)this.decorations);
        this.decorations.setMenu(testMenu);
        Assert.assertTrue((String)"Incorrect menu", (this.decorations.getMenu() == testMenu ? 1 : 0) != 0);
        this.decorations.setMenu(null);
        Assert.assertNull((Object)this.decorations.getMenu());
    }

    @Test
    public void test_setMinimizedZ() {
        this.decorations.setMinimized(false);
        Assert.assertFalse((String)":1:", (boolean)this.decorations.getMinimized());
        this.decorations.setMinimized(true);
        Assert.assertTrue((String)":2:", (boolean)this.decorations.getMinimized());
        Assert.assertFalse((String)":3:", (boolean)this.decorations.getMaximized());
    }

    @Test
    public void test_setTextLjava_lang_String() {
        try {
            this.decorations.setText(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String testStr = "test string";
        this.decorations.setText(testStr);
        Assert.assertEquals((String)"a", (Object)testStr, (Object)this.decorations.getText());
        this.decorations.setText("");
        Assert.assertTrue((String)"b", (boolean)this.decorations.getText().isEmpty());
        try {
            this.decorations.setText(null);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    @Test
    public void test_setVisibleZ() {
    }

    @Override
    protected void setWidget(Widget w) {
        if (this.decorations != null && !this.decorations.isDisposed()) {
            this.decorations.dispose();
        }
        this.decorations = (Decorations)w;
        super.setWidget(w);
    }

    private void loadImages() {
        String[] stringArray = SwtTestUtil.imageFormats;
        int n = SwtTestUtil.imageFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            String[] stringArray2 = SwtTestUtil.imageFilenames;
            int n3 = SwtTestUtil.imageFilenames.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                try {
                    Throwable throwable = null;
                    Object var10_11 = null;
                    try (InputStream resource = this.getClass().getResourceAsStream(fileName + "." + format);){
                        this.images.add(new Image((Device)this.shell.getDisplay(), resource));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
                ++n4;
            }
            ++n2;
        }
    }

    private void freeImages() {
        for (Image image : this.images) {
            image.dispose();
        }
    }
}

