/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Dialog;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.FileDialog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Test_org_eclipse_swt_widgets_FileDialog
extends Test_org_eclipse_swt_widgets_Dialog {
    FileDialog fileDialog;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.fileDialog = new FileDialog(this.shell, 0);
        this.setDialog((Dialog)this.fileDialog);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Shell() {
        new FileDialog(this.shell);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FileDialog fileDialog = new FileDialog(null);
        }, (String)"No exception thrown for parent == null");
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_ShellI() {
        FileDialog fd = new FileDialog(this.shell, 0);
        int style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assertions.assertEquals((int)65536, (int)(style &= 0xFBFFFFFF));
        fd = new FileDialog(this.shell, 65536);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assertions.assertEquals((int)65536, (int)(style &= 0xFBFFFFFF));
        fd = new FileDialog(this.shell, 32768);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assertions.assertEquals((int)32768, (int)(style &= 0xFBFFFFFF));
        fd = new FileDialog(this.shell, 131072);
        style = fd.getStyle();
        style &= 0xFDFFFFFF;
        Assertions.assertEquals((int)131072, (int)(style &= 0xFBFFFFFF));
    }

    @Test
    public void test_getFileNames() {
        String[] names = this.fileDialog.getFileNames();
        Assertions.assertEquals((int)0, (int)names.length);
    }

    @Test
    public void test_open() {
        if (SwtTestUtil.fTestDialogOpen) {
            this.fileDialog.open();
        }
    }

    @Test
    public void test_setFileNameLjava_lang_String() {
        this.fileDialog.setFileName("");
        String name = this.fileDialog.getFileName();
        Assertions.assertTrue((boolean)name.isEmpty());
        this.fileDialog.setFileName(null);
        name = this.fileDialog.getFileName();
        Assertions.assertNull((Object)name);
        this.fileDialog.setFileName("somefile.test");
        name = this.fileDialog.getFileName();
        Assertions.assertEquals((Object)"somefile.test", (Object)name);
    }

    @Test
    public void test_setFilterExtensions$Ljava_lang_String() {
        this.fileDialog.setFilterExtensions(new String[]{"txt", "java"});
        String[] filters = this.fileDialog.getFilterExtensions();
        Assertions.assertEquals((int)2, (int)filters.length);
        Assertions.assertEquals((Object)"txt", (Object)filters[0]);
        Assertions.assertEquals((Object)"java", (Object)filters[1]);
        this.fileDialog.setFilterExtensions(new String[]{""});
        filters = this.fileDialog.getFilterExtensions();
        Assertions.assertEquals((int)1, (int)filters.length);
        this.fileDialog.setFilterExtensions(null);
        filters = this.fileDialog.getFilterExtensions();
        Assertions.assertNull((Object)filters);
    }

    @Test
    public void test_setFilterNames$Ljava_lang_String() {
        this.fileDialog.setFilterNames(new String[]{"a.txt", "b.java"});
        String[] filters = this.fileDialog.getFilterNames();
        Assertions.assertEquals((int)2, (int)filters.length);
        Assertions.assertEquals((Object)"a.txt", (Object)filters[0]);
        Assertions.assertEquals((Object)"b.java", (Object)filters[1]);
        this.fileDialog.setFilterNames(new String[]{""});
        filters = this.fileDialog.getFilterNames();
        Assertions.assertEquals((int)1, (int)filters.length);
        this.fileDialog.setFilterNames(null);
        filters = this.fileDialog.getFilterNames();
        Assertions.assertNull((Object)filters);
    }

    @Test
    public void test_setFilterPathLjava_lang_String() {
        Assertions.assertEquals((Object)"", (Object)this.fileDialog.getFilterPath());
        String testStr = "./*";
        this.fileDialog.setFilterPath(testStr);
        Assertions.assertEquals((Object)testStr, (Object)this.fileDialog.getFilterPath());
        this.fileDialog.setFilterPath("");
        Assertions.assertTrue((boolean)this.fileDialog.getFilterPath().isEmpty());
        this.fileDialog.setFilterPath(null);
        Assertions.assertNull((Object)this.fileDialog.getFilterPath());
    }
}

