/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Widget;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Item
extends Test_org_eclipse_swt_widgets_Widget {
    Item item;
    Image[] images = new Image[SwtTestUtil.imageFormats.length * SwtTestUtil.imageFilenames.length];

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.loadImages();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.freeImages();
    }

    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Assert.assertNull((Object)this.item.getImage());
        this.item.setImage(this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.item.getImage());
        Assert.assertTrue((this.item.getImage() != this.images[1] ? 1 : 0) != 0);
        this.item.setImage(null);
        Assert.assertNull((Object)this.item.getImage());
    }

    @Test
    public void test_setTextLjava_lang_String() {
        String testStr = "test string";
        this.item.setText(testStr);
        Assert.assertEquals((String)"a", (Object)testStr, (Object)this.item.getText());
        this.item.setText("");
        Assert.assertTrue((String)"b", (boolean)this.item.getText().isEmpty());
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.item.setText(null));
    }

    private void loadImages() {
        int numFormats = SwtTestUtil.imageFormats.length;
        int numFiles = SwtTestUtil.imageFilenames.length;
        int i = 0;
        while (i < numFormats) {
            String format = SwtTestUtil.imageFormats[i];
            int index = i * numFiles;
            int j = 0;
            while (j < numFiles) {
                String fileName = SwtTestUtil.imageFilenames[j];
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (InputStream resource = this.getClass().getResourceAsStream(fileName + "." + format);){
                        this.images[index + j] = new Image((Device)this.shell.getDisplay(), resource);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {}
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void setWidget(Widget widget) {
        this.item = (Item)widget;
        super.setWidget(widget);
    }

    private void freeImages() {
        Image[] imageArray = this.images;
        int n = this.images.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            if (image != null) {
                image.dispose();
            }
            ++n2;
        }
    }
}

