/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Item;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_MenuItem
extends Test_org_eclipse_swt_widgets_Item {
    Menu menu;
    MenuItem menuItem;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.menu = new Menu((Control)this.shell);
        this.menuItem = new MenuItem(this.menu, 0);
        this.setWidget((Widget)this.menuItem);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_MenuI() {
        MenuItem mItem = new MenuItem(this.menu, 0);
        Assert.assertNotNull((Object)mItem);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            MenuItem menuItem = new MenuItem(null, 0);
        });
        mItem = new MenuItem(this.menu, 32);
        Assert.assertEquals((long)32L, (long)mItem.getStyle());
        mItem.dispose();
        mItem = new MenuItem(this.menu, 64);
        Assert.assertEquals((long)64L, (long)mItem.getStyle());
        mItem.dispose();
        mItem = new MenuItem(this.menu, 8);
        Assert.assertEquals((long)8L, (long)mItem.getStyle());
        mItem.dispose();
        mItem = new MenuItem(this.menu, 2);
        Assert.assertEquals((long)2L, (long)mItem.getStyle());
        mItem.dispose();
        mItem = new MenuItem(this.menu, 16);
        Assert.assertEquals((long)16L, (long)mItem.getStyle());
        mItem.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_MenuII() {
        MenuItem mItem = new MenuItem(this.menu, 0, 0);
        Assert.assertNotNull((Object)mItem);
        Assert.assertEquals((Object)mItem, (Object)this.menu.getItem(0));
        mItem = new MenuItem(this.menu, 0, 1);
        Assert.assertNotNull((Object)mItem);
        Assert.assertEquals((Object)mItem, (Object)this.menu.getItem(1));
    }

    @Test
    public void test_addArmListenerLorg_eclipse_swt_events_ArmListener() {
        this.listenerCalled = false;
        ArmListener listener = e -> {
            boolean bl = this.listenerCalled = true;
        };
        Assert.assertThrows((String)"No exception thrown for addArmListener with null argument", IllegalArgumentException.class, () -> this.menuItem.addArmListener(null));
        this.menuItem.addArmListener(listener);
        this.menuItem.notifyListeners(30, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        Assert.assertThrows((String)"No exception thrown for removeArmListener with null argument", IllegalArgumentException.class, () -> this.menuItem.removeArmListener(null));
        this.listenerCalled = false;
        this.menuItem.removeArmListener(listener);
        this.menuItem.notifyListeners(30, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addHelpListenerLorg_eclipse_swt_events_HelpListener() {
        this.listenerCalled = false;
        HelpListener listener = e -> {
            boolean bl = this.listenerCalled = true;
        };
        Assert.assertThrows((String)"No exception thrown for addHelpListener with null argument", IllegalArgumentException.class, () -> this.menuItem.addHelpListener(null));
        this.menuItem.addHelpListener(listener);
        this.menuItem.notifyListeners(28, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        Assert.assertThrows((String)"No exception thrown for removeHelpListener with null argument", IllegalArgumentException.class, () -> this.menuItem.removeHelpListener(null));
        this.listenerCalled = false;
        this.menuItem.removeHelpListener(listener);
        this.menuItem.notifyListeners(28, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Test_org_eclipse_swt_widgets_MenuItem.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        Assert.assertThrows((String)"No exception thrown for addSelectionListener with null argument", IllegalArgumentException.class, () -> this.menuItem.addSelectionListener(null));
        this.menuItem.addSelectionListener(listener);
        this.menuItem.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        Assert.assertThrows((String)"No exception thrown for removeSelectionListener with null argument", IllegalArgumentException.class, () -> this.menuItem.removeSelectionListener(null));
        this.listenerCalled = false;
        this.menuItem.removeSelectionListener(listener);
        this.menuItem.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.menuItem.addSelectionListener(listener);
        this.menuItem.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.menuItem.removeSelectionListener(listener);
        this.menuItem.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_getAccelerator() {
        this.menuItem.setAccelerator(SWT.MOD1 + 88);
        Assert.assertEquals((long)this.menuItem.getAccelerator(), (long)(SWT.MOD1 + 88));
        this.menuItem.setAccelerator(SWT.MOD2 + 89);
        Assert.assertEquals((long)this.menuItem.getAccelerator(), (long)(SWT.MOD2 + 89));
        this.menuItem.setAccelerator(SWT.MOD3 + 90);
        Assert.assertEquals((long)this.menuItem.getAccelerator(), (long)(SWT.MOD3 + 90));
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.menuItem.getParent(), (Object)this.menu);
    }

    @Test
    public void test_isEnabled() {
        this.menuItem.setEnabled(true);
        Assert.assertTrue((boolean)this.menuItem.isEnabled());
        this.menuItem.setEnabled(false);
        Assert.assertFalse((boolean)this.menuItem.isEnabled());
    }

    @Test
    public void test_setAcceleratorI() {
        this.menuItem.setAccelerator(262234);
        Assert.assertEquals((long)this.menuItem.getAccelerator(), (long)262234L);
    }

    @Test
    public void test_setEnabledZ() {
        this.menuItem.setEnabled(true);
        Assert.assertTrue((boolean)this.menuItem.getEnabled());
        this.menuItem.setEnabled(false);
        Assert.assertFalse((boolean)this.menuItem.getEnabled());
    }

    @Override
    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Assert.assertNull((Object)this.menuItem.getImage());
        this.menuItem.setImage(this.images[0]);
        Assert.assertEquals((Object)this.images[0], (Object)this.menuItem.getImage());
        Assert.assertTrue((this.menuItem.getImage() != this.images[1] ? 1 : 0) != 0);
        this.menuItem.setImage(null);
        Assert.assertNull((Object)this.menuItem.getImage());
    }

    @Test
    public void test_setMenuLorg_eclipse_swt_widgets_Menu() {
        Assert.assertNull((Object)this.menuItem.getMenu());
        MenuItem mItem = new MenuItem(this.menu, 64);
        Menu newMenu = new Menu((Decorations)this.shell, 4);
        mItem.setMenu(newMenu);
        Assert.assertEquals((Object)mItem.getMenu(), (Object)newMenu);
    }

    @Test
    public void test_setSelectionZ() {
        int[] itemStyles;
        int[] nArray = itemStyles = new int[]{32, 16};
        int n = itemStyles.length;
        int n2 = 0;
        while (n2 < n) {
            int itemStyle = nArray[n2];
            MenuItem mItem = new MenuItem(this.menu, itemStyle);
            mItem.setSelection(false);
            Assert.assertFalse((boolean)mItem.getSelection());
            mItem.setSelection(true);
            Assert.assertTrue((boolean)mItem.getSelection());
            mItem.dispose();
            ++n2;
        }
    }

    @Override
    @Test
    public void test_setTextLjava_lang_String() {
        this.menuItem.setText("ABCDEFG");
        Assert.assertEquals((Object)"ABCDEFG", (Object)this.menuItem.getText());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.menuItem.setText(null));
        this.menuItem.setText("ABCDEFG");
        this.menuItem.setAccelerator(SWT.MOD1 + 65);
        Assert.assertTrue((boolean)this.menuItem.getText().startsWith("ABCDEFG"));
        this.menuItem.setAccelerator(0);
        this.menuItem.setText("AB&CDEFG");
        Assert.assertEquals((Object)"AB&CDEFG", (Object)this.menuItem.getText());
    }
}

