/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Decorations;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Shell
extends Test_org_eclipse_swt_widgets_Decorations {
    private static final boolean IS_GTK_BUG_445900 = SwtTestUtil.isGTK;
    Shell testShell;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.testShell = new Shell(this.shell, 0);
        this.setWidget((Widget)this.shell);
        Assert.assertEquals((Object)this.shell, (Object)this.testShell.getParent());
    }

    @Test
    public void test_Constructor() {
        Shell newShell = new Shell();
        Assert.assertNotNull((String)"a: ", (Object)newShell.getDisplay());
        newShell.dispose();
    }

    @Test
    public void test_ConstructorI() {
        int[] cases = new int[]{8, 16, 32, 64, 64, 128, 2048, 4096, 8192, 16384, 0x800000, 65536};
        int i = 0;
        while (i < cases.length) {
            Shell newShell = new Shell(cases[i]);
            Assert.assertEquals((String)("a " + i), (Object)this.shell.getDisplay(), (Object)newShell.getDisplay());
            Assert.assertNotEquals((long)0L, (long)(newShell.getStyle() & cases[i]));
            newShell.dispose();
            ++i;
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Display() {
        Display display = this.shell.getDisplay();
        Shell newShell = new Shell(display);
        Assert.assertEquals((String)"a: ", (Object)display, (Object)newShell.getDisplay());
        newShell.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_DisplayI() {
        int[] cases = new int[]{8, 16, 32, 64, 64, 128, 2048, 4096, 8192, 16384, 0x800000, 65536};
        Display display = this.shell.getDisplay();
        int i = 0;
        while (i < cases.length) {
            Shell newShell = new Shell(display, cases[i]);
            Assert.assertEquals((String)("a " + i), (Object)this.shell.getDisplay(), (Object)newShell.getDisplay());
            newShell.dispose();
            ++i;
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Shell() {
        Shell newShell = new Shell(this.shell);
        Assert.assertEquals((String)"a: ", (Object)this.shell, (Object)newShell.getParent());
        newShell.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_ShellI() {
        int[] cases = new int[]{8, 16, 32, 64, 64, 128, 2048, 4096, 8192, 16384, 0x800000, 65536};
        int i = 0;
        while (i < cases.length) {
            Shell newShell = new Shell(this.shell, cases[i]);
            Assert.assertEquals((String)("a: " + i), (Object)this.shell, (Object)newShell.getParent());
            newShell.dispose();
            ++i;
        }
    }

    @Test
    public void test_addShellListenerLorg_eclipse_swt_events_ShellListener() {
        this.listenerCalled = false;
        boolean exceptionThrown = false;
        ShellListener listener = new ShellListener(){

            public void shellActivated(ShellEvent e) {
                Test_org_eclipse_swt_widgets_Shell.this.listenerCalled = true;
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
            }
        };
        try {
            this.shell.addShellListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
        exceptionThrown = false;
        this.shell.addShellListener(listener);
        this.shell.forceActive();
        this.listenerCalled = false;
        this.shell.removeShellListener(listener);
        this.shell.forceActive();
        try {
            this.shell.removeShellListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown", (boolean)exceptionThrown);
    }

    @Test
    public void test_addShellListenerShellActivatedAdapterLorg_eclipse_swt_events_ShellListener() {
        ShellListener listener = ShellListener.shellActivatedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.shell.addShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.removeShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addShellListenerShellDeactivatedAdapterLorg_eclipse_swt_events_ShellListener() {
        ShellListener listener = ShellListener.shellDeactivatedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.shell.addShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(27, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.removeShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addShellListenerShellDeiconifiedAdapterLorg_eclipse_swt_events_ShellListener() {
        ShellListener listener = ShellListener.shellDeiconifiedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.shell.addShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(20, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.removeShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addShellListenerShellIconifiedAdapterLorg_eclipse_swt_events_ShellListener() {
        ShellListener listener = ShellListener.shellIconifiedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.shell.addShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(19, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.removeShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_addShellListenerShellClosedAdapterLorg_eclipse_swt_events_ShellListener() {
        ShellListener listener = ShellListener.shellClosedAdapter(e -> {
            boolean bl = this.eventOccurred = true;
        });
        this.shell.addShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(21, new Event());
        Assert.assertTrue((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.removeShellListener(listener);
        this.eventOccurred = false;
        this.shell.notifyListeners(26, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(27, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(20, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(19, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
        this.shell.notifyListeners(21, new Event());
        Assert.assertFalse((boolean)this.eventOccurred);
    }

    @Test
    public void test_close() {
        this.testShell.setBounds(20, 30, 200, 200);
        this.testShell.open();
        this.testShell.close();
        this.shell.setBounds(20, 30, 200, 200);
        this.shell.open();
    }

    @Test
    public void test_dispose() {
        Shell newShell = new Shell();
        newShell.dispose();
    }

    @Test
    public void test_forceActive() {
        this.shell.forceActive();
    }

    @Test
    public void test_getEnabled() {
        Assert.assertTrue((String)":a0:", (boolean)this.shell.getEnabled());
        this.shell.setEnabled(false);
        Assert.assertTrue((String)":a:", (!this.shell.getEnabled() ? 1 : 0) != 0);
        this.shell.setEnabled(true);
        Assert.assertTrue((String)":b:", (boolean)this.shell.getEnabled());
    }

    @Test
    public void test_getImeInputMode() {
        int mode = this.shell.getImeInputMode();
        Assert.assertTrue((String)":a:", (mode >= 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_getLocation() {
        this.shell.setLocation(10, 15);
        Assert.assertEquals((String)":a:", (long)10L, (long)this.shell.getLocation().x);
        Assert.assertEquals((String)":b:", (long)15L, (long)this.shell.getLocation().y);
    }

    @Override
    @Test
    public void test_getShell() {
        Assert.assertEquals((String)":a:", (Object)this.shell, (Object)this.shell.getShell());
        Shell shell_1 = new Shell(this.shell);
        Assert.assertEquals((String)":b:", (Object)shell_1, (Object)shell_1.getShell());
        shell_1.dispose();
    }

    @Test
    public void test_getShells() {
        int num = this.shell.getShells().length;
        Assert.assertEquals((String)":a:", (long)1L, (long)num);
        Shell shell_1 = new Shell(this.shell);
        num = this.shell.getShells().length;
        Assert.assertEquals((String)":b:", (long)2L, (long)num);
        shell_1.dispose();
        num = this.shell.getShells().length;
        Assert.assertEquals((String)":c:", (long)1L, (long)num);
    }

    @Override
    @Test
    public void test_isEnabled() {
        Assert.assertTrue((String)":a:", (boolean)this.shell.isEnabled());
        this.shell.setEnabled(false);
        Assert.assertTrue((String)":b:", (!this.shell.isEnabled() ? 1 : 0) != 0);
        if (SwtTestUtil.fCheckBogusTestCases) {
            Assert.assertTrue((String)":b1:", (!this.testShell.isEnabled() ? 1 : 0) != 0);
        }
        this.shell.setEnabled(true);
        Assert.assertTrue((String)":c:", (boolean)this.shell.isEnabled());
        Assert.assertTrue((String)":a:", (boolean)this.testShell.isEnabled());
        this.testShell.setEnabled(false);
        Assert.assertTrue((String)":b:", (!this.testShell.isEnabled() ? 1 : 0) != 0);
        this.testShell.setEnabled(true);
        Assert.assertTrue((String)":c:", (boolean)this.testShell.isEnabled());
    }

    @Test
    public void test_open() {
        this.shell.open();
    }

    @Test
    public void test_setActive() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setActive(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Shell))");
            }
            return;
        }
        Shell shell2 = new Shell();
        shell2.setText("Shell2");
        shell2.open();
        this.shell.setVisible(true);
        this.shell.setActive();
        Assert.assertTrue((String)"visible shell was not made active", (this.shell.getDisplay().getActiveShell() == this.shell ? 1 : 0) != 0);
        shell2.setActive();
        this.testShell.setBounds(this.shell.getBounds());
        this.testShell.setVisible(true);
        this.testShell.setActive();
        Assert.assertTrue((String)"visible dialog shell was not made active", (this.testShell.getDisplay().getActiveShell() == this.testShell ? 1 : 0) != 0);
        shell2.setActive();
        this.shell.setVisible(false);
        this.shell.setActive();
        shell2.setText("Shell2: Not active");
        Assert.assertTrue((String)"non-visible shell was made active", (this.shell.getDisplay().getActiveShell() != this.shell ? 1 : 0) != 0);
        shell2.setActive();
        this.testShell.setVisible(false);
        this.testShell.setActive();
        shell2.setText("Shell2: Not active");
        Assert.assertTrue((String)"non-visible dialog shell was made active", (this.testShell.getDisplay().getActiveShell() != this.testShell ? 1 : 0) != 0);
        shell2.dispose();
    }

    @Override
    @Test
    public void test_setEnabledZ() {
    }

    @Test
    public void test_setImeInputModeI() {
        this.shell.setImeInputMode(0);
        Assert.assertEquals((String)":a:", (long)0L, (long)this.shell.getImeInputMode());
    }

    @Override
    @Test
    public void test_setVisibleZ() {
        this.shell.setVisible(false);
        Assert.assertTrue((String)":a:", (!this.shell.isVisible() ? 1 : 0) != 0);
        this.shell.setVisible(true);
        Assert.assertTrue((String)":b:", (boolean)this.shell.isVisible());
    }

    @Override
    @Test
    public void test_getParent() {
        Assert.assertNull((Object)this.shell.getParent());
        Assert.assertEquals((Object)this.shell, (Object)this.testShell.getParent());
    }

    @Test
    public void test_getStyle() {
        this.testShell.getStyle();
        Assert.assertTrue((String)"testShell not modeless", (!false ? 1 : 0) != 0);
        int[] nArray = new int[4];
        nArray[1] = 32768;
        nArray[2] = 65536;
        nArray[3] = 131072;
        int[] cases = nArray;
        int i = 0;
        while (i < cases.length) {
            Shell testShell2 = new Shell(this.shell, cases[i]);
            Assert.assertTrue((String)("shell " + i), ((testShell2.getStyle() & cases[i]) == cases[i] ? 1 : 0) != 0);
            testShell2.dispose();
            ++i;
        }
    }

    @Override
    @Test
    public void test_isVisible() {
        this.testShell.setVisible(true);
        Assert.assertTrue((boolean)this.testShell.isVisible());
        this.shell.setVisible(true);
        Assert.assertTrue((boolean)this.shell.isVisible());
        this.testShell.setVisible(true);
        this.shell.setVisible(true);
        Assert.assertTrue((String)"shell.isVisible() a:", (boolean)this.shell.isVisible());
        this.shell.setVisible(false);
        Assert.assertTrue((String)"shell.isVisible() b:", (!this.shell.isVisible() ? 1 : 0) != 0);
        if (SwtTestUtil.fCheckBogusTestCases) {
            Assert.assertTrue((String)"testShell.isVisible() c:", (!this.testShell.isVisible() ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void test_setBoundsIIII() {
    }

    @Override
    @Test
    public void test_setBoundsLorg_eclipse_swt_graphics_Rectangle() {
    }

    @Test
    public void test_activateEventSend() {
        if (SwtTestUtil.isGTK && SwtTestUtil.isX11) {
            int[] styles;
            Shell testShell = new Shell(this.shell, 1264);
            testShell.addListener(26, e -> {
                this.listenerCalled = true;
            });
            testShell.open();
            int[] nArray = styles = new int[]{16384, 65536, 32768, 131072, 8, 2048, 1264};
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                int style = nArray[n2];
                Shell childShell = new Shell(testShell, style);
                this.listenerCalled = false;
                childShell.open();
                childShell.dispose();
                Assert.assertTrue((boolean)this.listenerCalled);
                ++n2;
            }
        }
    }

    @Test
    public void test_setBounds() throws Exception {
        if (SwtTestUtil.isX11) {
            Rectangle bounds = new Rectangle(100, 200, 200, 200);
            Rectangle bounds2 = new Rectangle(150, 250, 250, 250);
            StringBuilder log = new StringBuilder();
            int[] styles = new int[]{8, 2048, 16, 2080, 48, 32};
            int i = 0;
            while (i < styles.length) {
                Shell testShell = new Shell(this.shell, styles[i]);
                try {
                    testShell.setBounds(bounds);
                    this.logUnlessEquals(log, i + ".1: style 0x" + Integer.toHexString(styles[i]), bounds, testShell.getBounds());
                    testShell.open();
                    this.logUnlessEquals(IS_GTK_BUG_445900 ? System.out : log, i + ".2: style 0x" + Integer.toHexString(styles[i]), bounds, testShell.getBounds());
                    testShell.setBounds(bounds);
                    this.logUnlessEquals(log, i + ".3: style 0x" + Integer.toHexString(styles[i]), bounds, testShell.getBounds());
                    testShell.setBounds(bounds2);
                    this.logUnlessEquals(log, i + ".4: style 0x" + Integer.toHexString(styles[i]), bounds2, testShell.getBounds());
                }
                finally {
                    testShell.dispose();
                }
                ++i;
            }
            if (log.length() > 0) {
                Assert.fail((String)log.toString());
            }
        }
    }

    private void logUnlessEquals(Appendable log, String message, Rectangle expected, Rectangle actual) throws IOException {
        if (!expected.equals((Object)actual)) {
            log.append(message).append("; expected: ").append(expected.toString()).append(", but was: ").append(actual.toString()).append("\n");
        }
    }

    @Test
    public void a_test_setRegion() {
        Region region = new Region();
        region.add(new Rectangle(10, 20, 100, 200));
        Assert.assertNull((String)":a:", (Object)this.shell.getRegion());
        this.shell.setRegion(region);
        Assert.assertNull((String)":b:", (Object)this.shell.getRegion());
        this.shell.setRegion(null);
        Assert.assertNull((String)":c:", (Object)this.shell.getRegion());
        Display display = this.shell.getDisplay();
        Shell shell2 = new Shell(display, 8);
        Assert.assertNull((String)":d:", (Object)shell2.getRegion());
        shell2.setRegion(region);
        Assert.assertEquals((String)":e:", (Object)region, (Object)shell2.getRegion());
        region.dispose();
        Assert.assertTrue((String)":f:", (boolean)shell2.getRegion().isDisposed());
        shell2.setRegion(null);
        Assert.assertNull((String)":g:", (Object)shell2.getRegion());
    }

    @Override
    @Test
    public void test_setSizeII() {
        if (SwtTestUtil.isWindows) {
            Point newSize = new Point(112, 27);
            int i = 0;
            while (i < 10) {
                this.testShell.setSize(newSize.x, newSize.y);
                Assert.assertEquals((Object)newSize, (Object)this.testShell.getSize());
                newSize.x += 100;
                newSize.y += 100;
                ++i;
            }
            newSize = new Point(1292, 1036);
            i = 0;
            while (i < 10) {
                this.testShell.setSize(newSize.x, newSize.y);
                Assert.assertEquals((Object)newSize, (Object)this.testShell.getSize());
                newSize.x -= 100;
                newSize.y -= 100;
                ++i;
            }
        }
    }

    @Test
    public void test_setSizeCustomResize() {
        if (SwtTestUtil.isGTK) {
            Shell testShell = new Shell(this.shell, 16400);
            Point size = new Point(200, 200);
            testShell.setSize(size);
            testShell.open();
            Assert.assertEquals((Object)size, (Object)testShell.getSize());
            testShell.dispose();
        }
    }

    @Override
    @Test
    public void test_setSizeLorg_eclipse_swt_graphics_Point() {
        if (SwtTestUtil.isWindows) {
            Point newSize = new Point(112, 27);
            int i = 0;
            while (i < 10) {
                this.testShell.setSize(newSize);
                Assert.assertEquals((Object)newSize, (Object)this.testShell.getSize());
                newSize.x += 100;
                newSize.y += 100;
                ++i;
            }
            newSize = new Point(1292, 1036);
            i = 0;
            while (i < 10) {
                this.testShell.setSize(newSize);
                Assert.assertEquals((Object)newSize, (Object)this.testShell.getSize());
                newSize.x -= 100;
                newSize.y -= 100;
                ++i;
            }
        }
    }

    private void createShell() {
        this.tearDown();
        this.shell = new Shell();
        this.testShell = new Shell(this.shell, 2272);
        this.testShell.setSize(100, 300);
        this.testShell.setText("Shell");
        this.testShell.setLayout((Layout)new FillLayout());
        this.setWidget((Widget)this.testShell);
    }

    @Test
    public void test_consistency_Open() {
        if (SwtTestUtil.fTestConsistency) {
            this.createShell();
            final Display display = this.shell.getDisplay();
            ArrayList<String> events = new ArrayList<String>();
            Object[] temp = this.hookExpectedEvents((Widget)this.testShell, this.getTestName(), events);
            this.shell.pack();
            this.shell.open();
            this.testShell.pack();
            this.testShell.open();
            new Thread(){

                @Override
                public void run() {
                    display.asyncExec((Runnable)new Thread(){

                        @Override
                        public void run() {
                            (this).Test_org_eclipse_swt_widgets_Shell.this.shell.dispose();
                        }
                    });
                }
            }.start();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            this.setUp();
            Object[] results = events.toArray(new String[events.size()]);
            Assert.assertArrayEquals((String)(this.getTestName() + " event ordering"), (Object[])temp, (Object[])results);
        }
    }

    @Test
    public void test_consistency_Iconify() {
        this.createShell();
        this.consistencyEvent(1, 0, 0, 0, 1, null, false);
    }

    @Test
    public void test_consistency_Close() {
        this.createShell();
        this.consistencyPrePackShell();
        this.consistencyEvent(0, 65536, 0, 0x100000D, 20);
        this.createShell();
    }

    @Test
    public void test_consistency_Dispose() {
        this.createShell();
        final Button button = new Button((Composite)this.testShell, 8);
        button.setText("dispose");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                button.dispose();
                Test_org_eclipse_swt_widgets_Shell.this.testShell.dispose();
            }
        });
        ArrayList<String> events = new ArrayList<String>();
        this.consistencyPrePackShell(this.testShell);
        Point pt = button.getLocation();
        this.consistencyEvent(pt.x, pt.y, 1, 0, 30, events);
        this.createShell();
    }

    @Test
    public void test_setAlpha() {
        this.createShell();
        this.testShell.setAlpha(128);
        int alpha = this.testShell.getAlpha();
        if (SwtTestUtil.isGTK && alpha == 255) {
            System.out.println("Test_org_eclipse_swt_widgets_Shell.test_setAlpha(): expected 128, but was 255. Probably missing window manager functionality, see bug 498208.");
        } else {
            Assert.assertEquals((long)128L, (long)alpha);
        }
        this.testShell.setAlpha(255);
        Assert.assertEquals((long)255L, (long)this.testShell.getAlpha());
    }

    @Test
    public void test_childDisposesParent() {
        this.createShell();
        Shell root = new Shell(this.testShell, 1264);
        Shell child = new Shell(root, 1264);
        child.addListener(12, e -> root.dispose());
        root.dispose();
    }

    @Test
    public void test_bug558652_scrollBarNPE() {
        int[] styles;
        this.createShell();
        int[] nArray = new int[3];
        nArray[1] = 2144;
        nArray[2] = 1264;
        int[] nArray2 = styles = nArray;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            int style = nArray2[n2];
            Shell shell = new Shell(this.testShell, style);
            Assert.assertNull((Object)shell.getVerticalBar());
            Assert.assertNull((Object)shell.getHorizontalBar());
            shell.dispose();
            shell = new Shell(this.testShell, style | 0x200);
            Assert.assertNotNull((Object)shell.getVerticalBar());
            Assert.assertNull((Object)shell.getHorizontalBar());
            shell.dispose();
            shell = new Shell(this.testShell, style | 0x100);
            Assert.assertNull((Object)shell.getVerticalBar());
            Assert.assertNotNull((Object)shell.getHorizontalBar());
            shell.dispose();
            shell = new Shell(this.testShell, style | 0x200 | 0x100);
            Assert.assertNotNull((Object)shell.getVerticalBar());
            Assert.assertNotNull((Object)shell.getHorizontalBar());
            shell.dispose();
            ++n2;
        }
    }

    @Test
    public void test_Issue450_NoShellActivateOnSetFocus() {
        String prevKey = System.getProperty("org.eclipse.swt.internal.activateShellOnForceFocus", null);
        System.setProperty("org.eclipse.swt.internal.activateShellOnForceFocus", "false");
        try {
            Display display = this.shell.getDisplay();
            Shell shell1 = new Shell(this.shell);
            shell1.setText("shell1");
            shell1.setLayout((Layout)new GridLayout());
            Text text11 = new Text((Composite)shell1, 2052);
            Text text12 = new Text((Composite)shell1, 2052);
            Shell shell2 = new Shell(this.shell);
            shell2.setText("shell2");
            shell2.setLayout((Layout)new GridLayout());
            Text text21 = new Text((Composite)shell2, 2052);
            Text text22 = new Text((Composite)shell2, 2052);
            SwtTestUtil.waitShellActivate(() -> ((Shell)shell1).open(), shell1);
            Assert.assertSame((String)"expecting the 1st shell to be activated", (Object)display.getActiveShell(), (Object)shell1);
            Assert.assertTrue((String)"expecting the 1st text field to be focused in the 1st shell", (boolean)text11.isFocusControl());
            SwtTestUtil.waitShellActivate(() -> ((Shell)shell2).open(), shell2);
            Assert.assertSame((String)"expecting the 2nd shell to be activated", (Object)display.getActiveShell(), (Object)shell2);
            Assert.assertTrue((String)"expecting the 1st text field in 2nd shell to be focused", (boolean)text21.isFocusControl());
            text12.setFocus();
            Assert.assertSame((String)"expecting the 2nd shell to remain activated", (Object)display.getActiveShell(), (Object)shell2);
            SwtTestUtil.waitShellActivate(() -> ((Shell)shell1).setActive(), shell1);
            Assert.assertSame((String)"expecting the 1st shell to be activated", (Object)display.getActiveShell(), (Object)shell1);
            Assert.assertTrue((String)"expecting the the 1st shell to have remembered the previous setFocus and with the shell activation setting it to the 2nd text field", (boolean)text12.isFocusControl());
            SwtTestUtil.waitShellActivate(() -> {
                shell1.dispose();
                if (SwtTestUtil.isCocoa) {
                    shell2.forceActive();
                }
            }, shell2);
            Assert.assertSame((String)"expecting the 2nd shell to be activated after the 1st, active has been disposed", (Object)display.getActiveShell(), (Object)shell2);
            Assert.assertTrue((String)"expecting the 1st text field in the 2nd shell to still have the focus because it hasn't been changed", (boolean)text21.isFocusControl());
            text22.setFocus();
            Assert.assertSame((String)"expecting the 2nd shell to remain activated", (Object)display.getActiveShell(), (Object)shell2);
            Assert.assertTrue((String)"expecting the 2nd text field to have received the focus", (boolean)text22.isFocusControl());
            shell2.dispose();
        }
        finally {
            if (prevKey != null) {
                System.setProperty("org.eclipse.swt.internal.activateShellOnForceFocus", prevKey);
            } else {
                System.getProperties().remove("org.eclipse.swt.internal.activateShellOnForceFocus");
            }
        }
    }
}

