/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Spinner
extends Test_org_eclipse_swt_widgets_Composite {
    Spinner spinner;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.spinner = new Spinner((Composite)this.shell, 0);
        this.setWidget((Widget)this.spinner);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        int[] cases;
        Assert.assertThrows((String)"No exception thrown for parent == null", IllegalArgumentException.class, () -> {
            Spinner spinner = new Spinner(null, 0);
        });
        int[] nArray = new int[3];
        nArray[1] = 8;
        nArray[2] = 64;
        int[] nArray2 = cases = nArray;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int style = nArray2[n2];
            this.spinner = new Spinner((Composite)this.shell, style);
            ++n2;
        }
    }

    @Test
    public void test_getIncrement() {
        int[] cases;
        int[] nArray = cases = new int[]{5, 100, 1000, 1};
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            this.spinner.setIncrement(value);
            Assert.assertEquals((long)value, (long)this.spinner.getIncrement());
            ++n2;
        }
        this.spinner.setIncrement(-1);
        Assert.assertEquals((long)cases[cases.length - 1], (long)this.spinner.getIncrement());
    }

    @Test
    public void test_getDigits() {
        int[] cases;
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 10;
        int[] nArray2 = cases = nArray;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int digits = nArray2[n2];
            this.spinner.setDigits(digits);
            Assert.assertEquals((long)digits, (long)this.spinner.getDigits());
            ++n2;
        }
        Assert.assertThrows((String)"setDigits should have failed with illegal Argument", IllegalArgumentException.class, () -> this.spinner.setDigits(-1));
        Assert.assertEquals((long)cases[cases.length - 1], (long)this.spinner.getDigits());
    }

    @Test
    public void test_getMaximum() {
        this.spinner.setMaximum(1000);
        Assert.assertEquals((long)1000L, (long)this.spinner.getMaximum());
        this.spinner.setMinimum(100);
        this.spinner.setMaximum(99);
        Assert.assertEquals((long)1000L, (long)this.spinner.getMaximum());
    }

    @Test
    public void test_getMinimum() {
        this.spinner.setMinimum(2);
        Assert.assertEquals((long)2L, (long)this.spinner.getMinimum());
        this.spinner.setMaximum(99);
        this.spinner.setMinimum(100);
        Assert.assertEquals((long)2L, (long)this.spinner.getMinimum());
    }

    @Test
    public void test_getPageIncrement() {
        int[] cases;
        int[] nArray = cases = new int[]{5, 1000, 20, 1};
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            this.spinner.setPageIncrement(value);
            Assert.assertEquals((long)value, (long)this.spinner.getPageIncrement());
            ++n2;
        }
        this.spinner.setPageIncrement(-1);
        Assert.assertEquals((long)cases[cases.length - 1], (long)this.spinner.getPageIncrement());
    }

    @Test
    public void test_getSelection() {
        int[] cases = new int[]{5, 1000, 25, 1};
        int i = 0;
        while (i < cases.length) {
            if (cases[i] >= this.spinner.getMaximum()) {
                cases[i] = this.spinner.getMaximum() - 1;
            }
            this.spinner.setSelection(cases[i]);
            Assert.assertEquals((long)cases[i], (long)this.spinner.getSelection());
            ++i;
        }
        this.spinner.setSelection(this.spinner.getMaximum() + 1);
        Assert.assertEquals((long)this.spinner.getMaximum(), (long)this.spinner.getSelection());
        this.spinner.setSelection(this.spinner.getMinimum() - 1);
        Assert.assertEquals((long)this.spinner.getMinimum(), (long)this.spinner.getSelection());
    }

    @Test
    public void test_getTextLimit() {
        int[] cases;
        int[] nArray = cases = new int[]{5, 1000, 1};
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            this.spinner.setTextLimit(value);
            Assert.assertEquals((long)value, (long)this.spinner.getTextLimit());
            ++n2;
        }
        Assert.assertThrows((String)"setTextLimit should have caused an expection with value 0", IllegalArgumentException.class, () -> this.spinner.setTextLimit(0));
    }

    @Test
    public void test_setValues() {
        int cases = 4;
        int[] selection = new int[]{5, 10, 15, 20};
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 5;
        nArray[2] = 15;
        int[] minimum = nArray;
        int[] maximum = new int[]{20, 30, 15, 50};
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        int[] digits = nArray2;
        int[] increment = new int[]{10, 5, 6, 100};
        int[] pageIncrement = new int[]{50, 5, 6, 100};
        int i = 0;
        while (i < cases) {
            this.spinner.setValues(selection[i], minimum[i], maximum[i], digits[i], increment[i], pageIncrement[i]);
            Assert.assertEquals((String)("i=" + i), (long)selection[i], (long)this.spinner.getSelection());
            Assert.assertEquals((String)("i=" + i), (long)minimum[i], (long)this.spinner.getMinimum());
            Assert.assertEquals((String)("i=" + i), (long)maximum[i], (long)this.spinner.getMaximum());
            Assert.assertEquals((String)("i=" + i), (long)digits[i], (long)this.spinner.getDigits());
            Assert.assertEquals((String)("i=" + i), (long)increment[i], (long)this.spinner.getIncrement());
            Assert.assertEquals((String)("i=" + i), (long)pageIncrement[i], (long)this.spinner.getPageIncrement());
            ++i;
        }
        this.spinner.setValues(5, 10, 3, -1, 0, -1);
        Assert.assertEquals((long)selection[cases - 1], (long)this.spinner.getSelection());
        Assert.assertEquals((long)minimum[cases - 1], (long)this.spinner.getMinimum());
        Assert.assertEquals((long)maximum[cases - 1], (long)this.spinner.getMaximum());
        Assert.assertEquals((long)digits[cases - 1], (long)this.spinner.getDigits());
        Assert.assertEquals((long)increment[cases - 1], (long)this.spinner.getIncrement());
        Assert.assertEquals((long)pageIncrement[cases - 1], (long)this.spinner.getPageIncrement());
        this.spinner = new Spinner((Composite)this.shell, 0);
    }

    @Test
    public void test_getText() {
        this.spinner.setSelection(5);
        Assert.assertEquals((Object)"5", (Object)this.spinner.getText());
        this.spinner.setSelection(-5);
        Assert.assertEquals((Object)"0", (Object)this.spinner.getText());
        this.spinner.setSelection(this.spinner.getMaximum() + 1);
        Assert.assertEquals((Object)String.valueOf(this.spinner.getMaximum()), (Object)this.spinner.getText());
    }
}

