/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Table
extends Test_org_eclipse_swt_widgets_Composite {
    protected Table table;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.makeCleanEnvironment(false);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            new Table(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_deselect$I() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        int[] nArray = new int[2];
        nArray[1] = 3;
        this.table.select(nArray);
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(new int[]{1, 2});
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(new int[]{1, 3, 5});
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        int[] nArray2 = new int[3];
        nArray2[0] = 9;
        nArray2[1] = 3;
        this.table.deselect(nArray2);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.selectAll();
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        try {
            this.table.deselect(null);
            Assert.fail((String)"No exception thrown for selection == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(new int[0]);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(new int[]{-1, 100, -1000});
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(new int[]{2, -1, 1, 100, 2});
        Assert.assertEquals((long)(number - 2), (long)this.table.getSelectionCount());
        this.table.deselect(new int[]{2, -1, 1, 100, 2});
        Assert.assertEquals((long)(number - 2), (long)this.table.getSelectionCount());
        this.table.deselect(new int[]{2, -1, 3, 100, 2});
        Assert.assertEquals((long)(number - 3), (long)this.table.getSelectionCount());
    }

    @Test
    public void test_deselectAll() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.select(new int[]{2, 4, 5, 10});
        Assert.assertEquals((long)4L, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.selectAll();
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
    }

    @Test
    public void test_deselectI() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.deselect(0);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 6;
        this.table.select(nArray);
        Assert.assertEquals((long)3L, (long)this.table.getSelectionCount());
        this.table.deselect(0);
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(0);
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(5);
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(3);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.deselect(100);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
    }

    @Test
    public void test_deselectII() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 6;
        this.table.select(nArray);
        Assert.assertEquals((long)3L, (long)this.table.getSelectionCount());
        this.table.deselect(7, 10);
        Assert.assertEquals((long)3L, (long)this.table.getSelectionCount());
        this.table.deselect(6, 10);
        Assert.assertEquals((long)2L, (long)this.table.getSelectionCount());
        this.table.deselect(1, 10);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.deselect(0, 10);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.deselect(0, 100);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.selectAll();
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.deselect(-10, 2);
        Assert.assertEquals((long)(number - 3), (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(-10, 2000);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(2000, -10);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(0, number - 1);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(0, 0);
        Assert.assertEquals((long)(number - 1), (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(number - 1, number - 1);
        Assert.assertEquals((long)(number - 1), (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(-1, -1);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
        this.table.deselect(number, number);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.selectAll();
    }

    @Test
    public void test_getColumnCount() {
        Assert.assertEquals((long)0L, (long)this.table.getColumnCount());
        TableColumn column0 = new TableColumn(this.table, 0);
        Assert.assertEquals((long)1L, (long)this.table.getColumnCount());
        TableColumn column1 = new TableColumn(this.table, 0);
        Assert.assertEquals((long)2L, (long)this.table.getColumnCount());
        TableColumn column2 = new TableColumn(this.table, 0);
        Assert.assertEquals((long)3L, (long)this.table.getColumnCount());
        column0.dispose();
        Assert.assertEquals((long)2L, (long)this.table.getColumnCount());
        column1.dispose();
        Assert.assertEquals((long)1L, (long)this.table.getColumnCount());
        column2.dispose();
        Assert.assertEquals((long)0L, (long)this.table.getColumnCount());
    }

    @Test
    public void test_getColumnI() {
        try {
            this.table.getColumn(0);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        TableColumn column0 = new TableColumn(this.table, 16384);
        try {
            this.table.getColumn(1);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)column0, (Object)this.table.getColumn(0));
        TableColumn column1 = new TableColumn(this.table, 16384);
        Assert.assertEquals((Object)column1, (Object)this.table.getColumn(1));
        column1.dispose();
        try {
            this.table.getColumn(1);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        column0.dispose();
        try {
            this.table.getColumn(0);
            Assert.fail((String)"No exception thrown for index out of range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getColumns() {
        Assert.assertEquals((long)0L, (long)this.table.getColumns().length);
        TableColumn column0 = new TableColumn(this.table, 16384);
        TableColumn[] columns = this.table.getColumns();
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)column0, (Object)columns[0]);
        column0.dispose();
        Assert.assertEquals((long)0L, (long)this.table.getColumns().length);
        column0 = new TableColumn(this.table, 16384);
        TableColumn column1 = new TableColumn(this.table, 131072, 1);
        columns = this.table.getColumns();
        Assert.assertEquals((long)2L, (long)columns.length);
        Assert.assertEquals((Object)column0, (Object)columns[0]);
        Assert.assertEquals((Object)column1, (Object)columns[1]);
        column0.dispose();
        columns = this.table.getColumns();
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)column1, (Object)columns[0]);
        column1.dispose();
        Assert.assertEquals((long)0L, (long)this.table.getColumns().length);
    }

    @Test
    public void test_getGridLineWidth() {
        this.table.getGridLineWidth();
    }

    @Test
    public void test_getHeaderHeight() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getHeaderHeight(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Table))");
            }
            return;
        }
        Assert.assertEquals((long)0L, (long)this.table.getHeaderHeight());
        this.table.setHeaderVisible(true);
        Assert.assertTrue((this.table.getHeaderHeight() > 0 ? 1 : 0) != 0);
        this.table.setHeaderVisible(false);
        Assert.assertEquals((long)0L, (long)this.table.getHeaderHeight());
    }

    @Test
    public void test_getItemCount() {
        int i;
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 100;
        int[] cases = nArray;
        int j = 0;
        while (j < cases.length) {
            i = 0;
            while (i < cases[j]) {
                new TableItem(this.table, 0);
                ++i;
            }
            Assert.assertEquals((String)("j=" + j), (long)cases[j], (long)this.table.getItemCount());
            this.table.removeAll();
            ++j;
        }
        this.makeCleanEnvironment(true);
        j = 0;
        while (j < cases.length) {
            i = 0;
            while (i < cases[j]) {
                new TableItem(this.table, 0);
                ++i;
            }
            Assert.assertEquals((String)("j=" + j), (long)cases[j], (long)this.table.getItemCount());
            this.table.removeAll();
            ++j;
        }
    }

    @Test
    public void test_getItemHeight() {
        Assert.assertTrue((String)":a: Item height <= 0", (this.table.getItemHeight() > 0 ? 1 : 0) != 0);
        new TableItem(this.table, 0);
        Assert.assertTrue((String)":b: Item height <= 0", (this.table.getItemHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getItemI() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("i=" + i), (Object)items[i], (Object)this.table.getItem(i));
            ++i;
        }
        try {
            this.table.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.table.getItem(number + 1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((String)("i=" + i), (Object)items[i], (Object)this.table.getItem(i));
            ++i;
        }
        try {
            this.table.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.table.getItem(number + 1);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItems() {
        int i;
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 100;
        int[] cases = nArray;
        int j = 0;
        while (j < cases.length) {
            int i2 = 0;
            while (i2 < cases[j]) {
                new TableItem(this.table, 0);
                ++i2;
            }
            Assert.assertEquals((String)("j=" + j), (long)cases[j], (long)this.table.getItems().length);
            this.table.removeAll();
            ++j;
        }
        j = 0;
        while (j < cases.length) {
            int i3 = 0;
            while (i3 < cases[j]) {
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(String.valueOf(i3));
                ++i3;
            }
            TableItem[] items = this.table.getItems();
            i = 0;
            while (i < items.length) {
                Assert.assertEquals((String)("j=" + j + ", i=" + i), (Object)String.valueOf(i), (Object)items[i].getText());
                ++i;
            }
            this.table.removeAll();
            ++j;
        }
        this.makeCleanEnvironment(true);
        j = 0;
        while (j < cases.length) {
            int i4 = 0;
            while (i4 < cases[j]) {
                new TableItem(this.table, 0);
                ++i4;
            }
            Assert.assertEquals((String)("j=" + j), (long)cases[j], (long)this.table.getItems().length);
            this.table.removeAll();
            ++j;
        }
        this.makeCleanEnvironment(true);
        j = 0;
        while (j < cases.length) {
            int i5 = 0;
            while (i5 < cases[j]) {
                TableItem ti = new TableItem(this.table, 0);
                ti.setText(String.valueOf(i5));
                ++i5;
            }
            TableItem[] items = this.table.getItems();
            i = 0;
            while (i < items.length) {
                Assert.assertEquals((String)("j=" + j + ", i=" + i), (Object)String.valueOf(i), (Object)items[i].getText());
                ++i;
            }
            this.table.removeAll();
            ++j;
        }
    }

    @Test
    public void test_getSelection() {
        int number = 15;
        Object[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[2], items[10], items[number - 1]}, (Object[])this.table.getSelection());
        this.table.setSelection((TableItem[])items);
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getSelection());
        this.table.setSelection((TableItem)items[0]);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0]}, (Object[])this.table.getSelection());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[10]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[10]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[number - 1]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[number - 1]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[2]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[10], items[number - 1], items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection((TableItem[])items);
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
    }

    @Test
    public void test_getSelectionCount() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)3L, (long)this.table.getSelectionCount());
        this.table.setSelection(items[2]);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.setSelection(items);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[number - 1]});
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[10]});
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.setSelection(items);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
    }

    @Test
    public void test_getSelectionIndex() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.table.getSelectionIndex());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)2L, (long)this.table.getSelectionIndex());
        this.table.setSelection(items[10]);
        Assert.assertEquals((long)10L, (long)this.table.getSelectionIndex());
        this.table.setSelection(items);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionIndex());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)this.table.getSelectionIndex());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertEquals((long)2L, (long)this.table.getSelectionIndex());
        this.table.setSelection(new TableItem[]{items[number - 1]});
        Assert.assertEquals((long)(number - 1), (long)this.table.getSelectionIndex());
        this.table.setSelection(new TableItem[]{items[10]});
        Assert.assertEquals((long)10L, (long)this.table.getSelectionIndex());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertEquals((long)-1L, (long)this.table.getSelectionIndex());
        this.table.setSelection(items);
        Assert.assertEquals((long)-1L, (long)this.table.getSelectionIndex());
    }

    @Test
    public void test_getSelectionIndices() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertArrayEquals((int[])new int[]{2, 10, number - 1}, (int[])this.table.getSelectionIndices());
        int[] all = new int[number];
        int i2 = 0;
        while (i2 < number) {
            all[i2] = i2;
            ++i2;
        }
        this.table.setSelection(items);
        Assert.assertArrayEquals((int[])all, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(true);
        i2 = 0;
        while (i2 < number) {
            items[i2] = new TableItem(this.table, 0);
            ++i2;
        }
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new TableItem[]{items[number - 1]});
        Assert.assertArrayEquals((int[])new int[]{number - 1}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new TableItem[]{items[10]});
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(items);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_indexOfLorg_eclipse_swt_widgets_TableItem() {
        int number = 20;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            items[i].setText(String.valueOf(i));
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)i, (long)this.table.indexOf(items[i]));
            ++i;
        }
        i = 0;
        while (i < number) {
            try {
                this.table.indexOf(null);
                Assert.fail((String)"No exception thrown for tableItem == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        Table table_2 = new Table((Composite)this.shell, 0);
        TableItem[] items_2 = new TableItem[number];
        int i2 = 0;
        while (i2 < number) {
            items_2[i2] = new TableItem(table_2, 0);
            items_2[i2].setText(String.valueOf(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < number) {
            Assert.assertEquals((String)("i=" + i2), (long)-1L, (long)this.table.indexOf(items_2[i2]));
            ++i2;
        }
        this.makeCleanEnvironment(true);
        number = 20;
        items = new TableItem[number];
        i2 = 0;
        while (i2 < number) {
            items[i2] = new TableItem(this.table, 0);
            items[i2].setText(String.valueOf(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < number) {
            Assert.assertEquals((long)i2, (long)this.table.indexOf(items[i2]));
            ++i2;
        }
        this.makeCleanEnvironment(true);
        i2 = 0;
        while (i2 < number) {
            items[i2] = new TableItem(this.table, 0);
            items[i2].setText(String.valueOf(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < number) {
            try {
                this.table.indexOf(null);
                Assert.fail((String)"No exception thrown for tableItem == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i2;
        }
        this.makeCleanEnvironment(true);
        i2 = 0;
        while (i2 < number) {
            items[i2] = new TableItem(this.table, 0);
            items[i2].setText(String.valueOf(i2));
            ++i2;
        }
        table_2 = new Table((Composite)this.shell, 0);
        items_2 = new TableItem[number];
        i2 = 0;
        while (i2 < number) {
            items_2[i2] = new TableItem(table_2, 0);
            items_2[i2].setText(String.valueOf(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < number) {
            Assert.assertEquals((String)("i=" + i2), (long)-1L, (long)this.table.indexOf(items_2[i2]));
            ++i2;
        }
    }

    @Test
    public void test_isSelectedI() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            ++i;
        }
        this.table.setSelection(new TableItem[]{items[2], items[number - 1], items[10]});
        i = 0;
        while (i < number) {
            if (i == 2 || i == number - 1 || i == 10) {
                Assert.assertTrue((String)(":b:" + i), (boolean)this.table.isSelected(i));
            } else {
                Assert.assertTrue((String)(":b:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            }
            ++i;
        }
        this.table.setSelection(items[0]);
        i = 0;
        while (i < number) {
            if (i == 0) {
                Assert.assertTrue((String)(":b:" + i), (boolean)this.table.isSelected(i));
            } else {
                Assert.assertTrue((String)(":b:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            }
            ++i;
        }
        this.table.setSelection(items);
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":c:" + i), (boolean)this.table.isSelected(i));
            ++i;
        }
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":d:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            ++i;
        }
        this.table.setSelection(new TableItem[]{items[10]});
        i = 0;
        while (i < number) {
            if (i == 10) {
                Assert.assertTrue((String)(":e:" + i), (boolean)this.table.isSelected(i));
            } else {
                Assert.assertTrue((String)(":e:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            }
            ++i;
        }
        this.table.setSelection(items);
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":f:" + i), (!this.table.isSelected(i) ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void test_remove$I() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(null);
            Assert.fail((String)"No exception thrown for tableItems == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray = new int[11];
            nArray[0] = 2;
            nArray[1] = 1;
            nArray[3] = -100;
            nArray[4] = 5;
            nArray[5] = 5;
            nArray[6] = 2;
            nArray[7] = 1;
            this.table.remove(nArray);
            Assert.fail((String)"No exception thrown for illegal index arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray = new int[11];
            nArray[0] = 2;
            nArray[1] = 1;
            nArray[3] = number;
            nArray[4] = 5;
            nArray[5] = 5;
            nArray[6] = 2;
            nArray[7] = 1;
            this.table.remove(nArray);
            Assert.fail((String)"No exception thrown for illegal index arguments");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.table.remove(new int[0]);
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertTrue((String)":a:", (!items[2].isDisposed() ? 1 : 0) != 0);
        this.table.remove(new int[]{2});
        Assert.assertTrue((String)":b:", (boolean)items[2].isDisposed());
        Assert.assertEquals((long)(number - 1), (long)this.table.getItemCount());
        Assert.assertTrue((String)":c:", (!items[number - 1].isDisposed() ? 1 : 0) != 0);
        this.table.remove(new int[]{number - 2});
        Assert.assertTrue((String)":d:", (boolean)items[number - 1].isDisposed());
        Assert.assertEquals((long)(number - 2), (long)this.table.getItemCount());
        Assert.assertTrue((String)":e:", (!items[3].isDisposed() ? 1 : 0) != 0);
        this.table.remove(new int[]{2});
        Assert.assertTrue((String)":f:", (boolean)items[3].isDisposed());
        Assert.assertEquals((long)(number - 3), (long)this.table.getItemCount());
        Assert.assertTrue((String)":g:", (!items[0].isDisposed() ? 1 : 0) != 0);
        this.table.remove(new int[1]);
        Assert.assertTrue((String)":h:", (boolean)items[0].isDisposed());
        Assert.assertEquals((long)(number - 4), (long)this.table.getItemCount());
    }

    @Test
    public void test_removeAll() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.removeAll();
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        i = 0;
        while (i <= number - 1) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.removeAll();
        this.table.removeAll();
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getItems());
    }

    @Test
    public void test_removeII() {
        int number = 5;
        Object[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(-number, number + 100);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(2, 3);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[1], items[4]}, (Object[])this.table.getItems());
        Assert.assertFalse((boolean)items[0].isDisposed());
        Assert.assertFalse((boolean)items[1].isDisposed());
        Assert.assertTrue((boolean)items[2].isDisposed());
        Assert.assertTrue((boolean)items[3].isDisposed());
        Assert.assertFalse((boolean)items[4].isDisposed());
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(2, 100);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(2, number);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(2, number - 1);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[1]}, (Object[])this.table.getItems());
        i = 0;
        while (i < 2) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        i = 2;
        while (i <= number - 1) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(0, 3);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getItems());
        i = 0;
        while (i <= 3) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        i = 4;
        while (i < number) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(0, number - 1);
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getItems());
        i = 0;
        while (i <= number - 1) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(new int[0]);
        Assert.assertEquals((long)number, (long)this.table.getItemCount());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(-20, -10);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(20, 40);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(200, 40);
        Assert.assertArrayEquals((Object[])items, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(2, 2);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[1], items[3], items[4]}, (Object[])this.table.getItems());
        Assert.assertTrue((boolean)items[2].isDisposed());
        i = 0;
        while (i < number && i != 2) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(0, 0);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[1], items[2], items[3], items[4]}, (Object[])this.table.getItems());
        Assert.assertTrue((boolean)items[0].isDisposed());
        i = 1;
        while (i < number) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(4, 4);
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[1], items[2], items[3]}, (Object[])this.table.getItems());
        Assert.assertTrue((boolean)items[4].isDisposed());
        i = 0;
        while (i < number && i != 4) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertEquals((long)number, (long)this.table.getItemCount());
        try {
            this.table.remove(-10, 2);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)number, (long)this.table.getItemCount());
        if (SwtTestUtil.fCheckSWTPolicy) {
            this.table.remove(10, 2);
            Assert.assertEquals((long)number, (long)this.table.getItemCount());
        }
        this.table.remove(0, 2);
        Assert.assertEquals((long)(number - 3), (long)this.table.getItemCount());
        Assert.assertArrayEquals((Object[])new TableItem[]{items[3], items[4]}, (Object[])this.table.getItems());
        i = 0;
        while (i < 2) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        i = 3;
        while (i < number) {
            Assert.assertFalse((boolean)items[i].isDisposed());
            ++i;
        }
        try {
            this.table.remove(1, 200);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)(number - 3), (long)this.table.getItemCount());
        Assert.assertArrayEquals((Object[])new TableItem[]{items[3], items[4]}, (Object[])this.table.getItems());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.remove(0, number - 1);
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        i = 0;
        while (i <= number - 1) {
            Assert.assertTrue((boolean)items[i].isDisposed());
            ++i;
        }
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(number, number);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        try {
            this.table.remove(number, number + 100);
            Assert.fail((String)"No exception thrown for illegal index range");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.makeCleanEnvironment(false);
        number = 15;
        items = new TableItem[number];
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 5;
        nArray[4] = 5;
        this.table.remove(nArray);
        Assert.assertEquals((long)(number - 4), (long)this.table.getItemCount());
        Assert.assertTrue((boolean)items[0].isDisposed());
        Assert.assertTrue((boolean)items[1].isDisposed());
        Assert.assertTrue((boolean)items[2].isDisposed());
        Assert.assertFalse((boolean)items[3].isDisposed());
        Assert.assertFalse((boolean)items[4].isDisposed());
        Assert.assertTrue((boolean)items[5].isDisposed());
    }

    @Test
    public void test_select$I() {
        block9: {
            try {
                this.table.select(null);
                Assert.fail((String)"No exception thrown for selection == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            int number = 15;
            TableItem[] items = new TableItem[number];
            int i = 0;
            while (i < number) {
                items[i] = new TableItem(this.table, 0);
                ++i;
            }
            this.table.select(new int[]{2, 10, 14});
            Assert.assertArrayEquals((int[])new int[]{2, 10, 14}, (int[])this.table.getSelectionIndices());
            this.table.deselectAll();
            this.table.select(new int[]{10, 2, 14});
            Assert.assertArrayEquals((int[])new int[]{2, 10, 14}, (int[])this.table.getSelectionIndices());
            this.table.deselectAll();
            int[] nArray = new int[3];
            nArray[0] = number;
            nArray[2] = number - 1;
            this.table.select(nArray);
            int[] nArray2 = new int[2];
            nArray2[1] = number - 1;
            Assert.assertArrayEquals((int[])nArray2, (int[])this.table.getSelectionIndices());
            this.table.deselectAll();
            int[] nArray3 = new int[3];
            nArray3[0] = number;
            nArray3[2] = -1;
            this.table.select(nArray3);
            Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
            this.table.deselectAll();
            this.table.select(new int[1]);
            Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
            this.table.select(new int[]{10});
            int[] nArray4 = new int[2];
            nArray4[1] = 10;
            Assert.assertArrayEquals((int[])nArray4, (int[])this.table.getSelectionIndices());
            this.table.select(new int[]{2});
            int[] nArray5 = new int[3];
            nArray5[1] = 2;
            nArray5[2] = 10;
            Assert.assertArrayEquals((int[])nArray5, (int[])this.table.getSelectionIndices());
            this.table.select(new int[]{14});
            int[] nArray6 = new int[4];
            nArray6[1] = 2;
            nArray6[2] = 10;
            nArray6[3] = 14;
            Assert.assertArrayEquals((int[])nArray6, (int[])this.table.getSelectionIndices());
            this.table.deselectAll();
            this.table.select(new int[]{15});
            Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
            this.table.select(new int[]{-1});
            Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
            this.table.select(new int[]{4, 4, 4});
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
            this.makeCleanEnvironment(true);
            items = new TableItem[number];
            i = 0;
            while (i < number) {
                items[i] = new TableItem(this.table, 0);
                ++i;
            }
            try {
                try {
                    this.table.select(null);
                    Assert.fail((String)"No exception thrown for selection == null");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                throw throwable;
            }
            Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        }
        this.table.select(new int[1]);
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{10});
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{2});
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{14});
        Assert.assertArrayEquals((int[])new int[]{14}, (int[])this.table.getSelectionIndices());
        this.table.deselectAll();
        this.table.select(new int[]{15});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{-1});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{10, 2, 14});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(new int[]{4, 4, 4});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_selectAll() {
        int number = 5;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.selectAll();
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        Assert.assertArrayEquals((int[])nArray, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.selectAll();
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_selectI() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.select(new int[]{10, 2, 14});
        Assert.assertArrayEquals((int[])new int[]{2, 10, 14}, (int[])this.table.getSelectionIndices());
        this.table.select(7);
        Assert.assertArrayEquals((int[])new int[]{2, 7, 10, 14}, (int[])this.table.getSelectionIndices());
        this.table.select(0);
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 7;
        nArray[3] = 10;
        nArray[4] = 14;
        Assert.assertArrayEquals((int[])nArray, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.select(0);
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.select(1);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.table.getSelectionIndices());
        this.table.select(10);
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])this.table.getSelectionIndices());
        this.table.select(number - 1);
        Assert.assertArrayEquals((int[])new int[]{number - 1}, (int[])this.table.getSelectionIndices());
        this.table.deselectAll();
        this.table.select(number);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(-1);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_selectII() {
        int number = 15;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.select(new int[]{10, 2, 14});
        Assert.assertArrayEquals((int[])new int[]{2, 10, 14}, (int[])this.table.getSelectionIndices());
        this.table.select(7);
        Assert.assertArrayEquals((int[])new int[]{2, 7, 10, 14}, (int[])this.table.getSelectionIndices());
        this.table.select(0);
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 7;
        nArray[3] = 10;
        nArray[4] = 14;
        Assert.assertArrayEquals((int[])nArray, (int[])this.table.getSelectionIndices());
        this.table.select(4, 10);
        int[] nArray2 = new int[10];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArray2[4] = 6;
        nArray2[5] = 7;
        nArray2[6] = 8;
        nArray2[7] = 9;
        nArray2[8] = 10;
        nArray2[9] = 14;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.table.getSelectionIndices());
        this.table.select(4, 14);
        int[] nArray3 = new int[13];
        nArray3[1] = 2;
        nArray3[2] = 4;
        nArray3[3] = 5;
        nArray3[4] = 6;
        nArray3[5] = 7;
        nArray3[6] = 8;
        nArray3[7] = 9;
        nArray3[8] = 10;
        nArray3[9] = 11;
        nArray3[10] = 12;
        nArray3[11] = 13;
        nArray3[12] = 14;
        Assert.assertArrayEquals((int[])nArray3, (int[])this.table.getSelectionIndices());
        this.table.select(0, 7);
        int[] nArray4 = new int[15];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[6] = 6;
        nArray4[7] = 7;
        nArray4[8] = 8;
        nArray4[9] = 9;
        nArray4[10] = 10;
        nArray4[11] = 11;
        nArray4[12] = 12;
        nArray4[13] = 13;
        nArray4[14] = 14;
        Assert.assertArrayEquals((int[])nArray4, (int[])this.table.getSelectionIndices());
        this.table.select(9, 5);
        int[] nArray5 = new int[15];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 4;
        nArray5[5] = 5;
        nArray5[6] = 6;
        nArray5[7] = 7;
        nArray5[8] = 8;
        nArray5[9] = 9;
        nArray5[10] = 10;
        nArray5[11] = 11;
        nArray5[12] = 12;
        nArray5[13] = 13;
        nArray5[14] = 14;
        Assert.assertArrayEquals((int[])nArray5, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(false);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.select(-100, 1000);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.select(0, 1000);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        this.table.select(0, number - 1);
        Assert.assertEquals((long)number, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        this.table.select(0, 0);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        this.table.select(number - 1, number);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        this.table.select(number, number);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.deselectAll();
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.select(0, 0);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        Assert.assertEquals((long)0L, (long)this.table.getSelectionIndex());
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.select(4, 4);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        this.table.select(10, 10);
        Assert.assertArrayEquals((int[])new int[]{10}, (int[])this.table.getSelectionIndices());
        this.table.select(number - 1, number - 1);
        Assert.assertArrayEquals((int[])new int[]{number - 1}, (int[])this.table.getSelectionIndices());
        this.table.deselectAll();
        this.table.select(number, number);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(0, number - 1);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(-1, number);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(4, 5);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(5, 4);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.select(-1, -1);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_setColumnOrder$I() {
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])new int[0]);
        this.table.setColumnOrder(new int[0]);
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])new int[0]);
        try {
            this.table.setColumnOrder(null);
            Assert.fail((String)"No exception thrown for null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.table.setColumnOrder(new int[1]);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        TableColumn column0 = new TableColumn(this.table, 0);
        TableColumn column1 = new TableColumn(this.table, 0);
        TableColumn column2 = new TableColumn(this.table, 0);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])nArray);
        try {
            this.table.setColumnOrder(null);
            Assert.fail((String)"No exception thrown for null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.table.setColumnOrder(new int[0]);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            this.table.setColumnOrder(nArray2);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray3 = new int[4];
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            this.table.setColumnOrder(nArray3);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray4 = new int[3];
            nArray4[2] = 1;
            this.table.setColumnOrder(nArray4);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            int[] nArray5 = new int[3];
            nArray5[0] = 3;
            nArray5[2] = 1;
            this.table.setColumnOrder(nArray5);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] nArray6 = new int[3];
        nArray6[0] = 2;
        nArray6[1] = 1;
        this.table.setColumnOrder(nArray6);
        int[] nArray7 = new int[3];
        nArray7[0] = 2;
        nArray7[1] = 1;
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])nArray7);
        column2.dispose();
        int[] nArray8 = new int[2];
        nArray8[0] = 1;
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])nArray8);
        try {
            int[] nArray9 = new int[3];
            nArray9[1] = 1;
            nArray9[2] = 2;
            this.table.setColumnOrder(nArray9);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        column1.dispose();
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])new int[1]);
        column0.dispose();
        Assert.assertArrayEquals((int[])this.table.getColumnOrder(), (int[])new int[0]);
        try {
            this.table.setColumnOrder(new int[1]);
            Assert.fail((String)"No exception thrown for invalid argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Table table2 = new Table(this.table.getParent(), 0);
        table2.dispose();
        try {
            table2.getColumnOrder();
            Assert.fail((String)"No exception thrown for widget is Disposed");
        }
        catch (SWTException sWTException) {}
        try {
            table2.setColumnOrder(new int[0]);
            Assert.fail((String)"No exception thrown for widget is Disposed");
        }
        catch (SWTException sWTException) {}
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
    }

    @Test
    public void test_setHeaderBackgroundLorg_eclipse_swt_graphics_Color() {
        Assert.assertNotNull((Object)this.table.getHeaderBackground());
        Color color = new Color(12, 34, 56);
        this.table.setHeaderBackground(color);
        Assert.assertEquals((Object)color, (Object)this.table.getHeaderBackground());
        this.table.setHeaderBackground(null);
        Assert.assertFalse((boolean)this.table.getHeaderBackground().equals((Object)color));
    }

    @Test
    public void test_setHeaderForegroundLorg_eclipse_swt_graphics_Color() {
        Assert.assertNotNull((Object)this.table.getHeaderForeground());
        Color color = new Color(12, 34, 56);
        this.table.setHeaderForeground(color);
        Assert.assertEquals((Object)color, (Object)this.table.getHeaderForeground());
        this.table.setHeaderForeground(null);
        Assert.assertFalse((boolean)this.table.getHeaderForeground().equals((Object)color));
    }

    @Test
    public void test_setHeaderVisibleZ() {
        Assert.assertFalse((boolean)this.table.getHeaderVisible());
        this.table.setHeaderVisible(true);
        Assert.assertTrue((boolean)this.table.getHeaderVisible());
        this.table.setHeaderVisible(false);
        Assert.assertFalse((boolean)this.table.getHeaderVisible());
    }

    @Test
    public void test_setItemCountI() {
        this.table.removeAll();
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        int i = 0;
        while (i < 8) {
            new TableItem(this.table, 0);
            Assert.assertEquals((long)(i + 1), (long)this.table.getItemCount());
            ++i;
        }
        Assert.assertEquals((long)8L, (long)this.table.getItemCount());
        Assert.assertEquals((long)4L, (long)this.table.indexOf(this.table.getItems()[4]));
        this.table.getItem(1).dispose();
        Assert.assertEquals((long)7L, (long)this.table.getItemCount());
        new TableItem(this.table, 0, 0);
        Assert.assertEquals((long)1L, (long)this.table.indexOf(this.table.getItems()[1]));
        Assert.assertEquals((long)8L, (long)this.table.getItemCount());
        this.table.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        this.table.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        this.table.setItemCount(-1);
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        this.table.setItemCount(10);
        Assert.assertEquals((long)10L, (long)this.table.getItemCount());
        this.table.getItem(1).dispose();
        Assert.assertEquals((long)9L, (long)this.table.getItemCount());
        Assert.assertEquals((long)4L, (long)this.table.indexOf(this.table.getItems()[4]));
        this.table.setItemCount(3);
        Assert.assertEquals((long)3L, (long)this.table.getItemCount());
        try {
            this.table.getItem(4);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.table.setItemCount(40);
        Assert.assertEquals((long)40L, (long)this.table.getItemCount());
        this.table.getItem(39);
        this.table.setItemCount(0);
        Assert.assertEquals((long)0L, (long)this.table.getItemCount());
        try {
            this.table.getItem(39);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setLinesVisibleZ() {
        Assert.assertFalse((boolean)this.table.getLinesVisible());
        this.table.setLinesVisible(true);
        Assert.assertTrue((boolean)this.table.getLinesVisible());
        this.table.setLinesVisible(false);
        Assert.assertFalse((boolean)this.table.getLinesVisible());
    }

    @Override
    @Test
    public void test_setRedrawZ() {
    }

    @Test
    public void test_setSelection$I() {
        int number;
        block9: {
            number = 5;
            TableItem[] items = new TableItem[number];
            int i = 0;
            while (i < number) {
                items[i] = new TableItem(this.table, 0);
                ++i;
            }
            try {
                this.table.setSelection(null);
                Assert.fail((String)"No exception thrown for selection == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.table.setSelection(new int[0]);
            Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
            int[] nArray = new int[3];
            nArray[1] = 3;
            nArray[2] = 2;
            this.table.setSelection(nArray);
            int[] nArray2 = new int[3];
            nArray2[1] = 2;
            nArray2[2] = 3;
            Assert.assertArrayEquals((int[])nArray2, (int[])this.table.getSelectionIndices());
            this.table.setSelection(new int[]{3, 2, 1});
            Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.table.getSelectionIndices());
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 4;
            this.table.setSelection(nArray3);
            int[] nArray4 = new int[3];
            nArray4[1] = 1;
            nArray4[2] = 4;
            Assert.assertArrayEquals((int[])nArray4, (int[])this.table.getSelectionIndices());
            int[] nArray5 = new int[3];
            nArray5[1] = 4;
            this.table.setSelection(nArray5);
            int[] nArray6 = new int[2];
            nArray6[1] = 4;
            Assert.assertArrayEquals((int[])nArray6, (int[])this.table.getSelectionIndices());
            this.table.setSelection(new int[]{2, 3, 4});
            Assert.assertArrayEquals((int[])new int[]{2, 3, 4}, (int[])this.table.getSelectionIndices());
            this.table.setSelection(new int[]{4, 4, 4, 4, 4, 4, 4});
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
            this.table.setSelection(new int[]{4});
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
            this.makeCleanEnvironment(true);
            i = 0;
            while (i < number) {
                items[i] = new TableItem(this.table, 0);
                ++i;
            }
            try {
                try {
                    this.table.setSelection(null);
                    Assert.fail((String)"No exception thrown for selection range == null");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                throw throwable;
            }
            Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        }
        this.table.setSelection(new int[0]);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[1]);
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{2});
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{4});
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{number - 1});
        Assert.assertArrayEquals((int[])new int[]{number - 1}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{number});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{-1});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 2;
        this.table.setSelection(nArray);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{3, 2, 1});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(new int[]{4, 4, 4, 4, 4, 4, 4});
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_setSelection$Lorg_eclipse_swt_widgets_TableItem() {
        int i22;
        TableItem[] items;
        int number;
        block14: {
            block12: {
                number = 5;
                items = new TableItem[number];
                i22 = 0;
                while (i22 < number) {
                    items[i22] = new TableItem(this.table, 0);
                    ++i22;
                }
                try {
                    try {
                        this.table.setSelection(null);
                        Assert.fail((String)"No exception thrown for selection range == null");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                        break block12;
                    }
                }
                catch (Throwable i22) {
                    Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                    throw i22;
                }
                Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
            }
            try {
                try {
                    this.table.setSelection(null);
                    Assert.fail((String)"No exception thrown for selection == null");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                    break block14;
                }
            }
            catch (Throwable i22) {
                Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
                throw i22;
            }
            Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        }
        this.table.setSelection(new TableItem[0]);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.setSelection(items[0]);
        Assert.assertEquals((long)1L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[0], items[3], items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[2], items[3]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[3], items[2], items[1]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[1], items[2], items[3]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[1], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[1], items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[0], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0], items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2], items[3], items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[2], items[3], items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4], items[4], items[4], items[4], items[4], items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getSelection());
        this.makeCleanEnvironment(false);
        i22 = 0;
        while (i22 < number) {
            items[i22] = new TableItem(this.table, 0);
            ++i22;
        }
        this.table.setSelection(new TableItem[]{items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[3]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[3]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[2]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[1]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[1]}, (Object[])this.table.getSelection());
        this.makeCleanEnvironment(true);
        i22 = 0;
        while (i22 < number) {
            items[i22] = new TableItem(this.table, 0);
            ++i22;
        }
        this.table.setSelection(new TableItem[0]);
        Assert.assertEquals((long)0L, (long)this.table.getSelectionCount());
        this.table.setSelection(new TableItem[]{items[0], items[3], items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[3], items[2], items[1]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[1], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[0], items[4], items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2], items[3], items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[0]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[0]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[3]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[3]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[4]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[2]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[2]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[1]});
        Assert.assertArrayEquals((Object[])new TableItem[]{items[1]}, (Object[])this.table.getSelection());
        this.table.setSelection(new TableItem[]{items[4], items[4], items[4], items[4], items[4], items[4]});
        Assert.assertArrayEquals((Object[])new TableItem[0], (Object[])this.table.getSelection());
    }

    @Test
    public void test_setSelectionI() {
        int number = 5;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.setSelection(0);
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.setSelection(3);
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(4);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(2);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(1);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.setSelection(0);
        Assert.assertArrayEquals((int[])new int[1], (int[])this.table.getSelectionIndices());
        this.table.setSelection(3);
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(4);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(2);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(1);
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.table.getSelectionIndices());
    }

    @Test
    public void test_setSelectionII() {
        int number = 5;
        TableItem[] items = new TableItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.setSelection(0, 1);
        int[] nArray = new int[2];
        nArray[1] = 1;
        Assert.assertArrayEquals((int[])nArray, (int[])this.table.getSelectionIndices());
        this.table.setSelection(2, 4);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(3, 4);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(5, 4);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        this.table.setSelection(2, 2);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(1, 4);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(0, 4);
        int[] nArray2 = new int[5];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        Assert.assertArrayEquals((int[])nArray2, (int[])this.table.getSelectionIndices());
        this.makeCleanEnvironment(true);
        i = 0;
        while (i < number) {
            items[i] = new TableItem(this.table, 0);
            ++i;
        }
        this.table.setSelection(0, 1);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.table.getSelectionIndices());
        }
        this.table.setSelection(2, 4);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        }
        this.table.setSelection(5, 4);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertArrayEquals((int[])new int[0], (int[])this.table.getSelectionIndices());
        }
        this.table.setSelection(2, 2);
        Assert.assertArrayEquals((int[])new int[]{2}, (int[])this.table.getSelectionIndices());
        this.table.setSelection(1, 4);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        }
        this.table.setSelection(0, 4);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.table.getSelectionIndices());
        }
    }

    @Test
    public void test_showSelection() {
        this.table.showSelection();
    }

    private void makeCleanEnvironment(boolean single) {
        if (this.table != null) {
            this.table.dispose();
        }
        this.table = new Table((Composite)this.shell, single ? 4 : 2);
        this.setWidget((Widget)this.table);
    }

    private void createTable(List<String> events) {
        this.makeCleanEnvironment(false);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        int col = 0;
        while (col < 3) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText("Col " + col);
            column.setWidth(50);
            this.hookExpectedEvents((Widget)column, this.getTestName(), events);
            ++col;
        }
        int row = 0;
        while (row < 3) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{"C0R" + row, "C1R" + row, "C2R" + row});
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            ++row;
        }
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyEvent(0, 0x1000002, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(20, this.table.getHeaderHeight() + this.table.getItemHeight() * 2, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_DoubleClick() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(20, this.table.getHeaderHeight() + this.table.getItemHeight() + 5, 1, 0, 40, events);
    }

    @Test
    public void test_consistency_EnterSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyEvent(13, 10, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyEvent(20, 25, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTable(events);
        this.consistencyEvent(30, 20, 50, 30, 50, events);
    }

    @Test
    public void test_Virtual() {
        this.table.dispose();
        this.table = new Table((Composite)this.shell, 0x10000800);
        this.setWidget((Widget)this.table);
        int count = 1000000;
        int visibleCount = 10;
        this.shell.setLayout((Layout)new FillLayout());
        int[] dataCounter = new int[1];
        this.table.addListener(36, event -> {
            TableItem item = (TableItem)event.item;
            int index = this.table.indexOf(item);
            item.setText("Item " + index);
            nArray[0] = dataCounter[0] + 1;
        });
        this.shell.setSize(200, this.table.getItemHeight() * visibleCount);
        this.shell.open();
        this.table.setItemCount(count);
        long end = System.currentTimeMillis() + 3000L;
        while (!this.shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertTrue((String)("SetData callback count not in range: " + dataCounter[0]), (dataCounter[0] > visibleCount / 2 && dataCounter[0] <= visibleCount * 3 ? 1 : 0) != 0);
    }

    @Test
    public void test_setTopIndex() {
        int i = 0;
        while (i < 10) {
            new TableItem(this.table, 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            new TableItem(this.table, 0);
            ++i;
        }
        this.table.setSize(50, 50);
        this.shell.open();
        this.table.setTopIndex(5);
        i = 0;
        while (i < 10) {
            new TableItem(this.table, 0);
            ++i;
        }
        this.shell.setVisible(false);
        Assert.assertEquals((long)5L, (long)this.table.getTopIndex());
    }
}

