/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.time.Instant;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Scrollable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Text
extends Test_org_eclipse_swt_widgets_Scrollable {
    Text text;
    String delimiterString;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.shell.pack();
        this.shell.open();
        this.makeCleanEnvironment(false);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        int[] cases;
        Assert.assertThrows((String)"No exception thrown for parent == null", IllegalArgumentException.class, () -> {
            Text text = this.text = new Text(null, 0);
        });
        int[] nArray = new int[7];
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[3] = 514;
        nArray[4] = 258;
        nArray[5] = 770;
        nArray[6] = 64;
        int[] nArray2 = cases = nArray;
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            int style = nArray2[n2];
            this.text = new Text((Composite)this.shell, style);
            ++n2;
        }
    }

    @Test
    public void test_addModifyListenerLorg_eclipse_swt_events_ModifyListener() {
        ModifyListener listener = event -> {
            boolean bl = this.listenerCalled = true;
        };
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.text.addModifyListener(null));
        this.text.addModifyListener(listener);
        this.listenerCalled = false;
        this.text.setText("new text");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.text.removeModifyListener(listener);
        this.text.setText("line");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.text.removeModifyListener(null));
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_widgets_Text.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        Assert.assertThrows(IllegalArgumentException.class, () -> this.text.addSelectionListener(null));
        this.text.addSelectionListener(listener);
        this.text.setText("12345");
        this.text.setSelection(1, 3);
        Assert.assertFalse((boolean)this.listenerCalled);
        this.text.removeSelectionListener(listener);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.text.removeSelectionListener(null));
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.text.addSelectionListener(listener);
        this.text.setText("12345");
        this.text.setSelection(1, 3);
        Assert.assertFalse((boolean)this.listenerCalled);
        this.text.removeSelectionListener(listener);
    }

    @Test
    public void test_addVerifyListenerLorg_eclipse_swt_events_VerifyListener() {
        this.text.setText("");
        Assert.assertThrows((String)"Expected exception not thrown", IllegalArgumentException.class, () -> this.text.addVerifyListener(null));
        VerifyListener listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.text = "NewLine1";
        };
        this.text.addVerifyListener(listener);
        this.listenerCalled = false;
        this.text.append("Line1");
        Assert.assertTrue((String)"append does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1", (Object)this.text.getText());
        this.text.removeVerifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)8L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)8L, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.text = "NewLine1";
        };
        this.text.addVerifyListener(listener);
        this.listenerCalled = false;
        this.text.insert("Line1");
        Assert.assertTrue((String)"insert does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1NewLine1", (Object)this.text.getText());
        this.text.removeVerifyListener(listener);
        listener = event -> {
            this.listenerCalled = true;
            Assert.assertEquals((String)"Verify event data invalid", (long)0L, (long)event.start);
            Assert.assertEquals((String)"Verify event data invalid", (long)16L, (long)event.end);
            Assert.assertEquals((String)"Verify event data invalid", (Object)"Line1", (Object)event.text);
            event.text = "NewLine1";
        };
        this.text.addVerifyListener(listener);
        this.text.setText("Line1");
        Assert.assertTrue((String)"setText does not send event", (boolean)this.listenerCalled);
        Assert.assertEquals((String)"Listener failed", (Object)"NewLine1", (Object)this.text.getText());
        this.listenerCalled = false;
        this.text.removeVerifyListener(listener);
        this.text.setText("Line1");
        Assert.assertFalse((String)"Listener not removed", (boolean)this.listenerCalled);
    }

    @Test
    public void test_appendLjava_lang_String() {
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.append(null));
        this.text.setText("01");
        this.text.append("23");
        Assert.assertEquals((Object)"0123", (Object)this.text.getText());
        this.text.append("45");
        Assert.assertEquals((Object)"012345", (Object)this.text.getText());
        this.text.setSelection(0);
        this.text.append("67");
        Assert.assertEquals((Object)"01234567", (Object)this.text.getText());
        this.text.setText("01");
        this.text.append("23");
        Assert.assertEquals((Object)"0123", (Object)this.text.getText());
        this.text.append("4" + this.delimiterString + "5");
        Assert.assertEquals((Object)("01234" + this.delimiterString + "5"), (Object)this.text.getText());
        this.text.setSelection(0);
        this.text.append("67");
        Assert.assertEquals((Object)("01234" + this.delimiterString + "567"), (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.append(null));
        this.makeCleanEnvironment(true);
        this.text.setText("01");
        this.text.append("23");
        Assert.assertEquals((Object)"0123", (Object)this.text.getText());
        this.text.append("45");
        Assert.assertEquals((Object)"012345", (Object)this.text.getText());
        this.text.setSelection(0);
        this.text.append("67");
        Assert.assertEquals((Object)"01234567", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.setText("01");
        this.text.append("23");
        Assert.assertEquals((Object)"0123", (Object)this.text.getText());
        this.text.append("4" + this.delimiterString + "5");
        Assert.assertEquals((Object)("01234" + this.delimiterString + "5"), (Object)this.text.getText());
        this.text.setSelection(0);
        this.text.append("67");
        Assert.assertEquals((Object)("01234" + this.delimiterString + "567"), (Object)this.text.getText());
    }

    @Test
    public void test_clearSelection() {
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
        this.text.clearSelection();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
        this.text.clearSelection();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
        this.text.clearSelection();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_copy() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_copy(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text).");
            }
            return;
        }
        this.text.copy();
        this.text.selectAll();
        this.text.copy();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText("00000");
        this.text.selectAll();
        this.text.copy();
        this.text.setSelection(2);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText("");
        this.text.paste();
        Assert.assertEquals((Object)"00000", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.copy();
        this.text.selectAll();
        this.text.copy();
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText("00000");
        this.text.selectAll();
        this.text.copy();
        this.text.setSelection(2);
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setText("");
        this.text.paste();
        Assert.assertEquals((Object)"00000", (Object)this.text.getText());
    }

    @Test
    public void test_cut() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_cut(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text).");
            }
            return;
        }
        this.text.cut();
        this.text.setText("01234567890");
        this.text.setSelection(2, 5);
        this.text.cut();
        Assert.assertEquals((Object)"01567890", (Object)this.text.getText());
        this.text.selectAll();
        this.text.cut();
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.cut();
        this.text.setText("01234567890");
        this.text.setSelection(2, 5);
        this.text.cut();
        Assert.assertEquals((Object)"01567890", (Object)this.text.getText());
        this.text.selectAll();
        this.text.cut();
        Assert.assertEquals((Object)"", (Object)this.text.getText());
    }

    @Test
    public void test_getCaretLineNumber() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getCaretLineNumber(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        this.text.setBounds(0, 0, 500, 500);
        Assert.assertEquals((long)0L, (long)this.text.getCaretLineNumber());
        this.text.setText("Line0\r\n");
        Assert.assertEquals((long)0L, (long)this.text.getCaretLineNumber());
        this.text.setTopIndex(1);
        Assert.assertEquals((long)0L, (long)this.text.getCaretLineNumber());
        this.text.append("Line1");
        Assert.assertEquals((long)1L, (long)this.text.getCaretLineNumber());
        String newText = "Line-1\r\n";
        this.text.setSelection(0, 0);
        this.text.insert(newText);
        Assert.assertEquals((long)1L, (long)this.text.getCaretLineNumber());
        this.text.setSelection(0, 0);
        Assert.assertEquals((long)0L, (long)this.text.getCaretLineNumber());
        this.text.setSelection(8, 8);
        Assert.assertEquals((long)1L, (long)this.text.getCaretLineNumber());
    }

    @Test
    public void test_getCaretLocation() {
        this.text.setSize(200, 50);
        this.text.setSelection(0, 0);
        this.text.insert("");
        Assert.assertTrue((this.text.getCaretLocation().x >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.text.getCaretLocation().y >= 0 ? 1 : 0) != 0);
        this.text.setText("Line0\r\nLine1\r\nLine2");
        this.text.insert("");
        Assert.assertTrue((this.text.getCaretLocation().x >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.text.getCaretLocation().y >= 0 ? 1 : 0) != 0);
        this.text.setSelection(1, 1);
        Assert.assertTrue((this.text.getCaretLocation().x > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.text.getCaretLocation().y >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getCaretPosition() {
        this.text.setText("Line");
        Assert.assertEquals((long)0L, (long)this.text.getCaretPosition());
        this.text.append("123");
        Assert.assertEquals((long)7L, (long)this.text.getCaretPosition());
        this.text.setSelection(1, 3);
        this.text.insert("123");
        Assert.assertEquals((long)4L, (long)this.text.getCaretPosition());
    }

    @Test
    public void test_getCharCount() {
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234567890");
        Assert.assertEquals((long)11L, (long)this.text.getCharCount());
        this.text.setText("012345" + this.delimiterString + "67890");
        Assert.assertEquals((long)(11 + this.delimiterString.length()), (long)this.text.getCharCount());
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234\t567890");
        Assert.assertEquals((long)12L, (long)this.text.getCharCount());
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234567890");
        Assert.assertEquals((long)11L, (long)this.text.getCharCount());
        this.text.setText("012345" + this.delimiterString + "67890");
        Assert.assertEquals((long)(11 + this.delimiterString.length()), (long)this.text.getCharCount());
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234\t567890");
        Assert.assertEquals((long)12L, (long)this.text.getCharCount());
        this.makeCleanEnvironment(true);
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234567890");
        Assert.assertEquals((long)11L, (long)this.text.getCharCount());
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.text.setText("012345" + this.delimiterString + "67890");
            Assert.assertEquals((long)(11 + this.delimiterString.length()), (long)this.text.getCharCount());
        }
        this.text.setText("");
        Assert.assertEquals((long)0L, (long)this.text.getCharCount());
        this.text.setText("01234\t567890");
        Assert.assertEquals((long)12L, (long)this.text.getCharCount());
    }

    @Test
    public void test_getDoubleClickEnabled() {
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((boolean)this.text.getDoubleClickEnabled());
        this.makeCleanEnvironment(true);
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((boolean)this.text.getDoubleClickEnabled());
    }

    @Test
    public void test_getEchoChar() {
        this.makeCleanEnvironment(true);
        this.text.setEchoChar('a');
        Assert.assertEquals((long)97L, (long)this.text.getEchoChar());
    }

    @Test
    public void test_getEditable() {
        Assert.assertTrue((boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((boolean)this.text.getEditable());
    }

    @Test
    public void test_getLineCount() {
        this.text.setBounds(0, 0, 500, 500);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.text.append("dddasd" + this.delimiterString);
        Assert.assertEquals((long)2L, (long)this.text.getLineCount());
        this.text.append("ddasdasdasdasd" + this.delimiterString);
        Assert.assertEquals((long)3L, (long)this.text.getLineCount());
        this.makeCleanEnvironment(true);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.text.append("dddasd" + this.delimiterString);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.text.append("ddasdasdasdasd" + this.delimiterString);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
    }

    @Test
    public void test_getLineDelimiter() {
        String platform = SWT.getPlatform();
        String delimiter = this.text.getLineDelimiter();
        switch (platform) {
            case "win32": {
                Assert.assertEquals((Object)"\r\n", (Object)delimiter);
                break;
            }
            case "cocoa": {
                Assert.assertEquals((Object)"\r", (Object)delimiter);
                break;
            }
            default: {
                Assert.assertEquals((Object)"\n", (Object)delimiter);
            }
        }
    }

    @Test
    public void test_getLineHeight() {
        Assert.assertTrue((this.text.getLineHeight() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getSelection() {
        this.text.setText("01234567890");
        this.text.setSelection(new Point(2, 2));
        Assert.assertEquals((Object)new Point(2, 2), (Object)this.text.getSelection());
        this.text.setSelection(new Point(2, 3));
        Assert.assertEquals((Object)new Point(2, 3), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 11));
        Assert.assertEquals((Object)new Point(3, 11), (Object)this.text.getSelection());
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertEquals((Object)new Point(4, 4), (Object)this.text.getSelection());
        this.text.setSelection(11);
        Assert.assertEquals((Object)new Point(11, 11), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 2));
        Assert.assertEquals((Object)new Point(2, 3), (Object)this.text.getSelection());
    }

    @Test
    public void test_getSelectionCount() {
        this.text.setText("01234567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 11);
        Assert.assertEquals((long)9L, (long)this.text.getSelectionCount());
        this.text.setText("0123\n4567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 12);
        Assert.assertEquals((long)10L, (long)this.text.getSelectionCount());
    }

    @Test
    public void test_getSelectionText() {
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 7);
        Assert.assertEquals((Object)"3456", (Object)this.text.getSelectionText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_getTabs() {
        if (SWT.getPlatform().equals("win32") || SWT.getPlatform().equals("gtk")) {
            this.text.setTabs(1);
            Assert.assertEquals((long)1L, (long)this.text.getTabs());
            this.text.setTabs(8);
            Assert.assertEquals((long)8L, (long)this.text.getTabs());
            this.text.setText("Line\t1\r\n");
            Assert.assertEquals((long)8L, (long)this.text.getTabs());
            this.text.setTabs(7);
            Assert.assertEquals((long)7L, (long)this.text.getTabs());
        }
    }

    @Test
    public void test_getText() {
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        String string = "012345" + this.delimiterString + "67890";
        this.text.setText(string);
        Assert.assertEquals((Object)string, (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.makeCleanEnvironment(true, true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
    }

    @Test
    public void test_getTextII() {
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
        this.text.setText("");
        this.text.setEchoChar('*');
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
        this.makeCleanEnvironment(true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
        this.text.setText("");
        this.text.setEchoChar('*');
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
        this.makeCleanEnvironment(true, true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
        this.text.setText("");
        this.text.setEchoChar('*');
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("a");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -4));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-4, -2));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-2, -1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, -1));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 0));
        Assert.assertEquals((Object)"a", (Object)this.text.getText(0, 1));
        Assert.assertEquals((Object)"", (Object)this.text.getText(10, 20));
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        Assert.assertEquals((Object)"0", (Object)this.text.getText(10, 20));
    }

    @Test
    public void test_getTextLimit() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getTextLimit(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        this.text.setTextLimit(10);
        Assert.assertEquals((long)10L, (long)this.text.getTextLimit());
    }

    @Test
    public void test_getTopIndex() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getTopIndex(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        this.text.setSize(50, this.text.getLineHeight());
        this.text.setTopIndex(0);
        Assert.assertEquals((long)0L, (long)this.text.getTopIndex());
        this.text.append(this.delimiterString + "0123456789");
        this.text.setTopIndex(1);
        Assert.assertEquals((long)1L, (long)this.text.getTopIndex());
        this.text.setTopIndex(17);
        Assert.assertEquals((long)1L, (long)this.text.getTopIndex());
    }

    @Test
    public void test_getTopPixel() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getTopPixel(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        this.text.setText("Line0\r\nLine0a\r\n");
        Assert.assertEquals((long)0L, (long)this.text.getTopPixel());
        this.text.setTopIndex(-2);
        Assert.assertEquals((long)0L, (long)this.text.getTopPixel());
        this.text.setTopIndex(-1);
        Assert.assertEquals((long)0L, (long)this.text.getTopPixel());
        this.text.setTopIndex(1);
        Assert.assertEquals((long)this.text.getLineHeight(), (long)this.text.getTopPixel());
        this.text.setSize(10, this.text.getLineHeight());
        this.text.setTopIndex(2);
        Assert.assertEquals((long)(this.text.getLineHeight() * 2), (long)this.text.getTopPixel());
        this.text.setTopIndex(0);
        Assert.assertEquals((long)0L, (long)this.text.getTopPixel());
        this.text.setTopIndex(3);
        Assert.assertEquals((long)(this.text.getLineHeight() * 2), (long)this.text.getTopPixel());
    }

    @Test
    public void test_insertLjava_lang_String() {
        this.text.setBounds(0, 0, 500, 500);
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.insert(null));
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.insert("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.insert("fred");
        Assert.assertEquals((Object)"fred", (Object)this.text.getText());
        this.text.setSelection(2);
        this.text.insert("helmut");
        Assert.assertEquals((Object)"frhelmuted", (Object)this.text.getText());
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.text.insert(this.delimiterString);
        Assert.assertEquals((long)2L, (long)this.text.getLineCount());
        this.makeCleanEnvironment(true);
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.insert(null));
        this.makeCleanEnvironment(true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.insert("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.insert("fred");
        Assert.assertEquals((Object)"fred", (Object)this.text.getText());
        this.text.setSelection(2);
        this.text.insert("helmut");
        Assert.assertEquals((Object)"frhelmuted", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.text.insert(Text.DELIMITER);
        Assert.assertEquals((long)1L, (long)this.text.getLineCount());
        this.makeCleanEnvironment(true);
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.insert(null));
    }

    @Override
    @Test
    public void test_isVisible() {
        this.control.setVisible(true);
        Assert.assertTrue((boolean)this.control.isVisible());
        this.control.setVisible(false);
        Assert.assertTrue((!this.control.isVisible() ? 1 : 0) != 0);
        this.control.setVisible(true);
        this.shell.setVisible(true);
        Assert.assertTrue((String)"Window should be visible", (boolean)this.control.isVisible());
        this.shell.setVisible(false);
        Assert.assertFalse((String)"Window should not be visible", (boolean)this.control.isVisible());
    }

    @Test
    public void test_paste() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_paste(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text).");
            }
            return;
        }
        this.text.setText("01234567890");
        this.text.setSelection(2, 4);
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.copy();
        this.text.setSelection(0);
        this.text.paste();
        Assert.assertEquals((Object)"2301234567890", (Object)this.text.getText());
        this.text.copy();
        this.text.setSelection(3);
        this.text.paste();
        Assert.assertEquals((Object)"230231234567890", (Object)this.text.getText());
        this.text.setText("0" + this.delimiterString + "1");
        this.text.selectAll();
        this.text.copy();
        this.text.setSelection(0);
        this.text.paste();
        Assert.assertEquals((Object)("0" + this.delimiterString + "10" + this.delimiterString + "1"), (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        this.text.setSelection(2, 4);
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.copy();
        this.text.setSelection(0);
        this.text.paste();
        Assert.assertEquals((Object)"2301234567890", (Object)this.text.getText());
        this.text.copy();
        this.text.setSelection(3);
        this.text.paste();
        Assert.assertEquals((Object)"230231234567890", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.setText("0" + this.delimiterString + "1");
        this.text.selectAll();
        this.text.copy();
        this.text.setSelection(0);
        this.text.paste();
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertEquals((Object)("0" + this.delimiterString + "10" + this.delimiterString + "1"), (Object)this.text.getText());
        }
    }

    @Test
    public void test_selectAll() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_selectAll(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text).");
            }
            return;
        }
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
        this.text.cut();
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234" + this.delimiterString + "567890");
        Assert.assertEquals((Object)("01234" + this.delimiterString + "567890"), (Object)this.text.getText());
        this.text.selectAll();
        Assert.assertEquals((Object)("01234" + this.delimiterString + "567890"), (Object)this.text.getSelectionText());
        this.text.cut();
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.selectAll();
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getSelectionText());
        this.text.cut();
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.text.setText("01234" + this.delimiterString + "567890");
            Assert.assertEquals((Object)("01234" + this.delimiterString + "567890"), (Object)this.text.getText());
            this.text.selectAll();
            Assert.assertEquals((Object)("01234" + this.delimiterString + "567890"), (Object)this.text.getSelectionText());
            this.text.cut();
            Assert.assertEquals((Object)"", (Object)this.text.getText());
        }
    }

    @Test
    public void test_setDoubleClickEnabledZ() {
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((boolean)this.text.getDoubleClickEnabled());
        this.makeCleanEnvironment(true);
        this.text.setDoubleClickEnabled(true);
        Assert.assertTrue((boolean)this.text.getDoubleClickEnabled());
        this.text.setDoubleClickEnabled(false);
        Assert.assertFalse((boolean)this.text.getDoubleClickEnabled());
    }

    @Test
    public void test_setEchoCharC() {
        this.makeCleanEnvironment(true);
        int i = 0;
        while (i < 128) {
            this.text.setEchoChar((char)i);
            Assert.assertEquals((long)((char)i), (long)this.text.getEchoChar());
            ++i;
        }
        this.makeCleanEnvironment(true);
        this.text.setEchoChar('a');
        Assert.assertEquals((long)97L, (long)this.text.getEchoChar());
        this.text.setEchoChar('\u0000');
        Assert.assertEquals((long)0L, (long)this.text.getEchoChar());
        this.text.setEchoChar('\n');
        Assert.assertEquals((long)10L, (long)this.text.getEchoChar());
        i = 0;
        while (i < 128) {
            this.text.setEchoChar((char)i);
            Assert.assertEquals((long)((char)i), (long)this.text.getEchoChar());
            ++i;
        }
    }

    @Test
    public void test_setEditableZ() {
        this.text.setEditable(true);
        Assert.assertTrue((boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((boolean)this.text.getEditable());
        this.text.setEditable(false);
        Assert.assertFalse((boolean)this.text.getEditable());
        this.text.setEditable(true);
        Assert.assertTrue((boolean)this.text.getEditable());
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        FontData fontData = this.text.getFont().getFontData()[0];
        Font font = new Font((Device)this.text.getDisplay(), fontData.getName(), 8, fontData.getStyle());
        this.text.setFont(font);
        int lineHeight = this.text.getLineHeight();
        this.text.setFont(null);
        font.dispose();
        font = new Font((Device)this.text.getDisplay(), fontData.getName(), 12, fontData.getStyle());
        this.text.setFont(font);
        Assert.assertTrue((this.text.getLineHeight() > lineHeight && font.equals((Object)this.text.getFont()) ? 1 : 0) != 0);
        this.text.setFont(null);
        font.dispose();
    }

    @Test
    public void test_setForegroundAfterBackground() {
        this.makeCleanEnvironment(false);
        Color gray = this.text.getDisplay().getSystemColor(16);
        Color white = this.text.getDisplay().getSystemColor(1);
        int systemColor = SwtTestUtil.isCocoa ? 24 : 21;
        Color defaultForeground = this.text.getDisplay().getSystemColor(systemColor);
        this.text.setBackground(gray);
        Assert.assertEquals((Object)this.text.getForeground(), (Object)defaultForeground);
        this.text.setForeground(white);
        Assert.assertEquals((Object)this.text.getForeground(), (Object)white);
        Assert.assertEquals((Object)this.text.getBackground(), (Object)gray);
    }

    @Test
    public void test_setOrientationI() {
        this.text.setOrientation(0x4000000);
        if ((this.text.getStyle() & 0x8000000) != 0) {
            Assert.assertEquals((long)0x4000000L, (long)this.text.getOrientation());
        }
        this.text.setOrientation(0x2000000);
        Assert.assertEquals((long)0x2000000L, (long)this.text.getOrientation());
    }

    @Override
    @Test
    public void test_setRedrawZ() {
        this.text.setRedraw(false);
        this.text.setRedraw(true);
    }

    @Test
    public void test_setSelectionI() {
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 7);
        Assert.assertEquals((Object)"3456", (Object)this.text.getSelectionText());
        this.text.setSelection(3, 0);
        Assert.assertEquals((Object)"012", (Object)this.text.getSelectionText());
    }

    @Test
    public void test_setSelectionII() {
        this.text.setText("01234567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 100);
        Assert.assertEquals((long)9L, (long)this.text.getSelectionCount());
        this.text.setText("0123" + this.delimiterString + "4567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 100);
        Assert.assertEquals((long)(9 + this.delimiterString.length()), (long)this.text.getSelectionCount());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 100);
        Assert.assertEquals((long)9L, (long)this.text.getSelectionCount());
        this.makeCleanEnvironment(true);
        this.text.setText("0123" + this.delimiterString + "4567890");
        Assert.assertEquals((long)0L, (long)this.text.getSelectionCount());
        this.text.setSelection(2, 4);
        Assert.assertEquals((long)2L, (long)this.text.getSelectionCount());
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.text.setSelection(2, 100);
            Assert.assertEquals((long)(9 + this.delimiterString.length()), (long)this.text.getSelectionCount());
        }
    }

    @Test
    public void test_setSelectionLorg_eclipse_swt_graphics_Point() {
        this.text.setText("dsdsdasdslaasdas");
        Assert.assertThrows((String)"No exception thrown for selection == null", IllegalArgumentException.class, () -> this.text.setSelection(null));
        this.text.setText("01234567890");
        this.text.setSelection(new Point(2, 2));
        Assert.assertEquals((Object)new Point(2, 2), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 2));
        Assert.assertEquals((Object)new Point(2, 3), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 100));
        Assert.assertEquals((Object)new Point(3, 11), (Object)this.text.getSelection());
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertEquals((Object)new Point(4, 4), (Object)this.text.getSelection());
        this.text.setSelection(100);
        Assert.assertEquals((Object)new Point(11, 11), (Object)this.text.getSelection());
        this.makeCleanEnvironment(true);
        this.text.setText("dsdsdasdslaasdas");
        Assert.assertThrows((String)"No exception thrown for selection == null", IllegalArgumentException.class, () -> this.text.setSelection(null));
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        this.text.setSelection(new Point(2, 2));
        Assert.assertEquals((Object)new Point(2, 2), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 2));
        Assert.assertEquals((Object)new Point(2, 3), (Object)this.text.getSelection());
        this.text.setSelection(new Point(3, 100));
        Assert.assertEquals((Object)new Point(3, 11), (Object)this.text.getSelection());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        this.text.setSelection(4);
        Assert.assertEquals((Object)new Point(4, 4), (Object)this.text.getSelection());
        this.text.setSelection(100);
        Assert.assertEquals((Object)new Point(11, 11), (Object)this.text.getSelection());
    }

    @Test
    public void test_setTabsI() {
        int i = 0;
        while (i < 200) {
            this.text.setTabs(i);
            Assert.assertEquals((long)i, (long)this.text.getTabs());
            ++i;
        }
    }

    @Test
    public void test_setTextLimitI() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setTextLimitI(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        this.text.setTextLimit(10);
        Assert.assertEquals((long)10L, (long)this.text.getTextLimit());
        this.text.setTextLimit(Text.LIMIT);
        Assert.assertEquals((long)Text.LIMIT, (long)this.text.getTextLimit());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.text.setTextLimit(0));
    }

    @Test
    public void test_setTextLjava_lang_String() {
        Assert.assertThrows((String)"No exception thrown for string == null", IllegalArgumentException.class, () -> this.text.setText(null));
        this.text.setText("");
        this.makeCleanEnvironment(true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"01234567890", (Object)this.text.getText());
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        if (SwtTestUtil.fCheckBogusTestCases) {
            this.text.setText("012345" + this.delimiterString + "67890");
            Assert.assertEquals((Object)("012345" + this.delimiterString + "67890"), (Object)this.text.getText());
        }
        this.makeCleanEnvironment(true);
        Assert.assertEquals((Object)"", (Object)this.text.getText());
        this.text.setText("01234567890");
        Assert.assertEquals((Object)"345", (Object)this.text.getText(3, 5));
        Assert.assertEquals((Object)"012", (Object)this.text.getText(-1, 2));
        Assert.assertEquals((Object)"34567890", (Object)this.text.getText(3, 100));
        Assert.assertEquals((Object)"", (Object)this.text.getText(5, 3));
        this.text.setText("");
        Assert.assertEquals((Object)"", (Object)this.text.getText(-1, 0));
        Assert.assertEquals((Object)"", (Object)this.text.getText(0, 10));
        Assert.assertEquals((Object)"", (Object)this.text.getText(1, 0));
    }

    @Test
    public void test_setTopIndexI() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setTopIndexI(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text)");
            }
            return;
        }
        int number = 100;
        int i = 0;
        while (i < number) {
            this.text.append("01234\n");
            ++i;
        }
        i = 1;
        while (i < number) {
            this.text.setTopIndex(i);
            Assert.assertEquals((long)i, (long)this.text.getTopIndex());
            ++i;
        }
        this.text.setTopIndex(number + 5);
        Assert.assertEquals((long)number, (long)this.text.getTopIndex());
        this.makeCleanEnvironment(true);
        this.text.setText("01234567890");
        this.text.append(Text.DELIMITER + "01234567890");
        this.text.setTopIndex(0);
        Assert.assertEquals((long)0L, (long)this.text.getTopIndex());
        this.text.setTopIndex(1);
        Assert.assertEquals((long)0L, (long)this.text.getTopIndex());
        this.text.setTopIndex(17);
        Assert.assertEquals((long)0L, (long)this.text.getTopIndex());
        this.text.setText("");
        i = 0;
        while (i < number) {
            this.text.append("01234" + Text.DELIMITER);
            ++i;
        }
        i = 0;
        while (i < number) {
            this.text.setTopIndex(i);
            Assert.assertEquals((long)0L, (long)this.text.getTopIndex());
            ++i;
        }
    }

    @Test
    public void test_showSelection() {
        this.text.showSelection();
        this.text.selectAll();
        this.text.showSelection();
        this.text.setText("00000");
        this.text.selectAll();
        this.text.showSelection();
        this.text.clearSelection();
        this.text.showSelection();
        this.makeCleanEnvironment(true);
        this.text.showSelection();
        this.text.selectAll();
        this.text.showSelection();
        this.text.setText("00000");
        this.text.selectAll();
        this.text.showSelection();
        this.text.clearSelection();
        this.text.showSelection();
    }

    private void makeCleanEnvironment(boolean single) {
        this.makeCleanEnvironment(single, false);
    }

    private void makeCleanEnvironment(boolean single, boolean border) {
        if (this.text != null) {
            this.text.dispose();
        }
        this.text = single ? new Text((Composite)this.shell, 4 | (border ? 2048 : 0)) : new Text((Composite)this.shell, 0x302 | (border ? 2048 : 0));
        this.setWidget((Widget)this.text);
        this.delimiterString = Text.DELIMITER;
    }

    @Override
    protected void setWidget(Widget w) {
        this.text = (Text)w;
        super.setWidget(w);
    }

    @Test
    public void test_consistency_EnterSelection() {
        this.makeCleanEnvironment(true);
        this.consistencyEvent(13, 10, 0, 0, 10);
    }

    @Test
    public void test_consistency_Modify() {
        this.makeCleanEnvironment(true);
        this.consistencyEvent(97, 0, 0, 0, 10);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.makeCleanEnvironment(true);
        this.consistencyEvent(10, 10, 3, 1, 30);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.makeCleanEnvironment(true);
        this.consistencyEvent(30, 10, 50, 0, 50);
    }

    @Test
    public void test_consistency_Segments() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_consistency_Segments(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Text).");
            }
            return;
        }
        SegmentListener sl1 = event -> {
            if ((event.lineText.length() & 1) == 1) {
                event.segments = new int[]{1, event.lineText.length()};
                event.segmentsChars = null;
            } else {
                int[] nArray = new int[3];
                nArray[2] = event.lineText.length();
                event.segments = nArray;
                event.segmentsChars = new char[]{':', '<', '>'};
            }
            this.listenerCalled = true;
        };
        Assert.assertThrows((String)"No exception thrown for addSegmentListener(null)", IllegalArgumentException.class, () -> this.text.addSegmentListener(null));
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] singleLine = blArray;
        int i = singleLine.length;
        while (i-- > 0) {
            this.makeCleanEnvironment(singleLine[i]);
            this.text.addSegmentListener(sl1);
            this.doSegmentsTest(true);
            this.text.addSegmentListener(sl1);
            this.doSegmentsTest(true);
            this.text.removeSegmentListener(sl1);
            this.doSegmentsTest(true);
            this.text.removeSegmentListener(sl1);
            this.text.setText(this.text.getText());
            this.doSegmentsTest(false);
        }
    }

    private void doSegmentsTest(boolean isListening) {
        Object string = "1234";
        this.text.setText((String)string);
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)string, (Object)this.text.getText());
        String substr = "56";
        this.text.append(substr);
        string = (String)string + substr;
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)string, (Object)this.text.getText());
        if ((this.text.getStyle() & 4) != 0) {
            int limit = ((String)string).length() - 1;
            this.text.setTextLimit(limit);
            Assert.assertEquals((long)limit, (long)this.text.getTextLimit());
            this.text.setText((String)string);
            Assert.assertEquals((Object)((String)string).substring(0, limit), (Object)this.text.getText());
        }
        this.text.setTextLimit(Text.LIMIT);
        this.text.setText((String)string);
        Assert.assertEquals((Object)string, (Object)this.text.getText());
        this.listenerCalled = false;
        Point pt = new Point(1, 3);
        this.text.setSelection(pt);
        Assert.assertEquals((Object)pt, (Object)this.text.getSelection());
        Assert.assertFalse((boolean)this.listenerCalled);
        this.text.copy();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        substr = ((String)string).substring(pt.x, pt.y);
        pt.y = 1;
        pt.x = 1;
        this.text.setSelection(pt);
        this.text.paste();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)(((String)string).substring(0, pt.x) + substr + ((String)string).substring(pt.y)), (Object)this.text.getText());
        pt.x = pt.y = pt.x + substr.length();
        Assert.assertEquals((Object)pt, (Object)this.text.getSelection());
        pt.x -= 2;
        this.text.setSelection(pt);
        Assert.assertEquals((Object)substr, (Object)this.text.getSelectionText());
        Assert.assertEquals((Object)substr, (Object)this.text.getText(pt.x, pt.y - 1));
        this.text.cut();
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        Assert.assertEquals((Object)string, (Object)this.text.getText());
        substr = "12";
        pt.x = 6;
        pt.y = 8;
        this.text.setSelection(pt.x, pt.y);
        this.text.cut();
        pt.y = pt.x;
        Assert.assertEquals((Object)pt, (Object)this.text.getSelection());
        this.listenerCalled = false;
        pt.y = 0;
        pt.x = 0;
        this.text.setSelection(pt);
        this.text.insert(substr);
        Assert.assertEquals((Object)isListening, (Object)this.listenerCalled);
        this.listenerCalled = false;
        pt.x = pt.y = pt.x + substr.length();
        Assert.assertEquals((Object)pt, (Object)this.text.getSelection());
        Assert.assertEquals((Object)(substr + (String)string), (Object)this.text.getText());
    }

    @Test
    public void test_backspaceAndDelete() {
        this.shell.open();
        this.text.setSize(10, 50);
        Instant timeOut = Instant.now().plusSeconds(10L);
        Display display = Display.getDefault();
        Event a = this.keyEvent(97, 1, (Widget)display.getFocusControl());
        Event aUp = this.keyEvent(97, 2, (Widget)display.getFocusControl());
        Event backspace = this.keyEvent(8, 1, (Widget)display.getFocusControl());
        Event backspaceUp = this.keyEvent(8, 2, (Widget)display.getFocusControl());
        display.post(a);
        display.post(aUp);
        while (Instant.now().isBefore(timeOut)) {
            if (this.text.getText().length() == 1) break;
            if (this.shell.isDisposed()) continue;
            display.readAndDispatch();
        }
        display.post(backspace);
        display.post(backspaceUp);
        while (Instant.now().isBefore(timeOut)) {
            if (this.text.getText().length() == 0) break;
            if (this.shell.isDisposed()) continue;
            display.readAndDispatch();
        }
        Assert.assertEquals((long)0L, (long)this.text.getText().length());
    }

    private Event keyEvent(int key, int type, Widget w) {
        Event e = new Event();
        e.keyCode = key;
        e.character = (char)key;
        e.type = type;
        e.widget = w;
        return e;
    }

    @Test
    public void test_issue472() {
        this.shell.open();
        int iFontHeight = 10;
        while (iFontHeight < 20) {
            Font font = new Font((Device)this.shell.getDisplay(), "", iFontHeight, 0);
            Group group = new Group((Composite)this.shell, 0);
            group.setText("Group");
            group.setFont(font);
            try {
                try {
                    Text text = new Text((Composite)group, 2122);
                    text.dispose();
                }
                catch (NullPointerException ex) {
                    throw new RuntimeException("NPE with font=" + iFontHeight, ex);
                }
            }
            finally {
                font.dispose();
            }
            ++iFontHeight;
        }
    }
}

